/*
 * Decompiled with CFR 0.152.
 */
package picard.reference;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SequenceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Fasta;

@CommandLineProgramProperties(usage="Subsets intervals from a reference sequence to a new FASTA file.This tool takes a list of intervals, reads the corresponding subsquences from a reference FASTA file and writes them to a new FASTA file as separate records. Note that the reference FASTA file must be accompanied by an index file and the interval list must be provided in Picard list format. The names provided for the intervals will be used to name the corresponding records in the output file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar ExtractSequences \\<br />      INTERVAL_LIST=regions_of_interest.interval_list \\<br />      R=reference.fasta \\<br />      O=extracted_IL_sequences.fasta</pre><hr />", usageShort="Subsets intervals from a reference sequence to a new FASTA file.", programGroup=Fasta.class)
public class ExtractSequences
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Subsets intervals from a reference sequence to a new FASTA file.";
    static final String USAGE_DETAILS = "This tool takes a list of intervals, reads the corresponding subsquences from a reference FASTA file and writes them to a new FASTA file as separate records. Note that the reference FASTA file must be accompanied by an index file and the interval list must be provided in Picard list format. The names provided for the intervals will be used to name the corresponding records in the output file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar ExtractSequences \\<br />      INTERVAL_LIST=regions_of_interest.interval_list \\<br />      R=reference.fasta \\<br />      O=extracted_IL_sequences.fasta</pre><hr />";
    @Option(doc="Interval list describing intervals to be extracted from the reference sequence.")
    public File INTERVAL_LIST;
    @Option(shortName="R", doc="Reference sequence FASTA file.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="O", doc="Output FASTA file.")
    public File OUTPUT;
    @Option(doc="Maximum line length for sequence data.")
    public int LINE_LENGTH = 80;

    public static void main(String[] stringArray) {
        new ExtractSequences().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INTERVAL_LIST);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IntervalList intervalList = IntervalList.fromFile((File)this.INTERVAL_LIST);
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)intervalList.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)referenceSequenceFile.getSequenceDictionary());
        BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
        for (Interval interval : intervalList) {
            ReferenceSequence referenceSequence = referenceSequenceFile.getSubsequenceAt(interval.getSequence(), (long)interval.getStart(), (long)interval.getEnd());
            byte[] byArray = referenceSequence.getBases();
            if (interval.isNegativeStrand()) {
                SequenceUtil.reverseComplement((byte[])byArray);
            }
            try {
                bufferedWriter.write(">");
                bufferedWriter.write(interval.getName());
                bufferedWriter.write("\n");
                for (int i = 0; i < byArray.length; ++i) {
                    if (i > 0 && i % this.LINE_LENGTH == 0) {
                        bufferedWriter.write("\n");
                    }
                    bufferedWriter.write(byArray[i]);
                }
                bufferedWriter.write("\n");
            }
            catch (IOException iOException) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), iOException);
            }
        }
        CloserUtil.close((Object)bufferedWriter);
        return 0;
    }
}

