/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Adds comments to the header of a BAM file.This tool makes a copy of the input bam file, with a modified header that includes the comments specified at the command line (prefixed by @CO). Use double quotes to wrap comments that include whitespace or special characters. <br /><br />Note that this tool cannot be run on SAM files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar AddCommentsToBam \\<br />      I=input.bam \\<br />      O=modified_bam.bam \\<br />      C=comment_1 \\<br />      C=\"comment 2\"</pre><hr />", usageShort="Adds comments to the header of a BAM file.", programGroup=SamOrBam.class)
public class AddCommentsToBam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Adds comments to the header of a BAM file.";
    static final String USAGE_DETAILS = "This tool makes a copy of the input bam file, with a modified header that includes the comments specified at the command line (prefixed by @CO). Use double quotes to wrap comments that include whitespace or special characters. <br /><br />Note that this tool cannot be run on SAM files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar AddCommentsToBam \\<br />      I=input.bam \\<br />      O=modified_bam.bam \\<br />      C=comment_1 \\<br />      C=\"comment 2\"</pre><hr />";
    @Option(shortName="I", doc="Input BAM file to add a comment to the header")
    public File INPUT;
    @Option(shortName="O", doc="Output BAM file to write results")
    public File OUTPUT;
    @Option(shortName="C", doc="Comments to add to the BAM file")
    public List<String> COMMENT;

    public static void main(String[] stringArray) {
        new AddCommentsToBam().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.INPUT.getAbsolutePath().endsWith(".sam")) {
            throw new PicardException("SAM files are not supported");
        }
        SAMFileHeader sAMFileHeader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.INPUT);
        for (String string : this.COMMENT) {
            if (string.contains("\n")) {
                throw new PicardException("Comments can not contain a new line");
            }
            sAMFileHeader.addComment(string);
        }
        BamFileIoUtils.reheaderBamFile((SAMFileHeader)sAMFileHeader, (File)this.INPUT, (File)this.OUTPUT, (boolean)this.CREATE_MD5_FILE, (boolean)this.CREATE_INDEX);
        return 0;
    }
}

