/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise", usageShort="Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise", programGroup=SamOrBam.class)
public class CheckTerminatorBlock
extends CommandLineProgram {
    static final String USAGE = "Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise";
    @Option(shortName="I", doc="The block compressed file to check.")
    public File INPUT;

    public static void main(String[] stringArray) {
        new CheckTerminatorBlock().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        try {
            BlockCompressedInputStream.FileTermination fileTermination = BlockCompressedInputStream.checkTermination((File)this.INPUT);
            System.err.println(fileTermination.name());
            if (fileTermination == BlockCompressedInputStream.FileTermination.DEFECTIVE) {
                return 100;
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new PicardException("Exception reading terminator block of file: " + this.INPUT.getAbsolutePath());
        }
    }
}

