/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.SecondaryOrSupplementarySkippingIterator;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.PositionalArguments;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Compare two input \".sam\" or \".bam\" files.  This tool initially compares the headers of SAM or BAM files.  If the file headers are comparable, the tool will examine and compare readUnmapped flag, reference name, start position and strand between the SAMRecords. The tool summarizes information on the number of read pairs that match or mismatch, and of reads that are missing or unmapped (stratified by direction: forward or reverse).<h4>Usage example:</h4><pre>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam</pre><hr />", usageShort="Compare two input \".sam\" or \".bam\" files.  ", programGroup=SamOrBam.class)
public class CompareSAMs
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Compare two input \".sam\" or \".bam\" files.  ";
    static final String USAGE_DETAILS = "This tool initially compares the headers of SAM or BAM files.  If the file headers are comparable, the tool will examine and compare readUnmapped flag, reference name, start position and strand between the SAMRecords. The tool summarizes information on the number of read pairs that match or mismatch, and of reads that are missing or unmapped (stratified by direction: forward or reverse).<h4>Usage example:</h4><pre>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam</pre><hr />";
    @PositionalArguments(minElements=2, maxElements=2)
    public List<File> samFiles;
    private final SamReader[] samReaders = new SamReader[2];
    private boolean sequenceDictionariesDiffer;
    private int mappingsMatch = 0;
    private int unmappedBoth = 0;
    private int unmappedLeft = 0;
    private int unmappedRight = 0;
    private int mappingsDiffer = 0;
    private int missingLeft = 0;
    private int missingRight = 0;
    private boolean areEqual;

    public static void main(String[] stringArray) {
        new CompareSAMs().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        for (int i = 0; i < this.samFiles.size(); ++i) {
            this.samReaders[i] = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.samFiles.get(i));
        }
        this.areEqual = this.compareHeaders();
        this.areEqual = this.compareAlignments() && this.areEqual;
        this.printReport();
        if (!this.areEqual) {
            System.out.println("SAM files differ.");
        } else {
            System.out.println("SAM files match.");
        }
        CloserUtil.close((Object)this.samReaders);
        return 0;
    }

    private void printReport() {
        System.out.println("Match\t" + this.mappingsMatch);
        System.out.println("Differ\t" + this.mappingsDiffer);
        System.out.println("Unmapped_both\t" + this.unmappedBoth);
        System.out.println("Unmapped_left\t" + this.unmappedLeft);
        System.out.println("Unmapped_right\t" + this.unmappedRight);
        System.out.println("Missing_left\t" + this.missingLeft);
        System.out.println("Missing_right\t" + this.missingRight);
    }

    private boolean compareAlignments() {
        if (!this.compareValues(this.samReaders[0].getFileHeader().getSortOrder(), this.samReaders[1].getFileHeader().getSortOrder(), "Sort Order")) {
            System.out.println("Cannot compare alignments if sort orders differ.");
            return false;
        }
        switch (this.samReaders[0].getFileHeader().getSortOrder()) {
            case coordinate: {
                if (this.sequenceDictionariesDiffer) {
                    System.out.println("Cannot compare coordinate-sorted SAM files because sequence dictionaries differ.");
                    return false;
                }
                return this.compareCoordinateSortedAlignments();
            }
            case queryname: {
                return this.compareQueryNameSortedAlignments();
            }
            case duplicate: 
            case unsorted: {
                return this.compareUnsortedAlignments();
            }
        }
        return false;
    }

    private boolean compareCoordinateSortedAlignments() {
        SAMRecord sAMRecord;
        Object object;
        Object object3;
        SecondaryOrSupplementarySkippingIterator secondaryOrSupplementarySkippingIterator = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)this.samReaders[0].iterator());
        SecondaryOrSupplementarySkippingIterator secondaryOrSupplementarySkippingIterator2 = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)this.samReaders[1].iterator());
        HashMap<String, SAMRecord> hashMap = new HashMap<String, SAMRecord>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        boolean bl = true;
        while (secondaryOrSupplementarySkippingIterator.hasCurrent()) {
            if (!secondaryOrSupplementarySkippingIterator2.hasCurrent()) {
                while (secondaryOrSupplementarySkippingIterator.hasCurrent()) {
                    object3 = secondaryOrSupplementarySkippingIterator.getCurrent();
                    SAMRecord sAMRecord2 = (SAMRecord)hashMap2.remove(this.getKeyForRecord((SAMRecord)object3));
                    if (sAMRecord2 == null) {
                        ++this.missingRight;
                    } else {
                        this.tallyAlignmentRecords((SAMRecord)object3, sAMRecord2);
                    }
                    secondaryOrSupplementarySkippingIterator.advance();
                }
                break;
            }
            object3 = secondaryOrSupplementarySkippingIterator.getCurrent();
            HashMap<String, Object> object22 = new HashMap<String, Object>();
            object22.put(this.getKeyForRecord((SAMRecord)object3), object3);
            while (secondaryOrSupplementarySkippingIterator.advance() && this.compareAlignmentCoordinates((SAMRecord)object3, (SAMRecord)(object = secondaryOrSupplementarySkippingIterator.getCurrent())) == 0) {
                object22.put(this.getKeyForRecord((SAMRecord)object), object);
            }
            while (secondaryOrSupplementarySkippingIterator2.hasCurrent() && this.compareAlignmentCoordinates((SAMRecord)object3, secondaryOrSupplementarySkippingIterator2.getCurrent()) > 0) {
                object = secondaryOrSupplementarySkippingIterator2.getCurrent();
                hashMap2.put(this.getKeyForRecord((SAMRecord)object), object);
                secondaryOrSupplementarySkippingIterator2.advance();
            }
            while (secondaryOrSupplementarySkippingIterator2.hasCurrent() && this.compareAlignmentCoordinates((SAMRecord)object3, secondaryOrSupplementarySkippingIterator2.getCurrent()) == 0) {
                object = secondaryOrSupplementarySkippingIterator2.getCurrent();
                sAMRecord = (SAMRecord)object22.remove(this.getKeyForRecord((SAMRecord)object));
                if (sAMRecord != null) {
                    bl = this.tallyAlignmentRecords(sAMRecord, (SAMRecord)object) && bl;
                } else {
                    hashMap2.put(this.getKeyForRecord((SAMRecord)object), object);
                }
                secondaryOrSupplementarySkippingIterator2.advance();
            }
            object = object22.values().iterator();
            while (object.hasNext()) {
                sAMRecord = (SAMRecord)object.next();
                hashMap.put(this.getKeyForRecord(sAMRecord), sAMRecord);
            }
        }
        while (secondaryOrSupplementarySkippingIterator2.hasCurrent()) {
            object3 = secondaryOrSupplementarySkippingIterator2.getCurrent();
            SAMRecord sAMRecord3 = (SAMRecord)hashMap.remove(this.getKeyForRecord((SAMRecord)object3));
            if (sAMRecord3 != null) {
                this.tallyAlignmentRecords(sAMRecord3, (SAMRecord)object3);
            } else {
                ++this.missingLeft;
            }
            secondaryOrSupplementarySkippingIterator2.advance();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            sAMRecord = (SAMRecord)entry.getValue();
            SAMRecord sAMRecord4 = (SAMRecord)hashMap2.remove(object);
            if (sAMRecord4 == null) {
                ++this.missingRight;
                continue;
            }
            this.tallyAlignmentRecords(sAMRecord, sAMRecord4);
        }
        this.missingLeft += hashMap2.size();
        if (bl && (this.missingLeft > 0 || this.missingRight > 0 || this.mappingsDiffer > 0 || this.unmappedLeft > 0 || this.unmappedRight > 0)) {
            bl = false;
        }
        return bl;
    }

    private int compareAlignmentCoordinates(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        int n;
        String string = sAMRecord.getReferenceName();
        String string2 = sAMRecord2.getReferenceName();
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return 1;
        }
        if (string2 == null) {
            return -1;
        }
        int n2 = this.samReaders[0].getFileHeader().getSequenceIndex(string);
        if (n2 != (n = this.samReaders[0].getFileHeader().getSequenceIndex(string2))) {
            return n2 - n;
        }
        return sAMRecord.getAlignmentStart() - sAMRecord2.getAlignmentStart();
    }

    private boolean compareQueryNameSortedAlignments() {
        SecondaryOrSupplementarySkippingIterator secondaryOrSupplementarySkippingIterator = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)this.samReaders[0].iterator());
        SecondaryOrSupplementarySkippingIterator secondaryOrSupplementarySkippingIterator2 = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)this.samReaders[1].iterator());
        boolean bl = true;
        while (secondaryOrSupplementarySkippingIterator.hasCurrent()) {
            if (!secondaryOrSupplementarySkippingIterator2.hasCurrent()) {
                this.missingRight += this.countRemaining(secondaryOrSupplementarySkippingIterator);
                return false;
            }
            int n = secondaryOrSupplementarySkippingIterator.getCurrent().getReadName().compareTo(secondaryOrSupplementarySkippingIterator2.getCurrent().getReadName());
            if (n < 0) {
                ++this.missingRight;
                secondaryOrSupplementarySkippingIterator.advance();
                bl = false;
                continue;
            }
            if (n > 0) {
                ++this.missingLeft;
                secondaryOrSupplementarySkippingIterator2.advance();
                bl = false;
                continue;
            }
            if (!this.tallyAlignmentRecords(secondaryOrSupplementarySkippingIterator.getCurrent(), secondaryOrSupplementarySkippingIterator2.getCurrent())) {
                bl = false;
            }
            secondaryOrSupplementarySkippingIterator.advance();
            secondaryOrSupplementarySkippingIterator2.advance();
        }
        if (secondaryOrSupplementarySkippingIterator2.hasCurrent()) {
            this.missingLeft += this.countRemaining(secondaryOrSupplementarySkippingIterator2);
            return false;
        }
        return bl;
    }

    private boolean compareUnsortedAlignments() {
        SecondaryOrSupplementarySkippingIterator secondaryOrSupplementarySkippingIterator = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)this.samReaders[0].iterator());
        SecondaryOrSupplementarySkippingIterator secondaryOrSupplementarySkippingIterator2 = new SecondaryOrSupplementarySkippingIterator((CloseableIterator)this.samReaders[1].iterator());
        boolean bl = true;
        while (secondaryOrSupplementarySkippingIterator.hasCurrent()) {
            if (!secondaryOrSupplementarySkippingIterator2.hasCurrent()) {
                this.missingRight += this.countRemaining(secondaryOrSupplementarySkippingIterator);
                return false;
            }
            SAMRecord sAMRecord = secondaryOrSupplementarySkippingIterator.getCurrent();
            SAMRecord sAMRecord2 = secondaryOrSupplementarySkippingIterator2.getCurrent();
            if (!this.compareValues(sAMRecord.getReadName(), sAMRecord2.getReadName(), "Read names")) {
                System.out.println("Read names cease agreeing in unsorted SAM files .  Comparison aborting.");
            }
            bl = this.tallyAlignmentRecords(sAMRecord, sAMRecord2) && bl;
            secondaryOrSupplementarySkippingIterator.advance();
            secondaryOrSupplementarySkippingIterator2.advance();
        }
        if (secondaryOrSupplementarySkippingIterator2.hasCurrent()) {
            this.missingLeft += this.countRemaining(secondaryOrSupplementarySkippingIterator2);
            return false;
        }
        return bl;
    }

    private int countRemaining(SecondaryOrSupplementarySkippingIterator secondaryOrSupplementarySkippingIterator) {
        int n = 0;
        while (secondaryOrSupplementarySkippingIterator.hasCurrent()) {
            secondaryOrSupplementarySkippingIterator.advance();
            ++n;
        }
        return n;
    }

    private boolean tallyAlignmentRecords(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        boolean bl;
        if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) {
            throw new PicardException("Read names do not match: " + sAMRecord.getReadName() + " : " + sAMRecord2.getReadName());
        }
        if (sAMRecord.getReadUnmappedFlag() && sAMRecord2.getReadUnmappedFlag()) {
            ++this.unmappedBoth;
            return true;
        }
        if (sAMRecord.getReadUnmappedFlag()) {
            ++this.unmappedLeft;
            return false;
        }
        if (sAMRecord2.getReadUnmappedFlag()) {
            ++this.unmappedRight;
            return false;
        }
        boolean bl2 = bl = sAMRecord.getReferenceName().equals(sAMRecord2.getReferenceName()) && sAMRecord.getAlignmentStart() == sAMRecord2.getAlignmentStart() && sAMRecord.getReadNegativeStrandFlag() == sAMRecord.getReadNegativeStrandFlag();
        if (!bl) {
            ++this.mappingsDiffer;
        } else {
            ++this.mappingsMatch;
        }
        return bl;
    }

    private boolean compareHeaders() {
        SAMFileHeader sAMFileHeader = this.samReaders[0].getFileHeader();
        SAMFileHeader sAMFileHeader2 = this.samReaders[1].getFileHeader();
        boolean bl = this.compareValues(sAMFileHeader.getVersion(), sAMFileHeader2.getVersion(), "File format version");
        bl = this.compareValues(sAMFileHeader.getCreator(), sAMFileHeader2.getCreator(), "File creator") && bl;
        boolean bl2 = bl = this.compareValues(sAMFileHeader.getAttribute("SO"), sAMFileHeader2.getAttribute("SO"), "Sort order") && bl;
        if (!this.compareSequenceDictionaries(sAMFileHeader, sAMFileHeader2)) {
            bl = false;
            this.sequenceDictionariesDiffer = true;
        }
        bl = this.compareReadGroups(sAMFileHeader, sAMFileHeader2) && bl;
        bl = this.compareProgramRecords(sAMFileHeader, sAMFileHeader2) && bl;
        return bl;
    }

    private boolean compareProgramRecords(SAMFileHeader sAMFileHeader, SAMFileHeader sAMFileHeader2) {
        List list = sAMFileHeader.getProgramRecords();
        List list2 = sAMFileHeader2.getProgramRecords();
        if (!this.compareValues(list.size(), list2.size(), "Number of program records")) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            bl = this.compareProgramRecord((SAMProgramRecord)list.get(i), (SAMProgramRecord)list2.get(i)) && bl;
        }
        return bl;
    }

    private boolean compareProgramRecord(SAMProgramRecord sAMProgramRecord, SAMProgramRecord sAMProgramRecord2) {
        String[] stringArray;
        if (sAMProgramRecord == null && sAMProgramRecord2 == null) {
            return true;
        }
        if (sAMProgramRecord == null) {
            this.reportDifference("null", sAMProgramRecord2.getProgramGroupId(), "Program Record");
            return false;
        }
        if (sAMProgramRecord2 == null) {
            this.reportDifference(sAMProgramRecord.getProgramGroupId(), "null", "Program Record");
            return false;
        }
        boolean bl = this.compareValues(sAMProgramRecord.getProgramGroupId(), sAMProgramRecord2.getProgramGroupId(), "Program Name");
        for (String string : stringArray = new String[]{"VN", "CL"}) {
            bl = this.compareValues(sAMProgramRecord.getAttribute(string), sAMProgramRecord2.getAttribute(string), string + " Program Record attribute") && bl;
        }
        return bl;
    }

    private boolean compareReadGroups(SAMFileHeader sAMFileHeader, SAMFileHeader sAMFileHeader2) {
        List list = sAMFileHeader.getReadGroups();
        List list2 = sAMFileHeader2.getReadGroups();
        if (!this.compareValues(list.size(), list2.size(), "Number of read groups")) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            bl = this.compareReadGroup((SAMReadGroupRecord)list.get(i), (SAMReadGroupRecord)list2.get(i)) && bl;
        }
        return bl;
    }

    private boolean compareReadGroup(SAMReadGroupRecord sAMReadGroupRecord, SAMReadGroupRecord sAMReadGroupRecord2) {
        String[] stringArray;
        boolean bl = this.compareValues(sAMReadGroupRecord.getReadGroupId(), sAMReadGroupRecord2.getReadGroupId(), "Read Group ID");
        bl = this.compareValues(sAMReadGroupRecord.getSample(), sAMReadGroupRecord2.getSample(), "Sample for read group " + sAMReadGroupRecord.getReadGroupId()) && bl;
        bl = this.compareValues(sAMReadGroupRecord.getLibrary(), sAMReadGroupRecord2.getLibrary(), "Library for read group " + sAMReadGroupRecord.getReadGroupId()) && bl;
        for (String string : stringArray = new String[]{"DS", "PU", "PI", "CN", "DT", "PL"}) {
            bl = this.compareValues(sAMReadGroupRecord.getAttribute(string), sAMReadGroupRecord2.getAttribute(string), string + " for read group " + sAMReadGroupRecord.getReadGroupId()) && bl;
        }
        return bl;
    }

    private boolean compareSequenceDictionaries(SAMFileHeader sAMFileHeader, SAMFileHeader sAMFileHeader2) {
        List list = sAMFileHeader.getSequenceDictionary().getSequences();
        List list2 = sAMFileHeader2.getSequenceDictionary().getSequences();
        if (list.size() != list2.size()) {
            this.reportDifference(list.size(), list2.size(), "Length of sequence dictionaries");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            bl = this.compareSequenceRecord((SAMSequenceRecord)list.get(i), (SAMSequenceRecord)list2.get(i), i + 1) && bl;
        }
        return bl;
    }

    private boolean compareSequenceRecord(SAMSequenceRecord sAMSequenceRecord, SAMSequenceRecord sAMSequenceRecord2, int n) {
        if (!sAMSequenceRecord.getSequenceName().equals(sAMSequenceRecord2.getSequenceName())) {
            this.reportDifference(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord2.getSequenceName(), "Name of sequence record " + n);
            return false;
        }
        boolean bl = this.compareValues(sAMSequenceRecord.getSequenceLength(), sAMSequenceRecord2.getSequenceLength(), "Length of sequence " + sAMSequenceRecord.getSequenceName());
        bl = this.compareValues(sAMSequenceRecord.getSpecies(), sAMSequenceRecord2.getSpecies(), "Species of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        bl = this.compareValues(sAMSequenceRecord.getAssembly(), sAMSequenceRecord2.getAssembly(), "Assembly of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        bl = this.compareValues(sAMSequenceRecord.getAttribute("M5"), sAMSequenceRecord2.getAttribute("M5"), "MD5 of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        bl = this.compareValues(sAMSequenceRecord.getAttribute("UR"), sAMSequenceRecord2.getAttribute("UR"), "URI of sequence " + sAMSequenceRecord.getSequenceName()) && bl;
        return bl;
    }

    private <T> boolean compareValues(T t, T t2, String string) {
        if (t == null) {
            if (t2 == null) {
                return true;
            }
            this.reportDifference(t, t2, string);
            return false;
        }
        if (t2 == null) {
            this.reportDifference(t, t2, string);
            return false;
        }
        if (!t.equals(t2)) {
            this.reportDifference(t, t2, string);
            return false;
        }
        return true;
    }

    private void reportDifference(String string, String string2, String string3) {
        System.out.println(string3 + " differs.");
        System.out.println(this.samFiles.get(0) + ": " + string);
        System.out.println(this.samFiles.get(1) + ": " + string2);
    }

    private void reportDifference(Object object, Object object2, String string) {
        if (object == null) {
            object = "null";
        }
        if (object2 == null) {
            object2 = "null";
        }
        this.reportDifference(object.toString(), object2.toString(), string);
    }

    private String getKeyForRecord(SAMRecord sAMRecord) {
        boolean bl = sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag();
        return sAMRecord.getReadName() + "-" + (bl ? "second" : "first");
    }

    public int getMappingsMatch() {
        return this.mappingsMatch;
    }

    public int getUnmappedBoth() {
        return this.unmappedBoth;
    }

    public int getUnmappedLeft() {
        return this.unmappedLeft;
    }

    public int getUnmappedRight() {
        return this.unmappedRight;
    }

    public int getMappingsDiffer() {
        return this.mappingsDiffer;
    }

    public int getMissingLeft() {
        return this.missingLeft;
    }

    public int getMissingRight() {
        return this.missingRight;
    }

    public boolean areEqual() {
        return this.areEqual;
    }
}

