/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.fastq.FastqConstants;
import htsjdk.samtools.fastq.FastqReader;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.util.FastqQualityFormat;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.QualityEncodingDetector;
import htsjdk.samtools.util.SolexaQualityConverter;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Converts a FASTQ file to an unaligned BAM or SAM file.  This tool extracts read sequences and base qualities from the input FASTQ file and writes them out to a new file in unaligned BAM (uBAM) format. Read group information can be provided on the command line. <br /><br />  Three versions of FASTQ quality scales are supported: FastqSanger, FastqSolexa and FastqIllumina (see http://maq.sourceforge.net/fastq.shtml for details). Input FASTQ files can be in GZip format (with .gz extension).<h4>Usage example:</h4><pre>java -jar picard.jar FastqToSam \\<br />      F1=file_1.fastq \\<br />      O=fastq_to_bam.bam \\<br />      SM=for_tool_testing </pre><hr />", usageShort="Converts a FASTQ file to an unaligned BAM or SAM file.  ", programGroup=SamOrBam.class)
public class FastqToSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Converts a FASTQ file to an unaligned BAM or SAM file.  ";
    static final String USAGE_DETAILS = "This tool extracts read sequences and base qualities from the input FASTQ file and writes them out to a new file in unaligned BAM (uBAM) format. Read group information can be provided on the command line. <br /><br />  Three versions of FASTQ quality scales are supported: FastqSanger, FastqSolexa and FastqIllumina (see http://maq.sourceforge.net/fastq.shtml for details). Input FASTQ files can be in GZip format (with .gz extension).<h4>Usage example:</h4><pre>java -jar picard.jar FastqToSam \\<br />      F1=file_1.fastq \\<br />      O=fastq_to_bam.bam \\<br />      SM=for_tool_testing </pre><hr />";
    private static final Log LOG = Log.getInstance(FastqToSam.class);
    @Option(shortName="F1", doc="Input fastq file (optionally gzipped) for single end data, or first read in paired end data.")
    public File FASTQ;
    @Option(shortName="F2", doc="Input fastq file (optionally gzipped) for the second read of paired end data.", optional=true)
    public File FASTQ2;
    @Option(doc="Use sequential fastq files with the suffix <prefix>_###.fastq or <prefix>_###.fastq.gz", optional=true)
    public boolean USE_SEQUENTIAL_FASTQS = false;
    @Option(shortName="V", doc="A value describing how the quality values are encoded in the input FASTQ file.  Either Solexa (phred scaling + 66), Illumina (phred scaling + 64) or Standard (phred scaling + 33).  If this value is not specified, the quality format will be detected automatically.", optional=true)
    public FastqQualityFormat QUALITY_FORMAT;
    @Option(doc="Output SAM/BAM file. ", shortName="O")
    public File OUTPUT;
    @Option(shortName="RG", doc="Read group name")
    public String READ_GROUP_NAME = "A";
    @Option(shortName="SM", doc="Sample name to insert into the read group header")
    public String SAMPLE_NAME;
    @Option(shortName="LB", doc="The library name to place into the LB attribute in the read group header", optional=true)
    public String LIBRARY_NAME;
    @Option(shortName="PU", doc="The platform unit (often run_barcode.lane) to insert into the read group header", optional=true)
    public String PLATFORM_UNIT;
    @Option(shortName="PL", doc="The platform type (e.g. illumina, solid) to insert into the read group header", optional=true)
    public String PLATFORM;
    @Option(shortName="CN", doc="The sequencing center from which the data originated", optional=true)
    public String SEQUENCING_CENTER;
    @Option(shortName="PI", doc="Predicted median insert size, to insert into the read group header", optional=true)
    public Integer PREDICTED_INSERT_SIZE;
    @Option(shortName="PG", doc="Program group to insert into the read group header.", optional=true)
    public String PROGRAM_GROUP;
    @Option(shortName="PM", doc="Platform model to insert into the group header (free-form text providing further details of the platform/technology used)", optional=true)
    public String PLATFORM_MODEL;
    @Option(doc="Comment(s) to include in the merged output file's header.", optional=true, shortName="CO")
    public List<String> COMMENT = new ArrayList<String>();
    @Option(shortName="DS", doc="Inserted into the read group header", optional=true)
    public String DESCRIPTION;
    @Option(shortName="DT", doc="Date the run was produced, to insert into the read group header", optional=true)
    public Iso8601Date RUN_DATE;
    @Option(shortName="SO", doc="The sort order for the output sam/bam file.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(doc="Minimum quality allowed in the input fastq.  An exception will be thrown if a quality is less than this value.")
    public int MIN_Q = 0;
    @Option(doc="Maximum quality allowed in the input fastq.  An exception will be thrown if a quality is greater than this value.")
    public int MAX_Q = 93;
    @Option(doc="If true and this is an unpaired fastq any occurrence of '/1' will be removed from the end of a read name.")
    public Boolean STRIP_UNPAIRED_MATE_NUMBER = false;
    @Option(doc="Allow (and ignore) empty lines")
    public Boolean ALLOW_AND_IGNORE_EMPTY_LINES = false;
    private static final SolexaQualityConverter solexaQualityConverter = SolexaQualityConverter.getSingleton();

    public static FastqQualityFormat determineQualityFormat(FastqReader fastqReader, FastqReader fastqReader2, FastqQualityFormat fastqQualityFormat) {
        QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
        if (fastqReader2 == null) {
            qualityEncodingDetector.add(10000L, new FastqReader[]{fastqReader});
        } else {
            qualityEncodingDetector.add(10000L, new FastqReader[]{fastqReader, fastqReader2});
            fastqReader2.close();
        }
        fastqReader.close();
        FastqQualityFormat fastqQualityFormat2 = qualityEncodingDetector.generateBestGuess(QualityEncodingDetector.FileContext.FASTQ, fastqQualityFormat);
        if (qualityEncodingDetector.isDeterminationAmbiguous()) {
            LOG.warn(new Object[]{"Making ambiguous determination about fastq's quality encoding; more than one format possible based on observed qualities."});
        }
        LOG.info(new Object[]{String.format("Auto-detected quality format as: %s.", fastqQualityFormat2)});
        return fastqQualityFormat2;
    }

    public static void main(String[] stringArray) {
        System.exit(new FastqToSam().instanceMain(stringArray));
    }

    protected static List<File> getSequentialFileList(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        FastqConstants.FastqExtensions fastqExtensions = null;
        String string = null;
        for (FastqConstants.FastqExtensions fastqExtensions2 : FastqConstants.FastqExtensions.values()) {
            string = "_001" + fastqExtensions2.getExtension();
            if (!file.getAbsolutePath().endsWith(string)) continue;
            fastqExtensions = fastqExtensions2;
            break;
        }
        if (null == fastqExtensions) {
            throw new PicardException(String.format("Could not parse the FASTQ extension (expected '_001' + '%s'): %s", FastqConstants.FastqExtensions.values().toString(), file));
        }
        int n = 2;
        while (true) {
            String string2 = file.getAbsolutePath();
            string2 = String.format("%s_%03d%s", string2.substring(0, string2.length() - string.length()), n, fastqExtensions.getExtension());
            try {
                IOUtil.assertFileIsReadable((File)new File(string2));
            }
            catch (SAMException sAMException) {
                break;
            }
            arrayList.add(new File(string2));
            ++n;
        }
        return arrayList;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.FASTQ);
        if (this.FASTQ2 != null) {
            IOUtil.assertFileIsReadable((File)this.FASTQ2);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMFileHeader sAMFileHeader = this.createSamFileHeader();
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, false, this.OUTPUT);
        this.QUALITY_FORMAT = FastqToSam.determineQualityFormat(this.fileToFastqReader(this.FASTQ), this.FASTQ2 == null ? null : this.fileToFastqReader(this.FASTQ2), this.QUALITY_FORMAT);
        ArrayList<FastqReader> arrayList = new ArrayList<FastqReader>();
        ArrayList<FastqReader> arrayList2 = new ArrayList<FastqReader>();
        if (this.USE_SEQUENTIAL_FASTQS) {
            for (File file : FastqToSam.getSequentialFileList(this.FASTQ)) {
                arrayList.add(this.fileToFastqReader(file));
            }
            if (null != this.FASTQ2) {
                for (File file : FastqToSam.getSequentialFileList(this.FASTQ2)) {
                    arrayList2.add(this.fileToFastqReader(file));
                }
                if (arrayList.size() != arrayList2.size()) {
                    throw new PicardException(String.format("Found %d files for FASTQ and %d files for FASTQ2.", arrayList.size(), arrayList2.size()));
                }
            }
        } else {
            arrayList.add(this.fileToFastqReader(this.FASTQ));
            if (this.FASTQ2 != null) {
                arrayList2.add(this.fileToFastqReader(this.FASTQ2));
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.makeItSo((FastqReader)arrayList.get(i), arrayList2.isEmpty() ? null : (FastqReader)arrayList2.get(i), sAMFileWriter);
        }
        for (FastqReader fastqReader : arrayList) {
            fastqReader.close();
        }
        for (FastqReader fastqReader : arrayList2) {
            fastqReader.close();
        }
        sAMFileWriter.close();
        return 0;
    }

    public void makeItSo(FastqReader fastqReader, FastqReader fastqReader2, SAMFileWriter sAMFileWriter) {
        int n = fastqReader2 == null ? this.doUnpaired(fastqReader, sAMFileWriter) : this.doPaired(fastqReader, fastqReader2, sAMFileWriter);
        LOG.info(new Object[]{"Processed " + n + " fastq reads"});
    }

    protected int doUnpaired(FastqReader fastqReader, SAMFileWriter sAMFileWriter) {
        int n = 0;
        ProgressLogger progressLogger = new ProgressLogger(LOG);
        while (fastqReader.hasNext()) {
            FastqRecord fastqRecord = fastqReader.next();
            SAMRecord sAMRecord = this.createSamRecord(sAMFileWriter.getFileHeader(), this.getReadName(fastqRecord.getReadHeader(), false), fastqRecord, false);
            sAMRecord.setReadPairedFlag(false);
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
            ++n;
        }
        return n;
    }

    protected int doPaired(FastqReader fastqReader, FastqReader fastqReader2, SAMFileWriter sAMFileWriter) {
        int n = 0;
        ProgressLogger progressLogger = new ProgressLogger(LOG);
        while (fastqReader.hasNext() && fastqReader2.hasNext()) {
            FastqRecord fastqRecord = fastqReader.next();
            FastqRecord fastqRecord2 = fastqReader2.next();
            String string = this.getReadName(fastqRecord.getReadHeader(), true);
            String string2 = this.getReadName(fastqRecord2.getReadHeader(), true);
            String string3 = this.getBaseName(string, string2, fastqReader, fastqReader2);
            SAMRecord sAMRecord = this.createSamRecord(sAMFileWriter.getFileHeader(), string3, fastqRecord, true);
            sAMRecord.setFirstOfPairFlag(true);
            sAMRecord.setSecondOfPairFlag(false);
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
            SAMRecord sAMRecord2 = this.createSamRecord(sAMFileWriter.getFileHeader(), string3, fastqRecord2, true);
            sAMRecord2.setFirstOfPairFlag(false);
            sAMRecord2.setSecondOfPairFlag(true);
            sAMFileWriter.addAlignment(sAMRecord2);
            progressLogger.record(sAMRecord2);
            ++n;
        }
        if (fastqReader.hasNext() || fastqReader2.hasNext()) {
            throw new PicardException("Input paired fastq files must be the same length");
        }
        return n;
    }

    private FastqReader fileToFastqReader(File file) {
        return new FastqReader(file, this.ALLOW_AND_IGNORE_EMPTY_LINES.booleanValue());
    }

    private SAMRecord createSamRecord(SAMFileHeader sAMFileHeader, String string, FastqRecord fastqRecord, boolean bl) {
        SAMRecord sAMRecord = new SAMRecord(sAMFileHeader);
        sAMRecord.setReadName(string);
        sAMRecord.setReadString(fastqRecord.getReadString());
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setAttribute(ReservedTagConstants.READ_GROUP_ID, (Object)this.READ_GROUP_NAME);
        byte[] byArray = StringUtil.stringToBytes((String)fastqRecord.getBaseQualityString());
        this.convertQuality(byArray, this.QUALITY_FORMAT);
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (n >= this.MIN_Q && n <= this.MAX_Q) continue;
            throw new PicardException("Base quality " + n + " is not in the range " + this.MIN_Q + ".." + this.MAX_Q + " for read " + fastqRecord.getReadHeader());
        }
        sAMRecord.setBaseQualities(byArray);
        if (bl) {
            sAMRecord.setReadPairedFlag(true);
            sAMRecord.setMateUnmappedFlag(true);
        }
        return sAMRecord;
    }

    public SAMFileHeader createSamFileHeader() {
        SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(this.READ_GROUP_NAME);
        sAMReadGroupRecord.setSample(this.SAMPLE_NAME);
        if (this.LIBRARY_NAME != null) {
            sAMReadGroupRecord.setLibrary(this.LIBRARY_NAME);
        }
        if (this.PLATFORM != null) {
            sAMReadGroupRecord.setPlatform(this.PLATFORM);
        }
        if (this.PLATFORM_UNIT != null) {
            sAMReadGroupRecord.setPlatformUnit(this.PLATFORM_UNIT);
        }
        if (this.SEQUENCING_CENTER != null) {
            sAMReadGroupRecord.setSequencingCenter(this.SEQUENCING_CENTER);
        }
        if (this.PREDICTED_INSERT_SIZE != null) {
            sAMReadGroupRecord.setPredictedMedianInsertSize(this.PREDICTED_INSERT_SIZE);
        }
        if (this.DESCRIPTION != null) {
            sAMReadGroupRecord.setDescription(this.DESCRIPTION);
        }
        if (this.RUN_DATE != null) {
            sAMReadGroupRecord.setRunDate((Date)this.RUN_DATE);
        }
        if (this.PLATFORM_MODEL != null) {
            sAMReadGroupRecord.setPlatformModel(this.PLATFORM_MODEL);
        }
        if (this.PROGRAM_GROUP != null) {
            sAMReadGroupRecord.setProgramGroup(this.PROGRAM_GROUP);
        }
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.addReadGroup(sAMReadGroupRecord);
        for (String string : this.COMMENT) {
            sAMFileHeader.addComment(string);
        }
        sAMFileHeader.setSortOrder(this.SORT_ORDER);
        return sAMFileHeader;
    }

    void convertQuality(byte[] byArray, FastqQualityFormat fastqQualityFormat) {
        switch (fastqQualityFormat) {
            case Standard: {
                SAMUtils.fastqToPhred((byte[])byArray);
                break;
            }
            case Solexa: {
                solexaQualityConverter.convertSolexaQualityCharsToPhredBinary(byArray);
                break;
            }
            case Illumina: {
                solexaQualityConverter.convertSolexa_1_3_QualityCharsToPhredBinary(byArray);
            }
        }
    }

    String getBaseName(String string, String string2, FastqReader fastqReader, FastqReader fastqReader2) {
        String[] stringArray = this.getReadNameTokens(string, 1, fastqReader);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        stringArray = this.getReadNameTokens(string2, 2, fastqReader2);
        String string5 = stringArray[0];
        String string6 = stringArray[1];
        if (!string3.equals(string5)) {
            throw new PicardException(String.format("In paired mode, read name 1 (%s) does not match read name 2 (%s)", string3, string5));
        }
        boolean bl = StringUtil.isBlank((String)string4);
        boolean bl2 = StringUtil.isBlank((String)string6);
        if (bl || bl2) {
            if (!bl) {
                throw new PicardException(this.error(fastqReader, "Pair 1 number is missing (" + string + "). Both pair numbers must be present or neither."));
            }
            if (!bl2) {
                throw new PicardException(this.error(fastqReader2, "Pair 2 number is missing (" + string2 + "). Both pair numbers must be present or neither."));
            }
        } else {
            if (!string4.equals("1")) {
                throw new PicardException(this.error(fastqReader, "Pair 1 number must be 1 (" + string + ")"));
            }
            if (!string6.equals("2")) {
                throw new PicardException(this.error(fastqReader2, "Pair 2 number must be 2 (" + string2 + ")"));
            }
        }
        return string3;
    }

    private String[] getReadNameTokens(String string, int n, FastqReader fastqReader) {
        if (string.equals("")) {
            throw new PicardException(this.error(fastqReader, "Pair read name " + n + " cannot be empty: " + string));
        }
        int n2 = string.lastIndexOf("/");
        String[] stringArray = new String[2];
        if (n2 == -1) {
            stringArray[0] = string;
            stringArray[1] = null;
        } else {
            stringArray[1] = string.substring(n2 + 1, string.length());
            if (!stringArray[1].equals("1") && !stringArray[1].equals("2")) {
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n2);
            }
        }
        return stringArray;
    }

    private String error(FastqReader fastqReader, String string) {
        return string + " at line " + fastqReader.getLineNumber() + " in file " + fastqReader.getFile().getAbsolutePath();
    }

    private String getReadName(String string, boolean bl) {
        String string2;
        int n = string.indexOf(" ");
        String string3 = string2 = n == -1 ? string : string.substring(0, n);
        while (this.STRIP_UNPAIRED_MATE_NUMBER.booleanValue() && !bl && (string2.endsWith("/1") || string2.endsWith("/2"))) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.MIN_Q < 0) {
            return new String[]{"MIN_Q must be >= 0"};
        }
        if (this.MAX_Q > 93) {
            return new String[]{"MAX_Q must be <= 93"};
        }
        return null;
    }
}

