/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Merges multiple SAM and/or BAM files into a single file.  This tool is used for combining SAM and/or BAM files from different runs or read groups, similarly to the \"merge\" function of Samtools (http://www.htslib.org/doc/samtools.html).  <br /><br />Note that to prevent errors in downstream processing, it is critical to identify/label read groups appropriately. If different samples contain identical read group IDs, this tool will avoid collisions by modifying the read group IDs to be unique. For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MergeSamFiles \\<br />      I=input_1.bam \\<br />      I=input_2.bam \\<br />      O=merged_files.bam</pre><hr />", usageShort="Merges multiple SAM and/or BAM files into a single file.  ", programGroup=SamOrBam.class)
public class MergeSamFiles
extends CommandLineProgram {
    private static final Log log = Log.getInstance(MergeSamFiles.class);
    static final String USAGE_SUMMARY = "Merges multiple SAM and/or BAM files into a single file.  ";
    static final String USAGE_DETAILS = "This tool is used for combining SAM and/or BAM files from different runs or read groups, similarly to the \"merge\" function of Samtools (http://www.htslib.org/doc/samtools.html).  <br /><br />Note that to prevent errors in downstream processing, it is critical to identify/label read groups appropriately. If different samples contain identical read group IDs, this tool will avoid collisions by modifying the read group IDs to be unique. For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MergeSamFiles \\<br />      I=input_1.bam \\<br />      I=input_2.bam \\<br />      O=merged_files.bam</pre><hr />";
    @Option(shortName="I", doc="SAM or BAM input file", minElements=1)
    public List<File> INPUT = new ArrayList<File>();
    @Option(shortName="O", doc="SAM or BAM file to write merged result to")
    public File OUTPUT;
    @Option(shortName="SO", doc="Sort order of output file", optional=true)
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.coordinate;
    @Option(doc="If true, assume that the input files are in the same sort order as the requested output sort order, even if their headers say otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="MSD", doc="Merge the sequence dictionaries", optional=true)
    public boolean MERGE_SEQUENCE_DICTIONARIES = false;
    @Option(doc="Option to create a background thread to encode, compress and write to disk the output file. The threaded version uses about 20% more CPU and decreases runtime by ~20% when writing out a compressed BAM file.")
    public boolean USE_THREADING = false;
    @Option(doc="Comment(s) to include in the merged output file's header.", optional=true, shortName="CO")
    public List<String> COMMENT = new ArrayList<String>();
    @Option(shortName="RGN", doc="An interval list file that contains the locations of the positions to merge. Assume bam are sorted and indexed. The resulting file will contain alignments that may overlap with genomic regions outside the requested region. Unmapped reads are discarded.", optional=true)
    public File INTERVALS = null;
    private static final int PROGRESS_INTERVAL = 1000000;

    public static void main(String[] stringArray) {
        System.exit(new MergeSamFiles().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        String string2;
        boolean bl;
        boolean bl2;
        SAMFileHeader.SortOrder sortOrder;
        CloseableIterator closeableIterator;
        SamReader samReader;
        boolean bl3 = true;
        List list = this.INTERVALS == null ? null : IntervalList.fromFile((File)this.INTERVALS).uniqued().getIntervals();
        HashMap<SamReader, CloseableIterator> hashMap = new HashMap<SamReader, CloseableIterator>(this.INPUT.size());
        ArrayList<SamReader> arrayList = new ArrayList<SamReader>();
        ArrayList<SAMFileHeader> arrayList2 = new ArrayList<SAMFileHeader>();
        SAMSequenceDictionary sAMSequenceDictionary = null;
        for (File file : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file);
            samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(file);
            if (this.INTERVALS != null) {
                if (!samReader.hasIndex()) {
                    throw new PicardException("Merging with interval but Bam file is not indexed " + file);
                }
                closeableIterator = new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(samReader, list, true);
                hashMap.put(samReader, closeableIterator);
            }
            arrayList.add(samReader);
            arrayList2.add(samReader.getFileHeader());
            if (sAMSequenceDictionary == null) {
                sAMSequenceDictionary = samReader.getFileHeader().getSequenceDictionary();
            } else if (sAMSequenceDictionary.equals((Object)samReader.getFileHeader().getSequenceDictionary())) {
                samReader.getFileHeader().setSequenceDictionary(sAMSequenceDictionary);
            }
            bl3 = bl3 && samReader.getFileHeader().getSortOrder() == this.SORT_ORDER;
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (bl3 || this.SORT_ORDER == SAMFileHeader.SortOrder.unsorted || this.ASSUME_SORTED || this.INTERVALS != null) {
            log.info(new Object[]{"Input files are in same order as output so sorting to temp directory is not needed."});
            sortOrder = this.SORT_ORDER;
            bl2 = this.ASSUME_SORTED;
            bl = true;
        } else {
            log.info(new Object[]{"Sorting input files using temp directory " + this.TMP_DIR});
            sortOrder = SAMFileHeader.SortOrder.unsorted;
            bl2 = false;
            bl = false;
        }
        samReader = new SamFileHeaderMerger(sortOrder, arrayList2, this.MERGE_SEQUENCE_DICTIONARIES);
        if (list == null) {
            closeableIterator = new MergingSamRecordIterator((SamFileHeaderMerger)samReader, arrayList, bl2);
        } else {
            log.info(new Object[]{"Warning: merged bams from different interval lists may contain the same read in both files"});
            closeableIterator = new MergingSamRecordIterator((SamFileHeaderMerger)samReader, hashMap, true);
        }
        SAMFileHeader sAMFileHeader = samReader.getMergedHeader();
        for (String string2 : this.COMMENT) {
            sAMFileHeader.addComment(string2);
        }
        sAMFileHeader.setSortOrder(this.SORT_ORDER);
        SAMFileWriterFactory sAMFileWriterFactory = new SAMFileWriterFactory();
        if (this.USE_THREADING) {
            sAMFileWriterFactory.setUseAsyncIo(true);
        }
        string2 = sAMFileWriterFactory.makeSAMOrBAMWriter(sAMFileHeader, bl, this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000);
        while (closeableIterator.hasNext()) {
            SAMRecord sAMRecord = closeableIterator.next();
            string2.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        log.info(new Object[]{"Finished reading inputs."});
        for (CloseableIterator closeableIterator2 : hashMap.values()) {
            CloserUtil.close((Object)closeableIterator2);
        }
        CloserUtil.close(arrayList);
        string2.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CREATE_INDEX.booleanValue() && this.SORT_ORDER != SAMFileHeader.SortOrder.coordinate) {
            return new String[]{"Can't CREATE_INDEX unless SORT_ORDER is coordinate"};
        }
        return null;
    }
}

