/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Replaces the SAMFileHeader in a SAM or BAM file.  This tool makes it possible to replace the header of a SAM or BAM file with the header of anotherfile, or a header block that has been edited manually (in a stub SAM file). The sort order (@SO) of the two input files must be the same.<br /><br />Note that validation is minimal, so it is up to the user to ensure that all the elements referred to in the SAMRecords are present in the new header. <br /><h4>Usage example:</h4><pre>java -jar picard.jar ReplaceSamHeader \\<br />      I=input_1.bam \\<br />      HEADER=input_2.bam \\<br />      O=bam_with_new_head.bam</pre><hr />", usageShort="Replaces the SAMFileHeader in a SAM or BAM file.  ", programGroup=SamOrBam.class)
public class ReplaceSamHeader
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Replaces the SAMFileHeader in a SAM or BAM file.  ";
    static final String USAGE_DETAILS = "This tool makes it possible to replace the header of a SAM or BAM file with the header of anotherfile, or a header block that has been edited manually (in a stub SAM file). The sort order (@SO) of the two input files must be the same.<br /><br />Note that validation is minimal, so it is up to the user to ensure that all the elements referred to in the SAMRecords are present in the new header. <br /><h4>Usage example:</h4><pre>java -jar picard.jar ReplaceSamHeader \\<br />      I=input_1.bam \\<br />      HEADER=input_2.bam \\<br />      O=bam_with_new_head.bam</pre><hr />";
    @Option(doc="SAM file from which SAMRecords will be read.", shortName="I")
    public File INPUT;
    @Option(doc="SAM file from which SAMFileHeader will be read.")
    public File HEADER;
    @Option(doc="SAMFileHeader from HEADER file will be written to this file, followed by SAMRecords from INPUT file", shortName="O")
    public File OUTPUT;

    public static void main(String[] stringArray) {
        new ReplaceSamHeader().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.HEADER);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMFileHeader sAMFileHeader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.HEADER);
        if (BamFileIoUtils.isBamFile((File)this.INPUT)) {
            this.blockCopyReheader(sAMFileHeader);
        } else {
            this.standardReheader(sAMFileHeader);
        }
        return 0;
    }

    private void standardReheader(SAMFileHeader sAMFileHeader) {
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(ValidationStringency.SILENT).open(this.INPUT);
        if (sAMFileHeader.getSortOrder() != samReader.getFileHeader().getSortOrder()) {
            throw new PicardException("Sort orders of INPUT (" + samReader.getFileHeader().getSortOrder().name() + ") and HEADER (" + sAMFileHeader.getSortOrder().name() + ") do not agree.");
        }
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, true, this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(Log.getInstance(ReplaceSamHeader.class));
        for (SAMRecord sAMRecord : samReader) {
            sAMRecord.setHeader(sAMFileHeader);
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        sAMFileWriter.close();
        CloserUtil.close((Object)samReader);
    }

    private void blockCopyReheader(SAMFileHeader sAMFileHeader) {
        BamFileIoUtils.reheaderBamFile((SAMFileHeader)sAMFileHeader, (File)this.INPUT, (File)this.OUTPUT, (boolean)this.CREATE_MD5_FILE, (boolean)this.CREATE_INDEX);
    }
}

