/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMRecordUtil;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.filter.FilteringIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FastqQualityFormat;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.QualityEncodingDetector;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(usage="Reverts SAM or BAM files to a previous state.  This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.<h4>Example with single output:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     O=reverted.bam</pre>Output format is BAM by default, or SAM or CRAM if the input path ends with '.sam' or '.cram', respectively.<h4>Example outputting by read group with output map:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     OUTPUT_BY_READGROUP=true \\<br />     OUTPUT_MAP=reverted_bam_paths.tsv</pre>Will output a BAM/SAM file per read group. By default, all outputs will be in BAM format. However, a SAM file will be produced instead for any read group mapped in OUTPUT_MAP to a path ending with '.sam'. A CRAM file will be produced for any read group mapped to a path ending with '.cram'. <h4>Example outputting by read group without output map:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     OUTPUT_BY_READGROUP=true \\<br />     O=/write/reverted/read/group/bams/in/this/dir</pre>Will output a BAM/SAM file per read group. By default, all outputs will be in BAM format. However, outputs will be in SAM format if the input path ends with '.sam', or CRAM format if it ends with '.cram'.<hr />", usageShort="Reverts SAM or BAM files to a previous state.  ", programGroup=SamOrBam.class)
public class RevertSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Reverts SAM or BAM files to a previous state.  ";
    static final String USAGE_DETAILS = "This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.<h4>Example with single output:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     O=reverted.bam</pre>Output format is BAM by default, or SAM or CRAM if the input path ends with '.sam' or '.cram', respectively.<h4>Example outputting by read group with output map:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     OUTPUT_BY_READGROUP=true \\<br />     OUTPUT_MAP=reverted_bam_paths.tsv</pre>Will output a BAM/SAM file per read group. By default, all outputs will be in BAM format. However, a SAM file will be produced instead for any read group mapped in OUTPUT_MAP to a path ending with '.sam'. A CRAM file will be produced for any read group mapped to a path ending with '.cram'. <h4>Example outputting by read group without output map:</h4><pre>java -jar picard.jar RevertSam \\<br />     I=input.bam \\<br />     OUTPUT_BY_READGROUP=true \\<br />     O=/write/reverted/read/group/bams/in/this/dir</pre>Will output a BAM/SAM file per read group. By default, all outputs will be in BAM format. However, outputs will be in SAM format if the input path ends with '.sam', or CRAM format if it ends with '.cram'.<hr />";
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(mutex={"OUTPUT_MAP"}, shortName="O", doc="The output SAM/BAM file to create, or an output directory if OUTPUT_BY_READGROUP is true.")
    public File OUTPUT;
    @Option(mutex={"OUTPUT"}, shortName="OM", doc="Tab separated file with two columns, READ_GROUP_ID and OUTPUT, providing file mapping only used if OUTPUT_BY_READGROUP is true.")
    public File OUTPUT_MAP;
    @Option(shortName="OBR", doc="When true, outputs each read group in a separate file.")
    public boolean OUTPUT_BY_READGROUP = false;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="Remove duplicate read flags from all reads.  Note that if this is true and REMOVE_ALIGNMENT_INFORMATION==false,  the output may have the unusual but sometimes desirable trait of having unmapped reads that are marked as duplicates.")
    public boolean REMOVE_DUPLICATE_INFORMATION = true;
    @Option(doc="Remove all alignment information from the file.")
    public boolean REMOVE_ALIGNMENT_INFORMATION = true;
    @Option(doc="When removing alignment information, the set of optional tags to remove.")
    public List<String> ATTRIBUTE_TO_CLEAR = new ArrayList<String>(){
        {
            this.add(SAMTag.NM.name());
            this.add(SAMTag.UQ.name());
            this.add(SAMTag.PG.name());
            this.add(SAMTag.MD.name());
            this.add(SAMTag.MQ.name());
            this.add(SAMTag.SA.name());
            this.add(SAMTag.MC.name());
            this.add(SAMTag.AS.name());
        }
    };
    @Option(doc="WARNING: This option is potentially destructive. If enabled will discard reads in order to produce a consistent output BAM. Reads discarded include (but are not limited to) paired reads with missing mates, duplicated records, records with mismatches in length of bases and qualities. This option can only be enabled if the output sort order is queryname and will always cause sorting to occur.")
    public boolean SANITIZE = false;
    @Option(doc="If SANITIZE=true and higher than MAX_DISCARD_FRACTION reads are discarded due to sanitization thenthe program will exit with an Exception instead of exiting cleanly. Output BAM will still be valid.")
    public double MAX_DISCARD_FRACTION = 0.01;
    @Option(doc="The sample alias to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="ALIAS", optional=true)
    public String SAMPLE_ALIAS;
    @Option(doc="The library name to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same library name ", shortName="LIB", optional=true)
    public String LIBRARY_NAME;
    private static final Log log = Log.getInstance(RevertSam.class);

    public static void main(String[] stringArray) {
        new RevertSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ValidationUtil.validateSanitizeSortOrder(this.SANITIZE, this.SORT_ORDER, arrayList);
        ValidationUtil.validateOutputParams(this.OUTPUT_BY_READGROUP, this.OUTPUT, this.OUTPUT_MAP, arrayList);
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    @Override
    protected int doWork() {
        Map<String, SAMFileHeader> map;
        Map<String, File> map2;
        String string;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        ValidationUtil.assertWritable(this.OUTPUT, this.OUTPUT_BY_READGROUP);
        boolean bl = this.SANITIZE;
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(this.VALIDATION_STRINGENCY).open(this.INPUT);
        SAMFileHeader sAMFileHeader = samReader.getFileHeader();
        ValidationUtil.validateHeaderOverrides(sAMFileHeader, this.SAMPLE_ALIAS, this.LIBRARY_NAME);
        boolean bl2 = this.isPresorted(sAMFileHeader, this.SORT_ORDER, bl);
        if (this.SAMPLE_ALIAS != null) {
            this.overwriteSample(sAMFileHeader.getReadGroups(), this.SAMPLE_ALIAS);
        }
        if (this.LIBRARY_NAME != null) {
            this.overwriteLibrary(sAMFileHeader.getReadGroups(), this.LIBRARY_NAME);
        }
        SAMFileHeader sAMFileHeader2 = this.createOutHeader(sAMFileHeader, this.SORT_ORDER, this.REMOVE_ALIGNMENT_INFORMATION);
        sAMFileHeader.getReadGroups().forEach(sAMReadGroupRecord -> sAMFileHeader2.addReadGroup(sAMReadGroupRecord));
        if (this.OUTPUT_BY_READGROUP) {
            string = RevertSam.getDefaultExtension(this.INPUT.toString());
            map2 = RevertSam.createOutputMap(this.OUTPUT_MAP, this.OUTPUT, string, sAMFileHeader.getReadGroups());
            ValidationUtil.assertAllReadGroupsMapped(map2, sAMFileHeader.getReadGroups());
            map = this.createHeaderMap(sAMFileHeader, this.SORT_ORDER, this.REMOVE_ALIGNMENT_INFORMATION);
        } else {
            map2 = null;
            map = null;
        }
        string = new SAMFileWriterFactory();
        RevertSamWriter revertSamWriter = new RevertSamWriter(this.OUTPUT_BY_READGROUP, map, map2, sAMFileHeader2, this.OUTPUT, bl2, (SAMFileWriterFactory)string, this.REFERENCE_SEQUENCE);
        RevertSamSorter revertSamSorter = bl ? new RevertSamSorter(this.OUTPUT_BY_READGROUP, map, sAMFileHeader2, this.MAX_RECORDS_IN_RAM) : null;
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Reverted");
        for (Object object2 : samReader) {
            if (object2.isSecondaryOrSupplementary()) continue;
            progressLogger.record(object2);
            this.revertSamRecord((SAMRecord)object2);
            if (bl) {
                revertSamSorter.add((SAMRecord)object2);
                continue;
            }
            revertSamWriter.addAlignment((SAMRecord)object2);
        }
        if (!bl) {
            revertSamWriter.close();
        } else {
            Object object;
            Object object2;
            try {
                object = this.createReadGroupFormatMap(sAMFileHeader, this.REFERENCE_SEQUENCE, this.VALIDATION_STRINGENCY, this.INPUT, this.RESTORE_ORIGINAL_QUALITIES);
            }
            catch (PicardException picardException) {
                log.error(new Object[]{picardException.getMessage()});
                return -1;
            }
            object2 = this.sanitize((Map<SAMReadGroupRecord, FastqQualityFormat>)object, revertSamSorter, revertSamWriter);
            SAMRecord sAMRecord = object2[0];
            SAMRecord sAMRecord2 = object2[1];
            revertSamWriter.close();
            double d = (double)sAMRecord / (double)sAMRecord2;
            DecimalFormat decimalFormat = new DecimalFormat("0.000%");
            log.info(new Object[]{"Discarded " + (long)sAMRecord + " out of " + (long)sAMRecord2 + " (" + decimalFormat.format(d) + ") reads in order to sanitize output."});
            if (d > this.MAX_DISCARD_FRACTION) {
                throw new PicardException("Discarded " + decimalFormat.format(d) + " which is above MAX_DISCARD_FRACTION of " + decimalFormat.format(this.MAX_DISCARD_FRACTION));
            }
        }
        CloserUtil.close((Object)samReader);
        return 0;
    }

    static String getDefaultExtension(String string) {
        if (string.endsWith(".sam")) {
            return ".sam";
        }
        if (string.endsWith(".cram")) {
            return ".cram";
        }
        return ".bam";
    }

    private boolean isPresorted(SAMFileHeader sAMFileHeader, SAMFileHeader.SortOrder sortOrder, boolean bl) {
        return sAMFileHeader.getSortOrder() == sortOrder || sortOrder == SAMFileHeader.SortOrder.queryname && bl;
    }

    public void revertSamRecord(SAMRecord sAMRecord) {
        byte[] byArray;
        if (this.RESTORE_ORIGINAL_QUALITIES && (byArray = sAMRecord.getOriginalBaseQualities()) != null) {
            sAMRecord.setBaseQualities(byArray);
            sAMRecord.setOriginalBaseQualities(null);
        }
        if (this.REMOVE_DUPLICATE_INFORMATION) {
            sAMRecord.setDuplicateReadFlag(false);
        }
        if (this.REMOVE_ALIGNMENT_INFORMATION) {
            if (sAMRecord.getReadNegativeStrandFlag()) {
                SAMRecordUtil.reverseComplement((SAMRecord)sAMRecord);
                sAMRecord.setReadNegativeStrandFlag(false);
            }
            sAMRecord.setReferenceIndex(-1);
            sAMRecord.setAlignmentStart(0);
            sAMRecord.setCigarString("*");
            sAMRecord.setMappingQuality(0);
            sAMRecord.setInferredInsertSize(0);
            sAMRecord.setNotPrimaryAlignmentFlag(false);
            sAMRecord.setProperPairFlag(false);
            sAMRecord.setReadUnmappedFlag(true);
            sAMRecord.setMateAlignmentStart(0);
            sAMRecord.setMateNegativeStrandFlag(false);
            sAMRecord.setMateReferenceIndex(-1);
            sAMRecord.setMateUnmappedFlag(true);
            this.ATTRIBUTE_TO_CLEAR.forEach(string -> sAMRecord.setAttribute(string, null));
        }
    }

    private long[] sanitize(Map<SAMReadGroupRecord, FastqQualityFormat> map, RevertSamSorter revertSamSorter, RevertSamWriter revertSamWriter) {
        long l = 0L;
        long l2 = 0L;
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Sanitized");
        List<PeekableIterator<SAMRecord>> list = revertSamSorter.iterators();
        for (PeekableIterator<SAMRecord> peekableIterator : list) {
            block1: while (peekableIterator.hasNext()) {
                List<SAMRecord> list2 = this.fetchByReadName(peekableIterator);
                l += (long)list2.size();
                for (SAMRecord sAMRecord : list2) {
                    if (sAMRecord.getReadBases().length == sAMRecord.getBaseQualities().length) continue;
                    log.debug(new Object[]{"Discarding " + list2.size() + " reads with name " + sAMRecord.getReadName() + " for mismatching bases and quals length."});
                    l2 += (long)list2.size();
                    continue block1;
                }
                if (!list2.get(0).getReadPairedFlag() && list2.size() > 1) {
                    log.debug(new Object[]{"Discarding " + list2.size() + " reads with name " + list2.get(0).getReadName() + " because they claim to be unpaired."});
                    l2 += (long)list2.size();
                    continue;
                }
                if (list2.get(0).getReadPairedFlag()) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    for (SAMRecord sAMRecord : list2) {
                        if (!sAMRecord.getReadPairedFlag()) {
                            ++n3;
                        }
                        if (sAMRecord.getFirstOfPairFlag()) {
                            ++n;
                        }
                        if (!sAMRecord.getSecondOfPairFlag()) continue;
                        ++n2;
                    }
                    if (n3 > 0 || n != 1 || n2 != 1) {
                        log.debug(new Object[]{"Discarding " + list2.size() + " reads with name " + list2.get(0).getReadName() + " because pairing information in corrupt."});
                        l2 += (long)list2.size();
                        continue;
                    }
                }
                for (SAMRecord sAMRecord : list2) {
                    FastqQualityFormat fastqQualityFormat = map.get(sAMRecord.getReadGroup());
                    if (!fastqQualityFormat.equals((Object)FastqQualityFormat.Standard)) {
                        Object object = sAMRecord.getBaseQualities();
                        int n = 0;
                        while (n < ((Object)object).length) {
                            Object object2 = object;
                            int n4 = n++;
                            object2[n4] = (byte)(object2[n4] - 31);
                        }
                        sAMRecord.setBaseQualities((byte[])object);
                    }
                    revertSamWriter.addAlignment(sAMRecord);
                    progressLogger.record(sAMRecord);
                }
            }
        }
        return new long[]{l2, l};
    }

    private List<SAMRecord> fetchByReadName(PeekableIterator<SAMRecord> peekableIterator) {
        ArrayList<SAMRecord> arrayList = new ArrayList<SAMRecord>();
        if (peekableIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)peekableIterator.next();
            arrayList.add(sAMRecord);
            while (peekableIterator.hasNext() && ((SAMRecord)peekableIterator.peek()).getReadName().equals(sAMRecord.getReadName())) {
                arrayList.add((SAMRecord)peekableIterator.next());
            }
        }
        return arrayList;
    }

    private void overwriteSample(List<SAMReadGroupRecord> list, String string) {
        list.forEach(sAMReadGroupRecord -> sAMReadGroupRecord.setSample(string));
    }

    private void overwriteLibrary(List<SAMReadGroupRecord> list, String string) {
        list.forEach(sAMReadGroupRecord -> sAMReadGroupRecord.setLibrary(string));
    }

    static Map<String, File> createOutputMap(File file, File file2, String string, List<SAMReadGroupRecord> list) {
        Map<String, File> map = file != null ? RevertSam.createOutputMapFromFile(file) : RevertSam.createOutputMap(list, file2, string);
        return map;
    }

    private static Map<String, File> createOutputMapFromFile(File file) {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(file);
        for (TabbedTextFileWithHeaderParser.Row row : tabbedTextFileWithHeaderParser) {
            String string = row.getField("READ_GROUP_ID");
            String string2 = row.getField("OUTPUT");
            File file2 = new File(string2);
            hashMap.put(string, file2);
        }
        CloserUtil.close((Object)tabbedTextFileWithHeaderParser);
        return hashMap;
    }

    private static Map<String, File> createOutputMap(List<SAMReadGroupRecord> list, File file, String string) {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (SAMReadGroupRecord sAMReadGroupRecord : list) {
            String string2 = sAMReadGroupRecord.getId();
            String string3 = string2 + string;
            Path path = Paths.get(file.toString(), string3);
            hashMap.put(string2, path.toFile());
        }
        return hashMap;
    }

    private Map<String, SAMFileHeader> createHeaderMap(SAMFileHeader sAMFileHeader, SAMFileHeader.SortOrder sortOrder, boolean bl) {
        HashMap<String, SAMFileHeader> hashMap = new HashMap<String, SAMFileHeader>();
        for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            SAMFileHeader sAMFileHeader2 = this.createOutHeader(sAMFileHeader, sortOrder, bl);
            sAMFileHeader2.addReadGroup(sAMReadGroupRecord);
            hashMap.put(sAMReadGroupRecord.getId(), sAMFileHeader2);
        }
        return hashMap;
    }

    private SAMFileHeader createOutHeader(SAMFileHeader sAMFileHeader, SAMFileHeader.SortOrder sortOrder, boolean bl) {
        SAMFileHeader sAMFileHeader2 = new SAMFileHeader();
        sAMFileHeader2.setSortOrder(sortOrder);
        if (!bl) {
            sAMFileHeader2.setSequenceDictionary(sAMFileHeader.getSequenceDictionary());
            sAMFileHeader2.setProgramRecords(sAMFileHeader.getProgramRecords());
        }
        return sAMFileHeader2;
    }

    private Map<SAMReadGroupRecord, FastqQualityFormat> createReadGroupFormatMap(SAMFileHeader sAMFileHeader, File file, ValidationStringency validationStringency, File file2, boolean bl) {
        HashMap<SAMReadGroupRecord, FastqQualityFormat> hashMap = new HashMap<SAMReadGroupRecord, FastqQualityFormat>();
        for (final SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(file).validationStringency(validationStringency).open(file2);
            SamRecordFilter samRecordFilter = new SamRecordFilter(){

                public boolean filterOut(SAMRecord sAMRecord) {
                    return !sAMRecord.getReadGroup().getId().equals(sAMReadGroupRecord.getId());
                }

                public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                    throw new UnsupportedOperationException();
                }
            };
            hashMap.put(sAMReadGroupRecord, QualityEncodingDetector.detect((long)10000L, (CloseableIterator)new FilteringIterator((Iterator)samReader.iterator(), samRecordFilter), (boolean)bl));
            CloserUtil.close((Object)samReader);
        }
        for (final SAMReadGroupRecord sAMReadGroupRecord : hashMap.keySet()) {
            log.info(new Object[]{"Detected quality format for " + sAMReadGroupRecord.getReadGroupId() + ": " + hashMap.get(sAMReadGroupRecord)});
        }
        if (hashMap.values().contains(FastqQualityFormat.Solexa)) {
            throw new PicardException("No quality score encoding conversion implemented for " + FastqQualityFormat.Solexa);
        }
        return hashMap;
    }

    static class ValidationUtil {
        ValidationUtil() {
        }

        static void validateSanitizeSortOrder(boolean bl, SAMFileHeader.SortOrder sortOrder, List<String> list) {
            if (bl && sortOrder != SAMFileHeader.SortOrder.queryname) {
                list.add("SORT_ORDER must be queryname when sanitization is enabled with SANITIZE=true.");
            }
        }

        static void validateOutputParams(boolean bl, File file, File file2, List<String> list) {
            if (bl) {
                ValidationUtil.validateOutputParamsByReadGroup(file, file2, list);
            } else {
                ValidationUtil.validateOutputParamsNotByReadGroup(file, file2, list);
            }
        }

        static void validateOutputParamsByReadGroup(File file, File file2, List<String> list) {
            if (file != null) {
                if (!Files.isDirectory(file.toPath(), new LinkOption[0])) {
                    list.add("When OUTPUT_BY_READGROUP=true and OUTPUT is provided, it must be a directory: " + file);
                }
                return;
            }
            if (file2 == null) {
                list.add("Must provide either OUTPUT or OUTPUT_MAP when OUTPUT_BY_READGROUP=true.");
                return;
            }
            if (!Files.isReadable(file2.toPath())) {
                list.add("Cannot read OUTPUT_MAP " + file2);
                return;
            }
            TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(file2);
            if (!ValidationUtil.isOutputMapHeaderValid(tabbedTextFileWithHeaderParser.columnLabelsList())) {
                list.add("Invalid header: " + file2 + ". Must be a tab-separated file with READ_GROUP_ID as first column and OUTPUT as second column.");
            }
        }

        static void validateOutputParamsNotByReadGroup(File file, File file2, List<String> list) {
            if (file2 != null) {
                list.add("Cannot provide OUTPUT_MAP when OUTPUT_BY_READGROUP=false. Provide OUTPUT instead.");
            }
            if (file == null) {
                list.add("OUTPUT is required when OUTPUT_BY_READGROUP=false");
                return;
            }
            if (Files.isDirectory(file.toPath(), new LinkOption[0])) {
                list.add("OUTPUT " + file + " should not be a directory when OUTPUT_BY_READGROUP=false");
            }
        }

        static void validateHeaderOverrides(SAMFileHeader sAMFileHeader, String string, String string2) {
            List list = sAMFileHeader.getReadGroups();
            if (string != null || string2 != null) {
                boolean bl = true;
                boolean bl2 = true;
                for (int i = 1; i < list.size(); ++i) {
                    if (!((SAMReadGroupRecord)list.get(0)).getSample().equals(((SAMReadGroupRecord)list.get(i)).getSample())) {
                        bl = false;
                    }
                    if (((SAMReadGroupRecord)list.get(0)).getLibrary().equals(((SAMReadGroupRecord)list.get(i)).getLibrary())) continue;
                    bl2 = false;
                }
                if (string != null && !bl) {
                    throw new PicardException("Read groups have multiple values for sample.  A value for SAMPLE_ALIAS cannot be supplied.");
                }
                if (string2 != null && !bl2) {
                    throw new PicardException("Read groups have multiple values for library name.  A value for library name cannot be supplied.");
                }
            }
        }

        static void assertWritable(File file, boolean bl) {
            if (bl) {
                if (file != null) {
                    IOUtil.assertDirectoryIsWritable((File)file);
                }
            } else {
                IOUtil.assertFileIsWritable((File)file);
            }
        }

        static void assertAllReadGroupsMapped(Map<String, File> map, List<SAMReadGroupRecord> list) {
            for (SAMReadGroupRecord sAMReadGroupRecord : list) {
                String string = sAMReadGroupRecord.getId();
                File file = map.get(string);
                if (file != null) continue;
                throw new PicardException("Read group id " + string + " not found in OUTPUT_MAP " + map);
            }
        }

        static boolean isOutputMapHeaderValid(List<String> list) {
            if (list.size() < 2) {
                return false;
            }
            if (!"READ_GROUP_ID".equals(list.get(0))) {
                return false;
            }
            return "OUTPUT".equals(list.get(1));
        }
    }

    private static class RevertSamSorter {
        private final Map<String, SortingCollection<SAMRecord>> sorterMap = new HashMap<String, SortingCollection<SAMRecord>>();
        private final SortingCollection<SAMRecord> singleSorter;
        private final boolean outputByReadGroup;

        RevertSamSorter(boolean bl, Map<String, SAMFileHeader> map, SAMFileHeader sAMFileHeader, int n) {
            this.outputByReadGroup = bl;
            if (bl) {
                for (Map.Entry<String, SAMFileHeader> entry : map.entrySet()) {
                    String string = entry.getKey();
                    SAMFileHeader sAMFileHeader2 = entry.getValue();
                    SortingCollection sortingCollection = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(sAMFileHeader2), (Comparator)new SAMRecordQueryNameComparator(), (int)n);
                    this.sorterMap.put(string, (SortingCollection<SAMRecord>)sortingCollection);
                }
                this.singleSorter = null;
            } else {
                this.singleSorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(sAMFileHeader), (Comparator)new SAMRecordQueryNameComparator(), (int)n);
            }
        }

        void add(SAMRecord sAMRecord) {
            SortingCollection<SAMRecord> sortingCollection = this.outputByReadGroup ? this.sorterMap.get(sAMRecord.getReadGroup().getId()) : this.singleSorter;
            sortingCollection.add((Object)sAMRecord);
        }

        List<PeekableIterator<SAMRecord>> iterators() {
            ArrayList<PeekableIterator<SAMRecord>> arrayList = new ArrayList<PeekableIterator<SAMRecord>>();
            if (this.outputByReadGroup) {
                for (SortingCollection<SAMRecord> sortingCollection : this.sorterMap.values()) {
                    PeekableIterator peekableIterator = new PeekableIterator((Iterator)sortingCollection.iterator());
                    arrayList.add((PeekableIterator<SAMRecord>)peekableIterator);
                }
            } else {
                PeekableIterator peekableIterator = new PeekableIterator((Iterator)this.singleSorter.iterator());
                arrayList.add(peekableIterator);
            }
            return arrayList;
        }
    }

    private static class RevertSamWriter {
        private final Map<String, SAMFileWriter> writerMap = new HashMap<String, SAMFileWriter>();
        private final SAMFileWriter singleWriter;
        private final boolean outputByReadGroup;

        RevertSamWriter(boolean bl, Map<String, SAMFileHeader> map, Map<String, File> map2, SAMFileHeader sAMFileHeader, File file, boolean bl2, SAMFileWriterFactory sAMFileWriterFactory, File file2) {
            this.outputByReadGroup = bl;
            if (bl) {
                this.singleWriter = null;
                for (Map.Entry<String, File> entry : map2.entrySet()) {
                    String string = entry.getKey();
                    File file3 = entry.getValue();
                    SAMFileHeader sAMFileHeader2 = map.get(string);
                    SAMFileWriter sAMFileWriter = sAMFileWriterFactory.makeWriter(sAMFileHeader2, bl2, file3, file2);
                    this.writerMap.put(string, sAMFileWriter);
                }
            } else {
                this.singleWriter = sAMFileWriterFactory.makeWriter(sAMFileHeader, bl2, file, file2);
            }
        }

        void addAlignment(SAMRecord sAMRecord) {
            SAMFileWriter sAMFileWriter = this.outputByReadGroup ? this.writerMap.get(sAMRecord.getReadGroup().getId()) : this.singleWriter;
            sAMFileWriter.addAlignment(sAMRecord);
        }

        void close() {
            if (this.outputByReadGroup) {
                for (SAMFileWriter sAMFileWriter : this.writerMap.values()) {
                    sAMFileWriter.close();
                }
            } else {
                this.singleWriter.close();
            }
        }
    }
}

