/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Takes a SAM or BAM file and separates all the reads into one SAM or BAM file per library name.  Reads that do not have a read group specified or whose read group does not have a library name are written to a file called 'unknown.'  The format (SAM or BAM) of the  output files matches that of the input file.  ", usageShort="Splits a SAM or BAM file into individual files by library", programGroup=SamOrBam.class)
public class SplitSamByLibrary
extends CommandLineProgram {
    @Option(shortName="I", doc="The SAM or BAM file to be split. ")
    public File INPUT;
    @Option(shortName="O", doc="The directory where the library SAM or BAM files should be written (defaults to the current directory). ", optional=true)
    public File OUTPUT = new File(".").getAbsoluteFile();
    private static final Log log = Log.getInstance(SplitSamByLibrary.class);
    public static final int NO_LIBRARIES_SPECIFIED_IN_HEADER = 2;

    public static void main(String[] stringArray) {
        System.exit(new SplitSamByLibrary().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        String string;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertDirectoryIsWritable((File)this.OUTPUT);
        SamReader samReader = SamReaderFactory.makeDefault().open(this.INPUT);
        HashMap<String, SAMFileWriter> hashMap = new HashMap<String, SAMFileWriter>();
        HashMap hashMap2 = new HashMap();
        SAMFileWriterFactory sAMFileWriterFactory = new SAMFileWriterFactory();
        String string2 = samReader.type().equals(SamReader.Type.BAM_TYPE) ? ".bam" : ".sam";
        SAMFileHeader sAMFileHeader = samReader.getFileHeader().clone();
        sAMFileHeader.setReadGroups(new ArrayList());
        SAMFileWriter sAMFileWriter = null;
        for (SAMReadGroupRecord object : samReader.getFileHeader().getReadGroups()) {
            string = object.getLibrary();
            if (string != null) {
                if (!hashMap2.containsKey(string)) {
                    hashMap2.put(string, new ArrayList());
                }
                ((List)hashMap2.get(string)).add(object);
                continue;
            }
            sAMFileHeader.addReadGroup(object);
        }
        if (hashMap2.isEmpty()) {
            log.error(new Object[]{"No individual libraries are specified in the header of " + this.INPUT.getAbsolutePath()});
            return 2;
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            string = (String)entry.getKey();
            SAMFileHeader sAMFileHeader2 = samReader.getFileHeader().clone();
            sAMFileHeader2.setReadGroups((List)entry.getValue());
            hashMap.put(string, sAMFileWriterFactory.makeSAMOrBAMWriter(sAMFileHeader2, true, new File(this.OUTPUT, IOUtil.makeFileNameSafe((String)string) + string2)));
        }
        for (SAMRecord sAMRecord : samReader) {
            string = sAMRecord.getReadGroup();
            if (string != null && string.getLibrary() != null) {
                ((SAMFileWriter)hashMap.get(string.getLibrary())).addAlignment(sAMRecord);
                continue;
            }
            if (sAMFileWriter == null) {
                sAMFileWriter = sAMFileWriterFactory.makeSAMOrBAMWriter(sAMFileHeader, true, new File(this.OUTPUT, "unknown" + string2));
            }
            sAMFileWriter.addAlignment(sAMRecord);
        }
        CloserUtil.close((Object)samReader);
        if (sAMFileWriter != null) {
            sAMFileWriter.close();
        }
        for (SAMFileWriter sAMFileWriter2 : hashMap.values()) {
            sAMFileWriter2.close();
        }
        return 0;
    }
}

