/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamIndexValidator;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamFileValidator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Validates a SAM or BAM file.  This tool reports on the validity of a SAM or BAM file relative to the SAM format specification (see http://samtools.github.io/hts-specs/SAMv1.pdf), which is useful for troubleshooting errors encountered with other tools that may be caused by improper formatting.<br /><br />By default, the tool runs in VERBOSE mode and will exit after finding 100 errors and output them to the console (stdout). It is often practical to start by running this tool with the SUMMARY mode option, which summarizes the \"errors\" and \"warnings\". Consequently, specific validation warnings or errors that are of lesser concern can be ignored using the IGNORE and/or IGNORE_WARNINGS arguments in order to focus on blocking errors. <br /><h4>Usage example:</h4><pre>java -jar picard.jar ValidateSamFile \\<br />     I=input.bam \\<br />     MODE=SUMMARY</pre><hr />", usageShort="Validates a SAM or BAM file.  ", programGroup=SamOrBam.class)
public class ValidateSamFile
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Validates a SAM or BAM file.  ";
    static final String USAGE_DETAILS = "This tool reports on the validity of a SAM or BAM file relative to the SAM format specification (see http://samtools.github.io/hts-specs/SAMv1.pdf), which is useful for troubleshooting errors encountered with other tools that may be caused by improper formatting.<br /><br />By default, the tool runs in VERBOSE mode and will exit after finding 100 errors and output them to the console (stdout). It is often practical to start by running this tool with the SUMMARY mode option, which summarizes the \"errors\" and \"warnings\". Consequently, specific validation warnings or errors that are of lesser concern can be ignored using the IGNORE and/or IGNORE_WARNINGS arguments in order to focus on blocking errors. <br /><h4>Usage example:</h4><pre>java -jar picard.jar ValidateSamFile \\<br />     I=input.bam \\<br />     MODE=SUMMARY</pre><hr />";
    @Option(shortName="I", doc="Input SAM/BAM file")
    public File INPUT;
    @Option(shortName="O", doc="Output file or standard out if missing", optional=true)
    public File OUTPUT;
    @Option(shortName="M", doc="Mode of output")
    public Mode MODE = Mode.VERBOSE;
    @Option(doc="List of validation error types to ignore.")
    public List<SAMValidationError.Type> IGNORE = new ArrayList<SAMValidationError.Type>();
    @Option(shortName="MO", doc="The maximum number of lines output in verbose mode")
    public Integer MAX_OUTPUT = 100;
    @Option(doc="If true, only report errors and ignore warnings.")
    public boolean IGNORE_WARNINGS = false;
    @Option(doc="DEPRECATED.  Use INDEX_VALIDATION_STRINGENCY instead.  If true and input is a BAM file with an index file, also validates the index.  Until this parameter is retired VALIDATE INDEX and INDEX_VALIDATION_STRINGENCY must agree on whether to validate the index.")
    public boolean VALIDATE_INDEX = true;
    @Option(doc="If set to anything other than IndexValidationStringency.NONE and input is a BAM file with an index file, also validates the index at the specified stringency. Until VALIDATE_INDEX is retired, VALIDATE INDEX and INDEX_VALIDATION_STRINGENCY must agree on whether to validate the index.")
    public BamIndexValidator.IndexValidationStringency INDEX_VALIDATION_STRINGENCY = BamIndexValidator.IndexValidationStringency.EXHAUSTIVE;
    @Option(shortName="BISULFITE", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads. If so, C->T is not counted as an error in computing the value of the NM tag.")
    public boolean IS_BISULFITE_SEQUENCED = false;
    @Option(doc="Relevant for a coordinate-sorted file containing read pairs only. Maximum number of file handles to keep open when spilling mate info to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_OPEN_TEMP_FILES = 8000;

    public static void main(String[] stringArray) {
        System.exit(new ValidateSamFile().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        PrintWriter printWriter;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        ReferenceSequenceFile referenceSequenceFile = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
            referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE);
        }
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
            try {
                printWriter = new PrintWriter(this.OUTPUT);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PicardException("Unexpected exception", fileNotFoundException);
            }
        } else {
            printWriter = new PrintWriter(System.out);
        }
        SamReaderFactory samReaderFactory = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(ValidationStringency.SILENT).enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.VALIDATE_CRC_CHECKSUMS});
        SamReader samReader = samReaderFactory.open(this.INPUT);
        if (samReader.type() != SamReader.Type.BAM_TYPE) {
            this.VALIDATE_INDEX = false;
        }
        samReaderFactory.setOption(SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES, this.VALIDATE_INDEX);
        samReaderFactory.reapplyOptions(samReader);
        SamFileValidator samFileValidator = new SamFileValidator(printWriter, this.MAX_OPEN_TEMP_FILES);
        samFileValidator.setErrorsToIgnore(this.IGNORE);
        if (this.IGNORE_WARNINGS) {
            samFileValidator.setIgnoreWarnings(this.IGNORE_WARNINGS);
        }
        if (this.MODE == Mode.SUMMARY) {
            samFileValidator.setVerbose(false, 0);
        } else {
            samFileValidator.setVerbose(true, this.MAX_OUTPUT.intValue());
        }
        if (this.IS_BISULFITE_SEQUENCED) {
            samFileValidator.setBisulfiteSequenced(this.IS_BISULFITE_SEQUENCED);
        }
        if (this.VALIDATE_INDEX) {
            samFileValidator.setValidateIndex(this.VALIDATE_INDEX);
        }
        if (IOUtil.isRegularPath((File)this.INPUT)) {
            samFileValidator.validateBamFileTermination(this.INPUT);
        }
        boolean bl = false;
        switch (this.MODE) {
            case SUMMARY: {
                bl = samFileValidator.validateSamFileSummary(samReader, referenceSequenceFile);
                break;
            }
            case VERBOSE: {
                bl = samFileValidator.validateSamFileVerbose(samReader, referenceSequenceFile);
            }
        }
        printWriter.flush();
        return bl ? 0 : 1;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (!this.VALIDATE_INDEX && this.INDEX_VALIDATION_STRINGENCY != BamIndexValidator.IndexValidationStringency.NONE || this.VALIDATE_INDEX && this.INDEX_VALIDATION_STRINGENCY == BamIndexValidator.IndexValidationStringency.NONE) {
            return new String[]{"VALIDATE_INDEX and INDEX_VALIDATION_STRINGENCY must be consistent: VALIDATE_INDEX is " + this.VALIDATE_INDEX + " and INDEX_VALIDATION_STRINGENCY is " + this.INDEX_VALIDATION_STRINGENCY};
        }
        return super.customCommandLineValidation();
    }

    public static enum Mode {
        VERBOSE,
        SUMMARY;

    }
}

