/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.SortingLongCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.EstimateLibraryComplexity;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;
import picard.sam.markduplicates.util.DiskBasedReadEndsForMarkDuplicatesMap;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesCodec;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesWithBarcodes;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesWithBarcodesCodec;

@CommandLineProgramProperties(usage="Identifies duplicate reads.  This tool locates and tags duplicate reads (both PCR and optical/sequencing-driven) in a BAM or SAM file, where\nduplicate reads are defined as originating from the same original fragment of DNA. Duplicates are identified as read\npairs having identical 5' positions (coordinate and strand) for both reads in a mate pair (and optionally, matching\nunique molecular identifier reads; see BARCODE_TAG option). Optical, or more broadly Sequencing, duplicates are\nduplicates that appear clustered together spatially during sequencing and can arise from optical/image-processing\nartifacts or from bio-chemical processes during clonal amplification and sequencing; they are identified using the\nREAD_NAME_REGEX and the OPTICAL_DUPLICATE_PIXEL_DISTANCE options.\n\nThe tool's main output is a new SAM or BAM file in which duplicates have been identified in the SAM flags field, or\noptionally removed (see REMOVE_DUPLICATE and REMOVE_SEQUENCING_DUPLICATES), and optionally marked with a duplicate type\nin the 'DT' optional attribute. In addition, it also outputs a metrics file containing the numbers of\nREAD_PAIRS_EXAMINED, UNMAPPED_READS, UNPAIRED_READS, UNPAIRED_READ DUPLICATES, READ_PAIR_DUPLICATES, and\nREAD_PAIR_OPTICAL_DUPLICATES.\n\nUsage example: java -jar picard.jar MarkDuplicates I=input.bam \\\n                 O=marked_duplicates.bam M=marked_dup_metrics.txt\n\nThe program can take either coordinate-sorted or query-sorted input, however the behavior is slightly different.\nWhen the input is coordinate-sorted, unmapped mates of mapped records, and supplementary and secondary alignments are not\nmarked as duplicates. When the input is query-sorted (actually query-grouped) then unmapped mates get marked as their mapped\ncounter-parts, and secondary and supplementary reads get marked as the primary records with the same query-name.\n", usageShort="Identifies duplicate reads.  ", programGroup=SamOrBam.class)
public class MarkDuplicates
extends AbstractMarkDuplicatesCommandLineProgram {
    static final String USAGE_SUMMARY = "Identifies duplicate reads.  ";
    static final String USAGE_DETAILS = "This tool locates and tags duplicate reads (both PCR and optical/sequencing-driven) in a BAM or SAM file, where\nduplicate reads are defined as originating from the same original fragment of DNA. Duplicates are identified as read\npairs having identical 5' positions (coordinate and strand) for both reads in a mate pair (and optionally, matching\nunique molecular identifier reads; see BARCODE_TAG option). Optical, or more broadly Sequencing, duplicates are\nduplicates that appear clustered together spatially during sequencing and can arise from optical/image-processing\nartifacts or from bio-chemical processes during clonal amplification and sequencing; they are identified using the\nREAD_NAME_REGEX and the OPTICAL_DUPLICATE_PIXEL_DISTANCE options.\n\nThe tool's main output is a new SAM or BAM file in which duplicates have been identified in the SAM flags field, or\noptionally removed (see REMOVE_DUPLICATE and REMOVE_SEQUENCING_DUPLICATES), and optionally marked with a duplicate type\nin the 'DT' optional attribute. In addition, it also outputs a metrics file containing the numbers of\nREAD_PAIRS_EXAMINED, UNMAPPED_READS, UNPAIRED_READS, UNPAIRED_READ DUPLICATES, READ_PAIR_DUPLICATES, and\nREAD_PAIR_OPTICAL_DUPLICATES.\n\nUsage example: java -jar picard.jar MarkDuplicates I=input.bam \\\n                 O=marked_duplicates.bam M=marked_dup_metrics.txt\n\nThe program can take either coordinate-sorted or query-sorted input, however the behavior is slightly different.\nWhen the input is coordinate-sorted, unmapped mates of mapped records, and supplementary and secondary alignments are not\nmarked as duplicates. When the input is query-sorted (actually query-grouped) then unmapped mates get marked as their mapped\ncounter-parts, and secondary and supplementary reads get marked as the primary records with the same query-name.\n";
    public static final String DUPLICATE_TYPE_TAG = "DT";
    public static final String DUPLICATE_TYPE_LIBRARY = "LB";
    public static final String DUPLICATE_TYPE_SEQUENCING = "SQ";
    private final Log log = Log.getInstance(MarkDuplicates.class);
    @Option(shortName="MAX_SEQS", doc="This option is obsolete. ReadEnds will always be spilled to disk.")
    public int MAX_SEQUENCES_FOR_DISK_READ_ENDS_MAP = 50000;
    @Option(shortName="MAX_FILE_HANDLES", doc="Maximum number of file handles to keep open when spilling read ends to disk. Set this number a little lower than the per-process maximum number of file that may be open. This number can be found by executing the 'ulimit -n' command on a Unix system.")
    public int MAX_FILE_HANDLES_FOR_READ_ENDS_MAP = 8000;
    @Option(doc="This number, plus the maximum RAM available to the JVM, determine the memory footprint used by some of the sorting collections.  If you are running out of memory, try reducing this number.")
    public double SORTING_COLLECTION_SIZE_RATIO = 0.25;
    @Option(doc="Barcode SAM tag (ex. BC for 10X Genomics)", optional=true)
    public String BARCODE_TAG = null;
    @Option(doc="Read one barcode SAM tag (ex. BX for 10X Genomics)", optional=true)
    public String READ_ONE_BARCODE_TAG = null;
    @Option(doc="Read two barcode SAM tag (ex. BX for 10X Genomics)", optional=true)
    public String READ_TWO_BARCODE_TAG = null;
    @Option(doc="If true remove 'optical' duplicates and other duplicates that appear to have arisen from the sequencing process instead of the library preparation process, even if REMOVE_DUPLICATES is false. If REMOVE_DUPLICATES is true, all duplicates are removed and this option is ignored.")
    public boolean REMOVE_SEQUENCING_DUPLICATES = false;
    @Option(doc="Determines how duplicate types are recorded in the DT optional attribute.")
    public DuplicateTaggingPolicy TAGGING_POLICY = DuplicateTaggingPolicy.DontTag;
    private SortingCollection<ReadEndsForMarkDuplicates> pairSort;
    private SortingCollection<ReadEndsForMarkDuplicates> fragSort;
    private SortingLongCollection duplicateIndexes;
    private SortingLongCollection opticalDuplicateIndexes;
    private int numDuplicateIndices = 0;
    private static final long NO_SUCH_INDEX = Long.MAX_VALUE;
    protected LibraryIdGenerator libraryIdGenerator = null;

    private int getBarcodeValue(SAMRecord sAMRecord) {
        return EstimateLibraryComplexity.getReadBarcodeValue(sAMRecord, this.BARCODE_TAG);
    }

    private int getReadOneBarcodeValue(SAMRecord sAMRecord) {
        return EstimateLibraryComplexity.getReadBarcodeValue(sAMRecord, this.READ_ONE_BARCODE_TAG);
    }

    private int getReadTwoBarcodeValue(SAMRecord sAMRecord) {
        return EstimateLibraryComplexity.getReadBarcodeValue(sAMRecord, this.READ_TWO_BARCODE_TAG);
    }

    public MarkDuplicates() {
        this.DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.SUM_OF_BASE_QUALITIES;
    }

    public static void main(String[] stringArray) {
        new MarkDuplicates().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertInputsAreValid((List)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.METRICS_FILE);
        boolean bl = null != this.BARCODE_TAG || null != this.READ_ONE_BARCODE_TAG || null != this.READ_TWO_BARCODE_TAG;
        this.reportMemoryStats("Start of doWork");
        this.log.info(new Object[]{"Reading input file and constructing read end information."});
        this.buildSortedReadEndLists(bl);
        this.reportMemoryStats("After buildSortedReadEndLists");
        this.generateDuplicateIndexes(bl, this.REMOVE_SEQUENCING_DUPLICATES || this.TAGGING_POLICY != DuplicateTaggingPolicy.DontTag);
        this.reportMemoryStats("After generateDuplicateIndexes");
        this.log.info(new Object[]{"Marking " + this.numDuplicateIndices + " records as duplicates."});
        if (this.READ_NAME_REGEX == null) {
            this.log.warn(new Object[]{"Skipped optical duplicate cluster discovery; library size estimation may be inaccurate!"});
        } else {
            this.log.info(new Object[]{"Found " + this.libraryIdGenerator.getNumberOfOpticalDuplicateClusters() + " optical duplicate clusters."});
        }
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator samHeaderAndIterator = this.openInputs();
        SAMFileHeader sAMFileHeader = samHeaderAndIterator.header;
        SAMFileHeader.SortOrder sortOrder = sAMFileHeader.getSortOrder();
        SAMFileHeader sAMFileHeader2 = sAMFileHeader.clone();
        this.log.info(new Object[]{"Reads are assumed to be ordered by: " + sortOrder});
        if (sortOrder != SAMFileHeader.SortOrder.coordinate && sortOrder != SAMFileHeader.SortOrder.queryname) {
            throw new PicardException("This program requires input that are either coordinate or query sorted. Found " + sortOrder);
        }
        this.COMMENT.forEach(arg_0 -> ((SAMFileHeader)sAMFileHeader2).addComment(arg_0));
        Map<String, String> map = this.getChainedPgIds(sAMFileHeader2);
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, true, this.OUTPUT);
        long l = 0L;
        long l2 = this.opticalDuplicateIndexes != null && this.opticalDuplicateIndexes.hasNext() ? this.opticalDuplicateIndexes.next() : Long.MAX_VALUE;
        long l3 = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : Long.MAX_VALUE;
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000000, "Written");
        CloseableIterator<SAMRecord> closeableIterator = samHeaderAndIterator.iterator;
        String string = null;
        String string2 = null;
        while (closeableIterator.hasNext()) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            SAMRecord sAMRecord = (SAMRecord)closeableIterator.next();
            String string3 = LibraryIdGenerator.getLibraryName(sAMFileHeader, sAMRecord);
            DuplicationMetrics duplicationMetrics = this.libraryIdGenerator.getMetricsByLibrary(string3);
            if (duplicationMetrics == null) {
                duplicationMetrics = new DuplicationMetrics();
                duplicationMetrics.LIBRARY = string3;
                this.libraryIdGenerator.addMetricsByLibrary(string3, duplicationMetrics);
            }
            if (sAMRecord.getReadUnmappedFlag()) {
                ++duplicationMetrics.UNMAPPED_READS;
            } else if (sAMRecord.isSecondaryOrSupplementary()) {
                ++duplicationMetrics.SECONDARY_OR_SUPPLEMENTARY_RDS;
            } else if (!sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) {
                ++duplicationMetrics.UNPAIRED_READS_EXAMINED;
            } else {
                ++duplicationMetrics.READ_PAIRS_EXAMINED;
            }
            boolean bl5 = bl4 = l > l3 && (sortOrder == SAMFileHeader.SortOrder.coordinate || !sAMRecord.getReadName().equals(string));
            if (bl4) {
                l3 = this.duplicateIndexes.hasNext() ? this.duplicateIndexes.next() : Long.MAX_VALUE;
            }
            boolean bl6 = bl3 = l == l3 || sortOrder == SAMFileHeader.SortOrder.queryname && l > l3 && sAMRecord.getReadName().equals(string);
            if (bl3) {
                string = sAMRecord.getReadName();
                sAMRecord.setDuplicateReadFlag(true);
                if (!sAMRecord.isSecondaryOrSupplementary() && !sAMRecord.getReadUnmappedFlag()) {
                    if (!sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) {
                        ++duplicationMetrics.UNPAIRED_READ_DUPLICATES;
                    } else {
                        ++duplicationMetrics.READ_PAIR_DUPLICATES;
                    }
                }
            } else {
                sAMRecord.setDuplicateReadFlag(false);
            }
            boolean bl7 = bl2 = l > l2 && (sortOrder == SAMFileHeader.SortOrder.coordinate || !sAMRecord.getReadName().equals(string2));
            if (bl2) {
                l2 = this.opticalDuplicateIndexes.hasNext() ? this.opticalDuplicateIndexes.next() : Long.MAX_VALUE;
            }
            boolean bl8 = sortOrder == SAMFileHeader.SortOrder.queryname && l > l2 && sAMRecord.getReadName().equals(string2) || l == l2;
            sAMRecord.setAttribute(DUPLICATE_TYPE_TAG, null);
            if (this.TAGGING_POLICY != DuplicateTaggingPolicy.DontTag && sAMRecord.getDuplicateReadFlag()) {
                if (bl8) {
                    string2 = sAMRecord.getReadName();
                    sAMRecord.setAttribute(DUPLICATE_TYPE_TAG, (Object)DuplicateType.SEQUENCING.code());
                } else if (this.TAGGING_POLICY == DuplicateTaggingPolicy.All) {
                    sAMRecord.setAttribute(DUPLICATE_TYPE_TAG, (Object)DuplicateType.LIBRARY.code());
                }
            }
            ++l;
            if (this.REMOVE_DUPLICATES && sAMRecord.getDuplicateReadFlag() || this.REMOVE_SEQUENCING_DUPLICATES && bl8) continue;
            if (this.PROGRAM_RECORD_ID != null) {
                sAMRecord.setAttribute(SAMTag.PG.name(), (Object)map.get(sAMRecord.getStringAttribute(SAMTag.PG.name())));
            }
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        closeableIterator.close();
        this.duplicateIndexes.cleanup();
        this.reportMemoryStats("Before output close");
        sAMFileWriter.close();
        this.reportMemoryStats("After output close");
        this.finalizeAndWriteMetrics(this.libraryIdGenerator);
        return 0;
    }

    long numOpticalDuplicates() {
        return (long)this.libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap().getSumOfValues();
    }

    private void reportMemoryStats(String string) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        this.log.info(new Object[]{string + " freeMemory: " + runtime.freeMemory() + "; totalMemory: " + runtime.totalMemory() + "; maxMemory: " + runtime.maxMemory()});
    }

    private void buildSortedReadEndLists(boolean bl) {
        ReadEndsForMarkDuplicatesCodec readEndsForMarkDuplicatesCodec;
        ReadEndsForMarkDuplicatesCodec readEndsForMarkDuplicatesCodec2;
        ReadEndsForMarkDuplicatesCodec readEndsForMarkDuplicatesCodec3;
        int n = bl ? ReadEndsForMarkDuplicatesWithBarcodes.getSizeOf() : ReadEndsForMarkDuplicates.getSizeOf();
        this.MAX_RECORDS_IN_RAM = (int)(Runtime.getRuntime().maxMemory() / (long)n) / 2;
        int n2 = (int)((double)Runtime.getRuntime().maxMemory() * this.SORTING_COLLECTION_SIZE_RATIO / (double)n);
        this.log.info(new Object[]{"Will retain up to " + n2 + " data points before spilling to disk."});
        if (bl) {
            readEndsForMarkDuplicatesCodec3 = new ReadEndsForMarkDuplicatesWithBarcodesCodec();
            readEndsForMarkDuplicatesCodec2 = new ReadEndsForMarkDuplicatesWithBarcodesCodec();
            readEndsForMarkDuplicatesCodec = new ReadEndsForMarkDuplicatesWithBarcodesCodec();
        } else {
            readEndsForMarkDuplicatesCodec3 = new ReadEndsForMarkDuplicatesCodec();
            readEndsForMarkDuplicatesCodec2 = new ReadEndsForMarkDuplicatesCodec();
            readEndsForMarkDuplicatesCodec = new ReadEndsForMarkDuplicatesCodec();
        }
        this.pairSort = SortingCollection.newInstance(ReadEndsForMarkDuplicates.class, (SortingCollection.Codec)readEndsForMarkDuplicatesCodec2, (Comparator)new ReadEndsMDComparator(bl), (int)n2, (Collection)this.TMP_DIR);
        this.fragSort = SortingCollection.newInstance(ReadEndsForMarkDuplicates.class, (SortingCollection.Codec)readEndsForMarkDuplicatesCodec3, (Comparator)new ReadEndsMDComparator(bl), (int)n2, (Collection)this.TMP_DIR);
        AbstractMarkDuplicatesCommandLineProgram.SamHeaderAndIterator samHeaderAndIterator = this.openInputs();
        SAMFileHeader.SortOrder sortOrder = samHeaderAndIterator.header.getSortOrder();
        SAMFileHeader sAMFileHeader = samHeaderAndIterator.header;
        DiskBasedReadEndsForMarkDuplicatesMap diskBasedReadEndsForMarkDuplicatesMap = new DiskBasedReadEndsForMarkDuplicatesMap(this.MAX_FILE_HANDLES_FOR_READ_ENDS_MAP, readEndsForMarkDuplicatesCodec);
        long l = 0L;
        ProgressLogger progressLogger = new ProgressLogger(this.log, 1000000, "Read");
        CloseableIterator<SAMRecord> closeableIterator = samHeaderAndIterator.iterator;
        if (null == this.libraryIdGenerator) {
            this.libraryIdGenerator = new LibraryIdGenerator(sAMFileHeader);
        }
        String string = null;
        long l2 = Long.MAX_VALUE;
        while (closeableIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)closeableIterator.next();
            if (this.PROGRAM_RECORD_ID != null) {
                this.pgIdsSeen.add(sAMRecord.getStringAttribute(SAMTag.PG.name()));
            }
            if (sortOrder == SAMFileHeader.SortOrder.queryname && !sAMRecord.getReadName().equals(string)) {
                string = sAMRecord.getReadName();
                l2 = l;
            }
            if (sAMRecord.getReadUnmappedFlag()) {
                if (sAMRecord.getReferenceIndex() == -1 && sortOrder == SAMFileHeader.SortOrder.coordinate) {
                    break;
                }
            } else if (!sAMRecord.isSecondaryOrSupplementary()) {
                long l3 = sortOrder == SAMFileHeader.SortOrder.queryname ? l2 : l;
                ReadEndsForMarkDuplicates readEndsForMarkDuplicates = this.buildReadEnds(sAMFileHeader, l3, sAMRecord, bl);
                this.fragSort.add((Object)readEndsForMarkDuplicates);
                if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag()) {
                    String string2 = sAMRecord.getAttribute(ReservedTagConstants.READ_GROUP_ID) + ":" + sAMRecord.getReadName();
                    ReadEndsForMarkDuplicates readEndsForMarkDuplicates2 = diskBasedReadEndsForMarkDuplicatesMap.remove(sAMRecord.getReferenceIndex(), string2);
                    if (readEndsForMarkDuplicates2 == null) {
                        readEndsForMarkDuplicates2 = this.buildReadEnds(sAMFileHeader, l3, sAMRecord, bl);
                        diskBasedReadEndsForMarkDuplicatesMap.put(readEndsForMarkDuplicates2.read2ReferenceIndex, string2, readEndsForMarkDuplicates2);
                    } else {
                        int n3 = readEndsForMarkDuplicates.read1ReferenceIndex;
                        int n4 = readEndsForMarkDuplicates.read1Coordinate;
                        if (sAMRecord.getFirstOfPairFlag()) {
                            readEndsForMarkDuplicates2.orientationForOpticalDuplicates = ReadEnds.getOrientationByte(sAMRecord.getReadNegativeStrandFlag(), readEndsForMarkDuplicates2.orientation == 1);
                            if (bl) {
                                ((ReadEndsForMarkDuplicatesWithBarcodes)readEndsForMarkDuplicates2).readOneBarcode = this.getReadOneBarcodeValue(sAMRecord);
                            }
                        } else {
                            readEndsForMarkDuplicates2.orientationForOpticalDuplicates = ReadEnds.getOrientationByte(readEndsForMarkDuplicates2.orientation == 1, sAMRecord.getReadNegativeStrandFlag());
                            if (bl) {
                                ((ReadEndsForMarkDuplicatesWithBarcodes)readEndsForMarkDuplicates2).readTwoBarcode = this.getReadTwoBarcodeValue(sAMRecord);
                            }
                        }
                        if (n3 > readEndsForMarkDuplicates2.read1ReferenceIndex || n3 == readEndsForMarkDuplicates2.read1ReferenceIndex && n4 >= readEndsForMarkDuplicates2.read1Coordinate) {
                            readEndsForMarkDuplicates2.read2ReferenceIndex = n3;
                            readEndsForMarkDuplicates2.read2Coordinate = n4;
                            readEndsForMarkDuplicates2.read2IndexInFile = l3;
                            readEndsForMarkDuplicates2.orientation = ReadEnds.getOrientationByte(readEndsForMarkDuplicates2.orientation == 1, sAMRecord.getReadNegativeStrandFlag());
                        } else {
                            readEndsForMarkDuplicates2.read2ReferenceIndex = readEndsForMarkDuplicates2.read1ReferenceIndex;
                            readEndsForMarkDuplicates2.read2Coordinate = readEndsForMarkDuplicates2.read1Coordinate;
                            readEndsForMarkDuplicates2.read2IndexInFile = readEndsForMarkDuplicates2.read1IndexInFile;
                            readEndsForMarkDuplicates2.read1ReferenceIndex = n3;
                            readEndsForMarkDuplicates2.read1Coordinate = n4;
                            readEndsForMarkDuplicates2.read1IndexInFile = l3;
                            readEndsForMarkDuplicates2.orientation = ReadEnds.getOrientationByte(sAMRecord.getReadNegativeStrandFlag(), readEndsForMarkDuplicates2.orientation == 1);
                        }
                        readEndsForMarkDuplicates2.score = (short)(readEndsForMarkDuplicates2.score + DuplicateScoringStrategy.computeDuplicateScore((SAMRecord)sAMRecord, (DuplicateScoringStrategy.ScoringStrategy)this.DUPLICATE_SCORING_STRATEGY));
                        this.pairSort.add((Object)readEndsForMarkDuplicates2);
                    }
                }
            }
            ++l;
            if (!progressLogger.record(sAMRecord)) continue;
            this.log.info(new Object[]{"Tracking " + diskBasedReadEndsForMarkDuplicatesMap.size() + " as yet unmatched pairs. " + diskBasedReadEndsForMarkDuplicatesMap.sizeInRam() + " records in RAM."});
        }
        this.log.info(new Object[]{"Read " + l + " records. " + diskBasedReadEndsForMarkDuplicatesMap.size() + " pairs never matched."});
        closeableIterator.close();
        this.pairSort.doneAdding();
        this.fragSort.doneAdding();
    }

    private ReadEndsForMarkDuplicates buildReadEnds(SAMFileHeader sAMFileHeader, long l, SAMRecord sAMRecord, boolean bl) {
        Object object;
        ReadEndsForMarkDuplicates readEndsForMarkDuplicates = bl ? new ReadEndsForMarkDuplicatesWithBarcodes() : new ReadEndsForMarkDuplicates();
        readEndsForMarkDuplicates.read1ReferenceIndex = sAMRecord.getReferenceIndex();
        readEndsForMarkDuplicates.read1Coordinate = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getUnclippedEnd() : sAMRecord.getUnclippedStart();
        readEndsForMarkDuplicates.orientation = sAMRecord.getReadNegativeStrandFlag() ? (byte)1 : 0;
        readEndsForMarkDuplicates.read1IndexInFile = l;
        readEndsForMarkDuplicates.score = DuplicateScoringStrategy.computeDuplicateScore((SAMRecord)sAMRecord, (DuplicateScoringStrategy.ScoringStrategy)this.DUPLICATE_SCORING_STRATEGY);
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getMateUnmappedFlag()) {
            readEndsForMarkDuplicates.read2ReferenceIndex = sAMRecord.getMateReferenceIndex();
        }
        readEndsForMarkDuplicates.libraryId = this.libraryIdGenerator.getLibraryId(sAMRecord);
        if (this.opticalDuplicateFinder.addLocationInformation(sAMRecord.getReadName(), readEndsForMarkDuplicates)) {
            readEndsForMarkDuplicates.readGroup = 0;
            object = (String)sAMRecord.getAttribute("RG");
            List list = sAMFileHeader.getReadGroups();
            if (object != null && list != null) {
                SAMReadGroupRecord sAMReadGroupRecord;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && !(sAMReadGroupRecord = (SAMReadGroupRecord)iterator.next()).getReadGroupId().equals(object)) {
                    readEndsForMarkDuplicates.readGroup = (short)(readEndsForMarkDuplicates.readGroup + 1);
                }
            }
        }
        if (bl) {
            object = readEndsForMarkDuplicates;
            ((ReadEndsForMarkDuplicatesWithBarcodes)object).barcode = this.getBarcodeValue(sAMRecord);
            if (!sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag()) {
                ((ReadEndsForMarkDuplicatesWithBarcodes)object).readOneBarcode = this.getReadOneBarcodeValue(sAMRecord);
            } else {
                ((ReadEndsForMarkDuplicatesWithBarcodes)object).readTwoBarcode = this.getReadTwoBarcodeValue(sAMRecord);
            }
        }
        return readEndsForMarkDuplicates;
    }

    private void generateDuplicateIndexes(boolean bl, boolean bl2) {
        int n = (int)Math.min((double)Runtime.getRuntime().maxMemory() * 0.25 / 8.0, 2.147483642E9);
        if (bl2) {
            this.opticalDuplicateIndexes = new SortingLongCollection(n /= 2, this.TMP_DIR.toArray(new File[this.TMP_DIR.size()]));
        }
        this.log.info(new Object[]{"Will retain up to " + n + " duplicate indices before spilling to disk."});
        this.duplicateIndexes = new SortingLongCollection(n, this.TMP_DIR.toArray(new File[this.TMP_DIR.size()]));
        ReadEndsForMarkDuplicates readEndsForMarkDuplicates = null;
        ArrayList<ReadEndsForMarkDuplicates> arrayList = new ArrayList<ReadEndsForMarkDuplicates>(200);
        this.log.info(new Object[]{"Traversing read pair information and detecting duplicates."});
        for (ReadEndsForMarkDuplicates readEndsForMarkDuplicates2 : this.pairSort) {
            if (readEndsForMarkDuplicates != null && this.areComparableForDuplicates(readEndsForMarkDuplicates, readEndsForMarkDuplicates2, true, bl)) {
                arrayList.add(readEndsForMarkDuplicates2);
                continue;
            }
            if (arrayList.size() > 1) {
                this.markDuplicatePairs(arrayList);
            }
            arrayList.clear();
            arrayList.add(readEndsForMarkDuplicates2);
            readEndsForMarkDuplicates = readEndsForMarkDuplicates2;
        }
        if (arrayList.size() > 1) {
            this.markDuplicatePairs(arrayList);
        }
        this.pairSort.cleanup();
        this.pairSort = null;
        this.log.info(new Object[]{"Traversing fragment information and detecting duplicates."});
        boolean bl3 = false;
        boolean bl4 = false;
        readEndsForMarkDuplicates = null;
        for (ReadEndsForMarkDuplicates readEndsForMarkDuplicates3 : this.fragSort) {
            if (readEndsForMarkDuplicates != null && this.areComparableForDuplicates(readEndsForMarkDuplicates, readEndsForMarkDuplicates3, false, bl)) {
                arrayList.add(readEndsForMarkDuplicates3);
                bl3 = bl3 || readEndsForMarkDuplicates3.isPaired();
                bl4 = bl4 || !readEndsForMarkDuplicates3.isPaired();
                continue;
            }
            if (arrayList.size() > 1 && bl4) {
                this.markDuplicateFragments(arrayList, bl3);
            }
            arrayList.clear();
            arrayList.add(readEndsForMarkDuplicates3);
            readEndsForMarkDuplicates = readEndsForMarkDuplicates3;
            bl3 = readEndsForMarkDuplicates3.isPaired();
            bl4 = !readEndsForMarkDuplicates3.isPaired();
        }
        this.markDuplicateFragments(arrayList, bl3);
        this.fragSort.cleanup();
        this.fragSort = null;
        this.log.info(new Object[]{"Sorting list of duplicate records."});
        this.duplicateIndexes.doneAddingStartIteration();
        if (this.opticalDuplicateIndexes != null) {
            this.opticalDuplicateIndexes.doneAddingStartIteration();
        }
    }

    private boolean areComparableForDuplicates(ReadEndsForMarkDuplicates readEndsForMarkDuplicates, ReadEndsForMarkDuplicates readEndsForMarkDuplicates2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = readEndsForMarkDuplicates.libraryId == readEndsForMarkDuplicates2.libraryId;
        if (bl2 && bl3) {
            ReadEndsForMarkDuplicatesWithBarcodes readEndsForMarkDuplicatesWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)readEndsForMarkDuplicates;
            ReadEndsForMarkDuplicatesWithBarcodes readEndsForMarkDuplicatesWithBarcodes2 = (ReadEndsForMarkDuplicatesWithBarcodes)readEndsForMarkDuplicates2;
            boolean bl5 = bl3 = readEndsForMarkDuplicatesWithBarcodes.barcode == readEndsForMarkDuplicatesWithBarcodes2.barcode && readEndsForMarkDuplicatesWithBarcodes.readOneBarcode == readEndsForMarkDuplicatesWithBarcodes2.readOneBarcode && readEndsForMarkDuplicatesWithBarcodes.readTwoBarcode == readEndsForMarkDuplicatesWithBarcodes2.readTwoBarcode;
        }
        if (bl3) {
            boolean bl6 = bl3 = readEndsForMarkDuplicates.read1ReferenceIndex == readEndsForMarkDuplicates2.read1ReferenceIndex && readEndsForMarkDuplicates.read1Coordinate == readEndsForMarkDuplicates2.read1Coordinate && readEndsForMarkDuplicates.orientation == readEndsForMarkDuplicates2.orientation;
        }
        if (bl3 && bl) {
            bl3 = readEndsForMarkDuplicates.read2ReferenceIndex == readEndsForMarkDuplicates2.read2ReferenceIndex && readEndsForMarkDuplicates.read2Coordinate == readEndsForMarkDuplicates2.read2Coordinate;
        }
        return bl3;
    }

    private void addIndexAsDuplicate(long l) {
        this.duplicateIndexes.add(l);
        ++this.numDuplicateIndices;
    }

    private void markDuplicatePairs(List<ReadEndsForMarkDuplicates> list) {
        short s = 0;
        ReadEndsForMarkDuplicates readEndsForMarkDuplicates = null;
        for (ReadEndsForMarkDuplicates readEndsForMarkDuplicates2 : list) {
            if (readEndsForMarkDuplicates2.score <= s && readEndsForMarkDuplicates != null) continue;
            s = readEndsForMarkDuplicates2.score;
            readEndsForMarkDuplicates = readEndsForMarkDuplicates2;
        }
        if (this.READ_NAME_REGEX != null) {
            AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(list, readEndsForMarkDuplicates, this.opticalDuplicateFinder, this.libraryIdGenerator);
        }
        for (ReadEndsForMarkDuplicates readEndsForMarkDuplicates2 : list) {
            if (readEndsForMarkDuplicates2 == readEndsForMarkDuplicates) continue;
            this.addIndexAsDuplicate(readEndsForMarkDuplicates2.read1IndexInFile);
            if (readEndsForMarkDuplicates2.read2IndexInFile != readEndsForMarkDuplicates2.read1IndexInFile) {
                this.addIndexAsDuplicate(readEndsForMarkDuplicates2.read2IndexInFile);
            }
            if (!readEndsForMarkDuplicates2.isOpticalDuplicate || this.opticalDuplicateIndexes == null) continue;
            this.opticalDuplicateIndexes.add(readEndsForMarkDuplicates2.read1IndexInFile);
            this.opticalDuplicateIndexes.add(readEndsForMarkDuplicates2.read2IndexInFile);
        }
    }

    private void markDuplicateFragments(List<ReadEndsForMarkDuplicates> list, boolean bl) {
        if (bl) {
            for (ReadEndsForMarkDuplicates readEndsForMarkDuplicates : list) {
                if (readEndsForMarkDuplicates.isPaired()) continue;
                this.addIndexAsDuplicate(readEndsForMarkDuplicates.read1IndexInFile);
            }
        } else {
            short s = 0;
            ReadEndsForMarkDuplicates readEndsForMarkDuplicates = null;
            for (ReadEndsForMarkDuplicates readEndsForMarkDuplicates2 : list) {
                if (readEndsForMarkDuplicates2.score <= s && readEndsForMarkDuplicates != null) continue;
                s = readEndsForMarkDuplicates2.score;
                readEndsForMarkDuplicates = readEndsForMarkDuplicates2;
            }
            for (ReadEndsForMarkDuplicates readEndsForMarkDuplicates2 : list) {
                if (readEndsForMarkDuplicates2 == readEndsForMarkDuplicates) continue;
                this.addIndexAsDuplicate(readEndsForMarkDuplicates2.read1IndexInFile);
            }
        }
    }

    static int compareInteger(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    static class ReadEndsMDComparator
    implements Comparator<ReadEndsForMarkDuplicates> {
        final boolean useBarcodes;

        public ReadEndsMDComparator(boolean bl) {
            this.useBarcodes = bl;
        }

        @Override
        public int compare(ReadEndsForMarkDuplicates readEndsForMarkDuplicates, ReadEndsForMarkDuplicates readEndsForMarkDuplicates2) {
            int n = readEndsForMarkDuplicates.libraryId - readEndsForMarkDuplicates2.libraryId;
            if (this.useBarcodes) {
                ReadEndsForMarkDuplicatesWithBarcodes readEndsForMarkDuplicatesWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)readEndsForMarkDuplicates;
                ReadEndsForMarkDuplicatesWithBarcodes readEndsForMarkDuplicatesWithBarcodes2 = (ReadEndsForMarkDuplicatesWithBarcodes)readEndsForMarkDuplicates2;
                if (n == 0) {
                    n = MarkDuplicates.compareInteger(readEndsForMarkDuplicatesWithBarcodes.barcode, readEndsForMarkDuplicatesWithBarcodes2.barcode);
                }
                if (n == 0) {
                    n = MarkDuplicates.compareInteger(readEndsForMarkDuplicatesWithBarcodes.readOneBarcode, readEndsForMarkDuplicatesWithBarcodes2.readOneBarcode);
                }
                if (n == 0) {
                    n = MarkDuplicates.compareInteger(readEndsForMarkDuplicatesWithBarcodes.readTwoBarcode, readEndsForMarkDuplicatesWithBarcodes2.readTwoBarcode);
                }
            }
            if (n == 0) {
                n = readEndsForMarkDuplicates.read1ReferenceIndex - readEndsForMarkDuplicates2.read1ReferenceIndex;
            }
            if (n == 0) {
                n = readEndsForMarkDuplicates.read1Coordinate - readEndsForMarkDuplicates2.read1Coordinate;
            }
            if (n == 0) {
                n = readEndsForMarkDuplicates.orientation - readEndsForMarkDuplicates2.orientation;
            }
            if (n == 0) {
                n = readEndsForMarkDuplicates.read2ReferenceIndex - readEndsForMarkDuplicates2.read2ReferenceIndex;
            }
            if (n == 0) {
                n = readEndsForMarkDuplicates.read2Coordinate - readEndsForMarkDuplicates2.read2Coordinate;
            }
            if (n == 0) {
                n = (int)(readEndsForMarkDuplicates.read1IndexInFile - readEndsForMarkDuplicates2.read1IndexInFile);
            }
            if (n == 0) {
                n = (int)(readEndsForMarkDuplicates.read2IndexInFile - readEndsForMarkDuplicates2.read2IndexInFile);
            }
            return n;
        }
    }

    public static enum DuplicateType {
        LIBRARY("LB"),
        SEQUENCING("SQ");

        private final String code;

        private DuplicateType(String string2) {
            this.code = string2;
        }

        public String code() {
            return this.code;
        }
    }

    public static enum DuplicateTaggingPolicy {
        DontTag,
        OpticalOnly,
        All;

    }
}

