/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.CoordinateSortedPairInfoMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Map;
import picard.PicardException;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesCodec;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesMap;

public class DiskBasedReadEndsForMarkDuplicatesMap
implements ReadEndsForMarkDuplicatesMap {
    private final CoordinateSortedPairInfoMap<String, ReadEndsForMarkDuplicates> pairInfoMap;

    public DiskBasedReadEndsForMarkDuplicatesMap(int n, ReadEndsForMarkDuplicatesCodec readEndsForMarkDuplicatesCodec) {
        this.pairInfoMap = new CoordinateSortedPairInfoMap(n, (CoordinateSortedPairInfoMap.Codec)new Codec(readEndsForMarkDuplicatesCodec));
    }

    @Override
    public ReadEndsForMarkDuplicates remove(int n, String string) {
        return (ReadEndsForMarkDuplicates)this.pairInfoMap.remove(n, (Object)string);
    }

    @Override
    public void put(int n, String string, ReadEndsForMarkDuplicates readEndsForMarkDuplicates) {
        this.pairInfoMap.put(n, (Object)string, (Object)readEndsForMarkDuplicates);
    }

    @Override
    public int size() {
        return this.pairInfoMap.size();
    }

    @Override
    public int sizeInRam() {
        return this.pairInfoMap.sizeInRam();
    }

    private static class Codec
    implements CoordinateSortedPairInfoMap.Codec<String, ReadEndsForMarkDuplicates> {
        private final ReadEndsForMarkDuplicatesCodec readEndsForMarkDuplicatesCodec;

        public Codec(ReadEndsForMarkDuplicatesCodec readEndsForMarkDuplicatesCodec) {
            this.readEndsForMarkDuplicatesCodec = readEndsForMarkDuplicatesCodec;
        }

        public void setInputStream(InputStream inputStream) {
            this.readEndsForMarkDuplicatesCodec.setInputStream(inputStream);
        }

        public void setOutputStream(OutputStream outputStream) {
            this.readEndsForMarkDuplicatesCodec.setOutputStream(outputStream);
        }

        public Map.Entry<String, ReadEndsForMarkDuplicates> decode() {
            try {
                String string = this.readEndsForMarkDuplicatesCodec.getInputStream().readUTF();
                ReadEndsForMarkDuplicates readEndsForMarkDuplicates = this.readEndsForMarkDuplicatesCodec.decode();
                return new AbstractMap.SimpleEntry<String, ReadEndsForMarkDuplicates>(string, readEndsForMarkDuplicates);
            }
            catch (IOException iOException) {
                throw new PicardException("Error loading ReadEndsForMarkDuplicatesMap from disk", iOException);
            }
        }

        public void encode(String string, ReadEndsForMarkDuplicates readEndsForMarkDuplicates) {
            try {
                this.readEndsForMarkDuplicatesCodec.getOutputStream().writeUTF(string);
                this.readEndsForMarkDuplicatesCodec.encode(readEndsForMarkDuplicates);
            }
            catch (IOException iOException) {
                throw new PicardException("Error spilling ReadEndsForMarkDuplicatesMap to disk.", iOException);
            }
        }
    }
}

