/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.SamRecordWithOrdinal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import picard.PicardException;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.PhysicalLocationForMateCigarSet;
import picard.sam.markduplicates.util.ReadEnds;

public class ReadEndsForMateCigar
extends ReadEnds {
    byte hasUnmapped = 0;
    public SamRecordWithOrdinal samRecordWithOrdinal = null;
    private PhysicalLocationForMateCigarSet locationSet = null;

    public ReadEndsForMateCigar(SAMFileHeader sAMFileHeader, SamRecordWithOrdinal samRecordWithOrdinal, OpticalDuplicateFinder opticalDuplicateFinder, short s) {
        this.readGroup = (short)-1;
        this.tile = (short)-1;
        this.y = -1;
        this.x = -1;
        this.read2Coordinate = -1;
        this.read2ReferenceIndex = -1;
        this.hasUnmapped = 0;
        this.samRecordWithOrdinal = samRecordWithOrdinal;
        SAMRecord sAMRecord = this.samRecordWithOrdinal.getRecord();
        this.read1ReferenceIndex = sAMRecord.getReferenceIndex();
        int n = this.read1Coordinate = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getUnclippedEnd() : sAMRecord.getUnclippedStart();
        if (sAMRecord.getReadUnmappedFlag()) {
            throw new PicardException("Found an unexpected unmapped read");
        }
        if (sAMRecord.getReadPairedFlag() && !sAMRecord.getReadUnmappedFlag() && !sAMRecord.getMateUnmappedFlag()) {
            this.read2ReferenceIndex = sAMRecord.getMateReferenceIndex();
            this.read2Coordinate = sAMRecord.getMateNegativeStrandFlag() ? SAMUtils.getMateUnclippedEnd((SAMRecord)sAMRecord) : SAMUtils.getMateUnclippedStart((SAMRecord)sAMRecord);
            this.orientation = ReadEnds.getOrientationByte(sAMRecord.getReadNegativeStrandFlag(), sAMRecord.getMateNegativeStrandFlag());
            if (sAMRecord.getReadPairedFlag()) {
                this.orientationForOpticalDuplicates = sAMRecord.getFirstOfPairFlag() ? ReadEnds.getOrientationByte(sAMRecord.getReadNegativeStrandFlag(), sAMRecord.getMateNegativeStrandFlag()) : ReadEnds.getOrientationByte(sAMRecord.getMateNegativeStrandFlag(), sAMRecord.getReadNegativeStrandFlag());
            }
        } else {
            this.orientation = sAMRecord.getReadNegativeStrandFlag() ? (byte)1 : 0;
        }
        this.libraryId = s;
        if (sAMRecord.getReadUnmappedFlag() || sAMRecord.getReadPairedFlag() && sAMRecord.getMateUnmappedFlag()) {
            this.hasUnmapped = 1;
        }
        if (opticalDuplicateFinder.addLocationInformation(sAMRecord.getReadName(), this)) {
            this.readGroup = 0;
            String string = (String)sAMRecord.getAttribute("RG");
            List list = sAMFileHeader.getReadGroups();
            if (string != null && list != null) {
                SAMReadGroupRecord sAMReadGroupRecord;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && !(sAMReadGroupRecord = (SAMReadGroupRecord)iterator.next()).getReadGroupId().equals(string)) {
                    this.readGroup = (short)(this.readGroup + 1);
                }
            }
        }
    }

    public ReadEndsForMateCigar(ReadEndsForMateCigar readEndsForMateCigar, SamRecordWithOrdinal samRecordWithOrdinal) {
        this.readGroup = readEndsForMateCigar.readGroup;
        this.tile = readEndsForMateCigar.tile;
        this.x = readEndsForMateCigar.x;
        this.y = readEndsForMateCigar.y;
        this.read1ReferenceIndex = readEndsForMateCigar.read1ReferenceIndex;
        this.read1Coordinate = readEndsForMateCigar.read1Coordinate;
        this.read2ReferenceIndex = readEndsForMateCigar.read2ReferenceIndex;
        this.read2Coordinate = readEndsForMateCigar.read2Coordinate;
        this.hasUnmapped = readEndsForMateCigar.hasUnmapped;
        this.samRecordWithOrdinal = samRecordWithOrdinal;
        this.orientation = readEndsForMateCigar.orientation;
        this.libraryId = readEndsForMateCigar.libraryId;
    }

    public SamRecordWithOrdinal getSamRecordIndex() {
        return this.samRecordWithOrdinal;
    }

    public SAMRecord getRecord() {
        return this.samRecordWithOrdinal.getRecord();
    }

    public String getRecordReadName() {
        return this.samRecordWithOrdinal.getRecord().getReadName();
    }

    @Override
    public boolean isPaired() {
        return this.getRecord().getReadPairedFlag();
    }

    public Set<ReadEnds> getReadEndSetForOpticalDuplicates() {
        if (null == this.locationSet) {
            throw new PicardException("Already called getReadEndSetForOpticalDuplicates");
        }
        Set<ReadEnds> set = this.locationSet.getReadEnds();
        this.locationSet = null;
        return set;
    }

    public PhysicalLocationForMateCigarSet getLocationSet() {
        return this.locationSet;
    }

    public PhysicalLocationForMateCigarSet removeLocationSet() {
        PhysicalLocationForMateCigarSet physicalLocationForMateCigarSet = this.locationSet;
        this.locationSet = null;
        return physicalLocationForMateCigarSet;
    }

    public void setLocationSet(PhysicalLocationForMateCigarSet physicalLocationForMateCigarSet) {
        this.locationSet = physicalLocationForMateCigarSet;
    }
}

