/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.util;

import htsjdk.samtools.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.sam.util.PhysicalLocation;

public class ReadNameParser {
    public static final String DEFAULT_READ_NAME_REGEX = "<optimized capture of last three ':' separated fields as numeric values>".intern();
    private final int[] tmpLocationFields = new int[3];
    private String readNameRegex = null;
    private Pattern readNamePattern;
    private boolean warnedAboutRegexNotMatching = false;
    private final Log log;

    public ReadNameParser() {
        this(DEFAULT_READ_NAME_REGEX);
    }

    public ReadNameParser(String string) {
        this(string, null);
    }

    public ReadNameParser(String string, Log log) {
        this.readNameRegex = string;
        this.log = log;
    }

    public boolean addLocationInformation(String string, PhysicalLocation physicalLocation) {
        try {
            Matcher matcher;
            if (this.readNameRegex == DEFAULT_READ_NAME_REGEX) {
                int n = ReadNameParser.getLastThreeFields(string, ':', this.tmpLocationFields);
                if (n != 5 && n != 7) {
                    if (null != this.log && !this.warnedAboutRegexNotMatching) {
                        this.log.warn(new Object[]{String.format("Default READ_NAME_REGEX '%s' did not match read name '%s'.  You may need to specify a READ_NAME_REGEX in order to correctly identify optical duplicates.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, string)});
                        this.warnedAboutRegexNotMatching = true;
                    }
                    return false;
                }
                physicalLocation.setTile((short)this.tmpLocationFields[0]);
                physicalLocation.setX(this.tmpLocationFields[1]);
                physicalLocation.setY(this.tmpLocationFields[2]);
                return true;
            }
            if (this.readNameRegex == null) {
                return false;
            }
            if (this.readNamePattern == null) {
                this.readNamePattern = Pattern.compile(this.readNameRegex);
            }
            if ((matcher = this.readNamePattern.matcher(string)).matches()) {
                physicalLocation.setTile((short)Integer.parseInt(matcher.group(1)));
                physicalLocation.setX(Integer.parseInt(matcher.group(2)));
                physicalLocation.setY(Integer.parseInt(matcher.group(3)));
                return true;
            }
            if (null != this.log && !this.warnedAboutRegexNotMatching) {
                this.log.warn(new Object[]{String.format("READ_NAME_REGEX '%s' did not match read name '%s'.  Your regex may not be correct.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, string)});
                this.warnedAboutRegexNotMatching = true;
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.log != null && !this.warnedAboutRegexNotMatching) {
                this.log.warn(new Object[]{"A field field parsed out of a read name was expected to contain an integer and did not. ", "Read name: ", string, ". Cause: ", numberFormatException.getMessage()});
                this.warnedAboutRegexNotMatching = true;
            }
            return false;
        }
    }

    public static int getLastThreeFields(String string, char c, int[] nArray) throws NumberFormatException {
        int n;
        int n2 = 2;
        int n3 = 0;
        int n4 = string.length();
        for (n = string.length() - 1; 0 <= n && 0 <= n2; --n) {
            if (string.charAt(n) != c && 0 != n) continue;
            ++n3;
            nArray[n2] = ReadNameParser.rapidParseInt(string.substring(0 == n ? 0 : n + 1, n4));
            --n2;
            n4 = n;
        }
        while (0 <= n) {
            if (string.charAt(n) == c || 0 == n) {
                ++n3;
            }
            --n;
        }
        if (n3 < 3) {
            nArray[2] = -1;
            nArray[1] = -1;
            nArray[0] = -1;
            return -1;
        }
        return n3;
    }

    public static int rapidParseInt(String string) throws NumberFormatException {
        char c;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        if (0 < n && '-' == string.charAt(0)) {
            n3 = 1;
            bl = true;
        }
        boolean bl2 = false;
        while (n3 < n && Character.isDigit(c = string.charAt(n3))) {
            n2 = n2 * 10 + (c - 48);
            bl2 = true;
            ++n3;
        }
        if (!bl2) {
            throw new NumberFormatException("String '" + string + "' did not start with a parsable number.");
        }
        if (bl) {
            n2 = -n2;
        }
        return n2;
    }
}

