/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.None;
import picard.util.CircularByteBuffer;

@CommandLineProgramProperties(usage="Provides a large, configurable, FIFO buffer that can be used to buffer input and output streams between programs with a buffer size that is larger than that offered by native unix FIFOs (usually 64k).", usageShort="FIFO buffer used to buffer input and output streams with a customizable buffer size ", programGroup=None.class)
public class FifoBuffer
extends CommandLineProgram {
    @Option(doc="The size of the memory buffer in bytes.")
    public int BUFFER_SIZE = 0x20000000;
    @Option(doc="The size, in bytes, to read/write atomically to the input and output streams.")
    public int IO_SIZE = 65536;
    @Option(doc="How frequently, in seconds, to report debugging statistics. Set to zero for never.")
    public int DEBUG_FREQUENCY = 0;
    @Option(doc="Name to use for Fifo in debugging statements.", optional=true)
    public String NAME;
    private final Log log = Log.getInstance(FifoBuffer.class);
    private final InputStream inputStream;
    private final PrintStream outputStream;

    public FifoBuffer(InputStream inputStream, PrintStream printStream) {
        this.inputStream = inputStream;
        this.outputStream = printStream;
        this.QUIET = true;
    }

    public FifoBuffer() {
        this(System.in, System.out);
    }

    public static void main(String[] stringArray) {
        new FifoBuffer().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        final CircularByteBuffer circularByteBuffer = new CircularByteBuffer(this.BUFFER_SIZE);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] byArray = new byte[FifoBuffer.this.IO_SIZE];
                    int n = 0;
                    while ((n = FifoBuffer.this.inputStream.read(byArray)) > -1) {
                        for (int i = 0; i < n; i += circularByteBuffer.write(byArray, i, n - i)) {
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException((Throwable)iOException);
                }
                finally {
                    circularByteBuffer.close();
                }
            }
        });
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] byArray = new byte[FifoBuffer.this.IO_SIZE];
                int n = 0;
                while ((n = circularByteBuffer.read(byArray, 0, byArray.length)) > 0 || !circularByteBuffer.isClosed()) {
                    FifoBuffer.this.outputStream.write(byArray, 0, n);
                }
            }
        });
        try {
            Object object;
            if (this.DEBUG_FREQUENCY > 0) {
                object = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NumberFormat numberFormat = NumberFormat.getPercentInstance();
                        DecimalFormat decimalFormat = new DecimalFormat("#,##0");
                        while (true) {
                            int n = circularByteBuffer.getCapacity();
                            int n2 = circularByteBuffer.getBytesAvailableToRead();
                            double d = (double)n2 / (double)n;
                            String string = FifoBuffer.this.NAME == null ? "" : FifoBuffer.this.NAME + " ";
                            FifoBuffer.this.log.info(new Object[]{"Fifo buffer ", string, "used ", decimalFormat.format(n2), " / ", decimalFormat.format(n), " (", numberFormat.format(d), ")."});
                            try {
                                Thread.sleep(FifoBuffer.this.DEBUG_FREQUENCY * 1000);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                });
                ((Thread)object).setName("BufferDebugThread");
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
            }
            object = new LoggingExceptionHandler();
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)object);
            thread.setName("Fifo Input Thread");
            thread.start();
            LoggingExceptionHandler loggingExceptionHandler = new LoggingExceptionHandler();
            thread2.setUncaughtExceptionHandler(new LoggingExceptionHandler());
            thread2.setName("Fifo Output Thread");
            thread2.start();
            thread.join();
            thread2.join();
            if (((LoggingExceptionHandler)object).throwable != null) {
                throw new PicardException("Exception on input thread.", ((LoggingExceptionHandler)object).throwable);
            }
            if (loggingExceptionHandler.throwable != null) {
                throw new PicardException("Exception on output thread.", loggingExceptionHandler.throwable);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PicardException("Interrupted!", interruptedException);
        }
        return 0;
    }

    class LoggingExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public Throwable throwable;

        LoggingExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            this.throwable = throwable;
            FifoBuffer.this.log.error(throwable, new Object[]{"Exception caught on thread ", thread.getName()});
        }
    }
}

