/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IntervalListScatterer {
    private final Mode mode;

    public IntervalListScatterer(Mode mode) {
        this.mode = mode;
    }

    private int deduceIdealSplitLength(IntervalList intervalList, int n) {
        int n2 = Math.max((int)Math.floor((double)intervalList.getBaseCount() / (1.0 * (double)n)), 1);
        switch (this.mode) {
            case INTERVAL_SUBDIVISION: {
                return n2;
            }
            case BALANCING_WITHOUT_INTERVAL_SUBDIVISION: 
            case BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW: {
                int n3 = Collections.max(intervalList.getIntervals(), new Comparator<Interval>(){

                    @Override
                    public int compare(Interval interval, Interval interval2) {
                        return Integer.valueOf(interval.length()).compareTo(interval2.length());
                    }
                }).length();
                return Math.max(n3, n2);
            }
        }
        throw new IllegalStateException();
    }

    public List<IntervalList> scatter(IntervalList intervalList, int n) {
        return this.scatter(intervalList, n, false);
    }

    private boolean shouldAddToRunningIntervalList(long l, long l2, double d) {
        switch (this.mode) {
            case BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW: {
                return l2 <= l || (double)l < d;
            }
        }
        return l2 <= l;
    }

    public List<IntervalList> scatter(IntervalList intervalList, int n, boolean bl) {
        if (n < 1) {
            throw new IllegalArgumentException("scatterCount < 1");
        }
        IntervalList intervalList2 = bl ? intervalList : intervalList.uniqued();
        long l = this.deduceIdealSplitLength(intervalList2, n);
        System.err.println("idealSplitLength=" + l);
        ArrayList<IntervalList> arrayList = new ArrayList<IntervalList>();
        IntervalList intervalList3 = new IntervalList(intervalList2.getHeader());
        ArrayDeque<Interval> arrayDeque = new ArrayDeque<Interval>(intervalList2.getIntervals());
        long l2 = intervalList2.getBaseCount();
        while (!arrayDeque.isEmpty() && arrayList.size() < n - 1) {
            double d;
            Interval interval = (Interval)arrayDeque.pollFirst();
            long l3 = intervalList3.getBaseCount() + (long)interval.length();
            if (this.shouldAddToRunningIntervalList(l, l3, d = (double)(l2 - intervalList3.getBaseCount()) / (double)(n - arrayList.size() - 1))) {
                intervalList3.add(interval);
            } else {
                switch (this.mode) {
                    case INTERVAL_SUBDIVISION: {
                        int n2 = (int)(l - intervalList3.getBaseCount());
                        Interval interval2 = new Interval(interval.getContig(), interval.getStart(), interval.getStart() + n2 - 1, interval.isNegativeStrand(), interval.getName());
                        Interval interval3 = new Interval(interval.getContig(), interval.getStart() + n2, interval.getEnd(), interval.isNegativeStrand(), interval.getName());
                        intervalList3.add(interval2);
                        arrayDeque.addFirst(interval3);
                        break;
                    }
                    case BALANCING_WITHOUT_INTERVAL_SUBDIVISION: 
                    case BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW: {
                        if (intervalList3.getIntervals().isEmpty()) {
                            intervalList3.add(interval);
                            break;
                        }
                        arrayDeque.addFirst(interval);
                        l2 -= intervalList3.getBaseCount();
                        arrayList.add(intervalList3.uniqued());
                        intervalList3 = new IntervalList(intervalList2.getHeader());
                    }
                }
            }
            if (intervalList3.getBaseCount() < l) continue;
            l2 -= intervalList3.getBaseCount();
            arrayList.add(intervalList3.uniqued());
            intervalList3 = new IntervalList(intervalList2.getHeader());
        }
        while (!arrayDeque.isEmpty()) {
            intervalList3.add((Interval)arrayDeque.pollFirst());
        }
        if (!intervalList3.getIntervals().isEmpty()) {
            arrayList.add(intervalList3.uniqued());
        }
        long l4 = -1L;
        long l5 = Integer.MAX_VALUE;
        for (IntervalList intervalList4 : arrayList) {
            long l6 = intervalList4.getBaseCount();
            if (l6 < l5) {
                l5 = l6;
            }
            if (l4 >= l6) continue;
            l4 = l6;
        }
        return arrayList;
    }

    public static enum Mode {
        INTERVAL_SUBDIVISION,
        BALANCING_WITHOUT_INTERVAL_SUBDIVISION,
        BALANCING_WITHOUT_INTERVAL_SUBDIVISION_WITH_OVERFLOW;

    }
}

