/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import htsjdk.samtools.metrics.MetricBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.TreeMap;

public class MetricsDoclet {
    public static boolean start(RootDoc rootDoc) {
        TreeMap<String, ClassDoc> treeMap = new TreeMap<String, ClassDoc>();
        for (ClassDoc fieldDocArray : rootDoc.classes()) {
            if (!MetricsDoclet.isMetricsClass(fieldDocArray)) continue;
            System.out.println("Processing " + fieldDocArray.qualifiedTypeName());
            treeMap.put(fieldDocArray.typeName(), fieldDocArray);
        }
        PrintStream printStream = MetricsDoclet.getOutput(rootDoc);
        if (printStream == null) {
            return false;
        }
        printStream.println("<h2>Picard Metrics Definitions</h2>");
        printStream.println("<section>");
        printStream.println("<p> Click on a metric to see a description of its fields.</p>");
        printStream.println("<ol>");
        for (ClassDoc classDoc : treeMap.values()) {
            printStream.println("<li><a href=\"#" + classDoc.name() + "\">" + classDoc.name() + "</a>: " + MetricsDoclet.firstSentence((Doc)classDoc) + "</li>");
        }
        printStream.println("</ol>");
        printStream.println("</section>");
        for (ClassDoc classDoc : treeMap.values()) {
            printStream.println("<a id=\"" + classDoc.name() + "\"></a>");
            printStream.println("<h2>" + classDoc.name() + "</h2>");
            printStream.println("<section>");
            printStream.println("<p>" + classDoc.commentText() + "</p>");
            printStream.println("<table>");
            printStream.println("<tr><th>Field</th><th>Description</th></tr>");
            for (FieldDoc fieldDoc : classDoc.fields()) {
                if (!fieldDoc.isPublic() || fieldDoc.isStatic()) continue;
                printStream.append("<tr>");
                printStream.append("<td>" + fieldDoc.name() + "</td>");
                printStream.append("<td>" + fieldDoc.commentText() + "</td>");
                printStream.append("</tr>");
            }
            printStream.println("</table>");
            printStream.println("</section>");
        }
        printStream.close();
        return true;
    }

    protected static boolean isMetricsClass(ClassDoc classDoc) {
        String string = MetricBase.class.getName();
        if (!classDoc.isClass()) {
            return false;
        }
        if (classDoc.qualifiedTypeName().contains("personal")) {
            return false;
        }
        do {
            if ((classDoc = classDoc.superclass()) == null || !string.equals(classDoc.qualifiedTypeName())) continue;
            return true;
        } while (classDoc != null);
        return false;
    }

    protected static PrintStream getOutput(RootDoc rootDoc) {
        for (String[] stringArray : rootDoc.options()) {
            if (!stringArray[0].equals("-f") || stringArray.length != 2) continue;
            try {
                return new PrintStream(new File(stringArray[1]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                rootDoc.printError("Could not open destination file: " + stringArray[1]);
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
        rootDoc.printError("Destination file parameter -f not supplied.");
        return null;
    }

    public static int optionLength(String string) {
        if (string.equals("-f")) {
            return 2;
        }
        return 0;
    }

    protected static String firstSentence(Doc doc) {
        Tag[] tagArray = doc.firstSentenceTags();
        StringBuilder stringBuilder = new StringBuilder(128);
        for (Tag tag : tagArray) {
            stringBuilder.append(tag.text());
        }
        return stringBuilder.toString();
    }
}

