/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.tribble.Tribble;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;
import picard.vcf.ByIntervalListVariantContextIterator;
import picard.vcf.GenotypeConcordanceContingencyMetrics;
import picard.vcf.GenotypeConcordanceCounts;
import picard.vcf.GenotypeConcordanceDetailMetrics;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceSchemeFactory;
import picard.vcf.GenotypeConcordanceStates;
import picard.vcf.GenotypeConcordanceSummaryMetrics;
import picard.vcf.OrderedSet;
import picard.vcf.PairedVariantSubContextIterator;

@CommandLineProgramProperties(usage="Evaluate genotype concordance between callsets.This tool evaluates the concordance between genotype calls for samples in different callsets where one is being considered as the truth (aka standard, or reference) and the other as the call that is being evaluated for accuracy. <br /><h4>Usage example:</h4><pre>java -jar picard.jar GenotypeConcordance \\<br />      CALL_VCF=input.vcf \\<br />      CALL_SAMPLE=sample_name \\<br />      O=gc_concordance.vcf \\<br />      TRUTH_VCF=truth_set.vcf \\<br />      TRUTH_SAMPLE=truth_sample#</pre><h4>Output Metrics:</h4><ul><li>Output metrics include GenotypeConcordanceContingencyMetrics, GenotypeConcordanceSummaryMetrics, and GenotypeConcordanceDetailMetrics.  For each set of metrics, the data is broken into separate sections for SNPs and INDELs.  Note that only SNP and INDEL variants are considered, MNP, Symbolic, and Mixed classes of variants are not included. </li><li>GenotypeConcordanceContingencyMetrics enumerate the constituents of each contingent in a callset including true-positive (TP), true-negative (TN), false-positive (FP), and false-negative (FN) calls. See http://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceContingencyMetrics for more details.</li><li>GenotypeConcordanceDetailMetrics include the numbers of SNPs and INDELs for each contingent genotype as well as the number of validated genotypes. See http://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceDetailMetrics for more details.</li><li>GenotypeConcordanceSummaryMetrics provide specific details for the variant caller performance on a callset including: values for sensitivity, specificity, and positive predictive values. See http://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceSummaryMetrics for more details.</li></ul><br /><br />Useful definitions applicable to alleles and genotypes:<br /> <ul><li>Truthset - A callset (typically in VCF format) containing variant calls and genotypes that have been cross-validated with multiple technologies e.g. Genome In A Bottle Consortium (GIAB) (https://sites.stanford.edu/abms/giab)</li><li>TP - True positives are variant calls that match a 'truthset'</li><li>FP - False-positives are reference sites miscalled as variant</li><li>FN - False-negatives are variant sites miscalled as reference</li><li>TN - True negatives are correctly called reference sites</li><li>Validated genotypes - are TP sites where the exact genotype (HET or HOM-VAR) has been validated </li> </ul><hr />", usageShort="Evaluate genotype concordance between callsets.", programGroup=VcfOrBcf.class)
public class GenotypeConcordance
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Evaluate genotype concordance between callsets.";
    static final String USAGE_DETAILS = "This tool evaluates the concordance between genotype calls for samples in different callsets where one is being considered as the truth (aka standard, or reference) and the other as the call that is being evaluated for accuracy. <br /><h4>Usage example:</h4><pre>java -jar picard.jar GenotypeConcordance \\<br />      CALL_VCF=input.vcf \\<br />      CALL_SAMPLE=sample_name \\<br />      O=gc_concordance.vcf \\<br />      TRUTH_VCF=truth_set.vcf \\<br />      TRUTH_SAMPLE=truth_sample#</pre><h4>Output Metrics:</h4><ul><li>Output metrics include GenotypeConcordanceContingencyMetrics, GenotypeConcordanceSummaryMetrics, and GenotypeConcordanceDetailMetrics.  For each set of metrics, the data is broken into separate sections for SNPs and INDELs.  Note that only SNP and INDEL variants are considered, MNP, Symbolic, and Mixed classes of variants are not included. </li><li>GenotypeConcordanceContingencyMetrics enumerate the constituents of each contingent in a callset including true-positive (TP), true-negative (TN), false-positive (FP), and false-negative (FN) calls. See http://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceContingencyMetrics for more details.</li><li>GenotypeConcordanceDetailMetrics include the numbers of SNPs and INDELs for each contingent genotype as well as the number of validated genotypes. See http://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceDetailMetrics for more details.</li><li>GenotypeConcordanceSummaryMetrics provide specific details for the variant caller performance on a callset including: values for sensitivity, specificity, and positive predictive values. See http://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceSummaryMetrics for more details.</li></ul><br /><br />Useful definitions applicable to alleles and genotypes:<br /> <ul><li>Truthset - A callset (typically in VCF format) containing variant calls and genotypes that have been cross-validated with multiple technologies e.g. Genome In A Bottle Consortium (GIAB) (https://sites.stanford.edu/abms/giab)</li><li>TP - True positives are variant calls that match a 'truthset'</li><li>FP - False-positives are reference sites miscalled as variant</li><li>FN - False-negatives are variant sites miscalled as reference</li><li>TN - True negatives are correctly called reference sites</li><li>Validated genotypes - are TP sites where the exact genotype (HET or HOM-VAR) has been validated </li> </ul><hr />";
    @Option(shortName="TV", doc="The VCF containing the truth sample")
    public File TRUTH_VCF;
    @Option(shortName="CV", doc="The VCF containing the call sample")
    public File CALL_VCF;
    @Option(shortName="O", doc="Basename for the two metrics files that are to be written. Resulting files will be <OUTPUT>.genotype_concordance_summary_metrics  and <OUTPUT>.genotype_concordance_detail_metrics.")
    public File OUTPUT;
    @Option(shortName="TS", doc="The name of the truth sample within the truth VCF")
    public String TRUTH_SAMPLE;
    @Option(shortName="CS", doc="The name of the call sample within the call VCF")
    public String CALL_SAMPLE;
    @Option(doc="One or more interval list files that will be used to limit the genotype concordance.  Note - if intervals are specified, the VCF files must be indexed.")
    public List<File> INTERVALS;
    @Option(doc="If true, multiple interval lists will be intersected. If false multiple lists will be unioned.")
    public boolean INTERSECT_INTERVALS = true;
    @Option(doc="Genotypes below this genotype quality will have genotypes classified as LowGq.")
    public int MIN_GQ = 0;
    @Option(doc="Genotypes below this depth will have genotypes classified as LowDp.")
    public int MIN_DP = 0;
    @Option(doc="If true, output all rows in detailed statistics even when count == 0.  When false only output rows with non-zero counts.")
    public boolean OUTPUT_ALL_ROWS = false;
    @Option(doc="If true, use the VCF index, else iterate over the entire VCF.", optional=true)
    public boolean USE_VCF_INDEX = false;
    @Option(shortName="MISSING_HOM", doc="Default is false, which follows the GA4GH Scheme. If true, missing sites in the truth set will be treated as HOM_REF sites and sites missing in both the truth and call sets will be true negatives. Useful when hom ref sites are left out of the truth set. This flag can only be used with a high confidence interval list.")
    public boolean MISSING_SITES_HOM_REF = false;
    private final Log log = Log.getInstance(GenotypeConcordance.class);
    private final ProgressLogger progress = new ProgressLogger(this.log, 10000, "checked", "variants");
    public static final String SUMMARY_METRICS_FILE_EXTENSION = ".genotype_concordance_summary_metrics";
    public static final String DETAILED_METRICS_FILE_EXTENSION = ".genotype_concordance_detail_metrics";
    public static final String CONTINGENCY_METRICS_FILE_EXTENSION = ".genotype_concordance_contingency_metrics";
    protected GenotypeConcordanceCounts snpCounter;
    protected GenotypeConcordanceCounts indelCounter;

    public GenotypeConcordanceCounts getSnpCounter() {
        return this.snpCounter;
    }

    public GenotypeConcordanceCounts getIndelCounter() {
        return this.indelCounter;
    }

    public static void main(String[] stringArray) {
        new GenotypeConcordance().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        IOUtil.assertFileIsReadable((File)this.TRUTH_VCF);
        IOUtil.assertFileIsReadable((File)this.CALL_VCF);
        boolean bl = this.INTERVALS != null && !this.INTERVALS.isEmpty();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            this.USE_VCF_INDEX = true;
        }
        if (this.USE_VCF_INDEX) {
            if (!this.indexExists(this.TRUTH_VCF)) {
                arrayList.add("The index file was not found for the TRUTH VCF.  Note that if intervals are specified, the VCF files must be indexed.");
            }
            if (!this.indexExists(this.CALL_VCF)) {
                arrayList.add("The index file was not found for the CALL VCF.  Note that if intervals are specified, the VCF files must be indexed.");
            }
        }
        if (this.MISSING_SITES_HOM_REF && !bl) {
            arrayList.add("You cannot use the MISSING_HOM option without also supplying an interval list over which missing sites are considered confident homozygous reference calls.");
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean indexExists(File file) {
        return Tribble.indexFile((File)file).exists() || Tribble.tabixIndexFile((File)file).exists();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doWork() {
        Object object;
        MetricsFile metricsFile;
        Object object2;
        void var10_13;
        Object object3;
        Object object4;
        File file = new File(this.OUTPUT + SUMMARY_METRICS_FILE_EXTENSION);
        File file2 = new File(this.OUTPUT + DETAILED_METRICS_FILE_EXTENSION);
        File file3 = new File(this.OUTPUT + CONTINGENCY_METRICS_FILE_EXTENSION);
        IOUtil.assertFileIsWritable((File)file);
        IOUtil.assertFileIsWritable((File)file2);
        IOUtil.assertFileIsWritable((File)file3);
        boolean bl = this.INTERVALS != null && !this.INTERVALS.isEmpty();
        IntervalList intervalList = null;
        SAMSequenceDictionary sAMSequenceDictionary = null;
        if (bl) {
            this.log.info(new Object[]{"Starting to load intervals list(s)."});
            long l = 0L;
            for (File object52 : this.INTERVALS) {
                IOUtil.assertFileIsReadable((File)object52);
                object4 = IntervalList.fromFile((File)object52);
                if (l == 0L) {
                    sAMSequenceDictionary = object4.getHeader().getSequenceDictionary();
                    l = sAMSequenceDictionary.getReferenceLength();
                }
                if (intervalList == null) {
                    intervalList = object4;
                    continue;
                }
                if (this.INTERSECT_INTERVALS) {
                    intervalList = IntervalList.intersection((IntervalList)intervalList, (IntervalList)object4);
                    continue;
                }
                intervalList = IntervalList.union((IntervalList)intervalList, (IntervalList)object4);
            }
            if (intervalList != null) {
                intervalList = intervalList.uniqued();
            }
            this.log.info(new Object[]{"Finished loading up intervals list(s)."});
        }
        VCFFileReader vCFFileReader = new VCFFileReader(this.TRUTH_VCF, this.USE_VCF_INDEX);
        VCFFileReader vCFFileReader2 = new VCFFileReader(this.CALL_VCF, this.USE_VCF_INDEX);
        if (!vCFFileReader.getFileHeader().getGenotypeSamples().contains(this.TRUTH_SAMPLE)) {
            throw new PicardException("File " + this.TRUTH_VCF.getAbsolutePath() + " does not contain genotypes for sample " + this.TRUTH_SAMPLE);
        }
        if (!vCFFileReader2.getFileHeader().getGenotypeSamples().contains(this.CALL_SAMPLE)) {
            throw new PicardException("File " + this.CALL_VCF.getAbsolutePath() + " does not contain genotypes for sample " + this.CALL_SAMPLE);
        }
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)vCFFileReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)vCFFileReader2.getFileHeader().getSequenceDictionary());
        if (bl) {
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)sAMSequenceDictionary, (SAMSequenceDictionary)vCFFileReader.getFileHeader().getSequenceDictionary());
        }
        if (bl) {
            object3 = new ByIntervalListVariantContextIterator(vCFFileReader, intervalList);
            ByIntervalListVariantContextIterator byIntervalListVariantContextIterator = new ByIntervalListVariantContextIterator(vCFFileReader2, intervalList);
        } else {
            object3 = vCFFileReader.iterator();
            CloseableIterator closeableIterator = vCFFileReader2.iterator();
        }
        object4 = new PairedVariantSubContextIterator((Iterator<VariantContext>)object3, this.TRUTH_SAMPLE, (Iterator<VariantContext>)var10_13, this.CALL_SAMPLE, vCFFileReader.getFileHeader().getSequenceDictionary());
        this.snpCounter = new GenotypeConcordanceCounts();
        this.indelCounter = new GenotypeConcordanceCounts();
        HashMap<VariantContext, Integer> hashMap = new HashMap<VariantContext, Integer>();
        this.log.info(new Object[]{"Starting iteration over variants."});
        while (((PairedVariantSubContextIterator)object4).hasNext()) {
            PairedVariantSubContextIterator.VcfTuple vcfTuple = ((PairedVariantSubContextIterator)object4).next();
            object2 = vcfTuple.leftVariantContext.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
            metricsFile = vcfTuple.rightVariantContext.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
            boolean bl2 = GenotypeConcordance.classifyVariants(vcfTuple.leftVariantContext, this.TRUTH_SAMPLE, vcfTuple.rightVariantContext, this.CALL_SAMPLE, Optional.of(this.snpCounter), Optional.of(this.indelCounter), this.MIN_GQ, this.MIN_DP);
            if (!bl2) {
                object = object2 + " " + metricsFile;
                Integer n = hashMap.getOrDefault(object, 0) + 1;
                hashMap.put((VariantContext)object, n);
            }
            object = vcfTuple.leftVariantContext.isPresent() ? vcfTuple.leftVariantContext.get() : vcfTuple.rightVariantContext.get();
            this.progress.record(object.getContig(), object.getStart());
        }
        if (this.MISSING_SITES_HOM_REF) {
            long l = intervalList != null ? intervalList.getBaseCount() : vCFFileReader.getFileHeader().getSequenceDictionary().getReferenceLength();
            GenotypeConcordance.addMissingTruthAndMissingCallStates(this.snpCounter.getCounterSize(), l, this.snpCounter);
            GenotypeConcordance.addMissingTruthAndMissingCallStates(this.indelCounter.getCounterSize(), l, this.indelCounter);
        }
        MetricsFile metricsFile2 = this.getMetricsFile();
        object2 = new GenotypeConcordanceSummaryMetrics(VariantContext.Type.SNP, this.snpCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        metricsFile2.addMetric((MetricBase)object2);
        object2 = new GenotypeConcordanceSummaryMetrics(VariantContext.Type.INDEL, this.indelCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        metricsFile2.addMetric((MetricBase)object2);
        metricsFile2.write(file);
        metricsFile = this.getMetricsFile();
        GenotypeConcordance.outputDetailMetricsFile(VariantContext.Type.SNP, metricsFile, this.snpCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF, this.OUTPUT_ALL_ROWS);
        GenotypeConcordance.outputDetailMetricsFile(VariantContext.Type.INDEL, metricsFile, this.indelCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF, this.OUTPUT_ALL_ROWS);
        metricsFile.write(file2);
        MetricsFile metricsFile3 = this.getMetricsFile();
        object = new GenotypeConcordanceContingencyMetrics(VariantContext.Type.SNP, this.snpCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        metricsFile3.addMetric((MetricBase)object);
        object = new GenotypeConcordanceContingencyMetrics(VariantContext.Type.INDEL, this.indelCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        metricsFile3.addMetric((MetricBase)object);
        metricsFile3.write(file3);
        for (String string : hashMap.keySet()) {
            this.log.info(new Object[]{"Uncovered truth/call Variant Context Type Counts: " + string + " " + hashMap.get(string)});
        }
        return 0;
    }

    public static boolean classifyVariants(Optional<VariantContext> optional, String string, Optional<VariantContext> optional2, String string2, int n, int n2) {
        return GenotypeConcordance.classifyVariants(optional, string, optional2, string2, Optional.empty(), Optional.empty(), n, n2);
    }

    public static boolean classifyVariants(Optional<VariantContext> optional, String string, Optional<VariantContext> optional2, String string2, Optional<GenotypeConcordanceCounts> optional3, Optional<GenotypeConcordanceCounts> optional4, int n, int n2) {
        VariantContext.Type type = optional.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
        VariantContext.Type type2 = optional2.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
        GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = GenotypeConcordance.determineState(optional.orElse(null), string, optional2.orElse(null), string2, n, n2);
        if (type == VariantContext.Type.SNP) {
            if (type2 == VariantContext.Type.SNP || type2 == VariantContext.Type.MIXED || type2 == VariantContext.Type.NO_VARIATION) {
                optional3.ifPresent(genotypeConcordanceCounts -> genotypeConcordanceCounts.increment(truthAndCallStates));
                return true;
            }
        } else if (type == VariantContext.Type.INDEL) {
            if (type2 == VariantContext.Type.INDEL || type2 == VariantContext.Type.MIXED || type2 == VariantContext.Type.NO_VARIATION) {
                optional4.ifPresent(genotypeConcordanceCounts -> genotypeConcordanceCounts.increment(truthAndCallStates));
                return true;
            }
        } else if (type == VariantContext.Type.MIXED) {
            if (type2 == VariantContext.Type.SNP) {
                optional3.ifPresent(genotypeConcordanceCounts -> genotypeConcordanceCounts.increment(truthAndCallStates));
                return true;
            }
            if (type2 == VariantContext.Type.INDEL) {
                optional4.ifPresent(genotypeConcordanceCounts -> genotypeConcordanceCounts.increment(truthAndCallStates));
                return true;
            }
        } else if (type == VariantContext.Type.NO_VARIATION) {
            if (type2 == VariantContext.Type.SNP) {
                optional3.ifPresent(genotypeConcordanceCounts -> genotypeConcordanceCounts.increment(truthAndCallStates));
                return true;
            }
            if (type2 == VariantContext.Type.INDEL) {
                optional4.ifPresent(genotypeConcordanceCounts -> genotypeConcordanceCounts.increment(truthAndCallStates));
                return true;
            }
        }
        return false;
    }

    public static void addMissingTruthAndMissingCallStates(double d, long l, GenotypeConcordanceCounts genotypeConcordanceCounts) {
        double d2 = (double)l - d;
        GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(GenotypeConcordanceStates.TruthState.MISSING, GenotypeConcordanceStates.CallState.MISSING);
        genotypeConcordanceCounts.increment(truthAndCallStates, d2);
    }

    public static void outputDetailMetricsFile(VariantContext.Type type, MetricsFile<GenotypeConcordanceDetailMetrics, ?> metricsFile, GenotypeConcordanceCounts genotypeConcordanceCounts, String string, String string2, boolean bl, boolean bl2) {
        GenotypeConcordanceSchemeFactory genotypeConcordanceSchemeFactory = new GenotypeConcordanceSchemeFactory();
        GenotypeConcordanceScheme genotypeConcordanceScheme = genotypeConcordanceSchemeFactory.getScheme(bl);
        genotypeConcordanceScheme.validateScheme();
        for (GenotypeConcordanceStates.TruthState truthState : GenotypeConcordanceStates.TruthState.values()) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                long l = genotypeConcordanceCounts.getCount(truthState, callState);
                String string3 = genotypeConcordanceScheme.getContingencyStateString(truthState, callState);
                if (l <= 0L && !bl2) continue;
                GenotypeConcordanceDetailMetrics genotypeConcordanceDetailMetrics = new GenotypeConcordanceDetailMetrics();
                genotypeConcordanceDetailMetrics.VARIANT_TYPE = type;
                genotypeConcordanceDetailMetrics.TRUTH_SAMPLE = string;
                genotypeConcordanceDetailMetrics.CALL_SAMPLE = string2;
                genotypeConcordanceDetailMetrics.TRUTH_STATE = truthState;
                genotypeConcordanceDetailMetrics.CALL_STATE = callState;
                genotypeConcordanceDetailMetrics.COUNT = l;
                genotypeConcordanceDetailMetrics.CONTINGENCY_VALUES = string3;
                metricsFile.addMetric((MetricBase)genotypeConcordanceDetailMetrics);
            }
        }
    }

    public static final GenotypeConcordanceStates.TruthAndCallStates determineState(VariantContext variantContext, String string, VariantContext variantContext2, String string2, int n, int n2) {
        int n3;
        int n4;
        Object object;
        GenotypeConcordanceStates.TruthState truthState = null;
        GenotypeConcordanceStates.CallState callState = null;
        Genotype genotype = null;
        Genotype genotype2 = null;
        if (variantContext == null) {
            truthState = GenotypeConcordanceStates.TruthState.MISSING;
        } else if (variantContext.isMixed()) {
            truthState = GenotypeConcordanceStates.TruthState.IS_MIXED;
        } else if (variantContext.isFiltered()) {
            truthState = GenotypeConcordanceStates.TruthState.VC_FILTERED;
        } else {
            genotype = variantContext.getGenotype(string);
            if (genotype.isNoCall()) {
                truthState = GenotypeConcordanceStates.TruthState.NO_CALL;
            } else if (genotype.isFiltered()) {
                truthState = GenotypeConcordanceStates.TruthState.GT_FILTERED;
            } else if (genotype.getGQ() != -1 && genotype.getGQ() < n) {
                truthState = GenotypeConcordanceStates.TruthState.LOW_GQ;
            } else if (genotype.getDP() != -1 && genotype.getDP() < n2) {
                truthState = GenotypeConcordanceStates.TruthState.LOW_DP;
            } else if (genotype.isMixed()) {
                truthState = GenotypeConcordanceStates.TruthState.NO_CALL;
            }
        }
        if (variantContext2 == null) {
            callState = GenotypeConcordanceStates.CallState.MISSING;
        } else if (variantContext2.isMixed()) {
            callState = GenotypeConcordanceStates.CallState.IS_MIXED;
        } else if (variantContext2.isFiltered()) {
            callState = GenotypeConcordanceStates.CallState.VC_FILTERED;
        } else {
            genotype2 = variantContext2.getGenotype(string2);
            if (genotype2.isNoCall()) {
                callState = GenotypeConcordanceStates.CallState.NO_CALL;
            } else if (genotype2.isFiltered()) {
                callState = GenotypeConcordanceStates.CallState.GT_FILTERED;
            } else if (genotype2.getGQ() != -1 && genotype2.getGQ() < n) {
                callState = GenotypeConcordanceStates.CallState.LOW_GQ;
            } else if (genotype2.getDP() != -1 && genotype2.getDP() < n2) {
                callState = GenotypeConcordanceStates.CallState.LOW_DP;
            } else if (genotype2.isMixed()) {
                callState = GenotypeConcordanceStates.CallState.NO_CALL;
            }
        }
        String string3 = variantContext != null ? variantContext.getReference().getBaseString() : null;
        String string4 = variantContext2 != null ? variantContext2.getReference().getBaseString() : null;
        String string5 = null;
        String string6 = null;
        if (null == truthState) {
            if (genotype.getAlleles().size() != 2) {
                throw new IllegalStateException("Genotype for Variant Context: " + variantContext + " does not have exactly 2 alleles");
            }
            string5 = genotype.getAllele(0).getBaseString();
            string6 = genotype.getAllele(1).getBaseString();
        }
        String string7 = null;
        String string8 = null;
        if (null == callState) {
            if (genotype2.getAlleles().size() != 2) {
                throw new IllegalStateException("Genotype for Variant Context: " + variantContext2 + " does not have exactly 2 alleles");
            }
            string7 = genotype2.getAllele(0).getBaseString();
            string8 = genotype2.getAllele(1).getBaseString();
        }
        if (string3 != null && string4 != null && !string3.equals(string4)) {
            if (string3.length() < string4.length()) {
                object = GenotypeConcordance.getStringSuffix(string4, string3, "Ref alleles mismatch between: " + variantContext + " and " + variantContext2);
                string3 = string3 + (String)object;
                if (null == truthState) {
                    string5 = genotype.getAllele(0).getBaseString() + (String)object;
                    string6 = genotype.getAllele(1).getBaseString() + (String)object;
                }
            } else if (string3.length() > string4.length()) {
                object = GenotypeConcordance.getStringSuffix(string3, string4, "Ref alleles mismatch between: " + variantContext + " and " + variantContext2);
                string4 = string4 + (String)object;
                if (null == callState) {
                    string7 = genotype2.getAllele(0).getBaseString() + (String)object;
                    string8 = genotype2.getAllele(1).getBaseString() + (String)object;
                }
            } else {
                throw new IllegalStateException("Ref alleles mismatch between: " + variantContext + " and " + variantContext2);
            }
        }
        object = new OrderedSet<String>();
        if (variantContext != null || variantContext2 != null) {
            ((OrderedSet)object).smartAdd(variantContext == null ? string4 : string3);
        }
        if (null == truthState) {
            ((OrderedSet)object).smartAdd(string5);
            ((OrderedSet)object).smartAdd(string6);
        }
        if (null == callState) {
            if (((ArrayList)object).indexOf(string7) > 1 || ((ArrayList)object).indexOf(string8) > 1) {
                ((ArrayList)object).remove(2);
                ((ArrayList)object).remove(1);
                ((OrderedSet)object).smartAdd(string6);
                ((OrderedSet)object).smartAdd(string5);
            }
            ((OrderedSet)object).smartAdd(string7);
            ((OrderedSet)object).smartAdd(string8);
        }
        if (null == truthState) {
            n4 = ((ArrayList)object).indexOf(string5);
            truthState = n4 == (n3 = ((ArrayList)object).indexOf(string6)) ? GenotypeConcordanceStates.TruthState.getHom(n4) : GenotypeConcordanceStates.TruthState.getVar(n4, n3);
        }
        if (null == callState && null == (callState = (n4 = ((ArrayList)object).indexOf(string7)) == (n3 = ((ArrayList)object).indexOf(string8)) ? GenotypeConcordanceStates.CallState.getHom(n4) : GenotypeConcordanceStates.CallState.getHet(n4, n3))) {
            throw new IllegalStateException("This should never happen...  Could not classify the call variant: " + genotype2);
        }
        return new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
    }

    static final String getStringSuffix(String string, String string2, String string3) {
        if (!string.startsWith(string2)) {
            throw new IllegalStateException(string3);
        }
        return string.substring(string2.length());
    }
}

