/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Map;
import picard.vcf.GenotypeConcordanceCounts;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceSchemeFactory;
import picard.vcf.GenotypeConcordanceStates;

public class GenotypeConcordanceContingencyMetrics
extends MetricBase {
    public VariantContext.Type VARIANT_TYPE;
    public String TRUTH_SAMPLE;
    public String CALL_SAMPLE;
    public long TP_COUNT;
    public long TN_COUNT;
    public long FP_COUNT;
    public long FN_COUNT;
    public long EMPTY_COUNT;

    public GenotypeConcordanceContingencyMetrics() {
    }

    public GenotypeConcordanceContingencyMetrics(VariantContext.Type type, GenotypeConcordanceCounts genotypeConcordanceCounts, String string, String string2, boolean bl) {
        this.VARIANT_TYPE = type;
        this.TRUTH_SAMPLE = string;
        this.CALL_SAMPLE = string2;
        GenotypeConcordanceSchemeFactory genotypeConcordanceSchemeFactory = new GenotypeConcordanceSchemeFactory();
        GenotypeConcordanceScheme genotypeConcordanceScheme = genotypeConcordanceSchemeFactory.getScheme(bl);
        genotypeConcordanceScheme.validateScheme();
        genotypeConcordanceCounts.validateCountsAgainstScheme(genotypeConcordanceScheme);
        Map<GenotypeConcordanceStates.ContingencyState, Long> map = genotypeConcordanceCounts.getContingencyStateCounts(genotypeConcordanceScheme);
        this.TP_COUNT = map.get((Object)GenotypeConcordanceStates.ContingencyState.TP);
        this.TN_COUNT = map.get((Object)GenotypeConcordanceStates.ContingencyState.TN);
        this.FP_COUNT = map.get((Object)GenotypeConcordanceStates.ContingencyState.FP);
        this.FN_COUNT = map.get((Object)GenotypeConcordanceStates.ContingencyState.FN);
        this.EMPTY_COUNT = map.get((Object)GenotypeConcordanceStates.ContingencyState.EMPTY);
    }
}

