/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFRecordCodec;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Lifts over a VCF file from one reference build to another.  This tool adjusts the coordinates of variants within a VCF file to match a new reference. The output file will be sorted and indexed using the target reference build. To be clear, REFERENCE_SEQUENCE should be the <em>target</em> reference build. The tool is based on the UCSC liftOver tool (see: http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation. <br /><br />Note that records may be rejected because they cannot be lifted over or because of sequence incompatibilities between the source and target reference genomes.  Rejected records will be emitted with filters to the REJECT file, using the source genome coordinates.<br /><h4>Usage example:</h4><pre>java -jar picard.jar LiftoverVcf \\<br />     I=input.vcf \\<br />     O=lifted_over.vcf \\<br />     CHAIN=b37tohg19.chain \\<br />     REJECT=rejected_variants.vcf \\<br />     R=reference_sequence.fasta</pre>For additional information, please see: http://genome.ucsc.edu/cgi-bin/hgLiftOver<hr />", usageShort="Lifts over a VCF file from one reference build to another.  ", programGroup=VcfOrBcf.class)
public class LiftoverVcf
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Lifts over a VCF file from one reference build to another.  ";
    static final String USAGE_DETAILS = "This tool adjusts the coordinates of variants within a VCF file to match a new reference. The output file will be sorted and indexed using the target reference build. To be clear, REFERENCE_SEQUENCE should be the <em>target</em> reference build. The tool is based on the UCSC liftOver tool (see: http://genome.ucsc.edu/cgi-bin/hgLiftOver) and uses a UCSC chain file to guide its operation. <br /><br />Note that records may be rejected because they cannot be lifted over or because of sequence incompatibilities between the source and target reference genomes.  Rejected records will be emitted with filters to the REJECT file, using the source genome coordinates.<br /><h4>Usage example:</h4><pre>java -jar picard.jar LiftoverVcf \\<br />     I=input.vcf \\<br />     O=lifted_over.vcf \\<br />     CHAIN=b37tohg19.chain \\<br />     REJECT=rejected_variants.vcf \\<br />     R=reference_sequence.fasta</pre>For additional information, please see: http://genome.ucsc.edu/cgi-bin/hgLiftOver<hr />";
    @Option(shortName="I", doc="The input VCF/BCF file to be lifted over.")
    public File INPUT;
    @Option(shortName="O", doc="The output location to write the lifted over VCF/BCF to.")
    public File OUTPUT;
    @Option(shortName="C", doc="The liftover chain file. See https://genome.ucsc.edu/goldenPath/help/chain.html for a description of chain files.  See http://hgdownload.soe.ucsc.edu/downloads.html#terms for where to download chain files.")
    public File CHAIN;
    @Option(doc="File to which to write rejected records.")
    public File REJECT;
    @Option(shortName="R", common=false, doc="The reference sequence (fasta) for the TARGET genome build.  The fasta file must have an accompanying sequence dictionary (.dict file).")
    public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;
    @Option(shortName="WMC", doc="Warn on missing contig.", optional=true)
    public boolean WARN_ON_MISSING_CONTIG = false;
    @Option(doc="Write the original contig/position for lifted variants to the INFO field.", optional=true)
    public boolean WRITE_ORIGINAL_POSITION = false;
    @Option(doc="The minimum percent match required for a variant to be lifted.", optional=true)
    public double LIFTOVER_MIN_MATCH = 1.0;
    @Option(doc="Allow INFO and FORMAT in the records that are not found in the header", optional=true)
    public boolean ALLOW_MISSING_FIELDS_IN_HEADER = false;
    protected static int EXIT_CODE_WHEN_CONTIG_NOT_IN_REFERENCE = 1;
    public static final String FILTER_CANNOT_LIFTOVER_INDEL = "ReverseComplementedIndel";
    public static final String FILTER_NO_TARGET = "NoTarget";
    public static final String FILTER_MISMATCHING_REF_ALLELE = "MismatchedRefAllele";
    private static final List<VCFFilterHeaderLine> FILTERS = CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine("ReverseComplementedIndel", "Indel falls into a reverse complemented region in the target genome."), new VCFFilterHeaderLine("NoTarget", "Variant could not be lifted between genome builds."), new VCFFilterHeaderLine("MismatchedRefAllele", "Reference allele does not match reference genome sequence after liftover.")});
    public static final String ORIGINAL_CONTIG = "OriginalContig";
    public static final String ORIGINAL_START = "OriginalStart";
    private static final List<VCFInfoHeaderLine> ATTRS = CollectionUtil.makeList((Object[])new VCFInfoHeaderLine[]{new VCFInfoHeaderLine("OriginalContig", 1, VCFHeaderLineType.String, "The name of the source contig/chromosome prior to liftover."), new VCFInfoHeaderLine("OriginalStart", 1, VCFHeaderLineType.String, "The position of the variant on the source contig prior to liftover.")});
    private final Log log = Log.getInstance(LiftoverVcf.class);

    public static void main(String[] stringArray) {
        new LiftoverVcf().instanceMainWithExit(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int doWork() {
        VCFInfoHeaderLine vCFInfoHeaderLine2;
        SAMSequenceRecord sAMSequenceRecord2;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.REJECT);
        LiftOver liftOver = new LiftOver(this.CHAIN);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, false);
        this.log.info(new Object[]{"Loading up the target reference genome."});
        ReferenceSequenceFileWalker referenceSequenceFileWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        for (SAMSequenceRecord sAMSequenceRecord2 : referenceSequenceFileWalker.getSequenceDictionary().getSequences()) {
            hashMap.put(sAMSequenceRecord2.getSequenceName(), referenceSequenceFileWalker.get(sAMSequenceRecord2.getSequenceIndex()).getBases());
        }
        CloserUtil.close((Object)referenceSequenceFileWalker);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        sAMSequenceRecord2 = new VCFHeader(vCFHeader);
        sAMSequenceRecord2.setSequenceDictionary(referenceSequenceFileWalker.getSequenceDictionary());
        if (this.WRITE_ORIGINAL_POSITION) {
            for (VCFInfoHeaderLine vCFInfoHeaderLine2 : ATTRS) {
                sAMSequenceRecord2.addMetaDataLine((VCFHeaderLine)vCFInfoHeaderLine2);
            }
        }
        VariantContextWriter variantContextWriter = new VariantContextWriterBuilder().setOption(Options.INDEX_ON_THE_FLY).modifyOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER, this.ALLOW_MISSING_FIELDS_IN_HEADER).setOutputFile(this.OUTPUT).setReferenceDictionary(referenceSequenceFileWalker.getSequenceDictionary()).build();
        variantContextWriter.writeHeader((VCFHeader)sAMSequenceRecord2);
        vCFInfoHeaderLine2 = new VariantContextWriterBuilder().setOutputFile(this.REJECT).unsetOption(Options.INDEX_ON_THE_FLY).modifyOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER, this.ALLOW_MISSING_FIELDS_IN_HEADER).build();
        VCFHeader vCFHeader2 = new VCFHeader(vCFFileReader.getFileHeader());
        for (VCFFilterHeaderLine vCFFilterHeaderLine : FILTERS) {
            vCFHeader2.addMetaDataLine((VCFHeaderLine)vCFFilterHeaderLine);
        }
        if (this.WRITE_ORIGINAL_POSITION) {
            for (VCFInfoHeaderLine vCFInfoHeaderLine3 : ATTRS) {
                vCFHeader2.addMetaDataLine((VCFHeaderLine)vCFInfoHeaderLine3);
            }
        }
        vCFInfoHeaderLine2.writeHeader(vCFHeader2);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        this.log.info(new Object[]{"Lifting variants over and sorting."});
        SortingCollection sortingCollection = SortingCollection.newInstance(VariantContext.class, (SortingCollection.Codec)new VCFRecordCodec((VCFHeader)sAMSequenceRecord2, this.ALLOW_MISSING_FIELDS_IN_HEADER || this.VALIDATION_STRINGENCY != ValidationStringency.STRICT), (Comparator)sAMSequenceRecord2.getVCFRecordComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 1000000, "read");
        HashMap<Allele, Allele> hashMap2 = new HashMap<Allele, Allele>(10);
        Object object = vCFFileReader.iterator();
        while (true) {
            VariantContext variantContext;
            block18: {
                VariantContextBuilder variantContextBuilder;
                Object object2;
                Interval interval;
                Interval interval2;
                block20: {
                    block16: {
                        block19: {
                            block17: {
                                if (!object.hasNext()) break block16;
                                variantContext = (VariantContext)object.next();
                                ++l3;
                                interval2 = new Interval(variantContext.getContig(), variantContext.getStart(), variantContext.getEnd(), false, variantContext.getContig() + ":" + variantContext.getStart() + "-" + variantContext.getEnd());
                                interval = liftOver.liftOver(interval2, this.LIFTOVER_MIN_MATCH);
                                if (interval != null && (!interval.isNegativeStrand() || !variantContext.isMixed() && !variantContext.isIndel())) break block17;
                                object2 = interval == null ? FILTER_NO_TARGET : FILTER_CANNOT_LIFTOVER_INDEL;
                                vCFInfoHeaderLine2.add(new VariantContextBuilder(variantContext).filter((String)object2).make());
                                ++l;
                                break block18;
                            }
                            if (hashMap.containsKey(interval.getContig())) break block19;
                            vCFInfoHeaderLine2.add(new VariantContextBuilder(variantContext).filter(FILTER_NO_TARGET).make());
                            ++l;
                            object2 = "Encountered a contig, " + interval.getContig() + " that is not part of the target reference.";
                            if (!this.WARN_ON_MISSING_CONTIG) {
                                this.log.error(new Object[]{object2});
                                return EXIT_CODE_WHEN_CONTIG_NOT_IN_REFERENCE;
                            }
                            this.log.warn(new Object[]{object2});
                            break block18;
                        }
                        hashMap2.clear();
                        object2 = new ArrayList();
                        variantContextBuilder = variantContext.getAlleles().iterator();
                        break block20;
                    }
                    object = new DecimalFormat("0.0000%");
                    String string = ((NumberFormat)object).format((double)(l + l2) / (double)l3);
                    this.log.info(new Object[]{"Processed ", l3, " variants."});
                    this.log.info(new Object[]{l, " variants failed to liftover."});
                    this.log.info(new Object[]{l2, " variants lifted over but had mismatching reference alleles after lift over."});
                    this.log.info(new Object[]{string, " of variants were not successfully lifted over and written to the output."});
                    vCFInfoHeaderLine2.close();
                    vCFFileReader.close();
                    sortingCollection.doneAdding();
                    progressLogger = new ProgressLogger(this.log, 1000000, "written");
                    this.log.info(new Object[]{"Writing out sorted records to final VCF."});
                    interval2 = sortingCollection.iterator();
                    while (true) {
                        if (!interval2.hasNext()) {
                            variantContextWriter.close();
                            sortingCollection.cleanup();
                            return 0;
                        }
                        interval = (VariantContext)interval2.next();
                        variantContextWriter.add((VariantContext)interval);
                        progressLogger.record(interval.getContig(), interval.getStart());
                    }
                }
                while (variantContextBuilder.hasNext()) {
                    Allele allele = (Allele)variantContextBuilder.next();
                    if (interval.isPositiveStrand() || allele.isSymbolic()) {
                        object2.add(allele);
                        continue;
                    }
                    Allele allele2 = Allele.create((String)SequenceUtil.reverseComplement((String)allele.getBaseString()), (boolean)allele.isReference());
                    object2.add(allele2);
                    hashMap2.put(allele, allele2);
                }
                variantContextBuilder = new VariantContextBuilder(variantContext.getSource(), interval.getContig(), (long)interval.getStart(), (long)interval.getEnd(), (Collection)object2);
                variantContextBuilder.id(variantContext.getID());
                variantContextBuilder.attributes(variantContext.getAttributes());
                if (this.WRITE_ORIGINAL_POSITION) {
                    variantContextBuilder.attribute(ORIGINAL_CONTIG, (Object)interval2.getContig());
                    variantContextBuilder.attribute(ORIGINAL_START, (Object)interval2.getStart());
                }
                variantContextBuilder.genotypes(LiftoverVcf.fixGenotypes(variantContext.getGenotypes(), hashMap2));
                variantContextBuilder.filters(variantContext.getFilters());
                variantContextBuilder.log10PError(variantContext.getLog10PError());
                boolean bl = false;
                for (Allele allele : variantContextBuilder.getAlleles()) {
                    if (!allele.isReference()) continue;
                    byte[] byArray = (byte[])hashMap.get(interval.getContig());
                    String string = StringUtil.bytesToString((byte[])byArray, (int)(interval.getStart() - 1), (int)interval.length());
                    if (string.equalsIgnoreCase(allele.getBaseString())) break;
                    bl = true;
                    break;
                }
                if (bl) {
                    vCFInfoHeaderLine2.add(new VariantContextBuilder(variantContext).filter(FILTER_MISMATCHING_REF_ALLELE).make());
                    ++l2;
                } else {
                    sortingCollection.add((Object)variantContextBuilder.make());
                }
            }
            progressLogger.record(variantContext.getContig(), variantContext.getStart());
        }
    }

    protected static GenotypesContext fixGenotypes(GenotypesContext genotypesContext, Map<Allele, Allele> map) {
        if (map.isEmpty()) {
            return genotypesContext;
        }
        GenotypesContext genotypesContext2 = GenotypesContext.create((int)genotypesContext.size());
        for (Genotype genotype : genotypesContext) {
            ArrayList<Allele> arrayList = new ArrayList<Allele>();
            for (Allele allele : genotype.getAlleles()) {
                Allele allele2 = map.containsKey(allele) ? map.get(allele) : allele;
                arrayList.add(allele2);
            }
            genotypesContext2.add(new GenotypeBuilder(genotype).alleles(arrayList).make());
        }
        return genotypesContext2;
    }
}

