/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Reads a VCF/VCF.gz/BCF and removes all genotype information from it while retaining all site level information, including annotations based on genotypes (e.g. AN, AF). Output an be any support variant format including .vcf, .vcf.gz or .bcf.", usageShort="Creates a VCF bereft of genotype information from an input VCF or BCF", programGroup=VcfOrBcf.class)
public class MakeSitesOnlyVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF or BCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF or BCF to emit without per-sample info.")
    public File OUTPUT;
    @Option(shortName="S", doc="Optionally one or more samples to retain when building the 'sites-only' VCF.", optional=true)
    public Set<String> SAMPLE = new TreeSet<String>();

    public static void main(String[] stringArray) {
        new MakeSitesOnlyVcf().instanceMainWithExit(stringArray);
    }

    public MakeSitesOnlyVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, false);
        VCFHeader vCFHeader = new VCFHeader(vCFFileReader.getFileHeader().getMetaDataInInputOrder());
        SAMSequenceDictionary sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        ProgressLogger progressLogger = new ProgressLogger(Log.getInstance(MakeSitesOnlyVcf.class), 10000);
        VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sAMSequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            variantContextWriterBuilder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            variantContextWriterBuilder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter variantContextWriter = variantContextWriterBuilder.build();
        VCFHeader vCFHeader2 = new VCFHeader(vCFHeader.getMetaDataInInputOrder(), this.SAMPLE);
        variantContextWriter.writeHeader(vCFHeader2);
        CloseableIterator closeableIterator = vCFFileReader.iterator();
        while (closeableIterator.hasNext()) {
            VariantContext variantContext = (VariantContext)closeableIterator.next();
            VariantContext variantContext2 = MakeSitesOnlyVcf.subsetToSamplesWithOriginalAnnotations(variantContext, this.SAMPLE);
            variantContextWriter.add(variantContext2);
            progressLogger.record(variantContext2.getChr(), variantContext2.getStart());
        }
        CloserUtil.close((Object)closeableIterator);
        CloserUtil.close((Object)vCFFileReader);
        variantContextWriter.close();
        return 0;
    }

    private static VariantContext subsetToSamplesWithOriginalAnnotations(VariantContext variantContext, Set<String> set) {
        VariantContextBuilder variantContextBuilder = new VariantContextBuilder(variantContext);
        GenotypesContext genotypesContext = variantContext.getGenotypes().subsetToSamples(set);
        variantContextBuilder.alleles((Collection)variantContext.getAlleles());
        return variantContextBuilder.genotypes(genotypesContext).make();
    }
}

