/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import java.util.Iterator;
import java.util.Optional;

public class PairedVariantSubContextIterator
implements Iterator<VcfTuple> {
    private final PeekableIterator<VariantContext> leftIterator;
    private final String leftSample;
    private final PeekableIterator<VariantContext> rightIterator;
    private final String rightSample;
    private final VariantContextComparator comparator;

    public PairedVariantSubContextIterator(Iterator<VariantContext> iterator, String string, Iterator<VariantContext> iterator2, String string2, SAMSequenceDictionary sAMSequenceDictionary) {
        this.leftIterator = new PeekableIterator(iterator);
        this.leftSample = string;
        this.rightIterator = new PeekableIterator(iterator2);
        this.rightSample = string2;
        this.comparator = new VariantContextComparator(sAMSequenceDictionary);
    }

    @Override
    public boolean hasNext() {
        return this.leftIterator.hasNext() || this.rightIterator.hasNext();
    }

    @Override
    public VcfTuple next() {
        Optional optional;
        if (!this.hasNext()) {
            throw new IllegalStateException("next() called while hasNext() is false.");
        }
        Optional optional2 = this.leftIterator.hasNext() ? Optional.of(this.leftIterator.peek()) : Optional.empty();
        Optional<Object> optional3 = optional = this.rightIterator.hasNext() ? Optional.of(this.rightIterator.peek()) : Optional.empty();
        if (!optional2.isPresent() && !optional.isPresent()) {
            throw new IllegalStateException("BUG: Both contexts empty.");
        }
        if (!optional2.isPresent()) {
            return new VcfTuple(Optional.empty(), ((VariantContext)this.rightIterator.next()).subContextFromSample(this.rightSample));
        }
        if (!optional.isPresent()) {
            return new VcfTuple(((VariantContext)this.leftIterator.next()).subContextFromSample(this.leftSample), Optional.empty());
        }
        int n = this.comparator.compare((VariantContext)optional2.get(), (VariantContext)optional.get());
        if (n == 0) {
            return new VcfTuple(((VariantContext)this.leftIterator.next()).subContextFromSample(this.leftSample), ((VariantContext)this.rightIterator.next()).subContextFromSample(this.rightSample));
        }
        if (n < 0) {
            return new VcfTuple(((VariantContext)this.leftIterator.next()).subContextFromSample(this.leftSample), Optional.empty());
        }
        return new VcfTuple(Optional.empty(), ((VariantContext)this.rightIterator.next()).subContextFromSample(this.rightSample));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class VcfTuple {
        public final Optional<VariantContext> leftVariantContext;
        public final Optional<VariantContext> rightVariantContext;

        private VcfTuple(Optional<VariantContext> optional, Optional<VariantContext> optional2) {
            this.leftVariantContext = optional;
            this.rightVariantContext = optional2;
        }

        VcfTuple(VariantContext variantContext, VariantContext variantContext2) {
            this(Optional.of(variantContext), Optional.of(variantContext2));
        }

        VcfTuple(Optional<VariantContext> optional, VariantContext variantContext) {
            this(optional, Optional.of(variantContext));
        }

        VcfTuple(VariantContext variantContext, Optional<VariantContext> optional) {
            this(Optional.of(variantContext), optional);
        }
    }
}

