/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterFactory;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.EnumSet;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Renames a sample within a VCF or BCF.  This tool enables the user to rename a sample in either a VCF or BCF file.  It is intended to change the name of a sample in a VCF prior to merging with VCF files in which one or more samples have similar names. Note that the input VCF file must be single-sample VCF and that the NEW_SAMPLE_NAME is required.<br /><h4>Usage example:</h4><pre>java -jar picard.jar RenameSampleInVcf \\<br />      I=input.vcf \\<br />      O=renamed.vcf \\<br />      NEW_SAMPLE_NAME=sample123</pre><hr />", usageShort="Renames a sample within a VCF or BCF.  ", programGroup=VcfOrBcf.class)
public class RenameSampleInVcf
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Renames a sample within a VCF or BCF.  ";
    static final String USAGE_DETAILS = "This tool enables the user to rename a sample in either a VCF or BCF file.  It is intended to change the name of a sample in a VCF prior to merging with VCF files in which one or more samples have similar names. Note that the input VCF file must be single-sample VCF and that the NEW_SAMPLE_NAME is required.<br /><h4>Usage example:</h4><pre>java -jar picard.jar RenameSampleInVcf \\<br />      I=input.vcf \\<br />      O=renamed.vcf \\<br />      NEW_SAMPLE_NAME=sample123</pre><hr />";
    @Option(shortName="I", doc="Input single sample VCF.")
    public File INPUT;
    @Option(shortName="O", doc="Output single sample VCF.")
    public File OUTPUT;
    @Option(doc="Existing name of sample in VCF; if provided, asserts that that is the name of the extant sample name", optional=true)
    public String OLD_SAMPLE_NAME = null;
    @Option(doc="New name to give sample in output VCF.")
    public String NEW_SAMPLE_NAME;

    public static void main(String[] stringArray) {
        new RenameSampleInVcf().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        if (vCFHeader.getGenotypeSamples().size() > 1) {
            throw new IllegalArgumentException("Input VCF must be single-sample.");
        }
        if (this.OLD_SAMPLE_NAME != null && !this.OLD_SAMPLE_NAME.equals(vCFHeader.getGenotypeSamples().get(0))) {
            throw new IllegalArgumentException("Input VCF did not contain expected sample. Contained: " + (String)vCFHeader.getGenotypeSamples().get(0));
        }
        EnumSet<Options> enumSet = EnumSet.copyOf(VariantContextWriterFactory.DEFAULT_OPTIONS);
        if (this.CREATE_INDEX.booleanValue()) {
            enumSet.add(Options.INDEX_ON_THE_FLY);
        } else {
            enumSet.remove(Options.INDEX_ON_THE_FLY);
        }
        VCFHeader vCFHeader2 = new VCFHeader(vCFHeader.getMetaDataInInputOrder(), CollectionUtil.makeList((Object[])new String[]{this.NEW_SAMPLE_NAME}));
        VariantContextWriter variantContextWriter = VariantContextWriterFactory.create((File)this.OUTPUT, (SAMSequenceDictionary)vCFHeader2.getSequenceDictionary(), enumSet);
        variantContextWriter.writeHeader(vCFHeader2);
        for (VariantContext variantContext : vCFFileReader) {
            variantContextWriter.add(variantContext);
        }
        variantContextWriter.close();
        vCFFileReader.close();
        return 0;
    }
}

