/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Splits SNPs and INDELs into separate files.  This tool reads in a VCF or BCF file and writes out the SNPs and INDELs it contains to separate files. The headers of the two output files will be identical and index files will be created for both outputs. If records other than SNPs or INDELs are present, set the STRICT option to \"false\", otherwise the tool will raise an exception and quit. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitVcfs \\<br />      I=input.vcf \\<br />      SNP_OUTPUT=snp.vcf \\<br />      INDEL_OUTPUT=indel.vcf \\<br />      STRICT=false</pre><hr />", usageShort="Splits SNPs and INDELs into separate files.  ", programGroup=VcfOrBcf.class)
public class SplitVcfs
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Splits SNPs and INDELs into separate files.  ";
    static final String USAGE_DETAILS = "This tool reads in a VCF or BCF file and writes out the SNPs and INDELs it contains to separate files. The headers of the two output files will be identical and index files will be created for both outputs. If records other than SNPs or INDELs are present, set the STRICT option to \"false\", otherwise the tool will raise an exception and quit. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitVcfs \\<br />      I=input.vcf \\<br />      SNP_OUTPUT=snp.vcf \\<br />      INDEL_OUTPUT=indel.vcf \\<br />      STRICT=false</pre><hr />";
    @Option(shortName="I", doc="The VCF or BCF input file")
    public File INPUT;
    @Option(doc="The VCF or BCF file to which SNP records should be written. The file format is determined by file extension.")
    public File SNP_OUTPUT;
    @Option(doc="The VCF or BCF file to which indel records should be written. The file format is determined by file extension.")
    public File INDEL_OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionaries in the input files", optional=true)
    public File SEQUENCE_DICTIONARY;
    @Option(doc="If true an exception will be thrown if an event type other than SNP or indel is encountered")
    public Boolean STRICT = true;
    private final Log log = Log.getInstance(SplitVcfs.class);

    public static void main(String[] stringArray) {
        new SplitVcfs().instanceMainWithExit(stringArray);
    }

    public SplitVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        SAMSequenceDictionary sAMSequenceDictionary;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        SAMSequenceDictionary sAMSequenceDictionary2 = sAMSequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.SEQUENCE_DICTIONARY).getSequenceDictionary() : vCFHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder().setReferenceDictionary(sAMSequenceDictionary).clearOptions();
        if (this.CREATE_INDEX.booleanValue()) {
            variantContextWriterBuilder.setOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter variantContextWriter = variantContextWriterBuilder.setOutputFile(this.SNP_OUTPUT).build();
        VariantContextWriter variantContextWriter2 = variantContextWriterBuilder.setOutputFile(this.INDEL_OUTPUT).build();
        variantContextWriter.writeHeader(vCFHeader);
        variantContextWriter2.writeHeader(vCFHeader);
        int n = 0;
        CloseableIterator closeableIterator = vCFFileReader.iterator();
        while (closeableIterator.hasNext()) {
            VariantContext variantContext = (VariantContext)closeableIterator.next();
            if (variantContext.isIndel()) {
                variantContextWriter2.add(variantContext);
            } else if (variantContext.isSNP()) {
                variantContextWriter.add(variantContext);
            } else {
                if (this.STRICT.booleanValue()) {
                    throw new IllegalStateException("Found a record with type " + variantContext.getType().name());
                }
                ++n;
            }
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        if (n > 0) {
            this.log.debug(new Object[]{"Found " + n + " records that didn't match SNP or INDEL"});
        }
        CloserUtil.close((Object)closeableIterator);
        CloserUtil.close((Object)vCFFileReader);
        variantContextWriter.close();
        variantContextWriter2.close();
        return 0;
    }
}

