/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import java.util.List;
import picard.vcf.filter.VariantFilter;

public class FisherStrandFilter
implements VariantFilter {
    private final double maxPhredScalePValue;

    public FisherStrandFilter(double d) {
        this.maxPhredScalePValue = d;
    }

    @Override
    public List<VCFFilterHeaderLine> headerLines() {
        return CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine("StrandBias", "Site exhibits excessive allele/strand correlation.")});
    }

    @Override
    public String filter(VariantContext variantContext) {
        double d = variantContext.getAttributeAsDouble("FS", 0.0);
        return d > this.maxPhredScalePValue ? "StrandBias" : null;
    }
}

