/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import htsjdk.samtools.util.IntervalList;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import picard.vcf.processor.VariantAccumulatorExecutor;
import picard.vcf.processor.VariantIteratorProducer;

public class VariantProcessor<RESULT, ACCUMULATOR extends Accumulator<RESULT>> {
    final ResultMerger<RESULT> merger;
    final VariantAccumulatorExecutor<ACCUMULATOR, RESULT> executor;

    VariantProcessor(ResultMerger<RESULT> resultMerger, VariantAccumulatorExecutor<ACCUMULATOR, RESULT> variantAccumulatorExecutor) {
        this.merger = resultMerger;
        this.executor = variantAccumulatorExecutor;
    }

    public RESULT process() {
        this.executor.start();
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        ArrayList arrayList = new ArrayList();
        for (Accumulator accumulator : this.executor.accumulators()) {
            arrayList.add(accumulator.result());
        }
        return this.merger.merge(arrayList);
    }

    public static class Builder<A extends Accumulator<R>, R> {
        final AccumulatorGenerator<A, R> accumulatorGenerator;
        ResultMerger<R> reducer = null;
        IntervalList intervals = null;
        final List<File> inputs = new ArrayList<File>();
        int threadCount = 1;

        Builder(AccumulatorGenerator<A, R> accumulatorGenerator) {
            this.accumulatorGenerator = accumulatorGenerator;
        }

        public Builder<A, R> multithreadingBy(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Multithreading value must exceed 0.");
            }
            this.threadCount = n;
            return this;
        }

        public Builder<A, R> withInput(File ... fileArray) {
            Collections.addAll(this.inputs, fileArray);
            return this;
        }

        public Builder<A, R> limitingProcessedRegionsTo(IntervalList intervalList) {
            if (this.intervals != null) {
                throw new IllegalStateException("Already provided an interval list.");
            }
            this.intervals = IntervalList.copyOf((IntervalList)intervalList);
            return this;
        }

        public Builder<A, R> combiningResultsBy(ResultMerger<R> resultMerger) {
            if (this.reducer != null) {
                throw new IllegalStateException("Already provided a reducer.");
            }
            this.reducer = resultMerger;
            return this;
        }

        public static <A extends Accumulator<R>, R> Builder<A, R> generatingAccumulatorsBy(AccumulatorGenerator<A, R> accumulatorGenerator) {
            return new Builder<A, R>(accumulatorGenerator);
        }

        public VariantProcessor<R, A> build() {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("You need to provided some inputs before building.");
            }
            if (this.reducer == null) {
                throw new IllegalStateException("You must provide a reducer before building.");
            }
            return new VariantProcessor<R, A>(this.reducer, new VariantAccumulatorExecutor.MultiThreadedChunkBased<A, R>(this.threadCount, this.composeVcfIteratorProducerFromBuilderArguments(), this.accumulatorGenerator));
        }

        private VariantIteratorProducer composeVcfIteratorProducerFromBuilderArguments() {
            VariantIteratorProducer variantIteratorProducer = this.intervals == null ? VariantIteratorProducer.byHundredMegabaseChunks(this.inputs) : VariantIteratorProducer.byHundredMegabaseChunksWithOnTheFlyFilteringByInterval(this.inputs, this.intervals);
            return variantIteratorProducer;
        }
    }

    public static interface ResultMerger<RESULT> {
        public RESULT merge(Collection<RESULT> var1);
    }

    public static interface AccumulatorGenerator<ACCUMULATOR extends Accumulator<RESULT>, RESULT> {
        public ACCUMULATOR build();
    }

    public static interface Accumulator<RESULT> {
        public void accumulate(VariantContext var1);

        public RESULT result();
    }
}

