/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.SecondaryAlignmentFilter;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractLocusIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.EdgeReadIterator;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.AbstractWgsMetricsCollector;
import picard.analysis.FastWgsMetricsCollector;
import picard.analysis.TheoreticalSensitivity;
import picard.analysis.TheoreticalSensitivityMetrics;
import picard.analysis.WgsMetrics;
import picard.analysis.WgsMetricsProcessorImpl;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.argumentcollections.IntervalArgumentCollection;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.filter.CountingAdapterFilter;
import picard.filter.CountingDuplicateFilter;
import picard.filter.CountingFilter;
import picard.filter.CountingMapQFilter;
import picard.filter.CountingPairedFilter;

@CommandLineProgramProperties(summary="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.<p>This tool collects metrics about the fractions of reads that pass base- and mapping-quality filters as well as coverage (read-depth) levels for WGS analyses. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.</p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetrics \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       R=reference_sequence.fasta </pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetrics.WgsMetrics'>CollectWgsMetrics</a> for detailed explanations of the output metrics.<hr />", oneLineSummary="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CollectWgsMetrics
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.";
    static final String USAGE_DETAILS = "<p>This tool collects metrics about the fractions of reads that pass base- and mapping-quality filters as well as coverage (read-depth) levels for WGS analyses. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.</p><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetrics \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       R=reference_sequence.fasta </pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetrics.WgsMetrics'>CollectWgsMetrics</a> for detailed explanations of the output metrics.<hr />";
    @Argument(shortName="I", doc="Input SAM/BAM/CRAM file.")
    public File INPUT;
    @Argument(shortName="O", doc="Output metrics file.")
    public File OUTPUT;
    @Argument(shortName="MQ", doc="Minimum mapping quality for a read to contribute coverage.")
    public int MINIMUM_MAPPING_QUALITY = 20;
    @Argument(shortName="Q", doc="Minimum base quality for a base to contribute coverage. N bases will be treated as having a base quality of negative infinity and will therefore be excluded from coverage regardless of the value of this parameter.")
    public int MINIMUM_BASE_QUALITY = 20;
    @Argument(shortName="CAP", doc="Treat positions with coverage exceeding this value as if they had coverage at this value (but calculate the difference for PCT_EXC_CAPPED).")
    public int COVERAGE_CAP = 250;
    @Argument(doc="At positions with coverage exceeding this value, completely ignore reads that accumulate beyond this value (so that they will not be considered for PCT_EXC_CAPPED).  Used to keep memory consumption in check, but could create bias if set too low")
    public int LOCUS_ACCUMULATION_CAP = 100000;
    @Argument(doc="For debugging purposes, stop after processing this many genomic bases.")
    public long STOP_AFTER = -1L;
    @Argument(doc="Determines whether to include the base quality histogram in the metrics file.")
    public boolean INCLUDE_BQ_HISTOGRAM = false;
    @Argument(doc="If true, count unpaired reads, and paired reads with one end unmapped")
    public boolean COUNT_UNPAIRED = false;
    @Argument(doc="Sample Size used for Theoretical Het Sensitivity sampling. Default is 10000.", optional=true)
    public int SAMPLE_SIZE = 10000;
    @ArgumentCollection
    protected IntervalArgumentCollection intervalArgumentCollection = this.makeIntervalArgumentCollection();
    @Argument(doc="Output for Theoretical Sensitivity metrics.", optional=true)
    public File THEORETICAL_SENSITIVITY_OUTPUT;
    @Argument(doc="Allele fraction for which to calculate theoretical sensitivity.", optional=true)
    public List<Double> ALLELE_FRACTION = new ArrayList<Double>(Arrays.asList(0.001, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.3, 0.5));
    @Argument(doc="If true, fast algorithm is used.")
    public boolean USE_FAST_ALGORITHM = false;
    @Argument(doc="Average read length in the file. Default is 150.", optional=true)
    public int READ_LENGTH = 150;
    protected File INTERVALS = null;
    private SAMFileHeader header = null;
    private final Log log = Log.getInstance(CollectWgsMetrics.class);

    @Override
    protected boolean requiresReference() {
        return true;
    }

    protected IntervalArgumentCollection makeIntervalArgumentCollection() {
        return new CollectWgsMetricsIntervalArgumentCollection();
    }

    protected SamReader getSamReader() {
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        this.header = in.getFileHeader();
        return in;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        this.INTERVALS = this.intervalArgumentCollection.getIntervalFile();
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
        }
        if (this.THEORETICAL_SENSITIVITY_OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.THEORETICAL_SENSITIVITY_OUTPUT);
        }
        if (this.LOCUS_ACCUMULATION_CAP < this.COVERAGE_CAP) {
            this.log.warn(new Object[]{"Setting the LOCUS_ACCUMULATION_CAP to be equal to the COVERAGE_CAP (" + this.COVERAGE_CAP + ") because it should not be lower"});
            this.LOCUS_ACCUMULATION_CAP = this.COVERAGE_CAP;
        }
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Processed", "loci");
        ReferenceSequenceFileWalker refWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        SamReader in = this.getSamReader();
        AbstractLocusIterator iterator = this.getLocusIterator(in);
        if (!this.header.getSequenceDictionary().isEmpty()) {
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.header.getSequenceDictionary(), (SAMSequenceDictionary)refWalker.getSequenceDictionary());
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        CountingAdapterFilter adapterFilter = new CountingAdapterFilter();
        CountingMapQFilter mapqFilter = new CountingMapQFilter(this.MINIMUM_MAPPING_QUALITY);
        CountingDuplicateFilter dupeFilter = new CountingDuplicateFilter();
        CountingPairedFilter pairFilter = new CountingPairedFilter();
        filters.add(new SecondaryAlignmentFilter());
        filters.add(adapterFilter);
        filters.add(mapqFilter);
        filters.add(dupeFilter);
        if (!this.COUNT_UNPAIRED) {
            filters.add(pairFilter);
        }
        iterator.setSamFilters(filters);
        iterator.setMappingQualityScoreCutoff(0);
        iterator.setIncludeNonPfReads(false);
        AbstractWgsMetricsCollector collector = this.getCollector(this.COVERAGE_CAP, this.getIntervalsToExamine());
        WgsMetricsProcessorImpl processor = this.getWgsMetricsProcessor(progress, refWalker, iterator, collector);
        processor.processFile();
        MetricsFile out = this.getMetricsFile();
        processor.addToMetricsFile(out, this.INCLUDE_BQ_HISTOGRAM, dupeFilter, adapterFilter, mapqFilter, pairFilter);
        out.write(this.OUTPUT);
        if (this.THEORETICAL_SENSITIVITY_OUTPUT != null) {
            MetricsFile theoreticalSensitivityMetrics = this.getMetricsFile();
            this.log.info(new Object[]{"Calculating theoretical sentitivity at " + this.ALLELE_FRACTION.size() + " allele fractions."});
            List<TheoreticalSensitivityMetrics> tsm = TheoreticalSensitivity.calculateSensitivities(this.SAMPLE_SIZE, collector.getUnfilteredDepthHistogram(), collector.getUnfilteredBaseQHistogram(), this.ALLELE_FRACTION);
            theoreticalSensitivityMetrics.addAllMetrics(tsm);
            theoreticalSensitivityMetrics.write(this.THEORETICAL_SENSITIVITY_OUTPUT);
        }
        return 0;
    }

    private <T extends AbstractRecordAndOffset> WgsMetricsProcessorImpl<T> getWgsMetricsProcessor(ProgressLogger progress, ReferenceSequenceFileWalker refWalker, AbstractLocusIterator<T, AbstractLocusInfo<T>> iterator, AbstractWgsMetricsCollector<T> collector) {
        return new WgsMetricsProcessorImpl<T>(iterator, refWalker, collector, progress);
    }

    protected IntervalList getIntervalsToExamine() {
        IntervalList intervals;
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
            intervals = IntervalList.fromFile((File)this.INTERVALS);
        } else {
            intervals = new IntervalList(this.header);
            for (SAMSequenceRecord rec : this.header.getSequenceDictionary().getSequences()) {
                Interval interval = new Interval(rec.getSequenceName(), 1, rec.getSequenceLength());
                intervals.add(interval);
            }
        }
        return intervals;
    }

    protected SAMFileHeader getSamFileHeader() {
        if (this.header == null) {
            throw new IllegalStateException("getSamFileHeader() was called but this.header is null");
        }
        return this.header;
    }

    protected WgsMetrics generateWgsMetrics(IntervalList intervals, Histogram<Integer> highQualityDepthHistogram, Histogram<Integer> unfilteredDepthHistogram, double pctExcludedByAdapter, double pctExcludedByMapq, double pctExcludedByDupes, double pctExcludedByPairing, double pctExcludedByBaseq, double pctExcludedByOverlap, double pctExcludedByCapping, double pctTotal, int coverageCap, Histogram<Integer> unfilteredBaseQHistogram, int theoreticalHetSensitivitySampleSize) {
        return new WgsMetrics(intervals, highQualityDepthHistogram, unfilteredDepthHistogram, pctExcludedByAdapter, pctExcludedByMapq, pctExcludedByDupes, pctExcludedByPairing, pctExcludedByBaseq, pctExcludedByOverlap, pctExcludedByCapping, pctTotal, coverageCap, unfilteredBaseQHistogram, theoreticalHetSensitivitySampleSize);
    }

    WgsMetrics generateWgsMetrics(IntervalList intervals, Histogram<Integer> highQualityDepthHistogram, Histogram<Integer> unfilteredDepthHistogram, long basesExcludedByAdapter, long basesExcludedByMapq, long basesExcludedByDupes, long basesExcludedByPairing, long basesExcludedByBaseq, long basesExcludedByOverlap, long basesExcludedByCapping, int coverageCap, Histogram<Integer> unfilteredBaseQHistogram, int theoreticalHetSensitivitySampleSize) {
        double total = highQualityDepthHistogram.getSum();
        double totalWithExcludes = total + (double)basesExcludedByDupes + (double)basesExcludedByAdapter + (double)basesExcludedByMapq + (double)basesExcludedByPairing + (double)basesExcludedByBaseq + (double)basesExcludedByOverlap + (double)basesExcludedByCapping;
        double pctExcludedByAdapter = totalWithExcludes == 0.0 ? 0.0 : (double)basesExcludedByAdapter / totalWithExcludes;
        double pctExcludedByMapq = totalWithExcludes == 0.0 ? 0.0 : (double)basesExcludedByMapq / totalWithExcludes;
        double pctExcludedByDupes = totalWithExcludes == 0.0 ? 0.0 : (double)basesExcludedByDupes / totalWithExcludes;
        double pctExcludedByPairing = totalWithExcludes == 0.0 ? 0.0 : (double)basesExcludedByPairing / totalWithExcludes;
        double pctExcludedByBaseq = totalWithExcludes == 0.0 ? 0.0 : (double)basesExcludedByBaseq / totalWithExcludes;
        double pctExcludedByOverlap = totalWithExcludes == 0.0 ? 0.0 : (double)basesExcludedByOverlap / totalWithExcludes;
        double pctExcludedByCapping = totalWithExcludes == 0.0 ? 0.0 : (double)basesExcludedByCapping / totalWithExcludes;
        double pctTotal = totalWithExcludes == 0.0 ? 0.0 : (totalWithExcludes - total) / totalWithExcludes;
        return this.generateWgsMetrics(intervals, highQualityDepthHistogram, unfilteredDepthHistogram, pctExcludedByAdapter, pctExcludedByMapq, pctExcludedByDupes, pctExcludedByPairing, pctExcludedByBaseq, pctExcludedByOverlap, pctExcludedByCapping, pctTotal, coverageCap, unfilteredBaseQHistogram, theoreticalHetSensitivitySampleSize);
    }

    protected long getBasesExcludedBy(CountingFilter filter) {
        return filter.getFilteredBases();
    }

    protected AbstractLocusIterator getLocusIterator(SamReader in) {
        if (this.USE_FAST_ALGORITHM) {
            return this.INTERVALS != null ? new EdgeReadIterator(in, IntervalList.fromFile((File)this.INTERVALS)) : new EdgeReadIterator(in);
        }
        SamLocusIterator iterator = this.INTERVALS != null ? new SamLocusIterator(in, IntervalList.fromFile((File)this.INTERVALS)) : new SamLocusIterator(in);
        iterator.setMaxReadsToAccumulatePerLocus(this.LOCUS_ACCUMULATION_CAP);
        iterator.setEmitUncoveredLoci(true);
        iterator.setQualityScoreCutoff(0);
        return iterator;
    }

    protected AbstractWgsMetricsCollector getCollector(int coverageCap, IntervalList intervals) {
        return this.USE_FAST_ALGORITHM ? new FastWgsMetricsCollector(this, coverageCap, intervals) : new WgsMetricsCollector(this, coverageCap, intervals);
    }

    public static class CollectWgsMetricsIntervalArgumentCollection
    implements IntervalArgumentCollection {
        @Argument(doc="An interval list file that contains the positions to restrict the assessment. Please note that all bases of reads that overlap these intervals will be considered, even if some of those bases extend beyond the boundaries of the interval. The ideal use case for this argument is to use it to restrict the calculation to a subset of (whole) contigs.", optional=true)
        public File INTERVALS;

        @Override
        public File getIntervalFile() {
            return this.INTERVALS;
        }
    }

    protected static class WgsMetricsCollector
    extends AbstractWgsMetricsCollector<SamLocusIterator.RecordAndOffset> {
        public WgsMetricsCollector(CollectWgsMetrics metrics, int coverageCap, IntervalList intervals) {
            super(metrics, coverageCap, intervals);
        }

        @Override
        public void addInfo(AbstractLocusInfo<SamLocusIterator.RecordAndOffset> info, ReferenceSequence ref, boolean referenceBaseN) {
            if (referenceBaseN) {
                return;
            }
            HashSet<String> readNames = new HashSet<String>(info.getRecordAndOffsets().size());
            int pileupSize = 0;
            int unfilteredDepth = 0;
            for (SamLocusIterator.RecordAndOffset recs : info.getRecordAndOffsets()) {
                if (recs.getBaseQuality() <= 2) {
                    ++this.basesExcludedByBaseq;
                    continue;
                }
                if (unfilteredDepth < this.coverageCap) {
                    byte by = recs.getRecord().getBaseQualities()[recs.getOffset()];
                    this.unfilteredBaseQHistogramArray[by] = this.unfilteredBaseQHistogramArray[by] + 1L;
                    ++unfilteredDepth;
                }
                if (recs.getBaseQuality() < this.collectWgsMetrics.MINIMUM_BASE_QUALITY || SequenceUtil.isNoCall((byte)recs.getReadBase())) {
                    ++this.basesExcludedByBaseq;
                    continue;
                }
                if (!readNames.add(recs.getRecord().getReadName())) {
                    ++this.basesExcludedByOverlap;
                    continue;
                }
                ++pileupSize;
            }
            int highQualityDepth = Math.min(pileupSize, this.coverageCap);
            if (highQualityDepth < pileupSize) {
                this.basesExcludedByCapping += (long)(pileupSize - this.coverageCap);
            }
            int n = highQualityDepth;
            this.highQualityDepthHistogramArray[n] = this.highQualityDepthHistogramArray[n] + 1L;
            int n2 = unfilteredDepth;
            this.unfilteredDepthHistogramArray[n2] = this.unfilteredDepthHistogramArray[n2] + 1L;
        }
    }
}

