/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.QualityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class HistogramGenerator {
    final boolean useOriginalQualities;
    int maxLengthSoFar = 0;
    double[] firstReadTotalsByCycle = new double[this.maxLengthSoFar];
    double[] firstReadTotalProbsByCycle = new double[this.maxLengthSoFar];
    long[] firstReadCountsByCycle = new long[this.maxLengthSoFar];
    double[] secondReadTotalsByCycle = new double[this.maxLengthSoFar];
    double[] secondReadTotalProbsByCycle = new double[this.maxLengthSoFar];
    long[] secondReadCountsByCycle = new long[this.maxLengthSoFar];
    int recordsCount = 0;
    public final int skipBases = 10;
    public final int minimalCount = 25;

    public HistogramGenerator(boolean useOriginalQualities) {
        this.useOriginalQualities = useOriginalQualities;
    }

    public HistogramGenerator(double[] firstReadTotalsByCycle, double[] firstReadTotalProbsByCycle, long[] firstReadCountsByCycle, double[] secondReadTotalsByCycle, double[] secondReadTotalProbsByCycle, long[] secondReadCountsByCycle, int nRecords) {
        this.firstReadCountsByCycle = (long[])firstReadCountsByCycle.clone();
        this.firstReadTotalsByCycle = (double[])firstReadTotalsByCycle.clone();
        this.firstReadTotalProbsByCycle = (double[])firstReadTotalProbsByCycle.clone();
        this.secondReadCountsByCycle = (long[])secondReadCountsByCycle.clone();
        this.secondReadTotalsByCycle = (double[])secondReadTotalsByCycle.clone();
        this.secondReadTotalProbsByCycle = (double[])secondReadTotalProbsByCycle.clone();
        this.useOriginalQualities = false;
        this.recordsCount = nRecords;
    }

    public void addRecord(SAMRecord rec) {
        byte[] quals;
        byte[] byArray = quals = this.useOriginalQualities ? rec.getOriginalBaseQualities() : rec.getBaseQualities();
        if (quals == null) {
            return;
        }
        ++this.recordsCount;
        int length = quals.length;
        boolean rc = rec.getReadNegativeStrandFlag();
        this.ensureArraysBigEnough(length + 1);
        for (int i = 0; i < length; ++i) {
            int cycle;
            int n = cycle = rc ? length - i : i + 1;
            if (rec.getReadPairedFlag() && rec.getSecondOfPairFlag()) {
                int n2 = cycle;
                this.secondReadTotalsByCycle[n2] = this.secondReadTotalsByCycle[n2] + (double)quals[i];
                int n3 = cycle;
                this.secondReadTotalProbsByCycle[n3] = this.secondReadTotalProbsByCycle[n3] + QualityUtil.getErrorProbabilityFromPhredScore((int)quals[i]);
                int n4 = cycle;
                this.secondReadCountsByCycle[n4] = this.secondReadCountsByCycle[n4] + 1L;
                continue;
            }
            int n5 = cycle;
            this.firstReadTotalsByCycle[n5] = this.firstReadTotalsByCycle[n5] + (double)quals[i];
            int n6 = cycle;
            this.firstReadTotalProbsByCycle[n6] = this.firstReadTotalProbsByCycle[n6] + QualityUtil.getErrorProbabilityFromPhredScore((int)quals[i]);
            int n7 = cycle;
            this.firstReadCountsByCycle[n7] = this.firstReadCountsByCycle[n7] + 1L;
        }
    }

    public void addOtherHistogramGenerator(HistogramGenerator other) {
        if (other != null) {
            this.ensureArraysBigEnough(other.maxLengthSoFar);
            for (int i = 0; i < this.maxLengthSoFar; ++i) {
                int n = i;
                this.firstReadCountsByCycle[n] = this.firstReadCountsByCycle[n] + other.firstReadCountsByCycle[i];
                int n2 = i;
                this.secondReadCountsByCycle[n2] = this.secondReadCountsByCycle[n2] + other.secondReadCountsByCycle[i];
                int n3 = i;
                this.firstReadTotalsByCycle[n3] = this.firstReadTotalsByCycle[n3] + other.firstReadTotalsByCycle[i];
                int n4 = i;
                this.secondReadTotalsByCycle[n4] = this.secondReadTotalsByCycle[n4] + other.secondReadTotalsByCycle[i];
                int n5 = i;
                this.firstReadTotalProbsByCycle[n5] = this.firstReadTotalProbsByCycle[n5] + other.firstReadTotalProbsByCycle[i];
                int n6 = i;
                this.secondReadTotalProbsByCycle[n6] = this.secondReadTotalProbsByCycle[n6] + other.secondReadTotalProbsByCycle[i];
            }
            this.recordsCount += other.recordsCount;
        }
    }

    public int calculateLQ(int threshold, int readInPair, int spanningWindowLength) {
        long[] counts;
        double[] accumulator;
        double errorProbThreshold = QualityUtil.getErrorProbabilityFromPhredScore((int)threshold);
        ArrayList<Double> result = new ArrayList<Double>();
        ArrayList<Long> weights = new ArrayList<Long>();
        if (readInPair == 1) {
            accumulator = this.firstReadTotalProbsByCycle;
            counts = this.firstReadCountsByCycle;
        } else {
            accumulator = this.secondReadTotalProbsByCycle;
            counts = this.secondReadCountsByCycle;
        }
        for (int i = 10; i < accumulator.length && counts[i] >= 25L; ++i) {
            result.add(accumulator[i] / (double)counts[i]);
            weights.add(counts[i]);
        }
        this.applySpanningWindowMean(result, weights, spanningWindowLength);
        return this.longestHighQuality(result, errorProbThreshold);
    }

    private void applySpanningWindowMean(List<Double> vector, List<Long> weights, int spanLength) {
        ArrayList<Double> tmp = new ArrayList<Double>(vector);
        for (int i = 0; i < vector.size(); ++i) {
            double tmpEr = 0.0;
            long tmpWeight = 0L;
            for (int j = Math.max(i - spanLength, 0); j < Math.min(i + spanLength + 1, vector.size()); ++j) {
                tmpEr += (Double)tmp.get(j) * (double)weights.get(j).longValue();
                tmpWeight += weights.get(j).longValue();
            }
            vector.set(i, tmpEr / (double)tmpWeight);
        }
    }

    private int longestHighQuality(List<Double> averageErrorProbabilities, double errorProbThreshold) {
        int curStart = 0;
        int curEnd = 0;
        int curBestIntervalLength = 0;
        while (curEnd < averageErrorProbabilities.size()) {
            if (averageErrorProbabilities.get(curEnd) <= errorProbThreshold) {
                ++curEnd;
                continue;
            }
            if (curEnd - curStart > curBestIntervalLength) {
                curBestIntervalLength = curEnd - curStart;
            }
            curEnd = curStart = curEnd + 1;
        }
        if (curEnd - curStart > curBestIntervalLength) {
            curBestIntervalLength = curEnd - curStart;
        }
        return curBestIntervalLength;
    }

    boolean isEmpty() {
        return this.maxLengthSoFar == 0;
    }

    private void ensureArraysBigEnough(int length) {
        if (length > this.maxLengthSoFar) {
            this.firstReadTotalsByCycle = Arrays.copyOf(this.firstReadTotalsByCycle, length);
            this.firstReadTotalProbsByCycle = Arrays.copyOf(this.firstReadTotalProbsByCycle, length);
            this.firstReadCountsByCycle = Arrays.copyOf(this.firstReadCountsByCycle, length);
            this.secondReadTotalsByCycle = Arrays.copyOf(this.secondReadTotalsByCycle, length);
            this.secondReadTotalProbsByCycle = Arrays.copyOf(this.secondReadTotalProbsByCycle, length);
            this.secondReadCountsByCycle = Arrays.copyOf(this.secondReadCountsByCycle, length);
            this.maxLengthSoFar = length;
        }
    }

    Histogram<Integer> getMeanQualityHistogram() {
        String label = this.useOriginalQualities ? "MEAN_ORIGINAL_QUALITY" : "MEAN_QUALITY";
        Histogram meanQualities = new Histogram("CYCLE", label);
        int firstReadLength = 0;
        for (int cycle = 0; cycle < this.firstReadTotalsByCycle.length; ++cycle) {
            if (!(this.firstReadTotalsByCycle[cycle] > 0.0)) continue;
            meanQualities.increment((Comparable)Integer.valueOf(cycle), this.firstReadTotalsByCycle[cycle] / (double)this.firstReadCountsByCycle[cycle]);
            firstReadLength = cycle;
        }
        for (int i = 0; i < this.secondReadTotalsByCycle.length; ++i) {
            if (this.secondReadCountsByCycle[i] <= 0L) continue;
            int cycle = firstReadLength + i;
            meanQualities.increment((Comparable)Integer.valueOf(cycle), this.secondReadTotalsByCycle[i] / (double)this.secondReadCountsByCycle[i]);
        }
        return meanQualities;
    }

    Histogram<Integer> getMeanErrorProbHistogram() {
        String label = this.useOriginalQualities ? "MEAN_ORIGINAL_ERROR_PROB" : "MEAN_ERROR_PROB";
        Histogram meanQualities = new Histogram("CYCLE", label);
        int firstReadLength = 0;
        for (int cycle = 0; cycle < this.firstReadTotalsByCycle.length; ++cycle) {
            if (!(this.firstReadTotalsByCycle[cycle] > 0.0)) continue;
            meanQualities.increment((Comparable)Integer.valueOf(cycle), this.firstReadTotalProbsByCycle[cycle] / (double)this.firstReadCountsByCycle[cycle]);
            firstReadLength = cycle;
        }
        for (int i = 0; i < this.secondReadTotalsByCycle.length; ++i) {
            if (this.secondReadCountsByCycle[i] <= 0L) continue;
            int cycle = firstReadLength + i;
            meanQualities.increment((Comparable)Integer.valueOf(cycle), this.secondReadTotalProbsByCycle[i] / (double)this.secondReadCountsByCycle[i]);
        }
        return meanQualities;
    }
}

