/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.HistogramGenerator;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.util.RExecutor;

@CommandLineProgramProperties(summary="Collect mean quality by cycle.This tool generates a data table and chart of mean quality by cycle from a BAM file. It is intended to be used on a single lane or a read group's worth of data, but can be applied to merged BAMs if needed. <br /><br />This metric gives an overall snapshot of sequencing machine performance. For most types of sequencing data, the output is expected to show a slight reduction in overall base quality scores towards the end of each read. Spikes in quality within reads are not expected and may indicate that technical problems occurred during sequencing.<br /><br /><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>java -jar picard.jar MeanQualityByCycle \\<br />      I=input.bam \\<br />      O=mean_qual_by_cycle.txt \\<br />      CHART=mean_qual_by_cycle.pdf</pre><hr />", oneLineSummary="Collect mean quality by cycle.", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class MeanQualityByCycle
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Collect mean quality by cycle.";
    static final String USAGE_DETAILS = "This tool generates a data table and chart of mean quality by cycle from a BAM file. It is intended to be used on a single lane or a read group's worth of data, but can be applied to merged BAMs if needed. <br /><br />This metric gives an overall snapshot of sequencing machine performance. For most types of sequencing data, the output is expected to show a slight reduction in overall base quality scores towards the end of each read. Spikes in quality within reads are not expected and may indicate that technical problems occurred during sequencing.<br /><br /><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage example:</h4><pre>java -jar picard.jar MeanQualityByCycle \\<br />      I=input.bam \\<br />      O=mean_qual_by_cycle.txt \\<br />      CHART=mean_qual_by_cycle.pdf</pre><hr />";
    @Argument(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Argument(doc="If set to true, calculate mean quality over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Argument(doc="If set to true calculate mean quality over PF reads only.")
    public boolean PF_READS_ONLY = false;
    private final HistogramGenerator q = new HistogramGenerator(false);
    private final HistogramGenerator oq = new HistogramGenerator(true);
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(MeanQualityByCycle.class);

    @Override
    protected String[] customCommandLineValidation() {
        if (!MeanQualityByCycle.checkRInstallation(this.CHART_OUTPUT != null)) {
            return new String[]{"R is not installed on this machine. It is required for creating the chart."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        List readGroups = header.getReadGroups();
        if (readGroups.size() == 1) {
            this.plotSubtitle = StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)readGroups.get(0)).getLibrary());
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.isSecondaryOrSupplementary()) {
            return;
        }
        this.q.addRecord(rec);
        this.oq.addRecord(rec);
    }

    @Override
    protected void finish() {
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(this.q.getMeanQualityHistogram());
        if (!this.oq.isEmpty()) {
            metrics.addHistogram(this.oq.getMeanQualityHistogram());
        }
        metrics.write(this.OUTPUT);
        if (this.q.isEmpty() && this.oq.isEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int rResult = RExecutor.executeFromClasspath("picard/analysis/meanQualityByCycle.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath().replaceAll("%", "%%"), this.INPUT.getName(), this.plotSubtitle);
            if (rResult != 0) {
                throw new PicardException("R script meanQualityByCycle.R failed with return code " + rResult);
            }
        }
    }
}

