/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.QualityUtil;
import java.util.Collection;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.MergeableMetricBase;
import picard.analysis.TheoreticalSensitivity;
import picard.util.MathUtil;

@DocumentedFeature(groupName="Metrics", summary="Metrics")
public class WgsMetrics
extends MergeableMetricBase {
    private static final double LOG_ODDS_THRESHOLD = 3.0;
    @MergeableMetricBase.MergingIsManual
    protected IntervalList intervals;
    @MergeableMetricBase.MergingIsManual
    protected final Histogram<Integer> highQualityDepthHistogram;
    @MergeableMetricBase.MergingIsManual
    protected final Histogram<Integer> unfilteredDepthHistogram;
    @MergeableMetricBase.MergingIsManual
    protected final Histogram<Integer> unfilteredBaseQHistogram;
    @MergeableMetricBase.MergeByAssertEquals
    protected final int coverageCap;
    @MergeableMetricBase.NoMergingKeepsValue
    protected final int theoreticalHetSensitivitySampleSize;
    @MergeableMetricBase.NoMergingIsDerived
    public long GENOME_TERRITORY;
    @MergeableMetricBase.NoMergingIsDerived
    public double MEAN_COVERAGE;
    @MergeableMetricBase.NoMergingIsDerived
    public double SD_COVERAGE;
    @MergeableMetricBase.NoMergingIsDerived
    public double MEDIAN_COVERAGE;
    @MergeableMetricBase.NoMergingIsDerived
    public double MAD_COVERAGE;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_ADAPTER;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_MAPQ;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_DUPE;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_UNPAIRED;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_BASEQ;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_OVERLAP;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_CAPPED;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_EXC_TOTAL;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_1X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_5X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_10X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_15X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_20X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_25X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_30X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_40X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_50X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_60X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_70X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_80X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_90X;
    @MergeableMetricBase.NoMergingIsDerived
    public double PCT_100X;
    @MergeableMetricBase.NoMergingIsDerived
    public double FOLD_80_BASE_PENALTY;
    @MergeableMetricBase.NoMergingIsDerived
    public double FOLD_90_BASE_PENALTY;
    @MergeableMetricBase.NoMergingIsDerived
    public double FOLD_95_BASE_PENALTY;
    @MergeableMetricBase.NoMergingIsDerived
    public double HET_SNP_SENSITIVITY;
    @MergeableMetricBase.NoMergingIsDerived
    public double HET_SNP_Q;

    public WgsMetrics() {
        this.intervals = null;
        this.highQualityDepthHistogram = null;
        this.unfilteredDepthHistogram = null;
        this.unfilteredBaseQHistogram = null;
        this.theoreticalHetSensitivitySampleSize = -1;
        this.coverageCap = -1;
    }

    public WgsMetrics(IntervalList intervals, Histogram<Integer> highQualityDepthHistogram, Histogram<Integer> unfilteredDepthHistogram, double pctExcludedByAdapter, double pctExcludedByMapq, double pctExcludedByDupes, double pctExcludedByPairing, double pctExcludedByBaseq, double pctExcludedByOverlap, double pctExcludedByCapping, double pctExcludeTotal, int coverageCap, Histogram<Integer> unfilteredBaseQHistogram, int theoreticalHetSensitivitySampleSize) {
        this.intervals = intervals.uniqued();
        this.highQualityDepthHistogram = highQualityDepthHistogram;
        this.unfilteredDepthHistogram = unfilteredDepthHistogram;
        this.unfilteredBaseQHistogram = unfilteredBaseQHistogram;
        this.coverageCap = coverageCap;
        this.theoreticalHetSensitivitySampleSize = theoreticalHetSensitivitySampleSize;
        this.PCT_EXC_ADAPTER = pctExcludedByAdapter;
        this.PCT_EXC_MAPQ = pctExcludedByMapq;
        this.PCT_EXC_DUPE = pctExcludedByDupes;
        this.PCT_EXC_UNPAIRED = pctExcludedByPairing;
        this.PCT_EXC_BASEQ = pctExcludedByBaseq;
        this.PCT_EXC_OVERLAP = pctExcludedByOverlap;
        this.PCT_EXC_CAPPED = pctExcludedByCapping;
        this.PCT_EXC_TOTAL = pctExcludeTotal;
        this.calculateDerivedFields();
    }

    @Override
    public MergeableMetricBase merge(MergeableMetricBase other) {
        WgsMetrics otherMetric = (WgsMetrics)other;
        if (this.highQualityDepthHistogram == null || otherMetric.highQualityDepthHistogram == null || this.unfilteredDepthHistogram == null || otherMetric.unfilteredDepthHistogram == null) {
            throw new PicardException("Depth histogram is required when deriving metrics.");
        }
        long genomeTerritory = this.intervals.getBaseCount() + otherMetric.intervals.getBaseCount();
        this.intervals.addall((Collection)otherMetric.intervals.getIntervals());
        this.intervals = this.intervals.uniqued();
        if (this.intervals.getBaseCount() != genomeTerritory) {
            throw new PicardException("Trying to merge WgsMetrics calculated on intervals that overlap.");
        }
        long thisMetricTotal = (long)this.highQualityDepthHistogram.getSum();
        long otherMetricTotal = (long)otherMetric.highQualityDepthHistogram.getSum();
        long total = thisMetricTotal + otherMetricTotal;
        long thisTotalWithExcludes = (long)((double)thisMetricTotal / (1.0 - this.PCT_EXC_TOTAL));
        long otherTotalWithExcludes = (long)((double)otherMetricTotal / (1.0 - otherMetric.PCT_EXC_TOTAL));
        double totalWithExcludes = thisTotalWithExcludes + otherTotalWithExcludes;
        if (0.0 < totalWithExcludes) {
            this.PCT_EXC_DUPE = (this.PCT_EXC_DUPE * (double)thisTotalWithExcludes + otherMetric.PCT_EXC_DUPE * (double)otherTotalWithExcludes) / totalWithExcludes;
            this.PCT_EXC_ADAPTER = (this.PCT_EXC_ADAPTER * (double)thisTotalWithExcludes + otherMetric.PCT_EXC_ADAPTER * (double)otherTotalWithExcludes) / totalWithExcludes;
            this.PCT_EXC_MAPQ = (this.PCT_EXC_MAPQ * (double)thisTotalWithExcludes + otherMetric.PCT_EXC_MAPQ * (double)otherTotalWithExcludes) / totalWithExcludes;
            this.PCT_EXC_UNPAIRED = (this.PCT_EXC_UNPAIRED * (double)thisTotalWithExcludes + otherMetric.PCT_EXC_UNPAIRED * (double)otherTotalWithExcludes) / totalWithExcludes;
            this.PCT_EXC_BASEQ = (this.PCT_EXC_BASEQ * (double)thisTotalWithExcludes + otherMetric.PCT_EXC_BASEQ * (double)otherTotalWithExcludes) / totalWithExcludes;
            this.PCT_EXC_OVERLAP = (this.PCT_EXC_OVERLAP * (double)thisTotalWithExcludes + otherMetric.PCT_EXC_OVERLAP * (double)otherTotalWithExcludes) / totalWithExcludes;
            this.PCT_EXC_CAPPED = (this.PCT_EXC_CAPPED * (double)thisTotalWithExcludes + otherMetric.PCT_EXC_CAPPED * (double)otherTotalWithExcludes) / totalWithExcludes;
            this.PCT_EXC_TOTAL = (totalWithExcludes - (double)total) / totalWithExcludes;
        }
        super.merge(other);
        this.highQualityDepthHistogram.addHistogram(otherMetric.highQualityDepthHistogram);
        this.unfilteredDepthHistogram.addHistogram(otherMetric.unfilteredDepthHistogram);
        if (this.unfilteredBaseQHistogram != null && otherMetric.unfilteredBaseQHistogram != null) {
            this.unfilteredBaseQHistogram.addHistogram(otherMetric.unfilteredBaseQHistogram);
        }
        return this;
    }

    @Override
    public void calculateDerivedFields() {
        if (this.highQualityDepthHistogram == null || this.unfilteredDepthHistogram == null) {
            throw new PicardException("Depth histogram is required when deriving metrics.");
        }
        if (this.unfilteredBaseQHistogram != null && this.theoreticalHetSensitivitySampleSize <= 0) {
            throw new PicardException("Sample size is required when a baseQ histogram is given when deriving metrics.");
        }
        long[] depthHistogramArray = new long[this.coverageCap + 1];
        for (Histogram.Bin bin : this.highQualityDepthHistogram.values()) {
            int depth;
            int n = depth = Math.min((int)bin.getIdValue(), this.coverageCap);
            depthHistogramArray[n] = (long)((double)depthHistogramArray[n] + bin.getValue());
        }
        this.GENOME_TERRITORY = (long)this.highQualityDepthHistogram.getSumOfValues();
        this.MEAN_COVERAGE = this.highQualityDepthHistogram.getMean();
        this.SD_COVERAGE = this.highQualityDepthHistogram.getStandardDeviation();
        this.MEDIAN_COVERAGE = this.highQualityDepthHistogram.getMedian();
        this.MAD_COVERAGE = this.highQualityDepthHistogram.getMedianAbsoluteDeviation();
        this.PCT_1X = (double)MathUtil.sum(depthHistogramArray, 1, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_5X = (double)MathUtil.sum(depthHistogramArray, 5, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_10X = (double)MathUtil.sum(depthHistogramArray, 10, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_15X = (double)MathUtil.sum(depthHistogramArray, 15, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_20X = (double)MathUtil.sum(depthHistogramArray, 20, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_25X = (double)MathUtil.sum(depthHistogramArray, 25, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_30X = (double)MathUtil.sum(depthHistogramArray, 30, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_40X = (double)MathUtil.sum(depthHistogramArray, 40, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_50X = (double)MathUtil.sum(depthHistogramArray, 50, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_60X = (double)MathUtil.sum(depthHistogramArray, 60, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_70X = (double)MathUtil.sum(depthHistogramArray, 70, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_80X = (double)MathUtil.sum(depthHistogramArray, 80, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_90X = (double)MathUtil.sum(depthHistogramArray, 90, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        this.PCT_100X = (double)MathUtil.sum(depthHistogramArray, 100, depthHistogramArray.length) / (double)this.GENOME_TERRITORY;
        if (this.highQualityDepthHistogram.getCount() > 0.0) {
            this.FOLD_80_BASE_PENALTY = this.MEAN_COVERAGE / this.highQualityDepthHistogram.getPercentile(0.2);
            this.FOLD_90_BASE_PENALTY = this.MEAN_COVERAGE / this.highQualityDepthHistogram.getPercentile(0.1);
            this.FOLD_95_BASE_PENALTY = this.MEAN_COVERAGE / this.highQualityDepthHistogram.getPercentile(0.05);
        } else {
            this.FOLD_80_BASE_PENALTY = 0.0;
            this.FOLD_90_BASE_PENALTY = 0.0;
            this.FOLD_95_BASE_PENALTY = 0.0;
        }
        if (this.unfilteredBaseQHistogram != null && this.unfilteredDepthHistogram != null) {
            double[] depthDoubleArray = TheoreticalSensitivity.normalizeHistogram(this.unfilteredDepthHistogram);
            double[] baseQDoubleArray = TheoreticalSensitivity.normalizeHistogram(this.unfilteredBaseQHistogram);
            this.HET_SNP_SENSITIVITY = TheoreticalSensitivity.hetSNPSensitivity(depthDoubleArray, baseQDoubleArray, this.theoreticalHetSensitivitySampleSize, 3.0);
            this.HET_SNP_Q = QualityUtil.getPhredScoreFromErrorProbability((double)(1.0 - this.HET_SNP_SENSITIVITY));
        }
    }
}

