/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.QualityUtil;
import org.broadinstitute.barclay.help.DocumentedFeature;

public class SequencingArtifactMetrics {
    public static final String PRE_ADAPTER_SUMMARY_EXT = ".pre_adapter_summary_metrics";
    public static final String PRE_ADAPTER_DETAILS_EXT = ".pre_adapter_detail_metrics";
    public static final String BAIT_BIAS_SUMMARY_EXT = ".bait_bias_summary_metrics";
    public static final String BAIT_BIAS_DETAILS_EXT = ".bait_bias_detail_metrics";
    public static final String ERROR_SUMMARY_EXT = ".error_summary_metrics";
    private static final double MIN_ERROR = 1.0E-10;

    static class SummaryPair {
        final PreAdapterSummaryMetrics preAdapterMetrics;
        final BaitBiasSummaryMetrics baitBiasMetrics;

        SummaryPair(PreAdapterSummaryMetrics preAdapterMetrics, BaitBiasSummaryMetrics baitBiasMetrics) {
            this.preAdapterMetrics = preAdapterMetrics;
            this.baitBiasMetrics = baitBiasMetrics;
        }
    }

    static class DetailPair {
        final PreAdapterDetailMetrics preAdapterMetrics;
        final BaitBiasDetailMetrics baitBiasMetrics;

        DetailPair(PreAdapterDetailMetrics preAdapterMetrics, BaitBiasDetailMetrics baitBiasMetrics) {
            this.preAdapterMetrics = preAdapterMetrics;
            this.baitBiasMetrics = baitBiasMetrics;
        }
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class BaitBiasDetailMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public String CONTEXT;
        public long FWD_CXT_REF_BASES;
        public long FWD_CXT_ALT_BASES;
        public long REV_CXT_REF_BASES;
        public long REV_CXT_ALT_BASES;
        public double FWD_ERROR_RATE;
        public double REV_ERROR_RATE;
        public double ERROR_RATE;
        public double QSCORE;

        public void calculateDerivedStatistics() {
            this.FWD_ERROR_RATE = 1.0E-10;
            long fwdBases = this.FWD_CXT_REF_BASES + this.FWD_CXT_ALT_BASES;
            if (fwdBases > 0L) {
                double fwdErr = (double)this.FWD_CXT_ALT_BASES / (double)fwdBases;
                this.FWD_ERROR_RATE = Math.max(1.0E-10, fwdErr);
            }
            this.REV_ERROR_RATE = 1.0E-10;
            long revBases = this.REV_CXT_REF_BASES + this.REV_CXT_ALT_BASES;
            if (revBases > 0L) {
                double revErr = (double)this.REV_CXT_ALT_BASES / (double)revBases;
                this.REV_ERROR_RATE = Math.max(1.0E-10, revErr);
            }
            this.ERROR_RATE = Math.max(1.0E-10, this.FWD_ERROR_RATE - this.REV_ERROR_RATE);
            this.QSCORE = QualityUtil.getPhredScoreFromErrorProbability((double)this.ERROR_RATE);
        }

        public int compareTo(BaitBiasDetailMetrics o) {
            int retval = Double.compare(this.QSCORE, o.QSCORE);
            if (retval != 0) {
                return retval;
            }
            retval = this.REF_BASE - o.REF_BASE;
            if (retval != 0) {
                return retval;
            }
            retval = this.ALT_BASE - o.ALT_BASE;
            if (retval != 0) {
                return retval;
            }
            retval = this.CONTEXT.compareTo(o.CONTEXT);
            return retval;
        }
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class PreAdapterDetailMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public String CONTEXT;
        public long PRO_REF_BASES;
        public long PRO_ALT_BASES;
        public long CON_REF_BASES;
        public long CON_ALT_BASES;
        public double ERROR_RATE;
        public double QSCORE;

        public void calculateDerivedStatistics() {
            this.ERROR_RATE = 1.0E-10;
            long totalBases = this.PRO_REF_BASES + this.PRO_ALT_BASES + this.CON_REF_BASES + this.CON_ALT_BASES;
            if (totalBases > 0L) {
                double rawErrorRate = (double)(this.PRO_ALT_BASES - this.CON_ALT_BASES) / (double)totalBases;
                this.ERROR_RATE = Math.max(1.0E-10, rawErrorRate);
            }
            this.QSCORE = QualityUtil.getPhredScoreFromErrorProbability((double)this.ERROR_RATE);
        }

        public int compareTo(PreAdapterDetailMetrics o) {
            int retval = Double.compare(this.QSCORE, o.QSCORE);
            if (retval != 0) {
                return retval;
            }
            retval = this.REF_BASE - o.REF_BASE;
            if (retval != 0) {
                return retval;
            }
            retval = this.ALT_BASE - o.ALT_BASE;
            if (retval != 0) {
                return retval;
            }
            retval = this.CONTEXT.compareTo(o.CONTEXT);
            return retval;
        }
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class BaitBiasSummaryMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public double TOTAL_QSCORE;
        public String WORST_CXT;
        public double WORST_CXT_QSCORE;
        public String WORST_PRE_CXT;
        public double WORST_PRE_CXT_QSCORE;
        public String WORST_POST_CXT;
        public double WORST_POST_CXT_QSCORE;
        public String ARTIFACT_NAME;

        public void inferArtifactName() {
            this.ARTIFACT_NAME = this.REF_BASE == 'G' && this.ALT_BASE == 'T' ? "Gref" : (this.REF_BASE == 'C' && this.ALT_BASE == 'A' ? "Cref" : "NA");
        }
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class PreAdapterSummaryMetrics
    extends MetricBase {
        public String SAMPLE_ALIAS;
        public String LIBRARY;
        public char REF_BASE;
        public char ALT_BASE;
        public double TOTAL_QSCORE;
        public String WORST_CXT;
        public double WORST_CXT_QSCORE;
        public String WORST_PRE_CXT;
        public double WORST_PRE_CXT_QSCORE;
        public String WORST_POST_CXT;
        public double WORST_POST_CXT_QSCORE;
        public String ARTIFACT_NAME;

        public void inferArtifactName() {
            this.ARTIFACT_NAME = this.REF_BASE == 'G' && this.ALT_BASE == 'T' ? "OxoG" : (this.REF_BASE == 'C' && this.ALT_BASE == 'T' ? "Deamination" : "NA");
        }
    }
}

