/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.replicates;

import htsjdk.samtools.DuplicateSetIterator;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.AggregateFilter;
import htsjdk.samtools.filter.AlignedFilter;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.MappingQualityFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SecondaryOrSupplementaryFilter;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.ComparableTuple;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.utils.ValidationUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.filter.CompoundFilter;
import htsjdk.variant.variantcontext.filter.FilteringVariantContextIterator;
import htsjdk.variant.variantcontext.filter.GenotypeQualityFilter;
import htsjdk.variant.variantcontext.filter.HeterozygosityFilter;
import htsjdk.variant.variantcontext.filter.PassingVariantFilter;
import htsjdk.variant.variantcontext.filter.SnpFilter;
import htsjdk.variant.variantcontext.filter.VariantContextFilter;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.replicates.IndependentReplicateMetric;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.filter.CountingPairedFilter;

@DocumentedFeature
@ExperimentalFeature
@CommandLineProgramProperties(summary="Estimates the rate of independent replication rate of reads within a bam. \n<p>This tool estimates the fraction of the input reads which would be marked as duplicates but are actually biological replicates, independent observations of the data. <p>The tools examines duplicate sets of size 2 and 3 that overlap known heterozygous sites of the sample. The tool classifies these duplicate sets into heterogeneous and homogeneous sets (those that contain the two alleles that are present in the variant and those that only contain one of them). From this the toolestimates the fraction of duplicates that arose from different original molecules, i.e. independently. <p><h4>Usage example:</h4><pre>java -jar picard.jar CollectIndependentReplicateMetrics \\\n    I=input.bam \\\n    V=input.vcf \\\n    O=output.independent_replicates_metrics \\\n</pre> ", oneLineSummary="Estimates the rate of independent replication rate of reads within a bam. \n", programGroup=DiagnosticsAndQCProgramGroup.class)
public class CollectIndependentReplicateMetrics
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Estimates the rate of independent replication rate of reads within a bam. \n";
    static final String USAGE_DETAILS = "<p>This tool estimates the fraction of the input reads which would be marked as duplicates but are actually biological replicates, independent observations of the data. <p>The tools examines duplicate sets of size 2 and 3 that overlap known heterozygous sites of the sample. The tool classifies these duplicate sets into heterogeneous and homogeneous sets (those that contain the two alleles that are present in the variant and those that only contain one of them). From this the toolestimates the fraction of duplicates that arose from different original molecules, i.e. independently. <p><h4>Usage example:</h4><pre>java -jar picard.jar CollectIndependentReplicateMetrics \\\n    I=input.bam \\\n    V=input.vcf \\\n    O=output.independent_replicates_metrics \\\n</pre> ";
    private static final int DOUBLETON_SIZE = 2;
    private static final int TRIPLETON_SIZE = 3;
    @Argument(shortName="I", doc="Input (indexed) BAM/CRAM file.")
    public File INPUT;
    @Argument(shortName="O", doc="Write metrics to this file")
    public File OUTPUT;
    @Argument(shortName="MO", doc="Write the confusion matrix (of UMIs) to this file", optional=true)
    public File MATRIX_OUTPUT;
    @Argument(shortName="V", doc="Input VCF file")
    public File VCF;
    @Argument(shortName="GQ", doc="minimal value for the GQ field in the VCF to use variant site.", optional=true)
    public Integer MINIMUM_GQ = 90;
    @Argument(shortName="MQ", doc="minimal value for the mapping quality of the reads to be used in the estimation.", optional=true)
    public Integer MINIMUM_MQ = 40;
    @Argument(shortName="BQ", doc="minimal value for the base quality of a base to be used in the estimation.", optional=true)
    public Integer MINIMUM_BQ = 17;
    @Argument(shortName="ALIAS", doc="Name of sample to look at in VCF. Can be omitted if VCF contains only one sample.", optional=true)
    public String SAMPLE = null;
    @Argument(doc="Number of sets to examine before stopping.", optional=true)
    public Integer STOP_AFTER = 0;
    @Argument(doc="Barcode SAM tag.", optional=true)
    public String BARCODE_TAG = "RX";
    @Argument(doc="Barcode Quality SAM tag.", optional=true)
    public String BARCODE_BQ = "QX";
    @Argument(shortName="MBQ", doc="minimal value for the base quality of all the bases in a molecular barcode, for it to be used.", optional=true)
    public Integer MINIMUM_BARCODE_BQ = 30;
    @Argument(shortName="FUR", doc="Whether to filter unpaired reads from the input.", optional=true)
    public boolean FILTER_UNPAIRED_READS = true;
    @Argument(fullName="PROGRESS_STEP_INTERVAL", doc="The interval between which progress will be displayed.", optional=true)
    public int PROGRESS_STEP_INTERVAL = 100000;
    private static final Log log = Log.getInstance(CollectIndependentReplicateMetrics.class);

    @Override
    protected int doWork() {
        Object set;
        IOUtil.assertFileIsReadable((File)this.VCF);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        if (!in.hasIndex()) {
            throw new PicardException("INPUT file must have an index.");
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.MATRIX_OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.MATRIX_OUTPUT);
        }
        VCFFileReader vcf = new VCFFileReader(this.VCF, false);
        VCFHeader vcfFileHeader = vcf.getFileHeader();
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)in.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)vcfFileHeader.getSequenceDictionary());
        ArrayList samples = vcfFileHeader.getSampleNamesInOrder();
        if (this.SAMPLE == null) {
            if (samples.size() != 1) {
                throw new IllegalArgumentException("When sample is null, VCF must have exactly 1 sample. found " + samples.size());
            }
            this.SAMPLE = (String)samples.get(0);
            log.info(new Object[]{"No SAMPLE given, using sample from VCF: ", this.SAMPLE});
        } else if (!samples.contains(this.SAMPLE)) {
            throw new IllegalArgumentException("When sample is not null, VCF must contain supplied sample. Cannot find sample " + this.SAMPLE + " in vcf.");
        }
        Histogram umiConfusionMatrix = new Histogram("ConfusionUMI", "Count");
        Histogram umiConfusionMatrixEditDistance = new Histogram("ConfusionUMI", "EditDistance");
        IndependentReplicateMetric metric = new IndependentReplicateMetric();
        Histogram umiEditDistanceInDiffBiDups = new Histogram("editDistance", "diffAllelesCount");
        Histogram umiEditDistanceInSameBiDups = new Histogram("editDistance", "sameAllelesCount");
        Histogram alleleBalanceCount = new Histogram("alleleBalance", "alleleBalanceCount");
        SortedMap<QueryInterval, List<Allele>> intervalAlleleMap = this.getQueryIntervalsMap(this.VCF);
        Iterator<QueryInterval> queryIntervalIterator = intervalAlleleMap.keySet().iterator();
        log.info(new Object[]{"Found " + intervalAlleleMap.size() + " heterozygous sites in VCF."});
        log.info(new Object[]{"Querying BAM for sites."});
        SAMRecordIterator samRecordIterator = in.query(QueryInterval.optimizeIntervals((QueryInterval[])intervalAlleleMap.keySet().toArray(new QueryInterval[0])), false);
        List samFilters = CollectionUtil.makeList((Object[])new SamRecordFilter[]{new AlignedFilter(true), new SecondaryOrSupplementaryFilter(), new MappingQualityFilter(this.MINIMUM_MQ.intValue())});
        if (this.FILTER_UNPAIRED_READS) {
            samFilters.add(new CountingPairedFilter());
        }
        FilteringSamIterator filteredSamRecordIterator = new FilteringSamIterator((Iterator)samRecordIterator, (SamRecordFilter)new AggregateFilter(samFilters));
        log.info(new Object[]{"Queried BAM, getting duplicate sets."});
        DuplicateSetIterator duplicateSets = new DuplicateSetIterator((CloseableIterator)filteredSamRecordIterator, in.getFileHeader(), false, null, log);
        QueryInterval queryInterval = null;
        log.info(new Object[]{"Starting iteration on reads"});
        ProgressLogger progress = new ProgressLogger(log, this.PROGRESS_STEP_INTERVAL, "examined", "duplicate sets");
        IndependentReplicateMetric locusData = new IndependentReplicateMetric();
        boolean useLocus = true;
        boolean newLocus = false;
        int thirdAlleleInfos = 0;
        Allele badAllele = null;
        String offendingReadName = null;
        block6: while (duplicateSets.hasNext()) {
            Object allele;
            Integer n;
            set = duplicateSets.next();
            SAMRecord setRep = set.getRepresentative();
            QueryInterval setRepsInterval = CollectIndependentReplicateMetrics.queryIntervalFromSamRecord(setRep);
            progress.record(setRep);
            if (!useLocus || queryInterval != null && CollectIndependentReplicateMetrics.isCleanlyBefore(queryInterval, setRepsInterval)) {
                if (!useLocus) {
                    Integer n2 = metric.nThreeAllelesSites;
                    metric.nThreeAllelesSites = metric.nThreeAllelesSites + 1;
                    if (++thirdAlleleInfos < 100) {
                        log.debug(new Object[]{"Skipping a locus due to third allele: " + badAllele + " but expected " + intervalAlleleMap.get(queryInterval) + " queryInterval " + queryInterval + " offending read name is : " + offendingReadName});
                    }
                }
                queryInterval = null;
            }
            while (queryIntervalIterator.hasNext() && (queryInterval == null || CollectIndependentReplicateMetrics.isCleanlyBefore(queryInterval, setRepsInterval))) {
                if (locusData.nReferenceReads == 0 || locusData.nAlternateReads == 0) {
                    useLocus = false;
                    log.debug(new Object[]{"will not use this locus due to lack of evidence of het site."});
                }
                if (useLocus && newLocus) {
                    metric.merge(locusData);
                    log.debug(new Object[]{"merging metric. total nSites so far: " + metric.nSites});
                    byte alleleBalance = (byte)Math.round(100.0 * ((double)locusData.nAlternateReads.intValue() + 0.5) / (double)(locusData.nAlternateReads + locusData.nReferenceReads + 1));
                    alleleBalanceCount.increment((Comparable)Byte.valueOf(alleleBalance));
                    newLocus = false;
                }
                queryInterval = queryIntervalIterator.next();
                locusData = new IndependentReplicateMetric();
                locusData.nSites = 1;
                useLocus = true;
            }
            newLocus = true;
            if (queryInterval == null) break;
            int setSize = set.size();
            IndependentReplicateMetric independentReplicateMetric = locusData;
            Integer.valueOf(independentReplicateMetric.nTotalReads + setSize);
            independentReplicateMetric.nTotalReads = independentReplicateMetric.nTotalReads;
            if (setSize > 1) {
                independentReplicateMetric = locusData;
                n = independentReplicateMetric.nDuplicateSets;
                independentReplicateMetric.nDuplicateSets = independentReplicateMetric.nDuplicateSets + 1;
            }
            if (setSize == 2) {
                independentReplicateMetric = locusData;
                n = independentReplicateMetric.nExactlyDouble;
                independentReplicateMetric.nExactlyDouble = independentReplicateMetric.nExactlyDouble + 1;
            } else if (setSize == 3) {
                independentReplicateMetric = locusData;
                n = independentReplicateMetric.nExactlyTriple;
                independentReplicateMetric.nExactlyTriple = independentReplicateMetric.nExactlyTriple + 1;
            } else if (setSize > 3) {
                independentReplicateMetric = locusData;
                Integer.valueOf(independentReplicateMetric.nReadsInBigSets + setSize);
                independentReplicateMetric.nReadsInBigSets = independentReplicateMetric.nReadsInBigSets;
            }
            log.debug(new Object[]{"set size is: " + setSize});
            List allelesInVc = (List)intervalAlleleMap.get(queryInterval);
            log.debug(new Object[]{"alleles in VC: " + allelesInVc});
            int nRef = 0;
            int nAlt = 0;
            int nOther = 0;
            for (SAMRecord read2 : set.getRecords()) {
                int offset = read2.getReadPositionAtReferencePosition(queryInterval.start) - 1;
                if (offset == -1) {
                    log.debug(new Object[]{"got offset -1, getting new set"});
                    continue block6;
                }
                if (read2.getBaseQualities()[offset] <= this.MINIMUM_BQ) {
                    log.debug(new Object[]{"got low read quality, getting new set"});
                    continue block6;
                }
                allele = Allele.create((byte)read2.getReadBases()[offset]);
                if (((Allele)allelesInVc.get(0)).basesMatch(allele)) {
                    ++nRef;
                    continue;
                }
                if (((Allele)allelesInVc.get(1)).basesMatch(allele)) {
                    ++nAlt;
                    continue;
                }
                ++nOther;
                useLocus = false;
                badAllele = allele;
                offendingReadName = read2.getReadName();
            }
            Object object = locusData;
            Integer.valueOf(((IndependentReplicateMetric)((Object)object)).nAlternateReads + nAlt);
            ((IndependentReplicateMetric)((Object)object)).nAlternateReads = ((IndependentReplicateMetric)((Object)object)).nAlternateReads;
            object = locusData;
            Integer.valueOf(((IndependentReplicateMetric)((Object)object)).nReferenceReads + nRef);
            ((IndependentReplicateMetric)((Object)object)).nReferenceReads = ((IndependentReplicateMetric)((Object)object)).nReferenceReads;
            if (setSize == 1 || setSize > 3) continue;
            SetClassification classification = CollectIndependentReplicateMetrics.classifySet(nRef, nAlt, nOther);
            log.debug(new Object[]{"Classification of set is: " + classification});
            if (setSize == 2) {
                Object object2;
                IndependentReplicateMetric independentReplicateMetric2;
                boolean useBarcodes = set.getRecords().stream().map(read -> read.getStringAttribute(this.BARCODE_BQ)).map(string -> string == null ? "" : string).noneMatch(string -> {
                    byte[] bytes = SAMUtils.fastqToPhred((String)string);
                    return IntStream.range(0, bytes.length).map(i -> bytes[i]).anyMatch(q -> q < this.MINIMUM_BARCODE_BQ);
                });
                log.debug(new Object[]{"using barcodes?" + useBarcodes});
                if (useBarcodes) {
                    offset = locusData;
                    allele = offset.nGoodBarcodes;
                    offset.nGoodBarcodes = offset.nGoodBarcodes + 1;
                } else {
                    offset = locusData;
                    allele = offset.nBadBarcodes;
                    offset.nBadBarcodes = offset.nBadBarcodes + 1;
                }
                List barcodes = set.getRecords().stream().map(read -> read.getStringAttribute(this.BARCODE_TAG)).map(string -> string == null ? "" : string).collect(Collectors.toList());
                log.debug(new Object[]{"found UMIs:" + barcodes});
                boolean hasMultipleOrientations = set.getRecords().stream().map(rec -> !rec.getReadPairedFlag() || rec.getFirstOfPairFlag()).distinct().count() != 1L;
                log.debug(new Object[]{"reads have multiple orientation?" + hasMultipleOrientations});
                byte editDistance = CollectIndependentReplicateMetrics.calculateEditDistance((String)barcodes.get(0), (String)barcodes.get(1));
                log.debug(new Object[]{"Edit distance between umi: " + editDistance});
                if (useBarcodes && editDistance != 0) {
                    if (hasMultipleOrientations) {
                        independentReplicateMetric2 = locusData;
                        object2 = independentReplicateMetric2.nMismatchingUMIsInContraOrientedBiDups;
                        independentReplicateMetric2.nMismatchingUMIsInContraOrientedBiDups = independentReplicateMetric2.nMismatchingUMIsInContraOrientedBiDups + 1;
                    } else {
                        independentReplicateMetric2 = locusData;
                        object2 = independentReplicateMetric2.nMismatchingUMIsInCoOrientedBiDups;
                        independentReplicateMetric2.nMismatchingUMIsInCoOrientedBiDups = independentReplicateMetric2.nMismatchingUMIsInCoOrientedBiDups + 1;
                    }
                }
                if (classification == SetClassification.DIFFERENT_ALLELES) {
                    independentReplicateMetric2 = locusData;
                    object2 = independentReplicateMetric2.nDifferentAllelesBiDups;
                    independentReplicateMetric2.nDifferentAllelesBiDups = independentReplicateMetric2.nDifferentAllelesBiDups + 1;
                    if (useBarcodes) {
                        umiEditDistanceInDiffBiDups.increment((Comparable)Byte.valueOf(editDistance));
                        if (editDistance == 0) {
                            independentReplicateMetric2 = locusData;
                            object2 = independentReplicateMetric2.nMatchingUMIsInDiffBiDups;
                            independentReplicateMetric2.nMatchingUMIsInDiffBiDups = independentReplicateMetric2.nMatchingUMIsInDiffBiDups + 1;
                        } else {
                            independentReplicateMetric2 = locusData;
                            object2 = independentReplicateMetric2.nMismatchingUMIsInDiffBiDups;
                            independentReplicateMetric2.nMismatchingUMIsInDiffBiDups = independentReplicateMetric2.nMismatchingUMIsInDiffBiDups + 1;
                        }
                    }
                } else if (classification == SetClassification.MISMATCHING_ALLELE) {
                    independentReplicateMetric2 = locusData;
                    object2 = independentReplicateMetric2.nMismatchingAllelesBiDups;
                    independentReplicateMetric2.nMismatchingAllelesBiDups = independentReplicateMetric2.nMismatchingAllelesBiDups + 1;
                } else {
                    if (classification == SetClassification.ALTERNATE_ALLELE) {
                        independentReplicateMetric2 = locusData;
                        object2 = independentReplicateMetric2.nAlternateAllelesBiDups;
                        independentReplicateMetric2.nAlternateAllelesBiDups = independentReplicateMetric2.nAlternateAllelesBiDups + 1;
                    } else {
                        independentReplicateMetric2 = locusData;
                        object2 = independentReplicateMetric2.nReferenceAllelesBiDups;
                        independentReplicateMetric2.nReferenceAllelesBiDups = independentReplicateMetric2.nReferenceAllelesBiDups + 1;
                    }
                    if (useBarcodes) {
                        umiEditDistanceInSameBiDups.increment((Comparable)Byte.valueOf(editDistance));
                        ComparableTuple key = new ComparableTuple((Comparable)((Object)((String)barcodes.get(0))), (Comparable)((Object)((String)barcodes.get(1))));
                        umiConfusionMatrix.increment((Comparable)key);
                        if (!umiConfusionMatrixEditDistance.containsKey((Comparable)key)) {
                            umiConfusionMatrixEditDistance.increment((Comparable)key, (double)editDistance);
                        }
                        if (editDistance == 0) {
                            object2 = locusData;
                            var40_54 = ((IndependentReplicateMetric)((Object)object2)).nMatchingUMIsInSameBiDups;
                            ((IndependentReplicateMetric)((Object)object2)).nMatchingUMIsInSameBiDups = ((IndependentReplicateMetric)((Object)object2)).nMatchingUMIsInSameBiDups + 1;
                        } else {
                            object2 = locusData;
                            var40_54 = ((IndependentReplicateMetric)((Object)object2)).nMismatchingUMIsInSameBiDups;
                            ((IndependentReplicateMetric)((Object)object2)).nMismatchingUMIsInSameBiDups = ((IndependentReplicateMetric)((Object)object2)).nMismatchingUMIsInSameBiDups + 1;
                        }
                    }
                }
            }
            if (setSize == 3) {
                switch (classification) {
                    case MISMATCHING_ALLELE: {
                        IndependentReplicateMetric independentReplicateMetric3 = locusData;
                        Integer n3 = independentReplicateMetric3.nMismatchingAllelesTriDups;
                        independentReplicateMetric3.nMismatchingAllelesTriDups = independentReplicateMetric3.nMismatchingAllelesTriDups + 1;
                        break;
                    }
                    case DIFFERENT_ALLELES: {
                        IndependentReplicateMetric independentReplicateMetric4 = locusData;
                        Integer n4 = independentReplicateMetric4.nDifferentAllelesTriDups;
                        independentReplicateMetric4.nDifferentAllelesTriDups = independentReplicateMetric4.nDifferentAllelesTriDups + 1;
                        break;
                    }
                    case ALTERNATE_ALLELE: {
                        IndependentReplicateMetric independentReplicateMetric5 = locusData;
                        Integer n5 = independentReplicateMetric5.nAlternateAllelesTriDups;
                        independentReplicateMetric5.nAlternateAllelesTriDups = independentReplicateMetric5.nAlternateAllelesTriDups + 1;
                        break;
                    }
                    case REFERENCE_ALLELE: {
                        IndependentReplicateMetric independentReplicateMetric6 = locusData;
                        Integer n6 = independentReplicateMetric6.nReferenceAllelesTriDups;
                        independentReplicateMetric6.nReferenceAllelesTriDups = independentReplicateMetric6.nReferenceAllelesTriDups + 1;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Un possible!");
                    }
                }
            }
            if (this.STOP_AFTER <= 0 || progress.getCount() <= (long)this.STOP_AFTER.intValue()) continue;
            break;
        }
        if (useLocus && newLocus) {
            metric.merge(locusData);
            log.debug(new Object[]{"Merged final metric. nSites:" + metric.nSites});
        } else {
            set = metric.nThreeAllelesSites;
            metric.nThreeAllelesSites = metric.nThreeAllelesSites + 1;
            log.debug(new Object[]{"didn't merge last metric, due to 3rd allele: nThreeAllelesSites =" + metric.nThreeAllelesSites});
        }
        log.info(new Object[]{"Iteration done. Emitting metrics."});
        MetricsFile metricsFile = this.getMetricsFile();
        metric.calculateDerivedFields();
        metricsFile.addMetric((MetricBase)metric);
        metricsFile.addHistogram(alleleBalanceCount);
        metricsFile.addHistogram(umiEditDistanceInDiffBiDups);
        metricsFile.addHistogram(umiEditDistanceInSameBiDups);
        metricsFile.write(this.OUTPUT);
        MetricsFile confusionMetrics = this.getMetricsFile();
        if (this.MATRIX_OUTPUT != null) {
            confusionMetrics.addHistogram(umiConfusionMatrix);
            confusionMetrics.addHistogram(umiConfusionMatrixEditDistance);
            confusionMetrics.write(this.MATRIX_OUTPUT);
        }
        return 0;
    }

    private static boolean isCleanlyBefore(QueryInterval lhs, QueryInterval rhs) {
        return !lhs.overlaps(rhs) && lhs.compareTo(rhs) < 0;
    }

    private static SetClassification classifySet(int nRef, int nAlt, int nOther) {
        if (nOther != 0) {
            return SetClassification.MISMATCHING_ALLELE;
        }
        if (nAlt > 0 && nRef > 0) {
            return SetClassification.DIFFERENT_ALLELES;
        }
        if (nRef == 0) {
            return SetClassification.ALTERNATE_ALLELE;
        }
        if (nAlt == 0) {
            return SetClassification.REFERENCE_ALLELE;
        }
        throw new IllegalAccessError("shouldn't be here!");
    }

    private static QueryInterval queryIntervalFromSamRecord(SAMRecord samRecord) {
        return new QueryInterval(samRecord.getReferenceIndex().intValue(), samRecord.getStart(), samRecord.getEnd());
    }

    private static byte calculateEditDistance(String lhs, String rhs) {
        ValidationUtils.validateArg((lhs.length() == rhs.length() ? 1 : 0) != 0, () -> "lengths of strings must equal, found '" + lhs + "' and '" + rhs + "'.");
        byte tmp = 0;
        for (int i = 0; i < rhs.length(); ++i) {
            if (rhs.charAt(i) == lhs.charAt(i)) continue;
            tmp = (byte)(tmp + 1);
        }
        return tmp;
    }

    private SortedMap<QueryInterval, List<Allele>> getQueryIntervalsMap(File vcf) {
        HashMap<String, Integer> contigIndexMap = new HashMap<String, Integer>();
        VCFFileReader vcfReader = new VCFFileReader(vcf, false);
        CompoundFilter compoundFilter = new CompoundFilter(true);
        compoundFilter.add((Object)new SnpFilter());
        compoundFilter.add((Object)new PassingVariantFilter());
        compoundFilter.add((Object)new GenotypeQualityFilter(this.MINIMUM_GQ.intValue(), this.SAMPLE));
        compoundFilter.add((Object)new HeterozygosityFilter(true, this.SAMPLE));
        FilteringVariantContextIterator hetIterator = new FilteringVariantContextIterator((Iterator)vcfReader.iterator(), (VariantContextFilter)compoundFilter);
        for (VCFContigHeaderLine vcfContig : vcfReader.getFileHeader().getContigLines()) {
            contigIndexMap.put(vcfContig.getID(), vcfContig.getContigIndex());
        }
        TreeMap<QueryInterval, List<Allele>> map = new TreeMap<QueryInterval, List<Allele>>();
        while (hetIterator.hasNext()) {
            VariantContext vc = (VariantContext)hetIterator.next();
            map.put(new QueryInterval(((Integer)contigIndexMap.get(vc.getContig())).intValue(), vc.getStart(), vc.getEnd()), vc.getGenotype(this.SAMPLE).getAlleles());
        }
        vcfReader.close();
        return map;
    }

    private static enum SetClassification {
        MISMATCHING_ALLELE,
        DIFFERENT_ALLELES,
        REFERENCE_ALLELE,
        ALTERNATE_ALLELE;

    }
}

