/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import picard.arrays.illumina.Build37ExtendedIlluminaManifestRecord;
import picard.arrays.illumina.IlluminaManifest;

public class Build37ExtendedIlluminaManifest
extends IlluminaManifest {
    private static final String BUILD37_CHR_HEADER_NAME = "build37Chr";
    private static final String BUILD37_POS_HEADER_NAME = "build37Pos";
    private static final String BUILD37_REF_ALLELE_HEADER_NAME = "build37RefAllele";
    private static final String BUILD37_ALLELE_A_HEADER_NAME = "build37AlleleA";
    private static final String BUILD37_ALLELE_B_HEADER_NAME = "build37AlleleB";
    private static final String BUILD37_RSID_NAME = "build37Rsid";
    private static final String BUILD37_FLAG_HEADER_NAME = "build37Flag";
    static final String[] EXTENDED_MANIFEST_HEADERS = new String[]{"build37Chr", "build37Pos", "build37RefAllele", "build37AlleleA", "build37AlleleB", "build37Rsid", "build37Flag"};
    static final String EXTENDED_MANIFEST_VERSION_HEADER_NAME = "CreateExtendedIlluminaManifest.version";
    static final String EXTENDED_MANIFEST_TARGET_BUILD_HEADER_NAME = "Target Build";
    static final String EXTENDED_MANIFEST_TARGET_REFERENCE_HEADER_NAME = "Target Reference File";
    static final String EXTENDED_MANIFEST_CLUSTER_FILE_HEADER_NAME = "Cluster File";
    static final String EXTENDED_MANIFEST_DBSNP_FILE_HEADER_NAME = "dbSNP File";
    static final String EXTENDED_MANIFEST_SUPPORTED_BUILD_HEADER_NAME = "Supported Build";
    static final String EXTENDED_MANIFEST_SUPPORTED_REFERENCE_HEADER_NAME = "Supported Reference File";
    static final String EXTENDED_MANIFEST_SUPPORTED_CHAIN_FILE_HEADER_NAME = "Supported Chain File";

    @Override
    public String[] getAllPossibleHeaderNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAllPossibleHeaderNames(), (Object[])EXTENDED_MANIFEST_HEADERS);
    }

    public Build37ExtendedIlluminaManifest(File manifestFile) throws IOException {
        super(manifestFile);
    }

    public Iterator<Build37ExtendedIlluminaManifestRecord> extendedIterator() {
        return new Iterator<Build37ExtendedIlluminaManifestRecord>(){
            private int assayCount = 0;
            private int numAssays = Build37ExtendedIlluminaManifest.this.getNumAssays();

            @Override
            public boolean hasNext() {
                return this.assayCount < this.numAssays && Build37ExtendedIlluminaManifest.this.manifestFileParser.hasNext();
            }

            @Override
            public Build37ExtendedIlluminaManifestRecord next() {
                ++this.assayCount;
                return new Build37ExtendedIlluminaManifestRecord(Build37ExtendedIlluminaManifest.this.getAssayHeaderNameToIndex(), (String[])Build37ExtendedIlluminaManifest.this.manifestFileParser.next(), this.assayCount - 1);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getExtendedManifestVersion() {
        String version = "?";
        for (String[] headerLine : this.getHeaderContents()) {
            if (!headerLine[0].equals(EXTENDED_MANIFEST_VERSION_HEADER_NAME)) continue;
            version = headerLine[1];
        }
        return version;
    }
}

