/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.tribble.annotation.Strand;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import picard.PicardException;
import picard.arrays.illumina.Build37ExtendedIlluminaManifestRecord;
import picard.arrays.illumina.IlluminaManifestRecord;

public class Build37ExtendedIlluminaManifestRecordCreator {
    private final String targetBuild;
    private final Map<String, ReferenceSequenceFile> referenceFilesMap;
    private final Map<String, File> chainFilesMap;
    private final Set<String> supportedBuilds;
    private final Set<String> unsupportedBuilds;
    private boolean refStrandDefinedInManifest = true;
    private final Log log = Log.getInstance(Build37ExtendedIlluminaManifestRecordCreator.class);
    public static final String BUILD_37 = "37";
    public static final String IUPAC_NUCLEOTIDE_CODES = "ACGTRYSWKMBDHVNacgtryswkmbdhvn";
    public static final String ACGT_CODES = "ACGTacgt";
    private static final String SRC_SEQ_REGEX = "([ACGTRYSWKMBDHVNacgtryswkmbdhvn]*)\\[([ACGTacgt-])\\/([ACGTacgt]*)\\]([ACGTRYSWKMBDHVNacgtryswkmbdhvn]*)";
    private static final Pattern pattern = Pattern.compile("([ACGTRYSWKMBDHVNacgtryswkmbdhvn]*)\\[([ACGTacgt-])\\/([ACGTacgt]*)\\]([ACGTRYSWKMBDHVNacgtryswkmbdhvn]*)");
    private static final String ACGT_REGEX = "^[ACGTacgt]+$";
    private static final Pattern ACGT_PATTERN = Pattern.compile("^[ACGTacgt]+$");
    public static final int FIVE_PRIME_SEQUENCE = 1;
    public static final int PRE_INDEL_SEQUENCE = 2;
    public static final int INDEL_SEQUENCE = 3;
    public static final int THREE_PRIME_SEQUENCE = 4;

    Build37ExtendedIlluminaManifestRecordCreator(String targetBuild, Map<String, ReferenceSequenceFile> referenceFilesMap, Map<String, File> chainFilesMap) {
        this.targetBuild = targetBuild;
        this.referenceFilesMap = referenceFilesMap;
        this.chainFilesMap = chainFilesMap;
        this.supportedBuilds = new HashSet<String>();
        this.unsupportedBuilds = new TreeSet<String>();
        this.supportedBuilds.add(targetBuild);
        this.supportedBuilds.addAll(chainFilesMap.keySet());
    }

    public Build37ExtendedIlluminaManifestRecord createRecord(IlluminaManifestRecord illuminaManifestRecord) {
        Build37ExtendedIlluminaManifestRecord newRecord = new Build37ExtendedIlluminaManifestRecord(illuminaManifestRecord, Build37ExtendedIlluminaManifestRecord.Flag.PASS, "", null, "", "", "", "");
        if (illuminaManifestRecord.getChr().equals("0") || illuminaManifestRecord.getPosition() == 0) {
            newRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.ILLUMINA_FLAGGED;
            return newRecord;
        }
        if (!this.supportedBuilds.contains(illuminaManifestRecord.getMajorGenomeBuild())) {
            this.unsupportedBuilds.add(illuminaManifestRecord.getMajorGenomeBuild());
            newRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.UNSUPPORTED_GENOME_BUILD;
            return newRecord;
        }
        if (illuminaManifestRecord.getMajorGenomeBuild().equals(this.targetBuild)) {
            newRecord.b37Chr = illuminaManifestRecord.getChr();
            newRecord.b37Pos = illuminaManifestRecord.getPosition();
        } else {
            this.liftOverToTargetBuild(newRecord, illuminaManifestRecord);
            if (newRecord.isFail().booleanValue()) {
                return newRecord;
            }
        }
        ReferenceSequenceFile refFile = this.referenceFilesMap.get(this.targetBuild);
        this.setReferenceStrand(newRecord, refFile);
        if (!newRecord.isFail().booleanValue()) {
            if (newRecord.isSnp()) {
                this.processSnp(newRecord, refFile);
            } else {
                this.processIndel(newRecord, refFile);
            }
        }
        return newRecord;
    }

    private void processSnp(Build37ExtendedIlluminaManifestRecord build37ExtendedIlluminaManifestRecord, ReferenceSequenceFile refFile) {
        build37ExtendedIlluminaManifestRecord.snpAlleleA = build37ExtendedIlluminaManifestRecord.getSnp().substring(1, 2);
        build37ExtendedIlluminaManifestRecord.snpAlleleB = build37ExtendedIlluminaManifestRecord.getSnp().substring(3, 4);
        if (build37ExtendedIlluminaManifestRecord.referenceStrand == Strand.NEGATIVE) {
            build37ExtendedIlluminaManifestRecord.snpAlleleA = SequenceUtil.reverseComplement((String)build37ExtendedIlluminaManifestRecord.snpAlleleA);
            build37ExtendedIlluminaManifestRecord.snpAlleleB = SequenceUtil.reverseComplement((String)build37ExtendedIlluminaManifestRecord.snpAlleleB);
        }
        if (build37ExtendedIlluminaManifestRecord.isAmbiguous()) {
            if (build37ExtendedIlluminaManifestRecord.getAlleleBProbeSeq() != null) {
                String probeAAllele = build37ExtendedIlluminaManifestRecord.getAlleleAProbeSeq().substring(build37ExtendedIlluminaManifestRecord.getAlleleAProbeSeq().length() - 1);
                Build37ExtendedIlluminaManifestRecordCreator.validateThatSequenceOnlyContainsACGTCharacters("AlleleAProbeSeq for record: " + build37ExtendedIlluminaManifestRecord, probeAAllele);
                String probeBAllele = build37ExtendedIlluminaManifestRecord.getAlleleBProbeSeq().substring(build37ExtendedIlluminaManifestRecord.getAlleleBProbeSeq().length() - 1);
                Build37ExtendedIlluminaManifestRecordCreator.validateThatSequenceOnlyContainsACGTCharacters("AlleleBProbeSeq for record: " + build37ExtendedIlluminaManifestRecord, probeBAllele);
                if (!probeAAllele.equals(build37ExtendedIlluminaManifestRecord.snpAlleleA) && !probeBAllele.equals(build37ExtendedIlluminaManifestRecord.snpAlleleB) && build37ExtendedIlluminaManifestRecord.referenceStrand == Strand.POSITIVE) {
                    build37ExtendedIlluminaManifestRecord.snpAlleleA = probeAAllele;
                    build37ExtendedIlluminaManifestRecord.snpAlleleB = probeBAllele;
                }
            } else {
                build37ExtendedIlluminaManifestRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.MISSING_ALLELE_B_PROBESEQ;
                this.log.warn(new Object[]{"Error in processSnp.  Record:" + build37ExtendedIlluminaManifestRecord});
                this.log.warn(new Object[]{"  Ambiguous probe without alleleBProbeSeq"});
            }
        }
        build37ExtendedIlluminaManifestRecord.snpRefAllele = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, build37ExtendedIlluminaManifestRecord.b37Chr, build37ExtendedIlluminaManifestRecord.b37Pos, build37ExtendedIlluminaManifestRecord.b37Pos);
    }

    private void setReferenceStrand(Build37ExtendedIlluminaManifestRecord build37ExtendedIlluminaManifestRecord, ReferenceSequenceFile refFile) {
        if (build37ExtendedIlluminaManifestRecord.referenceStrand != null) {
            return;
        }
        build37ExtendedIlluminaManifestRecord.referenceStrand = build37ExtendedIlluminaManifestRecord.getRefStrand();
        if (build37ExtendedIlluminaManifestRecord.referenceStrand == Strand.NONE) {
            this.refStrandDefinedInManifest = false;
            if (build37ExtendedIlluminaManifestRecord.isSnp()) {
                String probeSeq = build37ExtendedIlluminaManifestRecord.getAlleleAProbeSeq();
                if (build37ExtendedIlluminaManifestRecord.isAmbiguous()) {
                    probeSeq = probeSeq.substring(0, probeSeq.length() - 1);
                }
                Build37ExtendedIlluminaManifestRecordCreator.validateThatSequenceOnlyContainsACGTCharacters("AlleleAProbeSeq for record: " + build37ExtendedIlluminaManifestRecord, probeSeq);
                String reference = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, build37ExtendedIlluminaManifestRecord.b37Chr, build37ExtendedIlluminaManifestRecord.b37Pos - probeSeq.length(), build37ExtendedIlluminaManifestRecord.b37Pos - 1);
                String reverseReference = SequenceUtil.reverseComplement((String)Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, build37ExtendedIlluminaManifestRecord.b37Chr, build37ExtendedIlluminaManifestRecord.b37Pos + 1, build37ExtendedIlluminaManifestRecord.b37Pos + probeSeq.length()));
                if (reference.equals(probeSeq)) {
                    build37ExtendedIlluminaManifestRecord.referenceStrand = Strand.POSITIVE;
                } else if (reverseReference.equals(probeSeq)) {
                    build37ExtendedIlluminaManifestRecord.referenceStrand = Strand.NEGATIVE;
                } else {
                    build37ExtendedIlluminaManifestRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.PROBE_SEQUENCE_MISMATCH;
                    this.log.warn(new Object[]{"Error in getStrand.  Record:" + build37ExtendedIlluminaManifestRecord});
                    this.log.warn(new Object[]{"  Couldn't find alleleAProbeSeq in reference"});
                    this.log.debug(new Object[]{"  AlleleAProbeSeq: " + build37ExtendedIlluminaManifestRecord.getAlleleAProbeSeq()});
                    this.log.debug(new Object[]{"  Reference:       " + reference});
                    this.log.debug(new Object[]{"  Reverse Ref:     " + reverseReference});
                }
            } else if (build37ExtendedIlluminaManifestRecord.getIlmnStrand() == IlluminaManifestRecord.IlluminaStrand.PLUS) {
                build37ExtendedIlluminaManifestRecord.referenceStrand = Strand.POSITIVE;
            } else if (build37ExtendedIlluminaManifestRecord.getIlmnStrand() == IlluminaManifestRecord.IlluminaStrand.MINUS) {
                build37ExtendedIlluminaManifestRecord.referenceStrand = Strand.NEGATIVE;
            } else {
                throw new PicardException("Unexpected value for Illumina Strand: " + build37ExtendedIlluminaManifestRecord.getIlmnStrand());
            }
        }
    }

    private void processIndel(Build37ExtendedIlluminaManifestRecord extendedIlluminaManifestRecord, ReferenceSequenceFile refFile) {
        if (extendedIlluminaManifestRecord.isSnp()) {
            throw new PicardException("This shouldn't happen");
        }
        Matcher matcher = Build37ExtendedIlluminaManifestRecordCreator.parseSourceSeq(extendedIlluminaManifestRecord.getSourceSeq());
        if (!matcher.group(2).equals("-")) {
            throw new PicardException("Unexpected allele '-' Record: " + extendedIlluminaManifestRecord);
        }
        String fivePrimeSeq = matcher.group(1).toUpperCase();
        String indelSeq = matcher.group(3).toUpperCase();
        String threePrimeSeq = matcher.group(4).toUpperCase();
        Build37ExtendedIlluminaManifestRecordCreator.validateThatSequenceOnlyContainsACGTCharacters("Indel sequence for record: " + extendedIlluminaManifestRecord, indelSeq);
        boolean isSourceOnDesignStrand = extendedIlluminaManifestRecord.getSourceStrand() == extendedIlluminaManifestRecord.getIlmnStrand();
        if (isSourceOnDesignStrand != (extendedIlluminaManifestRecord.referenceStrand == Strand.POSITIVE)) {
            String temp = threePrimeSeq;
            threePrimeSeq = SequenceUtil.reverseComplement((String)fivePrimeSeq);
            indelSeq = SequenceUtil.reverseComplement((String)indelSeq);
            fivePrimeSeq = SequenceUtil.reverseComplement((String)temp);
        }
        ImmutablePair<Boolean, Boolean> illuminaIsIndel = this.calculateIsInsertionOrDeletion(extendedIlluminaManifestRecord, refFile, fivePrimeSeq, indelSeq, threePrimeSeq);
        boolean isInsertion = (Boolean)illuminaIsIndel.left;
        boolean isDeletion = (Boolean)illuminaIsIndel.right;
        if (!isInsertion && !isDeletion) {
            extendedIlluminaManifestRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.INDEL_NOT_FOUND;
            this.log.warn(new Object[]{"Error in processIndel.  Record: " + extendedIlluminaManifestRecord});
            this.log.warn(new Object[]{"  Couldn't find source sequence with or without variant in reference"});
            return;
        }
        if (isInsertion && isDeletion) {
            extendedIlluminaManifestRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.INDEL_CONFLICT;
            this.log.warn(new Object[]{"Error in processIndel.  Record: " + extendedIlluminaManifestRecord});
            this.log.warn(new Object[]{"  Conflict.  Both source sequence with and without variation found in reference"});
            return;
        }
        if (isDeletion) {
            Integer n = extendedIlluminaManifestRecord.b37Pos;
            extendedIlluminaManifestRecord.b37Pos = extendedIlluminaManifestRecord.b37Pos - 1;
        }
        String refAllele = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, extendedIlluminaManifestRecord.getB37Chr(), extendedIlluminaManifestRecord.getB37Pos(), extendedIlluminaManifestRecord.getB37Pos());
        extendedIlluminaManifestRecord.snpRefAllele = isDeletion ? refAllele + indelSeq : refAllele;
        if (extendedIlluminaManifestRecord.getSnp().equals("[I/D]")) {
            extendedIlluminaManifestRecord.snpAlleleA = refAllele + indelSeq;
            extendedIlluminaManifestRecord.snpAlleleB = refAllele;
        } else {
            extendedIlluminaManifestRecord.snpAlleleA = refAllele;
            extendedIlluminaManifestRecord.snpAlleleB = refAllele + indelSeq;
        }
    }

    private ImmutablePair<Boolean, Boolean> calculateIsInsertionOrDeletion(Build37ExtendedIlluminaManifestRecord extendedIlluminaManifestRecord, ReferenceSequenceFile refFile, String fivePrimeSeq, String indelSeq, String threePrimeSeq) {
        ImmutablePair<String, String> leftShiftedSourceSeq = Build37ExtendedIlluminaManifestRecordCreator.illuminaLeftShift(fivePrimeSeq, indelSeq, threePrimeSeq);
        String leftShiftedFivePrimeSeq = (String)leftShiftedSourceSeq.left;
        String leftShiftedThreePrimeSeq = (String)leftShiftedSourceSeq.right;
        int startIndex = extendedIlluminaManifestRecord.b37Pos;
        String indelSequenceFromReference = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, extendedIlluminaManifestRecord.b37Chr, startIndex, startIndex + indelSeq.length() - 1);
        boolean indelSequenceMatch = indelSeq.equals(indelSequenceFromReference);
        String genomicDeletionFivePrime = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, extendedIlluminaManifestRecord.b37Chr, startIndex - leftShiftedFivePrimeSeq.length(), startIndex - 1);
        String genomicDeletionThreePrime = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, extendedIlluminaManifestRecord.b37Chr, startIndex + indelSeq.length(), startIndex + indelSeq.length() + leftShiftedThreePrimeSeq.length() - 1);
        ImmutablePair<Double, Integer> deletionContextInfo = Build37ExtendedIlluminaManifestRecordCreator.calculateIsDeletion((String)leftShiftedSourceSeq.left, (String)leftShiftedSourceSeq.right, indelSequenceMatch, genomicDeletionFivePrime, indelSeq, genomicDeletionThreePrime);
        String genomicInsertionFivePrime = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, extendedIlluminaManifestRecord.b37Chr, startIndex - leftShiftedFivePrimeSeq.length() + 1, startIndex);
        String genomicInsertionThreePrime = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(refFile, extendedIlluminaManifestRecord.b37Chr, startIndex + 1, startIndex + leftShiftedThreePrimeSeq.length());
        ImmutablePair<Double, Integer> insertionContextInfo = Build37ExtendedIlluminaManifestRecordCreator.calculateIsInsertion((String)leftShiftedSourceSeq.left, (String)leftShiftedSourceSeq.right, genomicInsertionFivePrime, indelSeq, genomicInsertionThreePrime);
        boolean illuminaIsDeletion = indelSequenceMatch & (Double)deletionContextInfo.left > (Double)insertionContextInfo.left & (Integer)deletionContextInfo.right >= 1;
        boolean illuminaIsInsertion = (Double)insertionContextInfo.left > (Double)deletionContextInfo.left & (Integer)insertionContextInfo.right >= 1;
        return new ImmutablePair((Object)illuminaIsInsertion, (Object)illuminaIsDeletion);
    }

    static ImmutablePair<Double, Integer> calculateIsDeletion(String fivePrimeSeq, String threePrimeSeq, boolean indelSequenceMatch, String genomicDeletionFivePrime, String indelSeq, String genomicDeletionThreePrime) {
        ImmutablePair<String, String> leftShiftedGenomicDeletionSeqs = Build37ExtendedIlluminaManifestRecordCreator.illuminaLeftShift(genomicDeletionFivePrime, indelSeq, genomicDeletionThreePrime);
        int deletionContextSuffixMatchLength = Build37ExtendedIlluminaManifestRecordCreator.commonSuffixLength((String)leftShiftedGenomicDeletionSeqs.left, fivePrimeSeq);
        int deletionContextPrefixMatchLength = Build37ExtendedIlluminaManifestRecordCreator.commonPrefixLength((String)leftShiftedGenomicDeletionSeqs.right, threePrimeSeq);
        int minDeletionContextMaxLength = Math.min(deletionContextPrefixMatchLength, deletionContextSuffixMatchLength);
        int maxDeletionContext = Math.min(genomicDeletionFivePrime.length(), fivePrimeSeq.length()) + Math.min(genomicDeletionThreePrime.length(), threePrimeSeq.length()) + indelSeq.length();
        double deletionContextScore = 0.0;
        if (indelSequenceMatch) {
            deletionContextScore = (double)(deletionContextPrefixMatchLength + deletionContextSuffixMatchLength + indelSeq.length()) / (double)maxDeletionContext;
        }
        return new ImmutablePair((Object)deletionContextScore, (Object)minDeletionContextMaxLength);
    }

    static ImmutablePair<Double, Integer> calculateIsInsertion(String fivePrimeSeq, String threePrimeSeq, String genomicInsertionFivePrime, String indelSeq, String genomicInsertionThreePrime) {
        ImmutablePair<String, String> leftShiftedGenomicInsertionSeqs = Build37ExtendedIlluminaManifestRecordCreator.illuminaLeftShift(genomicInsertionFivePrime, indelSeq, genomicInsertionThreePrime);
        int insertionContextSuffixMatchLength = Build37ExtendedIlluminaManifestRecordCreator.commonSuffixLength((String)leftShiftedGenomicInsertionSeqs.left, fivePrimeSeq);
        int insertionContextPrefixMatchLength = Build37ExtendedIlluminaManifestRecordCreator.commonPrefixLength((String)leftShiftedGenomicInsertionSeqs.right, threePrimeSeq);
        int minInsertionContextMaxLength = Math.min(insertionContextPrefixMatchLength, insertionContextSuffixMatchLength);
        int maxInsertionContext = Math.min(genomicInsertionFivePrime.length(), fivePrimeSeq.length()) + Math.min(genomicInsertionThreePrime.length(), threePrimeSeq.length());
        double insertionContextScore = (double)(insertionContextSuffixMatchLength + insertionContextPrefixMatchLength) / (double)maxInsertionContext;
        return new ImmutablePair((Object)insertionContextScore, (Object)minInsertionContextMaxLength);
    }

    static ImmutablePair<String, String> illuminaLeftShift(String fivePrimeSeq, String indelSeq, String threePrimeSeq) {
        String modifiedFivePrimeSeq = fivePrimeSeq;
        StringBuilder modifiedThreePrimeSeq = new StringBuilder(threePrimeSeq);
        int indelLength = indelSeq.length();
        while (modifiedFivePrimeSeq.endsWith(indelSeq)) {
            modifiedFivePrimeSeq = modifiedFivePrimeSeq.substring(0, modifiedFivePrimeSeq.length() - indelLength);
            modifiedThreePrimeSeq.insert(0, indelSeq);
        }
        while (StringUtils.repeat((char)modifiedFivePrimeSeq.charAt(modifiedFivePrimeSeq.length() - 1), (int)indelLength).equals(indelSeq)) {
            modifiedThreePrimeSeq.insert(0, modifiedFivePrimeSeq.substring(modifiedFivePrimeSeq.length() - 1));
            modifiedFivePrimeSeq = modifiedFivePrimeSeq.substring(0, modifiedFivePrimeSeq.length() - 1);
        }
        return new ImmutablePair((Object)modifiedFivePrimeSeq, (Object)modifiedThreePrimeSeq.toString());
    }

    static int commonPrefixLength(String seq1, String seq2) {
        int commonLength;
        if (StringUtils.isEmpty((CharSequence)seq1) || StringUtils.isEmpty((CharSequence)seq2)) {
            return 0;
        }
        for (commonLength = 0; commonLength < seq1.length() && commonLength < seq2.length() && seq1.charAt(commonLength) == seq2.charAt(commonLength); ++commonLength) {
        }
        return commonLength;
    }

    static int commonSuffixLength(String seq1, String seq2) {
        if (StringUtils.isEmpty((CharSequence)seq1) || StringUtils.isEmpty((CharSequence)seq2)) {
            return 0;
        }
        int index1 = seq1.length() - 1;
        int index2 = seq2.length() - 1;
        int commonLength = 0;
        while (index1 >= 0 && index2 >= 0 && seq1.charAt(index1--) == seq2.charAt(index2--)) {
            ++commonLength;
        }
        return commonLength;
    }

    private static Matcher parseSourceSeq(String sourceSeq) {
        Matcher matcher = pattern.matcher(sourceSeq);
        if (matcher.find()) {
            return matcher;
        }
        throw new PicardException("Could not find the pattern V[W/X]Y in the SourceSeq: " + sourceSeq);
    }

    private static void validateThatSequenceOnlyContainsACGTCharacters(String sequenceDescription, String sequence) throws PicardException {
        if (!ACGT_PATTERN.matcher(sequence).find()) {
            throw new PicardException(sequenceDescription + " contains non-ACGT character(s)");
        }
    }

    private void liftOverToTargetBuild(Build37ExtendedIlluminaManifestRecord build37ExtendedIlluminaManifestRecord, IlluminaManifestRecord illuminaManifestRecord) {
        Interval interval;
        String supportedBuildNumber = illuminaManifestRecord.getMajorGenomeBuild();
        File chainFileToTargetBuild = this.chainFilesMap.get(supportedBuildNumber);
        LiftOver liftOver = new LiftOver(chainFileToTargetBuild);
        Interval targetBuildInterval = liftOver.liftOver(interval = new Interval(illuminaManifestRecord.getChr(), illuminaManifestRecord.getPosition(), illuminaManifestRecord.getPosition()));
        if (targetBuildInterval != null) {
            String newRefAllele;
            build37ExtendedIlluminaManifestRecord.b37Chr = targetBuildInterval.getContig();
            build37ExtendedIlluminaManifestRecord.b37Pos = targetBuildInterval.getStart();
            String originalRefAllele = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(this.referenceFilesMap.get(supportedBuildNumber), illuminaManifestRecord.getChr(), illuminaManifestRecord.getPosition(), illuminaManifestRecord.getPosition());
            if (originalRefAllele.equals(newRefAllele = Build37ExtendedIlluminaManifestRecordCreator.getSequenceAt(this.referenceFilesMap.get(this.targetBuild), build37ExtendedIlluminaManifestRecord.b37Chr, build37ExtendedIlluminaManifestRecord.b37Pos, build37ExtendedIlluminaManifestRecord.b37Pos))) {
                this.log.debug(new Object[]{"Lifted over record " + build37ExtendedIlluminaManifestRecord});
                this.log.debug(new Object[]{" From build " + supportedBuildNumber + " chr=" + illuminaManifestRecord.getChr() + ", position=" + illuminaManifestRecord.getPosition() + " To build " + this.targetBuild + " chr=" + build37ExtendedIlluminaManifestRecord.b37Chr + ", position=" + build37ExtendedIlluminaManifestRecord.b37Pos});
            } else {
                build37ExtendedIlluminaManifestRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.LIFTOVER_FAILED;
                this.log.error(new Object[]{"Liftover failed for record: " + build37ExtendedIlluminaManifestRecord});
                this.log.error(new Object[]{" Sequence at lifted over position does not match that at original position"});
            }
        } else {
            build37ExtendedIlluminaManifestRecord.flag = Build37ExtendedIlluminaManifestRecord.Flag.LIFTOVER_FAILED;
            this.log.error(new Object[]{"Liftover failed for record: " + build37ExtendedIlluminaManifestRecord});
        }
    }

    public Set<String> getUnsupportedBuilds() {
        return this.unsupportedBuilds;
    }

    public boolean isRefStrandDefinedInManifest() {
        return this.refStrandDefinedInManifest;
    }

    private static String getSequenceAt(ReferenceSequenceFile refFile, String chr, int startPos, int endPos) {
        int contigLength = refFile.getSequenceDictionary().getSequence(chr).getSequenceLength();
        int usedEndPos = Math.min(endPos, contigLength);
        return new String(refFile.getSubsequenceAt(chr, (long)startPos, (long)usedEndPos).getBases()).toUpperCase();
    }
}

