/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.ClassFinder;
import org.broadinstitute.barclay.argparser.CommandLineProgramGroup;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import picard.cmdline.CommandLineDefaults;
import picard.cmdline.CommandLineProgram;

public class PicardCommandLine {
    private static final Log log = Log.getInstance(PicardCommandLine.class);
    private static final String KNRM = PicardCommandLine.initializeColor("\u001b[0m");
    private static final String KBLD = PicardCommandLine.initializeColor("\u001b[1m");
    private static final String KRED = PicardCommandLine.initializeColor("\u001b[31m");
    private static final String KGRN = PicardCommandLine.initializeColor("\u001b[32m");
    private static final String KYEL = PicardCommandLine.initializeColor("\u001b[33m");
    private static final String KBLU = PicardCommandLine.initializeColor("\u001b[34m");
    private static final String KMAG = PicardCommandLine.initializeColor("\u001b[35m");
    private static final String KCYN = PicardCommandLine.initializeColor("\u001b[36m");
    private static final String KWHT = PicardCommandLine.initializeColor("\u001b[37m");
    private static final String KBLDRED = PicardCommandLine.initializeColor("\u001b[1m\u001b[31m");
    private static final String COMMAND_LINE_NAME = PicardCommandLine.class.getSimpleName();
    private static final String BETA_PREFIX = "**BETA - WORK IN PROGRESS** ";
    private static final String EXPERIMENTAL_PREFIX = "**EXPERIMENTAL - USE AT YOUR OWN RISK** ";
    private static final int HELP_SIMILARITY_FLOOR = 7;
    private static final int MINIMUM_SUBSTRING_LENGTH = 5;

    private static String initializeColor(String color) {
        if (CommandLineDefaults.COLOR_STATUS) {
            return color;
        }
        return "";
    }

    protected static List<String> getPackageList() {
        ArrayList<String> packageList = new ArrayList<String>();
        packageList.add("picard");
        return packageList;
    }

    protected int instanceMain(String[] args, List<String> packageList, String commandLineName) {
        CommandLineProgram program = PicardCommandLine.extractCommandLineProgram(args, packageList, commandLineName);
        if (null == program) {
            return 1;
        }
        String[] mainArgs = Arrays.copyOfRange(args, 1, args.length);
        return program.instanceMain(mainArgs);
    }

    protected int instanceMain(String[] args) {
        return this.instanceMain(args, PicardCommandLine.getPackageList(), COMMAND_LINE_NAME);
    }

    public static void main(String[] args) {
        System.exit(new PicardCommandLine().instanceMain(args, PicardCommandLine.getPackageList(), COMMAND_LINE_NAME));
    }

    private static CommandLineProgram extractCommandLineProgram(String[] args, List<String> packageList, String commandLineName) {
        HashMap simpleNameToClass = new HashMap();
        ArrayList missingAnnotationClasses = new ArrayList();
        PicardCommandLine.processAllCommandLinePrograms(packageList, (clazz, clProperties) -> {
            if (null == clProperties) {
                missingAnnotationClasses.add(clazz.getSimpleName());
            } else if (!clProperties.omitFromCommandLine()) {
                if (simpleNameToClass.containsKey(clazz.getSimpleName())) {
                    throw new RuntimeException("Simple class name collision: " + clazz.getSimpleName());
                }
                simpleNameToClass.put(clazz.getSimpleName(), clazz);
            }
        });
        if (!missingAnnotationClasses.isEmpty()) {
            throw new RuntimeException("The following classes are missing the required CommandLineProgramProperties annotation: " + missingAnnotationClasses.stream().collect(Collectors.joining(", ")));
        }
        HashSet classes = new HashSet();
        classes.addAll(simpleNameToClass.values());
        if (args.length < 1) {
            PicardCommandLine.printUsage(classes, commandLineName);
        } else if (args[0].equals("-h")) {
            PicardCommandLine.printUsage(classes, commandLineName);
        } else if (args[0].equals("--list-commands")) {
            PicardCommandLine.printCommandList(classes);
        } else {
            if (simpleNameToClass.containsKey(args[0])) {
                Class clazz2 = (Class)simpleNameToClass.get(args[0]);
                try {
                    return (CommandLineProgram)clazz2.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            PicardCommandLine.printUsage(classes, commandLineName);
            PicardCommandLine.printUnknown(classes, args[0]);
        }
        return null;
    }

    public static void processAllCommandLinePrograms(List<String> packageList, BiConsumer<Class<CommandLineProgram>, CommandLineProgramProperties> clpClassProcessor) {
        ClassFinder classFinder = new ClassFinder();
        packageList.forEach(pkg -> classFinder.find(pkg, CommandLineProgram.class));
        for (Class clazz : classFinder.getClasses()) {
            if (clazz.isInterface() || clazz.isSynthetic() || clazz.isPrimitive() || clazz.isLocalClass() || Modifier.isAbstract(clazz.getModifiers())) continue;
            clpClassProcessor.accept(clazz, PicardCommandLine.getProgramProperty(clazz));
        }
    }

    public static CommandLineProgramProperties getProgramProperty(Class clazz) {
        return clazz.getAnnotation(CommandLineProgramProperties.class);
    }

    private static void printCommandList(Set<Class<?>> classes) {
        PicardCommandLine.printUsage(classes, null, true, true);
    }

    private static void printUsage(Set<Class<?>> classes, String commandLineName) {
        PicardCommandLine.printUsage(classes, commandLineName, false, false);
    }

    private static void printUsage(Set<Class<?>> classes, String commandLineName, boolean commandListOnly, boolean toStdout) {
        StringBuilder builder = new StringBuilder();
        if (!commandListOnly) {
            builder.append(KBLDRED + "USAGE: " + commandLineName + " " + KGRN + "<program name>" + KBLDRED + " [-h]\n\n" + KNRM);
            builder.append(KBLDRED + "Available Programs:\n" + KNRM);
        }
        HashMap<Class, CommandLineProgramGroup> programGroupClassToProgramGroupInstance = new HashMap<Class, CommandLineProgramGroup>();
        TreeMap programsByGroup = new TreeMap(CommandLineProgramGroup.comparator);
        HashMap programsToProperty = new HashMap();
        for (Class<?> clazz : classes) {
            ArrayList programs;
            CommandLineProgramProperties property = PicardCommandLine.getProgramProperty(clazz);
            if (null == property) {
                throw new RuntimeException(String.format("The class '%s' is missing the required CommandLineProgramProperties annotation.", clazz.getSimpleName()));
            }
            programsToProperty.put(clazz, property);
            CommandLineProgramGroup programGroup = (CommandLineProgramGroup)programGroupClassToProgramGroupInstance.get(property.programGroup());
            if (null == programGroup) {
                try {
                    programGroup = (CommandLineProgramGroup)property.programGroup().newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                programGroupClassToProgramGroupInstance.put(property.programGroup(), programGroup);
            }
            if (null == (programs = (ArrayList)programsByGroup.get(programGroup))) {
                programs = new ArrayList();
                programsByGroup.put(programGroup, programs);
            }
            programs.add(clazz);
        }
        for (Map.Entry entry : programsByGroup.entrySet()) {
            CommandLineProgramGroup programGroup = (CommandLineProgramGroup)entry.getKey();
            if (!commandListOnly) {
                builder.append(KWHT + "--------------------------------------------------------------------------------------\n" + KNRM);
                builder.append(String.format("%s%-48s %-45s%s\n", KRED, programGroup.getName() + ":", programGroup.getDescription(), KNRM));
            }
            ArrayList sortedClasses = new ArrayList();
            sortedClasses.addAll((Collection)entry.getValue());
            Collections.sort(sortedClasses, new SimpleNameComparator());
            for (Class clazz : sortedClasses) {
                CommandLineProgramProperties property = (CommandLineProgramProperties)programsToProperty.get(clazz);
                if (null == property) {
                    throw new RuntimeException(String.format("Unexpected error: did not find the CommandLineProgramProperties annotation for '%s'", clazz.getSimpleName()));
                }
                if (!commandListOnly) {
                    builder.append(String.format(clazz.getSimpleName().length() >= 45 ? "%s    %s    %s%s%s%s%s\n" : "%s    %-45s%s%s%s%s%s\n", KGRN, clazz.getSimpleName(), KRED, PicardCommandLine.getToolSummaryPrefix(clazz), KCYN, property.oneLineSummary(), KNRM));
                    continue;
                }
                builder.append(clazz.getSimpleName() + "\n");
            }
            if (commandListOnly) continue;
            builder.append(String.format("\n", new Object[0]));
        }
        if (!commandListOnly) {
            builder.append(KWHT + "--------------------------------------------------------------------------------------\n\n" + KNRM);
        }
        if (toStdout) {
            System.out.print(builder.toString());
        } else {
            System.err.print(builder.toString());
        }
    }

    private static String getToolSummaryPrefix(Class<?> clazz) {
        if (clazz.getAnnotation(ExperimentalFeature.class) != null) {
            return EXPERIMENTAL_PREFIX;
        }
        if (clazz.getAnnotation(BetaFeature.class) != null) {
            return BETA_PREFIX;
        }
        return "";
    }

    public static void printUnknown(Set<Class<?>> classes, String command) {
        HashMap distances = new HashMap();
        int bestDistance = Integer.MAX_VALUE;
        int bestN = 0;
        for (Class<?> clazz : classes) {
            String name = clazz.getSimpleName();
            if (name.equals(command)) {
                throw new RuntimeException("Command matches: " + command);
            }
            int distance = name.startsWith(command) || 5 <= command.length() && name.contains(command) ? 0 : StringUtil.levenshteinDistance((String)command, (String)name, (int)0, (int)2, (int)1, (int)4);
            distances.put(clazz, distance);
            if (distance < bestDistance) {
                bestDistance = distance;
                bestN = 1;
                continue;
            }
            if (distance != bestDistance) continue;
            ++bestN;
        }
        if (0 == bestDistance && bestN == classes.size()) {
            bestDistance = 8;
        }
        System.err.println(String.format("'%s' is not a valid command. See PicardCommandLine -h for more information.", command));
        if (bestDistance < 7) {
            System.err.println(String.format("Did you mean %s?", bestN < 2 ? "this" : "one of these"));
            for (Class<?> clazz : classes) {
                if (bestDistance != (Integer)distances.get(clazz)) continue;
                System.err.println(String.format("        %s", clazz.getSimpleName()));
            }
        }
    }

    private static class SimpleNameComparator
    implements Comparator<Class> {
        private SimpleNameComparator() {
        }

        @Override
        public int compare(Class aClass, Class bClass) {
            return aClass.getSimpleName().compareTo(bClass.getSimpleName());
        }
    }
}

