/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SamReader;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.CappedHaplotypeProbabilities;
import picard.fingerprint.CrosscheckMetric;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.FingerprintChecker;
import picard.fingerprint.FingerprintIdDetails;
import picard.fingerprint.HaplotypeMap;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.MatchResults;
import picard.util.TabbedInputParser;

@CommandLineProgramProperties(summary="Checks the odds that all data in the set of input files come from the same individual. Can be used to cross-check readgroups, libraries, samples, or files. Acceptable inputs include BAM/SAM/CRAM and VCF/GVCF files. Output delivers LOD scores in the form of a CrosscheckMetric file. \n\n<h3>Summary</h3>\nCrosscheckFingerprints rapidly checks the odds that all of the genetic data within a set of files come from the same individual. This is accomplished by selectively sampling from the input files, and determining whether the genotypes of the specified Groups match to each other. (Groups are defined by the input and the argument CROSSCHECK_BY; they can be READ_GROUP, LIBRARY, SAMPLE, or FILE.)<br /><br /> Output is generated in the form of a \u201cmolten\u201d (one row per comparison) CrosscheckMetric file that includes the Logarithm of the Odds (LOD) score, as well as the tumor-aware LOD score. Tumor-aware LOD scores can be used to assess genotypic identity in the presence of a severe Loss of Heterozygosity (LOH) with high purity\u2014this could otherwise lead to a failure of the tool to identify samples are from the same individual. Output is also available as a matrix, to facilitate visual inspection of crosscheck results.<br /><br /> Metric files can contain many rows of output. We therefore recommend following up CrosscheckFingerprints with a step using [ClusterCrosscheckMetrics (Picard)](https://gatk.broadinstitute.org/hc/en-us/articles/360045798972--Tool-Documentation-Index); this tool will cluster groups together that pass a designated LOD threshold, ensuring that groups within the cluster are related to each other. <br /><br /> There may be cases where several groups out of a collection of possible groups must be identified---for example, to link a BAM to its correct sample in a multi-sample VCF. In this case, it would not be necessary to cross-check the various samples in the VCF against each other, but only to check the identity of the BAM against the various samples in the VCF. For this application, the SECOND_INPUT argument is provided. With SECOND_INPUT, CrosscheckFingerprints can do the following: <br /><br /> <ul><li> Independently aggregate data for the input files in INPUT and SECOND_INPUT. </li><li> Aggregate data at the SAMPLE level. </li><li> Compare samples from INPUT to the same sample in SECOND_INPUT. </li><li> Disables MATRIX_OUTPUT. </li></ul><br /><br />In some cases, the groups collected may not have any observations (\u2018reads\u2019 for BAM files, or \u2018calls\u2019 for VCF files) at fingerprinting sites. Alternatively, a sample in INPUT may be missing from SECOND_INPUT. These cases are handled as follows: <br /><br /> <ul><li> If running in CHECK_SAME_SAMPLES mode with the INPUT and SECOND_INPUT sets of input files: when either set of inputs (1) includes a sample not found in the other, or (2) contains a sample with no observations at any fingerprinting sites, then an error will be logged and the tool will return EXIT_CODE_WHEN_MISMATCH. </li><li> If running in any other running mode: when a group which is being crosschecked does not have any observations at fingerprinting sites, a warning will be logged. </li></ul><br /><br />Note that, as long as there is at least one comparison in which both files have observations at fingerprinting sites, the tool will return a \u2018zero\u2019. However, an error will be logged and the tool will return EXIT_CODE_WHEN_NO_VALID_CHECKS if all comparisons have at least one side without observations at a fingerprinting site (ie. all LOD scores are zero). <br /><br /> <hr/><h3>Examples</h3><h4>Check that all the readgroups from a sample match each other:</h4><pre>    java -jar picard.jar CrosscheckFingerprints \\\n          INPUT=sample.with.many.readgroups.bam \\\n          HAPLOTYPE_MAP=fingerprinting_haplotype_database.txt \\\n          LOD_THRESHOLD=-5 \\\n          OUTPUT=sample.crosscheck_metrics </pre>\n <h4>Check that all the readgroups match as expected when providing reads from two samples from the same individual:</h4> <pre>     java -jar picard.jar CrosscheckFingerprints \\\n           INPUT=sample.one.with.many.readgroups.bam \\\n           INPUT=sample.two.with.many.readgroups.bam \\\n           HAPLOTYPE_MAP=fingerprinting_haplotype_database.txt \\\n           LOD_THRESHOLD=-5 \\\n           EXPECT_ALL_GROUPS_TO_MATCH=true \\\n           OUTPUT=sample.crosscheck_metrics </pre><br /><br /><h4>Detailed Explanation</h4>\nThis tool calculates the LOD score for identity check between \"groups\" of data in the INPUT files as defined by the CROSSCHECK_BY argument. A positive value indicates that the data seems to have come from the same individual or, in other words the identity checks out. The scale is logarithmic (base 10), so a LOD of 6 indicates that it is 1,000,000 more likely that the data matches the genotypes than not. A negative value indicates that the data do not match. A score that is near zero is inconclusive and can result from low coverage or non-informative genotypes. <br /><br />Each group is assigned a sample identifier (for SAM this is taken from the SM tag in the appropriate readgroup header line, for VCF this is taken from the column label in the file-header. After combining all the data from the same group together, an all-against-all comparison is performed. Results are categorized as one of EXPECTED_MATCH, EXPECTED_MISMATCH, UNEXPECTED_MATCH, UNEXPECTED_MISMATCH, or AMBIGUOUS depending on the LOD score and on whether the sample identifiers of the groups agree: LOD scores that are less than LOD_THRESHOLD are considered mismatches, and those greater than -LOD_THRESHOLD are matches (between is ambiguous). If the sample identifiers are equal, the groups are expected to match. They are expected to mismatch otherwise. <br /><br />The identity check makes use of haplotype blocks defined in the HAPLOTYPE_MAP file to enable it to have higher statistical power for detecting identity or swap by aggregating data from several SNPs in the haplotype block. This enables an identity check of samples with very low coverage (e.g. ~1x mean coverage).<br /><br />When provided a VCF, the identity check looks at the PL, GL and GT fields (in that order) and uses the first one that it finds. ", oneLineSummary="Checks that all data in the input files appear to have come from the same individual", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CrosscheckFingerprints
extends CommandLineProgram {
    @Argument(shortName="I", doc="One or more input files (or lists of files) with which to compare fingerprints.", minElements=1)
    public List<String> INPUT;
    @Argument(doc="A tsv with two columns and no header which maps the input files to corresponding indices; to be used when index files are not located next to input files. First column must match the list of inputs. ", optional=true)
    public File INPUT_INDEX_MAP;
    @Argument(doc="A boolean value to determine whether input files should only be parsed if index files are available. Without turning this option on, the tool will need to read through the entirety of input files without index files either provided via the INPUT_INDEX_MAP or locally accessible relative to the input, which significantly increases runtime. If set to true and no index is found for a file, an exception will be thrown. This applies for both the INPUT and SECOND_INPUT files.")
    public boolean REQUIRE_INDEX_FILES = false;
    @Argument(doc="A tsv with two columns representing the sample as it appears in the INPUT data (in column 1) and the sample as it should be used for comparisons to SECOND_INPUT (in the second column). Need only include the samples that change. Values in column 1 should be unique. Values in column 2 should be unique even in union with the remaining unmapped samples. Should only be used with SECOND_INPUT. ", optional=true, mutex={"INPUT_SAMPLE_FILE_MAP"})
    public File INPUT_SAMPLE_MAP;
    @Argument(doc="A tsv with two columns representing the sample as it should be used for comparisons to SECOND_INPUT (in the first column) and  the source file (in INPUT) for the fingerprint (in the second column). Need only to include the samples that change. Values in column 1 should be unique even in union with the remaining unmapped samples. Values in column 2 should be unique in the file. Will error if more than one sample is found in a file (multi-sample VCF) pointed to in column 2. Should only be used in the presence of SECOND_INPUT. ", optional=true, mutex={"INPUT_SAMPLE_MAP"})
    public File INPUT_SAMPLE_FILE_MAP;
    @Argument(shortName="SI", optional=true, mutex={"MATRIX_OUTPUT"}, doc="A second set of input files (or lists of files) with which to compare fingerprints. If this option is provided the tool compares each sample in INPUT with the sample from SECOND_INPUT that has the same sample ID. In addition, data will be grouped by SAMPLE regardless of the value of CROSSCHECK_BY. When operating in this mode, each sample in INPUT must also have a corresponding sample in SECOND_INPUT. If this is violated, the tool will proceed to check the matching samples, but report the missing samples and return a non-zero error-code.")
    public List<String> SECOND_INPUT;
    @Argument(doc="A tsv with two columns and no header which maps the second input files to corresponding indices; to be used when index files are not located next to second input files. First column must match the list of second inputs. ", optional=true)
    public File SECOND_INPUT_INDEX_MAP;
    @Argument(doc="A tsv with two columns representing the sample as it appears in the SECOND_INPUT data (in column 1) and the sample as it should be used for comparisons to INPUT (in the second column). Note that in case of unrolling files (file-of-filenames) one would need to reference the final file, i.e. the file that contains the genomic data. Need only include the samples that change. Values in column 1 should be unique. Values in column 2 should be unique even in union with the remaining unmapped samples. Should only be used with SECOND_INPUT. ", optional=true)
    public File SECOND_INPUT_SAMPLE_MAP;
    @Argument(doc="A tsv with two columns representing the individual with which each sample is associated.  The first column is the sample id, and the second column is the associated individual id.  Values in the first column must be unique. If INPUT_SAMPLE_MAP or SECOND_INPUT_SAMPLE_MAP is also specified, then the values in the first column of this file should be the sample aliases specified in the second columns of INPUT_SAMPLE_MAP and SECOND_INPUT_SAMPLE_MAP, respectively.  When this input is specified, expectations for matches will be based on the equality or inequality of the individual ids associated with two samples, as opposed to the sample ids themselves.  Samples which are not listed in this file will have their sample id used as their individual id, for the purposes of match expectations.  This means that one sample id could be used as the individual id for another sample, but not included in the map itself, and these two samples would be considered to have come from the same individual.  Note that use of this parameter only affects labelling of matches and mismatches as EXPECTED or UNEXPECTED.  It has no affect on how data is grouped for crosschecking.", optional=true)
    public File SAMPLE_INDIVIDUAL_MAP;
    @Argument(doc="An argument that controls how crosschecking with both INPUT and SECOND_INPUT should occur. ")
    public Fingerprint.CrosscheckMode CROSSCHECK_MODE = Fingerprint.CrosscheckMode.CHECK_SAME_SAMPLE;
    @Argument(shortName="O", optional=true, doc="Optional output file to write metrics to. Default is to write to stdout.")
    public File OUTPUT = null;
    @Argument(shortName="MO", optional=true, doc="Optional output file to write matrix of LOD scores to. This is less informative than the metrics output and only contains Normal-Normal LOD score (i.e. doesn't account for Loss of Heterozygosity). It is however sometimes easier to use visually.", mutex={"SECOND_INPUT"})
    public File MATRIX_OUTPUT = null;
    @Argument(shortName="H", doc="The file lists a set of SNPs, optionally arranged in high-LD blocks, to be used for fingerprinting. See https://software.broadinstitute.org/gatk/documentation/article?id=9526 for details.")
    public File HAPLOTYPE_MAP;
    @Argument(shortName="LOD", doc="If any two groups (with the same sample name) match with a LOD score lower than the threshold the tool will exit with a non-zero code to indicate error. Program will also exit with an error if it finds two groups with different sample name that match with a LOD score greater than -LOD_THRESHOLD.\n\nLOD score 0 means equal likelihood that the groups match vs. come from different individuals, negative LOD score -N, mean 10^N time more likely that the groups are from different individuals, and +N means 10^N times more likely that the groups are from the same individual. ")
    public double LOD_THRESHOLD = 0.0;
    @Argument(doc="Specifies which data-type should be used as the basic comparison unit. Fingerprints from readgroups can be \"rolled-up\" to the LIBRARY, SAMPLE, or FILE level before being compared. Fingerprints from VCF can be be compared by SAMPLE or FILE.")
    public CrosscheckMetric.DataType CROSSCHECK_BY = CrosscheckMetric.DataType.READGROUP;
    @Argument(doc="The number of threads to use to process files and generate fingerprints.")
    public int NUM_THREADS = 1;
    @Argument(doc="Specifies whether the Tumor-aware result should be calculated. These are time consuming and can roughly double the runtime of the tool. When crosschecking many groups not calculating the tumor-aware  results can result in a significant speedup.")
    public boolean CALCULATE_TUMOR_AWARE_RESULTS = true;
    @Argument(doc="Allow the use of duplicate reads in performing the comparison. Can be useful when duplicate marking has been overly aggressive and coverage is low.")
    public boolean ALLOW_DUPLICATE_READS = false;
    @Argument(doc="Assumed genotyping error rate that provides a floor on the probability that a genotype comes from the expected sample. Must be greater than zero. ")
    public double GENOTYPING_ERROR_RATE = 0.01;
    @Argument(doc="If true, then only groups that do not relate to each other as expected will have their LODs reported.")
    public boolean OUTPUT_ERRORS_ONLY = false;
    @Argument(doc="The rate at which a heterozygous genotype in a normal sample turns into a homozygous (via loss of heterozygosity) in the tumor (model assumes independent events, so this needs to be larger than reality).", optional=true)
    public double LOSS_OF_HET_RATE = 0.5;
    @Argument(doc="Expect all groups' fingerprints to match, irrespective of their sample names.  By default (with this value set to false), groups (readgroups, libraries, files, or samples) with different sample names are expected to mismatch, and those with the same sample name are expected to match. ")
    public boolean EXPECT_ALL_GROUPS_TO_MATCH = false;
    @Argument(doc="When one or more mismatches between groups is detected, exit with this value instead of 0.")
    public int EXIT_CODE_WHEN_MISMATCH = 1;
    @Argument(doc="When all LOD scores are zero, exit with this value.")
    public int EXIT_CODE_WHEN_NO_VALID_CHECKS = 1;
    @Argument(doc="Maximal effect of any single haplotype block on outcome (-log10 of maximal likelihood difference between the different values for the three possible genotypes).", minValue=0.0)
    public double MAX_EFFECT_OF_EACH_HAPLOTYPE_BLOCK = 3.0;
    @Hidden
    @Argument(doc="When true code will check for readability on input files (this can be slow on cloud access)")
    public boolean TEST_INPUT_READABILITY = true;
    private final Log log = Log.getInstance(CrosscheckFingerprints.class);
    private double[][] crosscheckMatrix = null;
    private final List<String> lhsMatrixKeys = new ArrayList<String>();
    private final List<String> rhsMatrixKeys = new ArrayList<String>();
    private Map<String, String> sampleIndividualMap;

    @Override
    protected String[] customCommandLineValidation() {
        if (this.GENOTYPING_ERROR_RATE <= 0.0) {
            return new String[]{"GENOTYPING_ERROR_RATE must be greater than zero. Found " + this.GENOTYPING_ERROR_RATE};
        }
        if (this.GENOTYPING_ERROR_RATE >= 1.0) {
            return new String[]{"GENOTYPING_ERROR_RATE must be strictly less than 1, found " + this.GENOTYPING_ERROR_RATE};
        }
        if (this.SECOND_INPUT == null && this.INPUT_SAMPLE_MAP != null) {
            return new String[]{"INPUT_SAMPLE_MAP can only be used when also using SECOND_INPUT"};
        }
        if (this.SECOND_INPUT == null && this.SECOND_INPUT_SAMPLE_MAP != null) {
            return new String[]{"SECOND_INPUT_SAMPLE_MAP can only be used when also using SECOND_INPUT"};
        }
        if (this.REFERENCE_SEQUENCE == null) {
            ArrayList<String> allInputs = new ArrayList<String>(this.INPUT);
            allInputs.addAll(this.SECOND_INPUT);
            for (String input : allInputs) {
                if (!input.endsWith(SamReader.Type.CRAM_TYPE.fileExtension())) continue;
                return new String[]{"REFERENCE must be provided when using CRAM as input."};
            }
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected int doWork() {
        int numUnexpected;
        IOUtil.assertFileIsReadable((File)this.HAPLOTYPE_MAP);
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
        }
        if (!this.SECOND_INPUT.isEmpty() && this.CROSSCHECK_MODE == Fingerprint.CrosscheckMode.CHECK_SAME_SAMPLE) {
            this.log.info(new Object[]{"SECOND_INPUT is not empty, and CROSSCHECK_MODE==CHECK_SAME_SAMPLE. NOT doing cross-check. Will only compare each SAMPLE in INPUT against that sample in SECOND_INPUT."});
            if (this.CROSSCHECK_BY != CrosscheckMetric.DataType.SAMPLE) {
                this.log.warn(new Object[]{"CROSSCHECK_BY is not SAMPLE, This doesn't make sense in non-crosscheck mode. Setting CROSSCHECK_BY to SAMPLE."});
                this.CROSSCHECK_BY = CrosscheckMetric.DataType.SAMPLE;
            }
        }
        if (!this.SECOND_INPUT.isEmpty() && this.CROSSCHECK_MODE == Fingerprint.CrosscheckMode.CHECK_ALL_OTHERS) {
            this.log.info(new Object[]{"SECOND_INPUT is not empty, and CROSSCHECK_MODE==CHECK_ALL_OTHERS. Will compare fingerprints from INPUT against all the fingerprints in SECOND_INPUT."});
        }
        if (this.MATRIX_OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.MATRIX_OUTPUT);
        }
        if (this.INPUT_INDEX_MAP != null) {
            IOUtil.assertFileIsReadable((File)this.INPUT_INDEX_MAP);
        }
        if (this.INPUT_SAMPLE_MAP != null) {
            IOUtil.assertFileIsReadable((File)this.INPUT_SAMPLE_MAP);
        }
        if (this.INPUT_SAMPLE_FILE_MAP != null) {
            IOUtil.assertFileIsReadable((File)this.INPUT_SAMPLE_FILE_MAP);
        }
        if (this.SECOND_INPUT_INDEX_MAP != null) {
            IOUtil.assertFileIsReadable((File)this.SECOND_INPUT_INDEX_MAP);
        }
        if (this.SECOND_INPUT_SAMPLE_MAP != null) {
            IOUtil.assertFileIsReadable((File)this.SECOND_INPUT_SAMPLE_MAP);
        }
        if (this.SAMPLE_INDIVIDUAL_MAP != null) {
            IOUtil.assertFileIsReadable((File)this.SAMPLE_INDIVIDUAL_MAP);
        }
        HaplotypeMap map = new HaplotypeMap(this.HAPLOTYPE_MAP);
        FingerprintChecker checker = new FingerprintChecker(map);
        checker.setAllowDuplicateReads(this.ALLOW_DUPLICATE_READS);
        checker.setValidationStringency(this.VALIDATION_STRINGENCY);
        checker.setReferenceFasta(this.REFERENCE_SEQUENCE);
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(SamReader.Type.BAM_TYPE.fileExtension());
        extensions.add(SamReader.Type.SAM_TYPE.fileExtension());
        extensions.add(SamReader.Type.CRAM_TYPE.fileExtension());
        extensions.addAll(FileExtensions.VCF_LIST);
        List inputPaths = IOUtil.getPaths(this.INPUT);
        List unrolledFiles = IOUtil.unrollPaths((Collection)inputPaths, (String[])extensions.toArray(new String[0]));
        if (this.TEST_INPUT_READABILITY) {
            IOUtil.assertPathsAreReadable((List)unrolledFiles);
        }
        Map<Path, Path> indexPathMap = this.INPUT_INDEX_MAP != null ? this.getSamplePathToIndexMap(this.INPUT_INDEX_MAP, "INPUT_INDEX_MAP") : null;
        List secondInputsPaths = IOUtil.getPaths(this.SECOND_INPUT);
        Map<Path, Path> indexPathMap2 = this.SECOND_INPUT_INDEX_MAP != null ? this.getSamplePathToIndexMap(this.SECOND_INPUT_INDEX_MAP, "SECOND_INPUT_INDEX_MAP") : null;
        List unrolledFiles2 = IOUtil.unrollPaths((Collection)secondInputsPaths, (String[])extensions.toArray(new String[0]));
        if (this.TEST_INPUT_READABILITY) {
            IOUtil.assertPathsAreReadable((List)unrolledFiles2);
        }
        this.log.info(new Object[]{"Fingerprinting " + unrolledFiles.size() + " INPUT files."});
        if (this.REQUIRE_INDEX_FILES) {
            this.log.info(new Object[]{"Forcing index files to be present for fingerprinting input files."});
        }
        Map<FingerprintIdDetails, Fingerprint> uncappedFpMap = checker.fingerprintFiles(unrolledFiles, indexPathMap, this.REQUIRE_INDEX_FILES, this.NUM_THREADS, 1, TimeUnit.DAYS);
        Map<FingerprintIdDetails, Fingerprint> fpMap = this.capFingerprints(uncappedFpMap);
        if (this.INPUT_SAMPLE_MAP != null) {
            this.remapFingerprints(fpMap, this.INPUT_SAMPLE_MAP, "INPUT_SAMPLE_MAP");
        }
        if (this.INPUT_SAMPLE_FILE_MAP != null) {
            this.remapFingerprintsFromFiles(fpMap, this.INPUT_SAMPLE_FILE_MAP);
        }
        ArrayList<CrosscheckMetric> metrics = new ArrayList<CrosscheckMetric>();
        if (this.SECOND_INPUT.isEmpty()) {
            this.log.info(new Object[]{"Cross-checking all " + this.CROSSCHECK_BY + " against each other"});
            numUnexpected = this.crossCheckGrouped(fpMap, fpMap, metrics, Fingerprint.getFingerprintIdDetailsStringFunction(this.CROSSCHECK_BY), this.CROSSCHECK_BY);
        } else {
            this.log.info(new Object[]{"Fingerprinting " + unrolledFiles2.size() + " SECOND_INPUT files."});
            if (this.REQUIRE_INDEX_FILES) {
                this.log.info(new Object[]{"Forcing index files to be present for fingerprinting second input files."});
            }
            Map<FingerprintIdDetails, Fingerprint> uncappedFpMap2 = checker.fingerprintFiles(unrolledFiles2, indexPathMap2, this.REQUIRE_INDEX_FILES, this.NUM_THREADS, 1, TimeUnit.DAYS);
            Map<FingerprintIdDetails, Fingerprint> fpMap2 = this.capFingerprints(uncappedFpMap2);
            if (this.SECOND_INPUT_SAMPLE_MAP != null) {
                this.remapFingerprints(fpMap2, this.SECOND_INPUT_SAMPLE_MAP, "SECOND_INPUT_SAMPLE_MAP");
            }
            switch (this.CROSSCHECK_MODE) {
                case CHECK_SAME_SAMPLE: {
                    this.log.info(new Object[]{"Checking each sample in INPUT with the same sample in SECOND_INPUT."});
                    numUnexpected = this.checkFingerprintsBySample(fpMap, fpMap2, metrics);
                    break;
                }
                case CHECK_ALL_OTHERS: {
                    this.log.info(new Object[]{"Checking each " + this.CROSSCHECK_BY + " in INPUT with each " + this.CROSSCHECK_BY + " in SECOND_INPUT."});
                    numUnexpected = this.crossCheckGrouped(fpMap, fpMap2, metrics, Fingerprint.getFingerprintIdDetailsStringFunction(this.CROSSCHECK_BY), this.CROSSCHECK_BY);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unpossible!");
                }
            }
        }
        if (metrics.stream().noneMatch(m -> m.LOD_SCORE != 0.0)) {
            this.log.error(new Object[]{"No non-zero results found. This is likely an error. Probable cause: there are no reads or variants at fingerprinting sites "});
            return this.EXIT_CODE_WHEN_NO_VALID_CHECKS;
        }
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addAllMetrics(metrics);
        if (this.OUTPUT != null) {
            metricsFile.write(this.OUTPUT);
        } else {
            metricsFile.write((Writer)new OutputStreamWriter(System.out));
        }
        if (this.MATRIX_OUTPUT != null) {
            this.writeMatrix();
        }
        if (numUnexpected > 0) {
            this.log.warn(new Object[]{numUnexpected + " " + this.CROSSCHECK_BY + "s did not relate as expected."});
            return this.EXIT_CODE_WHEN_MISMATCH;
        }
        this.log.info(new Object[]{"All " + this.CROSSCHECK_BY + "s are related as expected."});
        return 0;
    }

    private Map<FingerprintIdDetails, Fingerprint> capFingerprints(Map<FingerprintIdDetails, Fingerprint> fpMap) {
        return fpMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Fingerprint value = (Fingerprint)entry.getValue();
            Fingerprint cappedFp = new Fingerprint(value.getSample(), value.getSource(), value.getInfo());
            value.values().stream().map(probabilities -> new CappedHaplotypeProbabilities((HaplotypeProbabilities)probabilities, -this.MAX_EFFECT_OF_EACH_HAPLOTYPE_BLOCK)).forEach(cappedFp::add);
            return cappedFp;
        }));
    }

    private void remapFingerprints(Map<FingerprintIdDetails, Fingerprint> fpMap, File sampleMapFile, String inputFieldName) {
        Map<String, String> sampleMap = this.getStringStringMap(sampleMapFile, inputFieldName);
        Set samplesInFpMap = fpMap.keySet().stream().map(id -> id.sample).collect(Collectors.toSet());
        Set samplesNotInSampleMap = sampleMap.keySet().stream().filter(((Predicate<String>)samplesInFpMap::contains).negate()).collect(Collectors.toSet());
        if (!samplesNotInSampleMap.isEmpty()) {
            this.log.warn(new Object[]{"Some samples in first column in the " + inputFieldName + " were not present as samples in fingerprinted file: [" + String.join((CharSequence)", ", samplesNotInSampleMap) + "]."});
        }
        ArrayList<String> resultingSamples = new ArrayList<String>(samplesInFpMap);
        sampleMap.keySet().forEach(s -> {
            if (resultingSamples.remove(s)) {
                resultingSamples.add((String)sampleMap.get(s));
            }
        });
        if (CollectionUtil.makeSet((Object[])resultingSamples.toArray(new String[0])).size() != resultingSamples.size()) {
            HashSet duplicates = new HashSet();
            HashSet unique = new HashSet();
            resultingSamples.forEach(s -> {
                if (unique.add(s)) {
                    duplicates.add(s);
                }
            });
            throw new IllegalArgumentException("After applying the mapping found in the " + inputFieldName + " the resulting sample names must be unique when taken together with the remaining unmapped samples. Duplicates are: " + Arrays.toString(duplicates.toArray()));
        }
        HashSet<FingerprintIdDetails> ids = new HashSet<FingerprintIdDetails>(fpMap.keySet());
        ids.forEach(id -> {
            if (!sampleMap.containsKey(id.sample)) {
                return;
            }
            Fingerprint fingerprint = (Fingerprint)fpMap.remove(id);
            id.sample = (String)sampleMap.get(id.sample);
            fpMap.put((FingerprintIdDetails)id, fingerprint);
        });
    }

    private void remapFingerprintsFromFiles(Map<FingerprintIdDetails, Fingerprint> fpMap, File sampleMapFile) {
        Map<String, String> sampleMap = this.getStringStringMap(sampleMapFile, "INPUT_SAMPLE_FILE_MAP").entrySet().stream().collect(Collectors.toMap(e -> {
            try {
                return IOUtil.getPath((String)((String)e.getValue())).toUri().toString();
            }
            catch (IOException e1) {
                throw new PicardException("Trouble reading file: " + (String)e.getValue(), e1);
            }
        }, Map.Entry::getKey));
        Set filesInFpMap = fpMap.keySet().stream().map(id -> id.file).collect(Collectors.toSet());
        Set sampleNotInFpMap = sampleMap.keySet().stream().filter(((Predicate<String>)filesInFpMap::contains).negate()).collect(Collectors.toSet());
        if (!sampleNotInFpMap.isEmpty()) {
            this.log.warn(new Object[]{"Some samples from the first column in INPUT_SAMPLE_FILE_MAP were not found: " + Arrays.toString(sampleNotInFpMap.toArray())});
        }
        Map<String, List<FingerprintIdDetails>> fileFpDetailSetMap = fpMap.keySet().stream().collect(Collectors.groupingBy(s -> s.file));
        HashMap<String, String> fileSampleMap = new HashMap<String, String>();
        fileFpDetailSetMap.forEach((key, fingerprintIdDetails) -> {
            Set samples = fingerprintIdDetails.stream().map(id -> id.sample).collect(Collectors.toSet());
            if (samples.size() > 1) {
                throw new IllegalArgumentException("fingerprinting file (" + key + "in INPUT_SAMPLE_FILE_MAP contains multiple samples: " + String.join((CharSequence)"", samples));
            }
            fileSampleMap.put((String)key, ((FingerprintIdDetails)fingerprintIdDetails.get((int)0)).sample);
        });
        ArrayList<String> resultingSamples = new ArrayList<String>(filesInFpMap);
        fileSampleMap.forEach((f, id) -> {
            if (resultingSamples.remove(id)) {
                resultingSamples.add((String)sampleMap.get(f));
            }
        });
        if (CollectionUtil.makeSet((Object[])resultingSamples.toArray(new String[0])).size() != resultingSamples.size()) {
            HashSet duplicates = new HashSet();
            HashSet unique = new HashSet();
            resultingSamples.forEach(s -> {
                if (unique.add(s)) {
                    duplicates.add(s);
                }
            });
            throw new IllegalArgumentException("After applying the mapping found in the INPUT_SAMPLE_FILE_MAP the resulting sample names must be unique when taken together with the remaining unmapped samples. Duplicates are: " + Arrays.toString(duplicates.toArray()));
        }
        HashSet<FingerprintIdDetails> ids = new HashSet<FingerprintIdDetails>(fpMap.keySet());
        ids.forEach(id -> {
            if (!sampleMap.containsKey(id.file)) {
                return;
            }
            Fingerprint fingerprint = (Fingerprint)fpMap.remove(id);
            id.sample = (String)sampleMap.get(id.file);
            fpMap.put((FingerprintIdDetails)id, fingerprint);
        });
    }

    private Map<String, String> getStringStringMap(File sampleMapFile, String inputFieldName) {
        LinkedHashMap<String, String> sampleMap = new LinkedHashMap<String, String>();
        TabbedInputParser parser = new TabbedInputParser(false, sampleMapFile);
        for (Object[] strings : parser) {
            if (strings.length != 2) {
                throw new IllegalArgumentException("Each line of the " + inputFieldName + " must have exactly two strings separated by a tab. Found: [" + Arrays.toString(strings) + "] right before [" + parser.getCurrentLine() + "], in " + sampleMapFile.getAbsolutePath());
            }
            if (sampleMap.containsKey(strings[0])) {
                throw new IllegalArgumentException("Strings in first column of the " + inputFieldName + " must be unique. found [" + (String)strings[0] + "] twice. Right before [" + parser.getCurrentLine() + "] in " + sampleMapFile.getAbsolutePath());
            }
            sampleMap.put((String)strings[0], (String)strings[1]);
        }
        return sampleMap;
    }

    private Map<Path, Path> getSamplePathToIndexMap(File indexMapFile, String inputArgumentName) {
        Map<String, String> indexStringMap = this.getStringStringMap(indexMapFile, inputArgumentName);
        LinkedHashMap<Path, Path> indexPathMap = new LinkedHashMap<Path, Path>();
        for (Map.Entry<String, String> entry : indexStringMap.entrySet()) {
            Path indexPath;
            Path inputPath;
            try {
                inputPath = IOUtil.getPath((String)entry.getKey());
            }
            catch (IOException e) {
                throw new PicardException("Trouble reading file: " + entry.getKey() + " for argument " + inputArgumentName, e);
            }
            try {
                indexPath = IOUtil.getPath((String)entry.getValue());
            }
            catch (IOException e) {
                throw new PicardException("Trouble reading index file: " + entry.getValue() + " for argument " + inputArgumentName, e);
            }
            indexPathMap.put(inputPath, indexPath);
        }
        return indexPathMap;
    }

    private void writeMatrix() {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(4);
        try (FileOutputStream stream = new FileOutputStream(this.MATRIX_OUTPUT);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));){
            writer.write(this.CROSSCHECK_BY.name());
            for (String rhsMatrixKey : this.rhsMatrixKeys) {
                writer.write("\t" + rhsMatrixKey);
            }
            writer.newLine();
            for (int row = 0; row < this.lhsMatrixKeys.size(); ++row) {
                writer.write(this.lhsMatrixKeys.get(row));
                for (double lod : this.crosscheckMatrix[row]) {
                    writer.write("\t" + format.format(lod));
                }
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int crossCheckGrouped(Map<FingerprintIdDetails, Fingerprint> lhsFingerprints, Map<FingerprintIdDetails, Fingerprint> rhsFingerprints, List<CrosscheckMetric> metrics, Function<FingerprintIdDetails, String> by, CrosscheckMetric.DataType type) {
        Map<FingerprintIdDetails, Fingerprint> lhsFingerprintsByGroup = Fingerprint.mergeFingerprintsBy(lhsFingerprints, by);
        Map<FingerprintIdDetails, Fingerprint> rhsFingerprintsByGroup = Fingerprint.mergeFingerprintsBy(rhsFingerprints, by);
        for (Map.Entry<FingerprintIdDetails, Fingerprint> pair : lhsFingerprintsByGroup.entrySet()) {
            if (pair.getValue().size() != 0) continue;
            this.log.warn(new Object[]{by.apply(pair.getKey()) + " was not fingerprinted in LEFT group.  It probably has no calls/reads overlapping fingerprinting sites."});
        }
        for (Map.Entry<FingerprintIdDetails, Fingerprint> pair : rhsFingerprintsByGroup.entrySet()) {
            if (pair.getValue().size() != 0) continue;
            this.log.warn(new Object[]{by.apply(pair.getKey()) + " was not fingerprinted in RIGHT group.  It probably has no calls/reads overlapping fingerprinting sites."});
        }
        if (this.MATRIX_OUTPUT != null) {
            this.crosscheckMatrix = new double[lhsFingerprintsByGroup.size()][];
            for (int row = 0; row < lhsFingerprintsByGroup.size(); ++row) {
                this.crosscheckMatrix[row] = new double[rhsFingerprintsByGroup.size()];
            }
            lhsFingerprintsByGroup.keySet().forEach(k -> this.lhsMatrixKeys.add(k.group));
            rhsFingerprintsByGroup.keySet().forEach(k -> this.rhsMatrixKeys.add(k.group));
        }
        return this.crossCheckFingerprints(lhsFingerprintsByGroup, rhsFingerprintsByGroup, type, metrics);
    }

    private int crossCheckFingerprints(Map<FingerprintIdDetails, Fingerprint> lhsFingerprints, Map<FingerprintIdDetails, Fingerprint> rhsFingerprints, CrosscheckMetric.DataType type, List<CrosscheckMetric> metrics) {
        int unexpectedResults = 0;
        long checksMade = 0L;
        int logEvery = 100000;
        ArrayList<FingerprintIdDetails> lhsFingerprintIdDetails = new ArrayList<FingerprintIdDetails>(lhsFingerprints.keySet());
        ArrayList<FingerprintIdDetails> rhsFingerprintIdDetails = new ArrayList<FingerprintIdDetails>(rhsFingerprints.keySet());
        long totalChecks = (long)lhsFingerprintIdDetails.size() * (long)rhsFingerprintIdDetails.size();
        if (this.SAMPLE_INDIVIDUAL_MAP != null) {
            ArrayList<FingerprintIdDetails> allFingerprintIdDetails = new ArrayList<FingerprintIdDetails>(lhsFingerprintIdDetails);
            allFingerprintIdDetails.addAll(rhsFingerprintIdDetails);
            Set<String> inputSamples = allFingerprintIdDetails.stream().map(id -> id.sample).collect(Collectors.toSet());
            this.sampleIndividualMap = this.buildSampleIndividualsMap(this.SAMPLE_INDIVIDUAL_MAP, inputSamples);
        }
        for (int row = 0; row < lhsFingerprintIdDetails.size(); ++row) {
            FingerprintIdDetails lhsId = (FingerprintIdDetails)lhsFingerprintIdDetails.get(row);
            for (int col = 0; col < rhsFingerprintIdDetails.size(); ++col) {
                FingerprintIdDetails rhsId = (FingerprintIdDetails)rhsFingerprintIdDetails.get(col);
                String lhsMatchId = this.resolveIndividualIfPossible(lhsId.sample);
                String rhsMatchId = this.resolveIndividualIfPossible(rhsId.sample);
                boolean expectedToMatch = this.EXPECT_ALL_GROUPS_TO_MATCH || lhsMatchId.equals(rhsMatchId);
                MatchResults results = FingerprintChecker.calculateMatchResults(lhsFingerprints.get(lhsId), rhsFingerprints.get(rhsId), this.GENOTYPING_ERROR_RATE, this.LOSS_OF_HET_RATE, false, this.CALCULATE_TUMOR_AWARE_RESULTS);
                CrosscheckMetric.FingerprintResult result = this.getMatchResults(expectedToMatch, results);
                if (!this.OUTPUT_ERRORS_ONLY || result == CrosscheckMetric.FingerprintResult.INCONCLUSIVE || !result.isExpected().booleanValue()) {
                    metrics.add(this.getMatchDetails(result, results, lhsId, rhsId, type));
                }
                if (result != CrosscheckMetric.FingerprintResult.INCONCLUSIVE && !result.isExpected().booleanValue()) {
                    ++unexpectedResults;
                }
                if (this.crosscheckMatrix != null) {
                    this.crosscheckMatrix[row][col] = results.getLOD();
                }
                if (++checksMade % 100000L != 0L) continue;
                this.log.info(new Object[]{"Compared " + checksMade + " of " + totalChecks});
            }
        }
        return unexpectedResults;
    }

    private int checkFingerprintsBySample(Map<FingerprintIdDetails, Fingerprint> fingerprints1, Map<FingerprintIdDetails, Fingerprint> fingerprints2, List<CrosscheckMetric> metrics) {
        int unexpectedResults = 0;
        Map<FingerprintIdDetails, Fingerprint> fingerprints1BySample = Fingerprint.mergeFingerprintsBy(fingerprints1, Fingerprint.getFingerprintIdDetailsStringFunction(CrosscheckMetric.DataType.SAMPLE));
        Map<FingerprintIdDetails, Fingerprint> fingerprints2BySample = Fingerprint.mergeFingerprintsBy(fingerprints2, Fingerprint.getFingerprintIdDetailsStringFunction(CrosscheckMetric.DataType.SAMPLE));
        Map<String, FingerprintIdDetails> sampleToDetail1 = fingerprints1BySample.keySet().stream().collect(Collectors.toMap(id -> id.group, id -> id));
        Map<String, FingerprintIdDetails> sampleToDetail2 = fingerprints2BySample.keySet().stream().collect(Collectors.toMap(id -> id.group, id -> id));
        HashSet<String> samples = new HashSet<String>();
        samples.addAll(sampleToDetail1.keySet());
        samples.addAll(sampleToDetail2.keySet());
        for (String sample : samples) {
            FingerprintIdDetails lhsID = sampleToDetail1.get(sample);
            FingerprintIdDetails rhsID = sampleToDetail2.get(sample);
            if (lhsID == null || rhsID == null) {
                this.log.error(new Object[]{String.format("sample %s is missing from %s group", sample, lhsID == null ? "LEFT" : "RIGHT")});
                ++unexpectedResults;
                continue;
            }
            Fingerprint lhsFP = fingerprints1BySample.get(lhsID);
            Fingerprint rhsFP = fingerprints2BySample.get(rhsID);
            if (lhsFP.size() == 0 || rhsFP.size() == 0) {
                this.log.error(new Object[]{String.format("sample %s from %s group was not fingerprinted.  Probably there are no reads/variants at fingerprinting sites.", sample, lhsFP.size() == 0 ? "LEFT" : "RIGHT")});
                ++unexpectedResults;
            }
            MatchResults results = FingerprintChecker.calculateMatchResults(lhsFP, rhsFP, this.GENOTYPING_ERROR_RATE, this.LOSS_OF_HET_RATE, false, this.CALCULATE_TUMOR_AWARE_RESULTS);
            CrosscheckMetric.FingerprintResult result = this.getMatchResults(true, results);
            if (!this.OUTPUT_ERRORS_ONLY || !result.isExpected().booleanValue()) {
                metrics.add(this.getMatchDetails(result, results, lhsID, rhsID, CrosscheckMetric.DataType.SAMPLE));
            }
            if (result != CrosscheckMetric.FingerprintResult.INCONCLUSIVE && !result.isExpected().booleanValue()) {
                ++unexpectedResults;
            }
            if (results.getLOD() != 0.0) continue;
            this.log.error(new Object[]{"LOD score of zero found when checking sample fingerprints.  Probably there are no reads/variants at fingerprinting sites for one of the samples"});
            ++unexpectedResults;
        }
        return unexpectedResults;
    }

    private CrosscheckMetric getMatchDetails(CrosscheckMetric.FingerprintResult matchResult, MatchResults results, FingerprintIdDetails leftPuDetails, FingerprintIdDetails rightPuDetails, CrosscheckMetric.DataType type) {
        CrosscheckMetric metric = new CrosscheckMetric();
        metric.LEFT_GROUP_VALUE = leftPuDetails.group;
        metric.RIGHT_GROUP_VALUE = rightPuDetails.group;
        metric.RESULT = matchResult;
        metric.LOD_SCORE = results.getLOD();
        metric.LOD_SCORE_TUMOR_NORMAL = results.getLodTN();
        metric.LOD_SCORE_NORMAL_TUMOR = results.getLodNT();
        metric.DATA_TYPE = type;
        metric.LEFT_RUN_BARCODE = leftPuDetails.runBarcode;
        metric.LEFT_LANE = leftPuDetails.runLane;
        metric.LEFT_MOLECULAR_BARCODE_SEQUENCE = leftPuDetails.molecularBarcode;
        metric.LEFT_LIBRARY = leftPuDetails.library;
        metric.LEFT_SAMPLE = leftPuDetails.sample;
        metric.LEFT_FILE = leftPuDetails.file;
        metric.RIGHT_RUN_BARCODE = rightPuDetails.runBarcode;
        metric.RIGHT_LANE = rightPuDetails.runLane;
        metric.RIGHT_MOLECULAR_BARCODE_SEQUENCE = rightPuDetails.molecularBarcode;
        metric.RIGHT_LIBRARY = rightPuDetails.library;
        metric.RIGHT_SAMPLE = rightPuDetails.sample;
        metric.RIGHT_FILE = rightPuDetails.file;
        return metric;
    }

    private CrosscheckMetric.FingerprintResult getMatchResults(boolean expectedToMatch, MatchResults results) {
        if (expectedToMatch) {
            if (results.getLOD() < this.LOD_THRESHOLD) {
                return CrosscheckMetric.FingerprintResult.UNEXPECTED_MISMATCH;
            }
            if (results.getLOD() > -this.LOD_THRESHOLD) {
                return CrosscheckMetric.FingerprintResult.EXPECTED_MATCH;
            }
            return CrosscheckMetric.FingerprintResult.INCONCLUSIVE;
        }
        if (results.getLOD() > -this.LOD_THRESHOLD) {
            return CrosscheckMetric.FingerprintResult.UNEXPECTED_MATCH;
        }
        if (results.getLOD() < this.LOD_THRESHOLD) {
            return CrosscheckMetric.FingerprintResult.EXPECTED_MISMATCH;
        }
        return CrosscheckMetric.FingerprintResult.INCONCLUSIVE;
    }

    private String resolveIndividualIfPossible(String sampleID) {
        if (this.sampleIndividualMap != null) {
            return this.sampleIndividualMap.getOrDefault(sampleID, sampleID);
        }
        return sampleID;
    }

    private Map<String, String> buildSampleIndividualsMap(File sampleIndividualMapFile, Set<String> sampleIDsInput) {
        if (this.SAMPLE_INDIVIDUAL_MAP != null) {
            Map<String, String> individualMap = this.getStringStringMap(sampleIndividualMapFile, "SAMPLE_INDIVIDUAL_MAP");
            for (String individualID : individualMap.values()) {
                if (!sampleIDsInput.contains(individualID)) continue;
                this.log.warn(new Object[]{"Sample " + individualID + " is used as an individual ID in " + sampleIndividualMapFile});
            }
            for (String sampleId : sampleIDsInput) {
                if (individualMap.keySet().contains(sampleId)) continue;
                this.log.warn(new Object[]{"Sample " + sampleId + " in input data not found in " + sampleIndividualMapFile});
            }
            for (String sampleId : individualMap.keySet()) {
                if (sampleIDsInput.contains(sampleId)) continue;
                this.log.warn(new Object[]{"Sample " + sampleId + " in " + sampleIndividualMapFile + " not found in input data"});
            }
            return individualMap;
        }
        return null;
    }
}

