/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import picard.PicardException;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;

public class FingerprintUtils {
    public static void writeFingerPrint(Fingerprint fingerprint, File outputFile, File referenceSequenceFileName, String sample, String source) throws IOException {
        try (ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)referenceSequenceFileName);
             VariantContextWriter variantContextWriter = FingerprintUtils.getVariantContextWriter(outputFile, referenceSequenceFileName, sample, source, ref);){
            FingerprintUtils.createVCSetFromFingerprint(fingerprint, ref, sample).forEach(arg_0 -> ((VariantContextWriter)variantContextWriter).add(arg_0));
        }
    }

    private static VariantContextWriter getVariantContextWriter(File outputFile, File referenceSequenceFileName, String sample, String source, ReferenceSequenceFile ref) {
        VariantContextWriter variantContextWriter = new VariantContextWriterBuilder().setReferenceDictionary(ref.getSequenceDictionary()).setOutputFile(outputFile).build();
        LinkedHashSet<Object> lines = new LinkedHashSet<Object>();
        lines.add(new VCFHeaderLine("reference", referenceSequenceFileName.getAbsolutePath()));
        lines.add(new VCFHeaderLine("source", source));
        lines.add(new VCFHeaderLine("fileDate", new Date().toString()));
        lines.add(VCFStandardHeaderLines.getFormatLine((String)"PL"));
        lines.add(VCFStandardHeaderLines.getFormatLine((String)"AD"));
        lines.add(VCFStandardHeaderLines.getFormatLine((String)"DP"));
        VCFHeader header = new VCFHeader(lines, Collections.singletonList(sample));
        header.setSequenceDictionary(ref.getSequenceDictionary());
        variantContextWriter.writeHeader(header);
        return variantContextWriter;
    }

    public static VariantContextSet createVCSetFromFingerprint(Fingerprint fingerPrint, ReferenceSequenceFile reference, String sample) {
        VariantContextSet variantContexts = new VariantContextSet(reference.getSequenceDictionary());
        fingerPrint.values().stream().map(hp -> hp.getRepresentativeSnp().getName()).filter(Objects::nonNull).filter(n -> !n.equals("")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).findFirst().ifPresent(e -> {
            throw new IllegalArgumentException("Found same SNP name twice (" + (String)e.getKey() + ") in fingerprint. Cannot create a VCF.");
        });
        fingerPrint.values().stream().map(hp -> FingerprintUtils.getVariantContext(reference, sample, hp)).forEach(variantContexts::add);
        return variantContexts;
    }

    @VisibleForTesting
    static VariantContext getVariantContext(ReferenceSequenceFile reference, String sample, HaplotypeProbabilities haplotypeProbabilities) {
        int obsAlt;
        int obsRef;
        Allele alleleAlt;
        Allele alleleRef;
        boolean swap12;
        Snp snp = haplotypeProbabilities.getRepresentativeSnp();
        byte refAllele = StringUtil.toUpperCase((byte)reference.getSubsequenceAt(snp.getChrom(), (long)snp.getPos(), (long)snp.getPos()).getBases()[0]);
        if (snp.getAllele1() != refAllele && snp.getAllele2() != refAllele) {
            throw new PicardException("Don't know how to deal with missing reference allele in fingerprinting map");
        }
        boolean bl = swap12 = snp.getAllele2() == refAllele;
        if (swap12) {
            alleleRef = Allele.create((byte)snp.getAllele2(), (boolean)true);
            alleleAlt = Allele.create((byte)snp.getAllele1(), (boolean)false);
            obsRef = haplotypeProbabilities.getObsAllele2();
            obsAlt = haplotypeProbabilities.getObsAllele1();
        } else {
            alleleRef = Allele.create((byte)snp.getAllele1(), (boolean)true);
            alleleAlt = Allele.create((byte)snp.getAllele2(), (boolean)false);
            obsRef = haplotypeProbabilities.getObsAllele1();
            obsAlt = haplotypeProbabilities.getObsAllele2();
        }
        double[] origGLs = haplotypeProbabilities.getLogLikelihoods();
        double[] GLs = Arrays.copyOf(origGLs, origGLs.length);
        if (swap12) {
            ArrayUtils.reverse((double[])GLs);
        }
        List<Allele> alleles = Arrays.asList(alleleRef, alleleAlt);
        Genotype gt = new GenotypeBuilder().DP(haplotypeProbabilities.getTotalObs()).noAttributes().PL(GLs).AD(new int[]{obsRef, obsAlt}).name(sample).make();
        try {
            return new VariantContextBuilder(snp.getName(), snp.getChrom(), (long)snp.getPos(), (long)snp.getPos(), alleles).log10PError(1.0).genotypes(new Genotype[]{gt}).unfiltered().make();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Trouble creating variant at %s-%d", snp.getChrom(), snp.getPos()), e);
        }
    }

    public static class VariantContextSet
    extends TreeSet<VariantContext> {
        VariantContextSet(SAMSequenceDictionary dict) {
            super((lhs, rhs) -> {
                int rhsContig;
                int lhsContig = dict.getSequenceIndex(lhs.getContig());
                int retval = lhsContig - (rhsContig = dict.getSequenceIndex(rhs.getContig()));
                if (retval != 0) {
                    return retval;
                }
                return lhs.getStart() - rhs.getStart();
            });
        }
    }
}

