/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeMap;
import picard.fingerprint.Snp;

@CommandLineProgramProperties(summary="Lifts over a haplotype database from one reference to another. Based on UCSC liftOver.\n Uses a UCSC chain file to guide the liftOver.", oneLineSummary="Lifts over a haplotype database from one reference to another", programGroup=DiagnosticsAndQCProgramGroup.class)
public class LiftOverHaplotypeMap
extends CommandLineProgram {
    @Argument(doc="Haplotype database to be lifted over.", shortName="I")
    public File INPUT;
    @Argument(doc="Where to write lifted-over haplotype database.", shortName="O")
    public File OUTPUT;
    @Argument(doc="Sequence dictionary to write into the output haplotype database. (Any file from which a dictionary is extractable.)", shortName="SD")
    public File SEQUENCE_DICTIONARY;
    @Argument(doc="Chain file that guides LiftOver. (UCSC format)")
    public File CHAIN;
    public static final int LIFTOVER_FAILED_FOR_ONE_OR_MORE_SNPS = 101;
    private static final Log log = Log.getInstance(LiftOverHaplotypeMap.class);

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        LiftOver liftOver = new LiftOver(this.CHAIN);
        HaplotypeMap fromMap = new HaplotypeMap(this.INPUT);
        SAMSequenceDictionary dict = SAMSequenceDictionaryExtractor.extractDictionary((File)this.SEQUENCE_DICTIONARY);
        liftOver.validateToSequences(dict);
        SAMFileHeader newHeader = new SAMFileHeader(dict);
        HaplotypeMap toMap = new HaplotypeMap(newHeader);
        boolean anyFailed = false;
        for (HaplotypeBlock fromHaplotypeBlock : fromMap.getHaplotypes()) {
            HaplotypeBlock toHaplotypeBlock = new HaplotypeBlock(fromHaplotypeBlock.getMaf());
            for (Snp snp : fromHaplotypeBlock.getSnps()) {
                Interval interval = liftOver.liftOver(new Interval(snp.getChrom(), snp.getPos(), snp.getPos()));
                if (interval != null) {
                    toHaplotypeBlock.addSnp(new Snp(snp.getName(), interval.getContig(), interval.getStart(), snp.getAllele1(), snp.getAllele2(), snp.getMaf(), snp.getFingerprintPanels()));
                    continue;
                }
                anyFailed = true;
                log.warn(new Object[]{"Liftover failed for ", snp.getName(), "(", snp.getChrom(), ":", snp.getPos(), ")"});
            }
            toMap.addHaplotype(toHaplotypeBlock);
        }
        toMap.writeToFile(this.OUTPUT);
        return anyFailed ? 101 : 0;
    }
}

