/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.io.AsyncWriterPool;
import htsjdk.io.Writer;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import picard.PicardException;
import picard.illumina.BarcodeExtractor;
import picard.illumina.BarcodeMetric;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.ThreadPoolExecutorWithExceptions;

public abstract class BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    public static final Set<IlluminaDataType> DATA_TYPES_WITH_BARCODE = new HashSet<IlluminaDataType>(Arrays.asList(IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF, IlluminaDataType.Barcodes));
    public static final Set<IlluminaDataType> DATA_TYPES_WITHOUT_BARCODE = new HashSet<IlluminaDataType>(Arrays.asList(IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF));
    protected final IlluminaDataProviderFactory[] laneFactories;
    protected final boolean demultiplex;
    protected final boolean ignoreUnexpectedBarcodes;
    protected final Map<String, ? extends Writer<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap;
    protected final boolean includeNonPfReads;
    protected final AsyncWriterPool writerPool;
    protected ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter = null;
    protected List<Integer> tiles;
    protected BarcodeExtractor barcodeExtractor;
    public static final Comparator<Integer> TILE_NUMBER_COMPARATOR = (integer1, integer2) -> {
        String s1 = integer1.toString();
        String s2 = integer2.toString();
        if (s1.length() < s2.length()) {
            if (s2.startsWith(s1)) {
                return 1;
            }
        } else if (s2.length() < s1.length() && s1.startsWith(s2)) {
            return -1;
        }
        return s1.compareTo(s2);
    };

    public BasecallsConverter(File basecallsDir, File barcodesDir, int[] lanes, ReadStructure readStructure, Map<String, ? extends Writer<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, Integer firstTile, Integer tileLimit, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean ignoreUnexpectedBarcodes, boolean applyEamssFiltering, boolean includeNonPfReads, AsyncWriterPool writerPool, BarcodeExtractor barcodeExtractor) {
        this.barcodeRecordWriterMap = barcodeRecordWriterMap;
        this.ignoreUnexpectedBarcodes = ignoreUnexpectedBarcodes;
        this.demultiplex = demultiplex;
        this.barcodeExtractor = barcodeExtractor;
        this.writerPool = writerPool;
        this.laneFactories = new IlluminaDataProviderFactory[lanes.length];
        for (int i = 0; i < lanes.length; ++i) {
            this.laneFactories[i] = new IlluminaDataProviderFactory(basecallsDir, barcodesDir, lanes[i], readStructure, bclQualityEvaluationStrategy, BasecallsConverter.getDataTypesFromReadStructure(readStructure, demultiplex, barcodesDir));
            this.laneFactories[i].setApplyEamssFiltering(applyEamssFiltering);
        }
        this.includeNonPfReads = includeNonPfReads;
        TreeSet<Integer> allTiles = new TreeSet<Integer>(TILE_NUMBER_COMPARATOR);
        for (IlluminaDataProviderFactory laneFactory : this.laneFactories) {
            allTiles.addAll(laneFactory.getAvailableTiles());
        }
        this.tiles = new ArrayList<Integer>(allTiles);
        this.setTileLimits(firstTile, tileLimit);
    }

    public abstract void processTilesAndWritePerSampleOutputs(Set<String> var1) throws IOException;

    public void closeWriters() throws IOException {
        if (this.writerPool != null) {
            this.writerPool.close();
        } else {
            for (Writer<CLUSTER_OUTPUT_RECORD> writer : this.barcodeRecordWriterMap.values()) {
                writer.close();
            }
        }
    }

    public static File[] getTiledFiles(File baseDirectory, Pattern pattern) {
        return IOUtil.getFilesMatchingRegexp((File)baseDirectory, (Pattern)pattern);
    }

    protected static Set<IlluminaDataType> getDataTypesFromReadStructure(ReadStructure readStructure, boolean demultiplex, File barcodesDir) {
        if (!readStructure.hasSampleBarcode() || !demultiplex || barcodesDir == null) {
            return DATA_TYPES_WITHOUT_BARCODE;
        }
        return DATA_TYPES_WITH_BARCODE;
    }

    protected IlluminaDataProviderFactory[] getLaneFactories() {
        return this.laneFactories;
    }

    protected void setConverter(ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter) {
        this.converter = converter;
    }

    protected void setTileLimits(Integer firstTile, Integer tileLimit) {
        if (firstTile != null) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (this.tiles.get(i).intValue() != firstTile.intValue()) continue;
                this.tiles = this.tiles.subList(i, this.tiles.size());
                break;
            }
            if (this.tiles.get(0).intValue() != firstTile.intValue()) {
                throw new PicardException("firstTile=" + firstTile + ", but that tile was not found.");
            }
        }
        if (tileLimit != null && this.tiles.size() > tileLimit) {
            this.tiles = this.tiles.subList(0, tileLimit);
        }
    }

    protected String maybeDemultiplex(ClusterData cluster, Map<String, BarcodeMetric> metrics, BarcodeMetric noMatch, ReadStructure outputReadStructure) {
        String barcode = null;
        if (this.demultiplex) {
            if (this.barcodeExtractor != null) {
                int[] barcodeIndices = outputReadStructure.sampleBarcodes.getIndices();
                byte[][] readSubsequences = new byte[barcodeIndices.length][];
                byte[][] qualityScores = new byte[barcodeIndices.length][];
                for (int i = 0; i < barcodeIndices.length; ++i) {
                    ReadData barcodeRead = cluster.getRead(barcodeIndices[i]);
                    readSubsequences[i] = barcodeRead.getBases();
                    qualityScores[i] = barcodeRead.getQualities();
                }
                BarcodeExtractor.BarcodeMatch match = this.barcodeExtractor.findBestBarcode(readSubsequences, qualityScores, true);
                BarcodeExtractor.updateMetrics(match, cluster.isPf(), metrics, noMatch);
                if (match.isMatched()) {
                    barcode = match.getBarcode();
                }
                cluster.setMatchedBarcode(barcode);
            } else {
                barcode = cluster.getMatchedBarcode();
            }
        }
        return barcode;
    }

    protected void interruptAndShutdownExecutors(ThreadPoolExecutorWithExceptions ... executors) {
        int tasksRunning = Arrays.stream(executors).mapToInt(test -> test.shutdownNow().size()).sum();
        String errorMessages = Arrays.stream(executors).map(e -> {
            if (e.exception != null) {
                return e.exception.toString();
            }
            return "";
        }).collect(Collectors.joining(","));
        throw new PicardException("Exceptions in tile processing. There were " + tasksRunning + " tasks still running or queued and they have been cancelled. Errors: " + errorMessages);
    }

    protected synchronized void updateMetrics(Map<String, BarcodeMetric> metrics, BarcodeMetric noMatch) {
        if (this.barcodeExtractor != null) {
            for (String key : metrics.keySet()) {
                this.barcodeExtractor.getMetrics().get(key).merge(metrics.get(key));
            }
            this.barcodeExtractor.getNoMatchMetric().merge(noMatch);
        }
    }

    protected static interface ClusterDataConverter<OUTPUT_RECORD> {
        public OUTPUT_RECORD convertClusterToOutputRecord(ClusterData var1);
    }

    protected static interface ConvertedClusterDataWriter<OUTPUT_RECORD>
    extends Writer<OUTPUT_RECORD> {
        public void write(OUTPUT_RECORD var1);

        public void close();
    }
}

