/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import picard.util.AdapterPair;

class CustomAdapterPair
implements AdapterPair {
    private final String fivePrime;
    private final String threePrime;
    private final String fivePrimeReadOrder;
    private final byte[] fivePrimeBytes;
    private final byte[] threePrimeBytes;
    private final byte[] fivePrimeReadOrderBytes;

    CustomAdapterPair(String fivePrime, String threePrime) {
        this.threePrime = threePrime;
        this.threePrimeBytes = StringUtil.stringToBytes((String)threePrime);
        this.fivePrime = fivePrime;
        this.fivePrimeReadOrder = SequenceUtil.reverseComplement((String)fivePrime);
        this.fivePrimeBytes = StringUtil.stringToBytes((String)fivePrime);
        this.fivePrimeReadOrderBytes = StringUtil.stringToBytes((String)this.fivePrimeReadOrder);
    }

    @Override
    public String get3PrimeAdapter() {
        return this.threePrime;
    }

    @Override
    public String get5PrimeAdapter() {
        return this.fivePrime;
    }

    @Override
    public String get3PrimeAdapterInReadOrder() {
        return this.threePrime;
    }

    @Override
    public String get5PrimeAdapterInReadOrder() {
        return this.fivePrimeReadOrder;
    }

    @Override
    public byte[] get3PrimeAdapterBytes() {
        return this.threePrimeBytes;
    }

    @Override
    public byte[] get5PrimeAdapterBytes() {
        return this.fivePrimeBytes;
    }

    @Override
    public byte[] get3PrimeAdapterBytesInReadOrder() {
        return this.threePrimeBytes;
    }

    @Override
    public byte[] get5PrimeAdapterBytesInReadOrder() {
        return this.fivePrimeReadOrderBytes;
    }

    @Override
    public String getName() {
        return "Custom adapter pair";
    }
}

