/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.io.AsyncWriterPool;
import htsjdk.io.Writer;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import picard.PicardException;
import picard.illumina.BarcodeExtractor;
import picard.illumina.BarcodeMetric;
import picard.illumina.BasecallsConverter;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.ThreadPoolExecutorUtil;
import picard.util.ThreadPoolExecutorWithExceptions;

public class SortedBasecallsConverter<CLUSTER_OUTPUT_RECORD>
extends BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    protected static final Log log = Log.getInstance(SortedBasecallsConverter.class);
    private final Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator;
    private final SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype;
    private final Class<CLUSTER_OUTPUT_RECORD> outputRecordClass;
    private final int maxReadsInRamPerTile;
    private final List<File> tmpDirs;
    private final Map<Integer, List<? extends Runnable>> completedWork = new ConcurrentHashMap<Integer, List<? extends Runnable>>();
    private final ThreadPoolExecutorWithExceptions tileReadExecutor;
    private final ProgressLogger readProgressLogger = new ProgressLogger(log, 1000000, "Read");
    private final ProgressLogger writeProgressLogger = new ProgressLogger(log, 1000000, "Write");
    private final Integer numThreads;

    protected SortedBasecallsConverter(File basecallsDir, File barcodesDir, int[] lanes, ReadStructure readStructure, Map<String, ? extends Writer<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int maxReadsInRamPerTile, List<File> tmpDirs, int numThreads, Integer firstTile, Integer tileLimit, Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean ignoreUnexpectedBarcodes, boolean applyEamssFiltering, boolean includeNonPfReads, AsyncWriterPool writerPool, BarcodeExtractor barcodeExtractor) {
        super(basecallsDir, barcodesDir, lanes, readStructure, barcodeRecordWriterMap, demultiplex, firstTile, tileLimit, bclQualityEvaluationStrategy, ignoreUnexpectedBarcodes, applyEamssFiltering, includeNonPfReads, writerPool, barcodeExtractor);
        this.tmpDirs = tmpDirs;
        this.maxReadsInRamPerTile = maxReadsInRamPerTile;
        this.codecPrototype = codecPrototype;
        this.outputRecordComparator = outputRecordComparator;
        this.outputRecordClass = outputRecordClass;
        this.numThreads = numThreads;
        this.tileReadExecutor = new ThreadPoolExecutorWithExceptions(numThreads);
    }

    @Override
    public void processTilesAndWritePerSampleOutputs(Set<String> barcodes) throws IOException {
        log.info(new Object[]{"Tile Read Executor - Queueing: ", this.tiles.size(), " TileProcessor jobs"});
        for (Integer tile : this.tiles) {
            this.tileReadExecutor.submit(new TileProcessor(tile, barcodes));
        }
        this.awaitTileProcessingCompletion();
    }

    protected void awaitTileProcessingCompletion() throws IOException {
        this.tileReadExecutor.shutdown();
        this.awaitExecutor("Tile Read Executor", this.tileReadExecutor);
        for (Integer tile : this.tiles) {
            log.info(new Object[]{"Tile " + tile + " Writer Executor Starting"});
            ThreadPoolExecutorWithExceptions tileWriteExecutor = new ThreadPoolExecutorWithExceptions(this.numThreads);
            this.completedWork.get(tile).forEach(tileWriteExecutor::submit);
            this.awaitExecutor("Tile " + tile + " Writer Executor", tileWriteExecutor);
        }
        this.closeWriters();
    }

    private void awaitExecutor(String executorName, ThreadPoolExecutorWithExceptions executor) {
        if (executor != null) {
            executor.shutdown();
            ThreadPoolExecutorUtil.awaitThreadPoolTermination(executorName, executor, Duration.ofMinutes(5L));
            if (executor.hasError()) {
                this.interruptAndShutdownExecutors(executor);
            }
            executor.cleanUp();
            log.info(new Object[]{"Done with awaitExecutor: " + executorName});
        }
    }

    private class TileProcessor
    implements Runnable {
        private final int tileNum;
        private final Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> barcodeToRecordCollection;
        private Map<String, BarcodeMetric> metrics;
        private BarcodeMetric noMatch;

        TileProcessor(int tileNum, Set<String> barcodes) {
            this.tileNum = tileNum;
            this.barcodeToRecordCollection = new HashMap(barcodes.size(), 1.0f);
            if (SortedBasecallsConverter.this.barcodeExtractor != null) {
                this.metrics = new LinkedHashMap<String, BarcodeMetric>(SortedBasecallsConverter.this.barcodeExtractor.getMetrics().size());
                for (String key : SortedBasecallsConverter.this.barcodeExtractor.getMetrics().keySet()) {
                    this.metrics.put(key, SortedBasecallsConverter.this.barcodeExtractor.getMetrics().get(key).copy());
                }
                this.noMatch = SortedBasecallsConverter.this.barcodeExtractor.getNoMatchMetric().copy();
            }
            for (String barcode : barcodes) {
                SortingCollection recordCollection = this.createSortingCollection();
                this.barcodeToRecordCollection.put(barcode, recordCollection);
            }
        }

        @Override
        public void run() {
            for (IlluminaDataProviderFactory laneFactory : SortedBasecallsConverter.this.laneFactories) {
                if (!laneFactory.getAvailableTiles().contains(this.tileNum)) continue;
                BaseIlluminaDataProvider dataProvider = laneFactory.makeDataProvider(this.tileNum);
                while (dataProvider.hasNext()) {
                    ClusterData cluster = (ClusterData)dataProvider.next();
                    SortedBasecallsConverter.this.readProgressLogger.record(null, 0);
                    if (!SortedBasecallsConverter.this.includeNonPfReads && !cluster.isPf().booleanValue()) continue;
                    String barcode2 = SortedBasecallsConverter.this.maybeDemultiplex(cluster, this.metrics, this.noMatch, laneFactory.getOutputReadStructure());
                    this.addRecord(barcode2, SortedBasecallsConverter.this.converter.convertClusterToOutputRecord(cluster));
                }
                dataProvider.close();
            }
            ArrayList writerList = new ArrayList();
            this.barcodeToRecordCollection.forEach((barcode, value) -> {
                value.doneAdding();
                Writer writer = (Writer)SortedBasecallsConverter.this.barcodeRecordWriterMap.get(barcode);
                log.debug(new Object[]{"Writing out barcode " + barcode});
                writerList.add(new SortedRecordToWriterPump(writer, value));
            });
            SortedBasecallsConverter.this.completedWork.put(this.tileNum, writerList);
            SortedBasecallsConverter.this.updateMetrics(this.metrics, this.noMatch);
            log.debug(new Object[]{"Finished processing tile " + this.tileNum});
        }

        private synchronized void addRecord(String barcode, CLUSTER_OUTPUT_RECORD record) {
            SortingCollection recordCollection = this.barcodeToRecordCollection.get(barcode);
            if (recordCollection != null) {
                recordCollection.add(record);
            } else if (!SortedBasecallsConverter.this.ignoreUnexpectedBarcodes) {
                throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", barcode));
            }
        }

        private synchronized SortingCollection<CLUSTER_OUTPUT_RECORD> createSortingCollection() {
            int maxRecordsInRam = Math.max(1, SortedBasecallsConverter.this.maxReadsInRamPerTile / SortedBasecallsConverter.this.barcodeRecordWriterMap.size());
            return SortingCollection.newInstanceFromPaths(SortedBasecallsConverter.this.outputRecordClass, (SortingCollection.Codec)SortedBasecallsConverter.this.codecPrototype.clone(), SortedBasecallsConverter.this.outputRecordComparator, (int)maxRecordsInRam, (Collection)IOUtil.filesToPaths(SortedBasecallsConverter.this.tmpDirs));
        }
    }

    private class SortedRecordToWriterPump
    implements Runnable {
        private final SortingCollection<CLUSTER_OUTPUT_RECORD> recordCollection;
        private final Writer<CLUSTER_OUTPUT_RECORD> writer;

        SortedRecordToWriterPump(Writer<CLUSTER_OUTPUT_RECORD> writer, SortingCollection<CLUSTER_OUTPUT_RECORD> recordCollection) {
            this.writer = writer;
            this.recordCollection = recordCollection;
        }

        @Override
        public void run() {
            for (Object record : this.recordCollection) {
                this.writer.write(record);
                SortedBasecallsConverter.this.writeProgressLogger.record(null, 0);
            }
            this.recordCollection.cleanup();
        }
    }
}

