/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import picard.illumina.parser.BarcodeData;
import picard.illumina.parser.BaseData;
import picard.illumina.parser.CbclData;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PfData;
import picard.illumina.parser.PositionalData;
import picard.illumina.parser.QualityData;
import picard.illumina.parser.ReadType;

public abstract class BaseIlluminaDataProvider
implements Iterator<ClusterData>,
Iterable<ClusterData>,
AutoCloseable {
    public static final Pattern FILE_NAME_PATTERN = Pattern.compile("^s_\\d+_(\\d{1,5}).+");
    protected final int lane;
    final ReadType[] outputReadTypes;
    final int numReads;

    public BaseIlluminaDataProvider(int lane, OutputMapping outputMapping) {
        this.numReads = outputMapping.numOutputReads();
        this.lane = lane;
        this.outputReadTypes = (ReadType[])StreamSupport.stream(outputMapping.getOutputDescriptors().spliterator(), false).map(rd -> rd.type).toArray(ReadType[]::new);
    }

    @Override
    public Iterator<ClusterData> iterator() {
        return this;
    }

    @Override
    public abstract void close();

    protected void addData(ClusterData clusterData, PositionalData posData) {
        clusterData.setX(posData.getXCoordinate());
        clusterData.setY(posData.getYCoordinate());
    }

    protected void addData(ClusterData clusterData, PfData pfData) {
        clusterData.setPf(pfData.isPf());
    }

    protected void addData(ClusterData clusterData, BarcodeData barcodeData) {
        clusterData.setMatchedBarcode(barcodeData.getBarcode());
    }

    protected void addReadData(ClusterData clusterData, int numReads, BaseData baseData) {
        byte[][] bases = baseData.getBases();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setBases(bases[i]);
        }
    }

    protected void addReadData(ClusterData clusterData, int numReads, QualityData qualityData) {
        byte[][] qualities = qualityData.getQualities();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setQualities(qualities[i]);
        }
    }

    protected void addReadData(ClusterData clusterData, int numReads, CbclData cbclData) {
        byte[][] bases = cbclData.getBases();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setBases(bases[i]);
        }
        byte[][] qualities = cbclData.getQualities();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setQualities(qualities[i]);
        }
        clusterData.setPf(cbclData.isPf());
        clusterData.setX(cbclData.getPositionInfo().xQseqCoord);
        clusterData.setY(cbclData.getPositionInfo().yQseqCoord);
    }

    abstract void seekToTile(Integer var1);

    public static Integer fileToTile(String fileName) {
        Matcher matcher = FILE_NAME_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return Integer.parseInt(matcher.group(1));
    }
}

