/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.PicardException;
import picard.illumina.parser.BarcodeData;
import picard.illumina.parser.BaseData;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PfData;
import picard.illumina.parser.PositionalData;
import picard.illumina.parser.QualityData;

class IlluminaDataProvider
extends BaseIlluminaDataProvider {
    private final File basecallDirectory;
    private final IlluminaParser[] parsers;
    private final IlluminaDataType[][] dataTypes;

    IlluminaDataProvider(OutputMapping outputMapping, Map<IlluminaParser, Set<IlluminaDataType>> parsersToDataTypes, File basecallDirectory, int lane) {
        super(lane, outputMapping);
        this.basecallDirectory = basecallDirectory;
        int numParsers = parsersToDataTypes.size();
        if (numParsers == 0) {
            throw new PicardException("There were 0 parsers passed to IlluminaDataProvider!");
        }
        int i = 0;
        this.parsers = new IlluminaParser[numParsers];
        this.dataTypes = new IlluminaDataType[numParsers][];
        for (Map.Entry<IlluminaParser, Set<IlluminaDataType>> pToD : parsersToDataTypes.entrySet()) {
            this.parsers[i] = pToD.getKey();
            Set<IlluminaDataType> dts = pToD.getValue();
            this.dataTypes[i] = new IlluminaDataType[dts.size()];
            dts.toArray(this.dataTypes[i++]);
        }
    }

    @Override
    public boolean hasNext() {
        boolean more = this.parsers[0].hasNext();
        if (!more) {
            for (int i = 1; i < this.parsers.length; ++i) {
                if (!this.parsers[i].hasNext()) continue;
                throw new PicardException("Unequal length Illumina files in " + this.basecallDirectory + ", lane " + this.lane + ". Failing parser: " + this.parsers[i].getClass().getName());
            }
        }
        return more;
    }

    @Override
    public ClusterData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ClusterData cluster = new ClusterData(this.outputReadTypes);
        cluster.setLane(this.lane);
        cluster.setTile(this.parsers[0].getTileOfNextCluster());
        for (int i = 0; i < this.parsers.length; ++i) {
            Object ilData = this.parsers[i].next();
            block8: for (IlluminaDataType ilDataType : this.dataTypes[i]) {
                switch (ilDataType) {
                    case Position: {
                        this.addData(cluster, (PositionalData)ilData);
                        continue block8;
                    }
                    case PF: {
                        this.addData(cluster, (PfData)ilData);
                        continue block8;
                    }
                    case Barcodes: {
                        this.addData(cluster, (BarcodeData)ilData);
                        continue block8;
                    }
                    case BaseCalls: {
                        this.addReadData(cluster, this.numReads, (BaseData)ilData);
                        continue block8;
                    }
                    case QualityScores: {
                        this.addReadData(cluster, this.numReads, (QualityData)ilData);
                        continue block8;
                    }
                    default: {
                        throw new PicardException("Unknown data type " + ilDataType + " requested by IlluminaDataProviderFactory");
                    }
                }
            }
        }
        return cluster;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekToTile(Integer oneBasedTileNumber) {
        for (IlluminaParser parser : this.parsers) {
            parser.seekToTile(oneBasedTileNumber);
        }
    }

    @Override
    public void close() {
        for (IlluminaParser parser : this.parsers) {
            parser.close();
        }
    }
}

