/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.fakers.FileFaker;

public abstract class ParameterizedFileUtil {
    public static final String PER_TILE_PATTERN_STRING = "s_(\\d+)_(\\d{1,5})";
    protected final String extension;
    protected Pattern matchPattern;
    protected final int lane;
    protected List<Integer> tiles;
    protected final File base;
    protected final FileFaker faker;
    protected static final boolean DefaultSkipEmptyFiles = true;
    protected final boolean skipEmptyFiles;

    public ParameterizedFileUtil(boolean laneTileRegex, String extension, File base, FileFaker faker, int lane, boolean skipEmptyFiles) {
        this(extension, base, faker, lane, skipEmptyFiles);
        this.matchPattern = laneTileRegex ? Pattern.compile(ParameterizedFileUtil.escapePeriods(ParameterizedFileUtil.makeLaneTileRegex(this.processTxtExtension(extension), lane))) : Pattern.compile(ParameterizedFileUtil.escapePeriods(this.makeLaneRegex(extension, lane)));
    }

    public ParameterizedFileUtil(boolean laneTileRegex, String extension, File base, FileFaker faker, int lane) {
        this(laneTileRegex, extension, base, faker, lane, true);
    }

    public ParameterizedFileUtil(String pattern, String extension, File base, FileFaker faker, int lane) {
        this(extension, base, faker, lane);
        this.matchPattern = Pattern.compile(pattern);
    }

    private ParameterizedFileUtil(String extension, File base, FileFaker faker, int lane) {
        this(extension, base, faker, lane, true);
    }

    private ParameterizedFileUtil(String extension, File base, FileFaker faker, int lane, boolean skipEmptyFiles) {
        this.faker = faker;
        this.extension = extension;
        this.base = base;
        this.lane = lane;
        this.skipEmptyFiles = skipEmptyFiles;
    }

    public abstract boolean filesAvailable();

    public List<Integer> getTiles() {
        return this.tiles;
    }

    public abstract List<String> verify(List<Integer> var1, int[] var2);

    public abstract List<String> fakeFiles(List<Integer> var1, int[] var2, IlluminaFileUtil.SupportedIlluminaFormat var3);

    protected Integer fileToTile(String fileName) {
        Matcher matcher = this.matchPattern.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return Integer.parseInt(matcher.group(1));
    }

    public static String makeLaneTileRegex(String fileNameEndPattern, int lane) {
        if (lane < 0) {
            throw new PicardException("Lane (" + lane + ") cannot be negative");
        }
        return "^s_" + lane + "_(\\d{1,5})" + fileNameEndPattern + "$";
    }

    private String makeLaneRegex(String fileNameEndPattern, int lane) {
        return "^s_" + lane + fileNameEndPattern + "$";
    }

    public static String escapePeriods(String preEscaped) {
        return preEscaped.replaceAll("\\.", "\\.");
    }

    private String processTxtExtension(String fileNameEndPattern) {
        if (fileNameEndPattern.endsWith(".txt")) {
            return fileNameEndPattern + "(\\.gz|\\.bz2)?";
        }
        return fileNameEndPattern;
    }

    protected File getRunFile(File baseDirectory, Pattern pattern) {
        if (baseDirectory.exists()) {
            IOUtil.assertDirectoryIsReadable((File)baseDirectory);
            File[] files = IOUtil.getFilesMatchingRegexp((File)baseDirectory, (Pattern)pattern);
            if (files.length == 1) {
                return files[0];
            }
        }
        return null;
    }

    protected IlluminaFileMap getTiledFiles(File baseDirectory, Pattern pattern) {
        IlluminaFileMap fileMap = new IlluminaFileMap();
        if (baseDirectory.exists()) {
            File[] files;
            IOUtil.assertDirectoryIsReadable((File)baseDirectory);
            for (File file : files = IOUtil.getFilesMatchingRegexp((File)baseDirectory, (Pattern)pattern)) {
                if (this.skipEmptyFiles && file.length() <= 0L) continue;
                fileMap.put(this.fileToTile(file.getName()), file);
            }
        }
        return fileMap;
    }

    public void setTiles(List<Integer> tiles) {
        this.tiles = tiles;
    }

    public void setTilesForPerRunFile(List<Integer> tiles) {
    }

    public boolean checkTileCount() {
        return true;
    }

    public static String makeBarcodeRegex(int lane) {
        return ParameterizedFileUtil.makeLaneTileRegex("_barcode.txt(\\.gz|\\.bz2)?", lane);
    }
}

