/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import picard.illumina.parser.PerTileFileUtil;
import picard.illumina.parser.fakers.FileFaker;

public class PerTileOrPerRunFileUtil
extends PerTileFileUtil {
    private final File runFile;

    public PerTileOrPerRunFileUtil(String extension, File base, FileFaker faker, int lane) {
        super(extension, base, faker, lane);
        Pattern runFileMatchPattern = Pattern.compile("^s" + extension + "$");
        this.runFile = this.getRunFile(base.getParentFile(), runFileMatchPattern);
    }

    @Override
    public boolean filesAvailable() {
        return super.filesAvailable() || this.runFile != null;
    }

    @Override
    public void setTilesForPerRunFile(List<Integer> tiles) {
        if (this.runFile != null) {
            tiles.forEach(i -> this.fileMap.put(i, this.runFile));
            this.tiles = tiles;
        }
    }

    @Override
    public boolean checkTileCount() {
        return this.runFile == null;
    }

    @Override
    public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
        File baseDir = this.runFile != null ? this.runFile.getParentFile() : this.base;
        return this.verifyPerTile(baseDir, expectedTiles);
    }
}

