/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.fakers;

import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.GZIPOutputStream;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.fakers.FileFaker;
import picard.illumina.parser.readers.BclReader;

public class MultiTileBclFileFaker
extends FileFaker {
    @Override
    protected void fakeFile(ByteBuffer buffer) {
        buffer.putInt(1);
        for (long perTileSize = (long)this.size; perTileSize > 0L; --perTileSize) {
            buffer.put((byte)0);
        }
    }

    @Override
    protected boolean addLeadingZeros() {
        return false;
    }

    @Override
    protected int bufferSize() {
        return (this.size - 32) * this.tiles.size() + 32;
    }

    public void fakeMultiTileBclFile(File bcl, TileIndex tileIndex) throws IOException {
        this.tiles = tileIndex.getTiles();
        Object outputStream = BclReader.isGzipped(bcl) ? new GZIPOutputStream(new FileOutputStream(bcl)) : (BclReader.isBlockGzipped(bcl) ? new BlockCompressedOutputStream(bcl) : new FileOutputStream(bcl));
        for (TileIndex.TileIndexRecord tileRecord : tileIndex) {
            ByteBuffer buffer = ByteBuffer.allocate(tileRecord.getNumClustersInTile() + 4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.size = tileRecord.getNumClustersInTile();
            this.fakeFile(buffer);
            buffer.flip();
            ((OutputStream)outputStream).write(buffer.array());
        }
        CloserUtil.close((Object)outputStream);
    }
}

