/*
 * Decompiled with CFR 0.152.
 */
package picard.nio;

import htsjdk.io.HtsPath;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PicardHtsPath
extends HtsPath {
    public PicardHtsPath(String rawInputString) {
        super(rawInputString);
    }

    public PicardHtsPath(HtsPath htsPath) {
        super(htsPath);
    }

    public PicardHtsPath(File file) {
        this(file.toURI().toString());
    }

    public static List<PicardHtsPath> fromPaths(Collection<String> paths) {
        Objects.requireNonNull(paths);
        return paths.stream().map(PicardHtsPath::new).collect(Collectors.toList());
    }

    public Path toPath() {
        try {
            return IOUtil.getPath((String)super.getURIString());
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public static PicardHtsPath fromPath(Path path) {
        Objects.requireNonNull(path);
        return new PicardHtsPath(new HtsPath(path.toUri().toString()));
    }

    public static List<Path> toPaths(Collection<PicardHtsPath> picardHtsPaths) {
        Objects.requireNonNull(picardHtsPaths);
        return picardHtsPaths.stream().map(PicardHtsPath::toPath).collect(Collectors.toList());
    }
}

