/*
 * Decompiled with CFR 0.152.
 */
package picard.pedigree;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import picard.pedigree.Sex;

public class PedFile
extends TreeMap<String, PedTrio> {
    private static final Log log = Log.getInstance(PedFile.class);
    static final Pattern WHITESPACE = Pattern.compile("\\s+");
    static final Pattern TAB = Pattern.compile("\\t");
    private final Pattern delimiterPattern;
    private final String delimiterString;
    public static final Number NO_PHENO = -9;
    public static final Sex UNKNOWN_SEX = Sex.Unknown;

    public PedFile(boolean isTabMode) {
        this.delimiterPattern = isTabMode ? TAB : WHITESPACE;
        this.delimiterString = isTabMode ? "tabs" : "whitespace";
    }

    public void add(PedTrio trio) {
        this.put(trio.getIndividualId(), trio);
    }

    public void write(File file) {
        IOUtil.assertFileIsWritable((File)file);
        BufferedWriter out = IOUtil.openFileForBufferedWriting((File)file);
        try {
            for (PedTrio trio : this.values()) {
                out.write(trio.getFamilyId());
                out.write("\t");
                out.write(trio.getIndividualId());
                out.write("\t");
                out.write(trio.getPaternalId());
                out.write("\t");
                out.write(trio.getMaternalId());
                out.write("\t");
                out.write(String.valueOf(trio.getSex().toCode()));
                out.write("\t");
                out.write(trio.getPhenotype().toString());
                out.newLine();
            }
            out.close();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("IOException while writing to file " + file.getAbsolutePath(), (Throwable)ioe);
        }
    }

    public static PedFile fromFile(File file, boolean isTabMode) {
        PedFile pedFile = new PedFile(isTabMode);
        IOUtil.assertFileIsReadable((File)file);
        for (String line : IOUtil.readLines((File)file)) {
            String[] fields = pedFile.delimiterPattern.split(line);
            if (fields.length != 6) {
                log.error(new Object[]{"Ped file line contained invalid number of fields, skipping: " + line});
                continue;
            }
            PedFile pedFile2 = pedFile;
            Objects.requireNonNull(pedFile2);
            PedTrio trio = pedFile2.new PedTrio(fields[0], fields[1], fields[2], fields[3], Sex.fromCode(Integer.parseInt(fields[4])), fields[5].contains(".") ? Double.parseDouble(fields[5]) : (double)Integer.parseInt(fields[5]));
            pedFile.add(trio);
        }
        return pedFile;
    }

    public PedFile removeIncompleteTrios() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            if (((PedTrio)iterator.next().getValue()).hasBothParents()) continue;
            iterator.remove();
        }
        return this;
    }

    public static PedFile fromSexMap(Map<String, Sex> sampleSexes) {
        PedFile pedfile = new PedFile(true);
        for (Map.Entry<String, Sex> sampleSex : sampleSexes.entrySet()) {
            PedFile pedFile = pedfile;
            Objects.requireNonNull(pedFile);
            PedTrio ped = pedFile.new PedTrio(sampleSex.getKey(), sampleSex.getKey(), ".", ".", sampleSex.getValue(), NO_PHENO);
            pedfile.add(ped);
        }
        return pedfile;
    }

    public class PedTrio {
        private final String familyId;
        private final String individualId;
        private final String paternalId;
        private final String maternalId;
        private final Sex sex;
        private final Number phenotype;

        public PedTrio(String familyId, String individualId, String paternalId, String maternalId, Sex sex, Number phenotype) {
            if (PedFile.this.delimiterPattern.split(familyId).length != 1) {
                throw new IllegalArgumentException("FamilyID     cannot contain " + PedFile.this.delimiterString + ": [" + familyId + "]");
            }
            if (PedFile.this.delimiterPattern.split(individualId).length != 1) {
                throw new IllegalArgumentException("IndividualID cannot contain " + PedFile.this.delimiterString + ": [" + individualId + "]");
            }
            if (PedFile.this.delimiterPattern.split(paternalId).length != 1) {
                throw new IllegalArgumentException("PaternalID   cannot contain " + PedFile.this.delimiterString + ": [" + paternalId + "]");
            }
            if (PedFile.this.delimiterPattern.split(maternalId).length != 1) {
                throw new IllegalArgumentException("MaternalID   cannot contain " + PedFile.this.delimiterString + ": [" + maternalId + "]");
            }
            this.familyId = familyId;
            this.individualId = individualId;
            this.paternalId = paternalId;
            this.maternalId = maternalId;
            this.sex = sex;
            this.phenotype = phenotype;
        }

        public boolean hasBothParents() {
            return this.paternalId != null && this.maternalId != null;
        }

        public String getFamilyId() {
            return this.familyId;
        }

        public String getIndividualId() {
            return this.individualId;
        }

        public String getPaternalId() {
            return this.paternalId;
        }

        public String getMaternalId() {
            return this.maternalId;
        }

        public Sex getSex() {
            return this.sex;
        }

        public Number getPhenotype() {
            return this.phenotype;
        }
    }
}

