/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CoordMath;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

public class MostDistantPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        SAMRecord bestSecondEnd;
        SAMRecord bestFirstEnd;
        BestEndAlignmentsAccumulator firstEndBest = new BestEndAlignmentsAccumulator();
        BestEndAlignmentsAccumulator secondEndBest = new BestEndAlignmentsAccumulator();
        CollectionUtil.MultiMap firstEndBySequence = new CollectionUtil.MultiMap();
        BestPairAlignmentsAccumulator pairBest = new BestPairAlignmentsAccumulator();
        for (SAMRecord rec : hitsForInsert.firstOfPairOrFragment) {
            if (rec.getReadUnmappedFlag()) {
                throw new IllegalStateException();
            }
            firstEndBest.considerBest(rec);
            firstEndBySequence.append((Object)rec.getReferenceIndex(), (Object)rec);
        }
        for (SAMRecord secondEnd : hitsForInsert.secondOfPair) {
            if (secondEnd.getReadUnmappedFlag()) {
                throw new IllegalStateException();
            }
            secondEndBest.considerBest(secondEnd);
            Collection firstEnds = (Collection)firstEndBySequence.get((Object)secondEnd.getReferenceIndex());
            if (firstEnds == null) continue;
            for (SAMRecord firstEnd : firstEnds) {
                pairBest.considerBest(firstEnd, secondEnd);
            }
        }
        if (pairBest.hasBest()) {
            Map.Entry<SAMRecord, SAMRecord> pairEntry = this.pickRandomlyFromList(pairBest.bestAlignmentPairs);
            bestFirstEnd = pairEntry.getKey();
            bestSecondEnd = pairEntry.getValue();
        } else {
            bestFirstEnd = firstEndBest.hasBest() ? this.pickRandomlyFromList(firstEndBest.bestAlignments) : null;
            bestSecondEnd = secondEndBest.hasBest() ? this.pickRandomlyFromList(secondEndBest.bestAlignments) : null;
        }
        if (hitsForInsert.firstOfPairOrFragment.isEmpty() != (bestFirstEnd == null)) {
            throw new IllegalStateException("Should not happen");
        }
        if (hitsForInsert.secondOfPair.isEmpty() != (bestSecondEnd == null)) {
            throw new IllegalStateException("Should not happen");
        }
        if (bestFirstEnd != null) {
            this.moveToHead(hitsForInsert.firstOfPairOrFragment, bestFirstEnd);
        }
        if (bestSecondEnd != null) {
            this.moveToHead(hitsForInsert.secondOfPair, bestSecondEnd);
        }
        hitsForInsert.setPrimaryAlignment(0);
        if (hitsForInsert.firstOfPairOrFragment.size() <= 1 || hitsForInsert.secondOfPair.size() <= 1) {
            return;
        }
        int amountToSlide = hitsForInsert.firstOfPairOrFragment.size() - 1;
        for (int i = 0; i < amountToSlide; ++i) {
            hitsForInsert.secondOfPair.add(1, null);
        }
    }

    private <T> T pickRandomlyFromList(List<T> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private void moveToHead(List<SAMRecord> list, SAMRecord rec) {
        if (list.get(0) == rec) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i) != rec) continue;
            list.remove(i);
            list.add(0, rec);
            return;
        }
        throw new IllegalStateException("Should not be reached");
    }

    private static class BestEndAlignmentsAccumulator {
        public int bestMapq = -1;
        public List<SAMRecord> bestAlignments = new ArrayList<SAMRecord>();

        private BestEndAlignmentsAccumulator() {
        }

        public void considerBest(SAMRecord rec) {
            if (this.bestMapq == -1) {
                this.bestMapq = rec.getMappingQuality();
                this.bestAlignments.add(rec);
            } else {
                int cmp = SAMUtils.compareMapqs((int)this.bestMapq, (int)rec.getMappingQuality());
                if (cmp < 0) {
                    this.bestMapq = rec.getMappingQuality();
                    this.bestAlignments.clear();
                    this.bestAlignments.add(rec);
                } else if (cmp == 0) {
                    this.bestAlignments.add(rec);
                }
            }
        }

        public boolean hasBest() {
            return this.bestMapq != -1;
        }
    }

    private static class BestPairAlignmentsAccumulator {
        public int bestDistance = -1;
        public int bestPairMapq = -1;
        public List<Map.Entry<SAMRecord, SAMRecord>> bestAlignmentPairs = new ArrayList<Map.Entry<SAMRecord, SAMRecord>>();

        private BestPairAlignmentsAccumulator() {
        }

        public void considerBest(SAMRecord firstEnd, SAMRecord secondEnd) {
            int thisPairMapq = SAMUtils.combineMapqs((int)firstEnd.getMappingQuality(), (int)secondEnd.getMappingQuality());
            int thisDistance = CoordMath.getLength((int)Math.min(firstEnd.getAlignmentStart(), secondEnd.getAlignmentStart()), (int)Math.max(firstEnd.getAlignmentEnd(), secondEnd.getAlignmentEnd()));
            if (thisDistance > this.bestDistance || thisDistance == this.bestDistance && thisPairMapq > this.bestPairMapq) {
                this.bestDistance = thisDistance;
                this.bestPairMapq = thisPairMapq;
                this.bestAlignmentPairs.clear();
                this.bestAlignmentPairs.add(new AbstractMap.SimpleEntry<SAMRecord, SAMRecord>(firstEnd, secondEnd));
            } else if (thisDistance == this.bestDistance && thisPairMapq == this.bestPairMapq) {
                this.bestAlignmentPairs.add(new AbstractMap.SimpleEntry<SAMRecord, SAMRecord>(firstEnd, secondEnd));
            }
        }

        public boolean hasBest() {
            return this.bestDistance != -1;
        }
    }
}

