/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.SamErrorMetric;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.reference.SamLocusAndReferenceIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import picard.sam.SamErrorMetric.CollectSamErrorMetrics;
import picard.sam.util.Pair;
import picard.sam.util.PhysicalLocationInt;
import picard.sam.util.ReadNameParser;

public class ReadBaseStratification {
    private static final Log log = Log.getInstance(CollectSamErrorMetrics.class);
    private static int LONG_HOMOPOLYMER = 6;
    private static int GC_CACHE_SIZE = 1000;
    private static int LOCATION_BIN_SIZE = 2500;
    public static final RecordAndOffsetStratifier<Character> currentReadBaseStratifier = ReadBaseStratification.wrapStaticFunction((SamLocusIterator.RecordAndOffset rao) -> ReadBaseStratification.stratifyReadBase(rao, 0), "read_base");
    public static final RecordAndOffsetStratifier<Character> previousReadBaseStratifier = ReadBaseStratification.wrapStaticFunction((SamLocusIterator.RecordAndOffset rao) -> ReadBaseStratification.stratifyReadBase(rao, -1), "prev_base");
    public static final RecordAndOffsetStratifier<Character> nextReadBaseStratifier = ReadBaseStratification.wrapStaticFunction((SamLocusIterator.RecordAndOffset rao) -> ReadBaseStratification.stratifyReadBase(rao, 1), "next_base");
    public static final RecordAndOffsetStratifier<Character> referenceBaseStratifier = ReadBaseStratification.wrapStaticFunction(ReadBaseStratification::stratifyReferenceBase, "ref_base");
    public static final PairStratifier<Character, Character> postDiNucleotideStratifier = ReadBaseStratification.PairStratifierFactory(referenceBaseStratifier, nextReadBaseStratifier, "post_dinuc");
    public static final PairStratifier<Character, Character> preDiNucleotideStratifier = ReadBaseStratification.PairStratifierFactory(previousReadBaseStratifier, referenceBaseStratifier, "pre_dinuc");
    public static final RecordAndOffsetStratifier<Integer> homoPolymerLengthStratifier = ReadBaseStratification.wrapStaticFunction(ReadBaseStratification::stratifyHomopolymerLength, "homopolymer_length");
    public static final PairStratifier<Integer, Pair<Character, Character>> homopolymerStratifier = ReadBaseStratification.PairStratifierFactory(homoPolymerLengthStratifier, preDiNucleotideStratifier, "homopolymer_and_following_ref_base");
    public static final Lazy<PairStratifier<LongShortHomopolymer, Pair<Character, Character>>> binnedHomopolymerStratifier = new Lazy(() -> ReadBaseStratification.PairStratifierFactory(new LongShortHomopolymerStratifier(LONG_HOMOPOLYMER), preDiNucleotideStratifier, "binned_length_homopolymer_and_following_ref_base"));
    public static final RecordAndOffsetStratifier<String> oneBasePaddedContextStratifier = ReadBaseStratification.wrapStaticFunction((SamLocusIterator.RecordAndOffset rao, SamLocusAndReferenceIterator.SAMLocusAndReference lar) -> ReadBaseStratification.stratifySurroundingContext(rao, lar, 1, 1), "one_base_padded_context");
    public static final RecordAndOffsetStratifier<String> twoBasePaddedContextStratifier = ReadBaseStratification.wrapStaticFunction((SamLocusIterator.RecordAndOffset rao, SamLocusAndReferenceIterator.SAMLocusAndReference lar) -> ReadBaseStratification.stratifySurroundingContext(rao, lar, 2, 2), "two_base_padded_context");
    public static final RecordStratifier<String> nonStratifier = ReadBaseStratification.wrapStaticReadFunction(sam -> "all", "all");
    public static final GCContentStratifier gcContentStratifier = new GCContentStratifier();
    public static final FlowCellTileStratifier flowCellTileStratifier = new FlowCellTileStratifier();
    public static final FlowCellXStratifier flowCellXStratifier = new FlowCellXStratifier();
    public static final FlowCellYStratifier flowCellYStratifier = new FlowCellYStratifier();
    public static final RecordStratifier<String> readgroupStratifier = ReadBaseStratification.wrapStaticReadFunction(ReadBaseStratification::stratifyReadGroup, "read_group");
    public static final RecordAndOffsetStratifier<ReadOrdinality> readOrdinalityStratifier = ReadBaseStratification.wrapStaticReadFunction(ReadOrdinality::of, "read_ordinality");
    public static final RecordAndOffsetStratifier<ProperPaired> readPairednessStratifier = ReadBaseStratification.wrapStaticReadFunction(ProperPaired::of, "pair_proper");
    public static final RecordAndOffsetStratifier<ReadDirection> readDirectionStratifier = ReadBaseStratification.wrapStaticReadFunction(ReadDirection::of, "read_direction");
    public static final RecordAndOffsetStratifier<PairOrientation> readOrientationStratifier = ReadBaseStratification.wrapStaticReadFunction(PairOrientation::of, "pair_orientation");
    public static final BinnedReadCycleStratifier binnedReadCycleStratifier = new BinnedReadCycleStratifier();
    public static final RecordAndOffsetStratifier<Integer> baseCycleStratifier = ReadBaseStratification.wrapStaticFunction(ReadBaseStratification::stratifyCycle, "cycle");
    public static final RecordAndOffsetStratifier<Integer> insertLengthStratifier = ReadBaseStratification.wrapStaticReadFunction(ReadBaseStratification::stratifyInsertLength, "insert_length");
    public static final RecordAndOffsetStratifier<Integer> softClipsLengthStratifier = ReadBaseStratification.wrapStaticReadFunction(ReadBaseStratification::stratifySoftClippedBases, "softclipped_bases");
    public static final RecordAndOffsetStratifier<Byte> baseQualityStratifier = ReadBaseStratification.wrapStaticFunction(ReadBaseStratification::stratifyBaseQuality, "base_quality");
    public static final RecordAndOffsetStratifier<Integer> mappingQualityStratifier = ReadBaseStratification.wrapStaticReadFunction(ReadBaseStratification::stratifyMappingQuality, "mapping_quality");
    public static final MismatchesInReadStratifier mismatchesInReadStratifier = new MismatchesInReadStratifier();
    public static final ConsensusStratifier consensusStratifier = new ConsensusStratifier();
    public static final NsInReadStratifier nsInReadStratifier = new NsInReadStratifier();
    public static final CigarOperatorsInReadStratifier insertionsInReadStratifier = new CigarOperatorsInReadStratifier(CigarOperator.I);
    public static final CigarOperatorsInReadStratifier deletionsInReadStratifier = new CigarOperatorsInReadStratifier(CigarOperator.D);
    public static final IndelsInReadStratifier indelsInReadStratifier = new IndelsInReadStratifier();
    public static final IndelLengthStratifier indelLengthStratifier = new IndelLengthStratifier();
    public static final int NOT_ALIGNED_ERROR = -1;

    public static void setGcCacheSize(int gcCacheSize) {
        GC_CACHE_SIZE = gcCacheSize;
    }

    public static void setLongHomopolymer(int longHomopolymer) {
        LONG_HOMOPOLYMER = longHomopolymer;
    }

    public static void setLocationBinSize(int locationBinSize) {
        LOCATION_BIN_SIZE = locationBinSize;
    }

    private static <T extends Comparable<T>> RecordAndOffsetStratifier<T> wrapStaticFunction(final BiFunction<SamLocusIterator.RecordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference, T> staticStratify, final String suffix) {
        return new RecordAndOffsetStratifier<T>(){

            @Override
            public T stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
                return (Comparable)staticStratify.apply(recordAndOffset, locusInfo);
            }

            @Override
            public String getSuffix() {
                return suffix;
            }
        };
    }

    private static <T extends Comparable<T>> RecordAndOffsetStratifier<T> wrapStaticFunction(Function<SamLocusIterator.RecordAndOffset, T> staticStratify, String suffix) {
        return ReadBaseStratification.wrapStaticFunction((SamLocusIterator.RecordAndOffset rao, SamLocusAndReferenceIterator.SAMLocusAndReference ignored) -> (Comparable)staticStratify.apply((SamLocusIterator.RecordAndOffset)rao), suffix);
    }

    private static <T extends Comparable<T>> RecordStratifier<T> wrapStaticReadFunction(final Function<SAMRecord, T> staticStratify, final String suffix) {
        return new RecordStratifier<T>(){

            @Override
            public T stratify(SAMRecord sam) {
                return (Comparable)staticStratify.apply(sam);
            }

            @Override
            public String getSuffix() {
                return suffix;
            }
        };
    }

    public static <T extends Comparable<T>, S extends Comparable<S>> PairStratifier<T, S> PairStratifierFactory(RecordAndOffsetStratifier<T> leftStratifier, RecordAndOffsetStratifier<S> rightStratifier, final String suffix) {
        return new PairStratifier<T, S>(leftStratifier, rightStratifier){

            @Override
            public String getSuffix() {
                return suffix;
            }
        };
    }

    private static Integer stratifyCigarOperatorsInRead(SAMRecord samRecord, CigarOperator operator) {
        try {
            return samRecord.getCigar().getCigarElements().stream().filter(ce -> ce.getOperator().equals((Object)operator)).mapToInt(CigarElement::getLength).sum();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String stratifySurroundingContext(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo, int basesBefore, int basesAfter) {
        StringBuilder stringBuilder = new StringBuilder(basesAfter + basesBefore + 1);
        for (int offset = -basesBefore; offset <= basesAfter; ++offset) {
            if (offset == 0) {
                stringBuilder.append(ReadBaseStratification.stratifyReferenceBase(recordAndOffset, locusInfo));
                continue;
            }
            Character surroundingBase = ReadBaseStratification.stratifyReadBase(recordAndOffset, offset);
            if (surroundingBase == null) {
                return null;
            }
            stringBuilder.append(surroundingBase);
        }
        return stringBuilder.toString();
    }

    private static int stratifyCycle(SamLocusIterator.RecordAndOffset recordAndOffset) {
        SAMRecord rec = recordAndOffset.getRecord();
        int offset = recordAndOffset.getOffset();
        int retval = rec.getReadNegativeStrandFlag() ? rec.getReadLength() - offset - 1 : offset;
        return ++retval;
    }

    private static Integer stratifyHomopolymerLength(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
        ReadDirection direction = ReadDirection.of(recordAndOffset.getRecord());
        byte[] readBases = recordAndOffset.getRecord().getReadBases();
        if (SequenceUtil.isNoCall((byte)locusInfo.getReferenceBase())) {
            return null;
        }
        int runLengthOffset = recordAndOffset.getOffset();
        if (runLengthOffset < 0 || runLengthOffset >= recordAndOffset.getRecord().getReadLength()) {
            return null;
        }
        if (direction == ReadDirection.POSITIVE) {
            while (--runLengthOffset >= 0 && readBases[runLengthOffset] == readBases[recordAndOffset.getOffset() - 1]) {
            }
            return recordAndOffset.getOffset() - runLengthOffset - 1;
        }
        while (++runLengthOffset < recordAndOffset.getRecord().getReadLength() && readBases[runLengthOffset] == readBases[recordAndOffset.getOffset() + 1]) {
        }
        return runLengthOffset - recordAndOffset.getOffset() - 1;
    }

    private static Character stratifyReadBase(SamLocusIterator.RecordAndOffset recordAndOffset, int offset) {
        ReadDirection direction = ReadDirection.of(recordAndOffset.getRecord());
        int requestedOffset = recordAndOffset.getOffset() + offset * (direction == ReadDirection.POSITIVE ? 1 : -1);
        if (requestedOffset < 0 || requestedOffset >= recordAndOffset.getRecord().getReadLength()) {
            return null;
        }
        return Character.valueOf(ReadBaseStratification.stratifySequenceBase(recordAndOffset.getRecord().getReadBases()[requestedOffset], direction == ReadDirection.NEGATIVE));
    }

    private static Character stratifyReferenceBase(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
        ReadDirection direction = ReadDirection.of(recordAndOffset.getRecord());
        if (SequenceUtil.isNoCall((byte)locusInfo.getReferenceBase())) {
            return null;
        }
        return Character.valueOf(ReadBaseStratification.stratifySequenceBase(locusInfo.getReferenceBase(), direction == ReadDirection.NEGATIVE));
    }

    private static char stratifySequenceBase(byte input, Boolean getComplement) {
        return (char)SequenceUtil.upperCase((byte)(getComplement != false ? SequenceUtil.complement((byte)input) : input));
    }

    private static Integer stratifyInsertLength(SAMRecord sam) {
        return Math.min(sam.getReadLength() * 10, Math.abs(sam.getInferredInsertSize()));
    }

    private static Integer stratifySoftClippedBases(SAMRecord sam) {
        Cigar cigar = sam.getCigar();
        if (cigar == null) {
            return -1;
        }
        return cigar.getCigarElements().stream().filter(e -> e.getOperator() == CigarOperator.S).mapToInt(CigarElement::getLength).sum();
    }

    private static Byte stratifyBaseQuality(SamLocusIterator.RecordAndOffset recordAndOffset) {
        return recordAndOffset.getBaseQuality();
    }

    private static int stratifyMappingQuality(SAMRecord sam) {
        return sam.getMappingQuality();
    }

    private static String stratifyReadGroup(SAMRecord sam) {
        return sam.getReadGroup().getReadGroupId();
    }

    private static Integer stratifyIndelLength(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
        if (recordAndOffset.getAlignmentType() != AbstractRecordAndOffset.AlignmentType.Insertion && recordAndOffset.getAlignmentType() != AbstractRecordAndOffset.AlignmentType.Deletion) {
            return 0;
        }
        CigarElement cigarElement = ReadBaseStratification.getIndelElement(recordAndOffset);
        if (cigarElement == null) {
            return null;
        }
        if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Insertion && cigarElement.getOperator() != CigarOperator.I) {
            throw new IllegalStateException("Wrong CIGAR operator for the given position.");
        }
        if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Deletion && cigarElement.getOperator() != CigarOperator.D) {
            throw new IllegalStateException("Wrong CIGAR operator for the given position.");
        }
        return cigarElement.getLength();
    }

    public static CigarElement getIndelElement(SamLocusIterator.RecordAndOffset recordAndOffset) {
        SAMRecord record = recordAndOffset.getRecord();
        int offset = recordAndOffset.getOffset();
        if (recordAndOffset.getAlignmentType() != AbstractRecordAndOffset.AlignmentType.Insertion && recordAndOffset.getAlignmentType() != AbstractRecordAndOffset.AlignmentType.Deletion) {
            log.warn(new Object[]{"This method is not supported for matching bases."});
            return null;
        }
        if (record == null) {
            throw new IllegalArgumentException("record must not be null.");
        }
        if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Insertion && offset < 0) {
            throw new IllegalArgumentException("offset must greater than zero for an insertion.");
        }
        if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Deletion && offset < -1) {
            throw new IllegalArgumentException("offset must greater than -1 for a deletion.");
        }
        Cigar cigar = record.getCigar();
        if (cigar.isEmpty()) {
            return null;
        }
        if (offset == -1) {
            return cigar.getCigarElement(0);
        }
        int readPosition = 0;
        for (CigarElement cigarElement : cigar) {
            if (readPosition > offset + 1) {
                return null;
            }
            if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Insertion ? cigarElement.getOperator().consumesReadBases() && readPosition == offset : recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Deletion && readPosition == offset + 1) {
                return cigarElement;
            }
            readPosition += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
        }
        return null;
    }

    public static interface RecordAndOffsetStratifier<T extends Comparable<T>> {
        public T stratify(SamLocusIterator.RecordAndOffset var1, SamLocusAndReferenceIterator.SAMLocusAndReference var2);

        public String getSuffix();
    }

    public static enum ReadDirection {
        POSITIVE("+"),
        NEGATIVE("-");

        private final String outputString;

        private ReadDirection(String output) {
            this.outputString = output;
        }

        public String toString() {
            return this.outputString;
        }

        public static ReadDirection of(SAMRecord sam) {
            return sam.getReadNegativeStrandFlag() ? NEGATIVE : POSITIVE;
        }
    }

    public static class LongShortHomopolymerStratifier
    implements RecordAndOffsetStratifier<LongShortHomopolymer> {
        final int longHomopolymer;

        @Override
        public LongShortHomopolymer stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            Integer hpLength = homoPolymerLengthStratifier.stratify(recordAndOffset, locusInfo);
            if (hpLength == null) {
                return null;
            }
            return hpLength < this.longHomopolymer ? LongShortHomopolymer.SHORT_HOMOPOLYMER : LongShortHomopolymer.LONG_HOMOPOLYMER;
        }

        LongShortHomopolymerStratifier(int longHomopolymer) {
            this.longHomopolymer = longHomopolymer;
        }

        @Override
        public String getSuffix() {
            return "long_short_homopolymer";
        }
    }

    public static class PairStratifier<T extends Comparable<T>, R extends Comparable<R>>
    implements RecordAndOffsetStratifier<Pair<T, R>> {
        final RecordAndOffsetStratifier<T> a;
        final RecordAndOffsetStratifier<R> b;

        public PairStratifier(RecordAndOffsetStratifier<T> a, RecordAndOffsetStratifier<R> b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public Pair<T, R> stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            T a = this.a.stratify(recordAndOffset, locusInfo);
            R b = this.b.stratify(recordAndOffset, locusInfo);
            if (a == null || b == null) {
                return null;
            }
            return new Pair<T, R>(a, b);
        }

        @Override
        public String getSuffix() {
            return this.a.getSuffix() + "_and_" + this.b.getSuffix();
        }
    }

    static abstract class RecordStratifier<T extends Comparable<T>>
    implements RecordAndOffsetStratifier<T> {
        RecordStratifier() {
        }

        @Override
        public T stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            return this.stratify(recordAndOffset.getRecord());
        }

        abstract T stratify(SAMRecord var1);
    }

    public static class GCContentStratifier
    extends RecordStratifier<Double> {
        final Cache<SAMRecord, Double> gcCache = CacheBuilder.newBuilder().maximumSize((long)GC_CACHE_SIZE).build();

        @Override
        public Double stratify(SAMRecord sam) {
            try {
                return (Double)this.gcCache.get((Object)sam, () -> (double)Math.round(100.0 * SequenceUtil.calculateGc((byte[])sam.getReadBases())) / 100.0);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getSuffix() {
            return "gc";
        }
    }

    public static class FlowCellTileStratifier
    extends PositionBasedStratifier {
        @Override
        public Integer stratify(SAMRecord sam) {
            try {
                PhysicalLocationInt location = new PhysicalLocationInt();
                readNameParser.addLocationInformation(sam.getReadName(), location);
                return location.getTile();
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }

        @Override
        public String getSuffix() {
            return "tile";
        }
    }

    public static class FlowCellXStratifier
    extends PositionBasedStratifier {
        @Override
        public Integer stratify(SAMRecord sam) {
            try {
                PhysicalLocationInt location = new PhysicalLocationInt();
                readNameParser.addLocationInformation(sam.getReadName(), location);
                return location.getX() / LOCATION_BIN_SIZE;
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }

        @Override
        public String getSuffix() {
            return "x";
        }
    }

    public static class FlowCellYStratifier
    extends PositionBasedStratifier {
        @Override
        public Integer stratify(SAMRecord sam) {
            try {
                PhysicalLocationInt location = new PhysicalLocationInt();
                readNameParser.addLocationInformation(sam.getReadName(), location);
                return location.getY() / LOCATION_BIN_SIZE;
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }

        @Override
        public String getSuffix() {
            return "y";
        }
    }

    public static class BinnedReadCycleStratifier
    implements RecordAndOffsetStratifier<CycleBin> {
        @Override
        public CycleBin stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            int readCycle = ReadBaseStratification.stratifyCycle(recordAndOffset);
            double relativePosition = (double)readCycle / (double)recordAndOffset.getRecord().getReadLength();
            return CycleBin.valueOf(relativePosition);
        }

        @Override
        public String getSuffix() {
            return "binned_cycle";
        }
    }

    public static class MismatchesInReadStratifier
    implements RecordAndOffsetStratifier<Integer> {
        @Override
        public Integer stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            Integer numberMismatches = recordAndOffset.getRecord().getIntegerAttribute(SAMTag.NM.name());
            if (numberMismatches == null) {
                return null;
            }
            if (recordAndOffset.getReadBase() != locusInfo.getReferenceBase()) {
                return numberMismatches - 1;
            }
            return numberMismatches;
        }

        @Override
        public String getSuffix() {
            return "mismatches_in_read";
        }
    }

    public static class ConsensusStratifier
    extends RecordStratifier<Consensus> {
        static final String FIRST_STRAND_TAG = "aD";
        static final String SECOND_STRAND_TAG = "bD";
        static final String BOTH_STRANDS_TAG = "cD";

        @Override
        public Consensus stratify(SAMRecord sam) {
            int copiesOfSecondStrand;
            int copiesOfFirstStrand;
            if (sam.hasAttribute(FIRST_STRAND_TAG) && sam.hasAttribute(SECOND_STRAND_TAG)) {
                copiesOfFirstStrand = sam.getIntegerAttribute(FIRST_STRAND_TAG);
                copiesOfSecondStrand = sam.getIntegerAttribute(SECOND_STRAND_TAG);
            } else {
                copiesOfFirstStrand = 0;
                copiesOfSecondStrand = 0;
            }
            int copiesOfBothStrands = sam.hasAttribute(BOTH_STRANDS_TAG) ? sam.getIntegerAttribute(BOTH_STRANDS_TAG) : 0;
            if (copiesOfBothStrands == 1) {
                return Consensus.SIMPLEX_SINGLETON;
            }
            if (copiesOfSecondStrand == 0 && copiesOfBothStrands > 1) {
                return Consensus.SIMPLEX_CONSENSUS;
            }
            if (copiesOfFirstStrand > 0 && copiesOfSecondStrand > 0 && (copiesOfFirstStrand == 1 || copiesOfSecondStrand == 1)) {
                return Consensus.DUPLEX_SINGLETON;
            }
            if (copiesOfFirstStrand > 1 && copiesOfSecondStrand > 1) {
                return Consensus.DUPLEX_CONSENSUS;
            }
            return Consensus.UNKNOWN;
        }

        @Override
        public String getSuffix() {
            return "consensus";
        }
    }

    public static class NsInReadStratifier
    extends RecordStratifier<Integer> {
        private static String numberOfNsTag = "numberOfNs";

        @Override
        public Integer stratify(SAMRecord sam) {
            int numberOfNsInRead = 0;
            if (sam.getTransientAttribute((Object)numberOfNsTag) != null) {
                numberOfNsInRead = (Integer)sam.getTransientAttribute((Object)numberOfNsTag);
            } else {
                byte[] bases;
                for (byte base : bases = sam.getReadBases()) {
                    if (!SequenceUtil.isNoCall((byte)base)) continue;
                    ++numberOfNsInRead;
                }
                sam.setTransientAttribute((Object)numberOfNsTag, (Object)numberOfNsInRead);
            }
            return numberOfNsInRead;
        }

        @Override
        public String getSuffix() {
            return "ns_in_read";
        }
    }

    public static class CigarOperatorsInReadStratifier
    extends RecordStratifier<Integer> {
        private CigarOperator operator;

        public CigarOperatorsInReadStratifier(CigarOperator op) {
            this.operator = op;
        }

        @Override
        public Integer stratify(SAMRecord samRecord) {
            return ReadBaseStratification.stratifyCigarOperatorsInRead(samRecord, this.operator);
        }

        @Override
        public String getSuffix() {
            return "cigar_elements_" + this.operator.name() + "_in_read";
        }
    }

    public static class IndelsInReadStratifier
    extends RecordStratifier<Integer> {
        @Override
        public Integer stratify(SAMRecord samRecord) {
            Integer insertedBasesInRead = ReadBaseStratification.stratifyCigarOperatorsInRead(samRecord, CigarOperator.I);
            Integer deletedBasesInRead = ReadBaseStratification.stratifyCigarOperatorsInRead(samRecord, CigarOperator.D);
            if (insertedBasesInRead == null || deletedBasesInRead == null) {
                return null;
            }
            return insertedBasesInRead + deletedBasesInRead;
        }

        @Override
        public String getSuffix() {
            return "indels_in_read";
        }
    }

    public static class IndelLengthStratifier
    implements RecordAndOffsetStratifier {
        public Integer stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            return ReadBaseStratification.stratifyIndelLength(recordAndOffset, locusInfo);
        }

        @Override
        public String getSuffix() {
            return "indel_length";
        }
    }

    public static enum Consensus {
        SIMPLEX_SINGLETON,
        SIMPLEX_CONSENSUS,
        DUPLEX_SINGLETON,
        DUPLEX_CONSENSUS,
        UNKNOWN;

    }

    public static enum LongShortHomopolymer {
        SHORT_HOMOPOLYMER,
        LONG_HOMOPOLYMER;

    }

    public static enum PairOrientation {
        F1R2,
        F2R1,
        F1F2,
        R1R2;


        private static PairOrientation ofExplicit(boolean firstPositive, boolean secondPositive) {
            if (firstPositive == secondPositive) {
                return firstPositive ? R1R2 : F1F2;
            }
            return firstPositive ? F1R2 : F2R1;
        }

        public static PairOrientation of(SAMRecord sam) {
            boolean matePositiveStrand;
            ReadOrdinality ordinality = ReadOrdinality.of(sam);
            ReadDirection direction = ReadDirection.of(sam);
            if (!sam.getReadPairedFlag()) {
                return null;
            }
            if (direction == null || sam.getReadUnmappedFlag() || sam.getMateUnmappedFlag()) {
                return null;
            }
            boolean bl = matePositiveStrand = !sam.getMateNegativeStrandFlag();
            if (ordinality == ReadOrdinality.FIRST) {
                return PairOrientation.ofExplicit(direction == ReadDirection.POSITIVE, matePositiveStrand);
            }
            return PairOrientation.ofExplicit(matePositiveStrand, direction == ReadDirection.POSITIVE);
        }
    }

    public static enum CycleBin {
        QUINTILE_1(0.0, 0.2),
        QUINTILE_2(0.2, 0.4),
        QUINTILE_3(0.4, 0.6),
        QUINTILE_4(0.6, 0.8),
        QUINTILE_5(0.8, 1.0);

        final double lower;
        final double upper;

        private CycleBin(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }

        static CycleBin valueOf(double value) {
            return Stream.of(CycleBin.values()).filter(e -> value >= e.lower && value <= e.upper).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Value for CycleBin must be between 0 and 1 (inclusive), found: %g", value)));
        }
    }

    public static enum ProperPaired {
        PROPER,
        IMPROPER,
        CHIMERIC,
        DISCORDANT,
        UNKNOWN;


        public static ProperPaired of(SAMRecord sam) {
            if (sam.getReadPairedFlag() && !sam.getMateUnmappedFlag() && !sam.getReadUnmappedFlag() && !sam.getMateReferenceIndex().equals(sam.getReferenceIndex())) {
                return DISCORDANT;
            }
            if (!sam.getReadUnmappedFlag() && sam.getCigar().isClipped() && sam.hasAttribute(SAMTag.SA.toString())) {
                return CHIMERIC;
            }
            if (sam.getReadUnmappedFlag() || sam.getReadPairedFlag() && sam.getMateUnmappedFlag()) {
                return UNKNOWN;
            }
            if (!sam.getProperPairFlag()) {
                return IMPROPER;
            }
            return PROPER;
        }
    }

    public static enum ReadOrdinality {
        FIRST,
        SECOND;


        public static ReadOrdinality of(SAMRecord sam) {
            if (!sam.getReadPairedFlag()) {
                return null;
            }
            return sam.getFirstOfPairFlag() ? FIRST : SECOND;
        }
    }

    static enum Stratifier implements CommandLineParser.ClpEnum
    {
        ALL(() -> nonStratifier, "Puts all bases in the same stratum."),
        GC_CONTENT(() -> gcContentStratifier, "The GC-content of the read."),
        READ_ORDINALITY(() -> readOrdinalityStratifier, "The read ordinality (i.e. first or second)."),
        READ_BASE(() -> currentReadBaseStratifier, "the base in the original reading direction."),
        READ_DIRECTION(() -> readDirectionStratifier, "The alignment direction of the read (encoded as + or -)."),
        PAIR_ORIENTATION(() -> readOrientationStratifier, "The read-pair's orientation (encoded as '[FR]1[FR]2')."),
        PAIR_PROPERNESS(() -> readPairednessStratifier, "The properness of the read-pair's alignment. Looks for indications of chimerism."),
        REFERENCE_BASE(() -> referenceBaseStratifier, "The reference base in the read's direction."),
        PRE_DINUC(() -> preDiNucleotideStratifier, "The read base at the previous cycle, and the current reference base."),
        POST_DINUC(() -> postDiNucleotideStratifier, "The read base at the subsequent cycle, and the current reference base."),
        HOMOPOLYMER_LENGTH(() -> homoPolymerLengthStratifier, "The length of homopolymer the base is part of (only accounts for bases that were read prior to the current base)."),
        HOMOPOLYMER(() -> homopolymerStratifier, "The length of homopolymer, the base that the homopolymer is comprised of, and the reference base."),
        BINNED_HOMOPOLYMER(() -> binnedHomopolymerStratifier.get(), "The scale of homopolymer (long or short), the base that the homopolymer is comprised of, and the reference base."),
        FLOWCELL_TILE(() -> flowCellTileStratifier, "The flowcell and tile where the base was read (taken from the read name)."),
        FLOWCELL_Y(() -> flowCellYStratifier, "The y-coordinate of the read (taken from the read name)"),
        FLOWCELL_X(() -> flowCellXStratifier, "The x-coordinate of the read (taken from the read name)"),
        READ_GROUP(() -> readgroupStratifier, "The read-group id of the read."),
        CYCLE(() -> baseCycleStratifier, "The machine cycle during which the base was read."),
        BINNED_CYCLE(() -> binnedReadCycleStratifier, "The binned machine cycle. Similar to CYCLE, but binned into 5 evenly spaced ranges across the size of the read.  This stratifier may produce confusing results when used on datasets with variable sized reads."),
        SOFT_CLIPS(() -> softClipsLengthStratifier, "The number of softclipped bases the read has."),
        INSERT_LENGTH(() -> insertLengthStratifier, "The insert-size they came from (taken from the TLEN field.)"),
        BASE_QUALITY(() -> baseQualityStratifier, "The base quality."),
        MAPPING_QUALITY(() -> mappingQualityStratifier, "The read's mapping quality."),
        MISMATCHES_IN_READ(() -> mismatchesInReadStratifier, "The number of bases in the read that mismatch the reference, excluding the current base.  This stratifier requires the NM tag."),
        ONE_BASE_PADDED_CONTEXT(() -> oneBasePaddedContextStratifier, "The current reference base and a one base padded region from the read resulting in a 3-base context."),
        TWO_BASE_PADDED_CONTEXT(() -> twoBasePaddedContextStratifier, "The current reference base and a two base padded region from the read resulting in a 5-base context."),
        CONSENSUS(() -> consensusStratifier, "Whether or not duplicate reads were used to form a consensus read.  This stratifier makes use of the aD, bD, and cD tags for duplex consensus reads.  If the reads are single index consensus, only the cD tags are used."),
        NS_IN_READ(() -> nsInReadStratifier, "The number of Ns in the read."),
        INSERTIONS_IN_READ(() -> insertionsInReadStratifier, "The number of Insertions in the read cigar."),
        DELETIONS_IN_READ(() -> deletionsInReadStratifier, "The number of Deletions in the read cigar."),
        INDELS_IN_READ(() -> indelsInReadStratifier, "The number of INDELs in the read cigar."),
        INDEL_LENGTH(() -> indelLengthStratifier, "The number of bases in an indel");

        private final String docString;
        private final Supplier<RecordAndOffsetStratifier<?>> stratifier;

        public String getHelpDoc() {
            return this.docString + " Suffix is '" + this.stratifier.get().getSuffix() + "'.";
        }

        private Stratifier(Supplier<RecordAndOffsetStratifier<?>> stratifier, String docString) {
            this.stratifier = stratifier;
            this.docString = docString;
        }

        public RecordAndOffsetStratifier<?> makeStratifier() {
            return this.stratifier.get();
        }
    }

    public static class CollectionStratifier
    implements RecordAndOffsetStratifier {
        final RecordAndOffsetStratifier stratifier;

        public CollectionStratifier(Collection<RecordAndOffsetStratifier<?>> stratifiers) {
            if (stratifiers.isEmpty()) {
                throw new IllegalArgumentException("Must construct with a non-empty collection of stratifiers.");
            }
            LinkedList linkedListStratifiers = new LinkedList(stratifiers);
            while (linkedListStratifiers.size() > 1) {
                RecordAndOffsetStratifier<?> first = linkedListStratifiers.remove(0);
                RecordAndOffsetStratifier<?> second = linkedListStratifiers.remove(0);
                PairStratifier newPair = new PairStratifier(first, second);
                linkedListStratifiers.add(0, newPair);
            }
            this.stratifier = linkedListStratifiers.remove();
        }

        public Comparable stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            return this.stratifier.stratify(recordAndOffset, locusInfo);
        }

        @Override
        public String getSuffix() {
            return this.stratifier.getSuffix();
        }
    }

    static abstract class PositionBasedStratifier
    implements RecordAndOffsetStratifier<Integer> {
        static final ReadNameParser readNameParser = new ReadNameParser();

        PositionBasedStratifier() {
        }

        @Override
        public Integer stratify(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo) {
            return this.stratify(recordAndOffset.getRecord());
        }

        abstract Integer stratify(SAMRecord var1);
    }
}

